#
#VID 0679deeb-8eaf-11db-abc9-0003476f14d3
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57729);
 script_cve_id("CVE-2006-4244", "CVE-2006-4731", "CVE-2006-5872");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: sql-ledger";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: sql-ledger

CVE-2006-4244
SQL-Ledger 2.4.4 through 2.6.17 authenticates users by verifying that
the value of the sql-ledger-[username] cookie matches the value of the
sessionid parameter, which allows remote attackers to gain access as
any logged-in user by setting the cookie and the parameter to the same
value.

CVE-2006-4731
Multiple directory traversal vulnerabilities in (1) login.pl and (2)
admin.pl in (a) SQL-Ledger before 2.6.19 and (b) LedgerSMB before
1.0.0p1 allow remote attackers to execute arbitrary Perl code via an
unspecified terminal parameter value containing ../ (dot dot slash).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.us.debian.org/security/2006/dsa-1239
http://www.vuxml.org/freebsd/0679deeb-8eaf-11db-abc9-0003476f14d3.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: sql-ledger";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"sql-ledger");
if(!isnull(bver) && revcomp(a:bver, b:"2.6.22")<0) {
    security_note(0, data:"Package sql-ledger version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
