##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_squidguard_detect.nasl 5533 2009-11-02 13:58:21Z nov $
#
# squidGuard Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800964);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("SquidGuard Version Detection");
  desc = "
  Overview: This script detects the installed version of SquidGuard and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Sets the version of SquidGuard in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sgSock = ssh_login_or_reuse_connection();
if(!sgSock){
  exit(0);
}

getPath = find_bin(prog_name:"squidGuard", sock:sgSock);
foreach binFile (getPath)
{
  sgVer = get_bin_version(full_prog_name:chomp(binFile), sock:sgSock,
                          version_argv:"-v",
                          ver_pattern:"SquidGuard.? ([0-9.]+)([a-z][0-9])?");
  if(sgVer[1] != NULL)
  {
    if(sgVer[2] =~ "^[a-z][0-9]"){
      sgVer = sgVer[1] + "." + sgVer[2];
    }
    else
      sgVer = sgVer[1];
    set_kb_item(name:"SquidGuard/Ver", value:sgVer);
    security_note(data:"squidGuard version " + sgVer + 
                       " running at location " + binFile +
                       " was detected on the host");
  }
}
ssh_close_connection();
