###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tugzip_file_bof_vuln.nasl 0407 2008-10-31 11:30:58Z oct $
#
# TUGzip zip File Buffer Overflow Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800122);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-4779");
  script_bugtraq_id(31913);
  script_name("TUGzip zip File Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with TUGzip, which is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  The flaw exists due to boundary error while processing an archive containing
  an overly long file or directory name.

  Impact:
  Successful exploitation allows attackers to execute arbitrary code by
  tricking a user into opening a specially crafted archive or can even
  crash an affected application.

  Impact Level: Application/System

  Affected Software/OS:
  TUGzip Version 3.5.0.0 and prior on Windows (Any).

  Fix: No solution/patch is available as on 31st October, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.tugzip.com/

  References:
  http://secunia.com/advisories/32411
  http://www.milw0rm.com/exploits/6831
  http://xforce.iss.net/xforce/xfdb/46120
  http://www.frsirt.com/english/advisories/2008/2918

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 8.1
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of TUGzip");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Get Application Path
appPath = registry_get_sz(item:"Inno Setup: App Path",
          key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\TUGZip_is1");
if(!appPath){
  exit(0);
}

exePath = appPath + "\TUGZip.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

# Get TUGZip Version
tugZipVer = GetVer(file:file, share:share);
if(!tugZipVer){
  exit(0);
}

if(version_is_less_equal(version:tugZipVer, test_version:"3.5.0.0")){
  security_hole(0);
}
