###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux vulnerability USN-662-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840296);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"8.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "662-1");
  script_cve_id("CVE-2008-3528", "CVE-2008-4395");
  script_name( "Ubuntu Update for linux vulnerability USN-662-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the Linux kernel could be made to hang temporarily
  when mounting corrupted ext2/3 filesystems.  If a user were tricked into
  mounting a specially crafted filesystem, a remote attacker could cause
  system hangs, leading to a denial of service. (CVE-2008-3528)
  
  Anders Kaseorg discovered that ndiswrapper did not correctly handle long
  ESSIDs.  For a system using ndiswrapper, a physically near-by attacker
  could generate specially crafted wireless network traffic and execute
  arbitrary code with root privileges. (CVE-2008-4395)

  Affected Software/OS:
  linux vulnerability on Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000770.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of linux vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.27-7-generic_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.27-7-server_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.27-7-generic_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.27-7-server_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.27-7-virtual_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.27_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.27-7_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.27_2.6.27-7.16", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}