###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_filezilla_server_detect.nasl 927 2009-03-20 12:21:24Z mar $
#
# FileZilla Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900518);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("FileZilla Server Version Detection");
  desc = "

  Overview: This script finds the version of FileZilla Server and
  sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of FileZilla Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("FTP");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

fzillaPort = get_kb_item("Services/ftp");
if(!fzillaPort){
  fzillaPort = 21;
}

if(get_port_state(fzillaPort))
{
  banner = get_ftp_banner(port:fzillaPort);
  if("FileZilla Server" >!< banner){
    exit(0);
  }

  fzillaVer = eregmatch(pattern:"FileZilla Server version ([0-9a-z.]+)",
                        string:banner);
  if(fzillaVer[1] != NULL){
    set_kb_item(name:"FileZilla/Serv/Ver", value:fzillaVer[1]);
    security_note(data:"FileZilla Server version " + fzillaVer[1] +
                                             " was detected on the host");
  }
}
