<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="str"
                version="1.0">

<!-- 
     This file contains templates for assisting in the construction of
     initial PhotoML descriptions of roll data recorded in a simple
     text format.

     Copyright © 2005,2010 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

  <xsl:output method="xml" indent="yes" encoding="utf-8"
              doctype-public="-//BW//DTD PhotoML 0.13//EN"
              doctype-system="photo.dtd"/>


  <!-- Match top level element of pmlcreate roll data representation. -->
  <xsl:template match="/rolldata">
    <photo>
      <xsl:apply-templates select="*"/>
    </photo>
  </xsl:template>


  <!-- Handle data for each roll -->
  <xsl:template match="roll">
    <xsl:variable name="fn" select="str:tokenize(fnum,' ')"/>
    <roll id='{@gid}'>
      <xsl:comment/>
      <xsl:if test="/rolldata/@collect">
        <collection id="{/rolldata/@collect}"  
                    cgid="{format-number(@number,'00')}"/>
        <xsl:comment/>
      </xsl:if>
      <xsl:apply-templates select="film"/>
      <xsl:comment/>
      <xsl:apply-templates select="processing"/>
      <xsl:comment/>
      <xsl:apply-templates select="@load"/>
      <xsl:comment/>
      <xsl:apply-templates select="frames">
        <xsl:with-param name="fn" select="$fn"/>
        <xsl:with-param name="exp" select="exposure"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="@unload"/>
      <xsl:comment/>
    </roll>
    <xsl:comment/>
  </xsl:template>


  <!-- Handle camera details -->
  <xsl:template match="camera">
    <equipment>
      <body>
        <make><xsl:value-of select="@make"/></make>
        <model><xsl:value-of select="@model"/></model>
      </body>
    </equipment>
  </xsl:template>


  <!-- Handle film details -->
  <xsl:template match="film">
    <film>
      <make><xsl:value-of select="@make"/></make>
      <name><xsl:value-of select="@name"/></name>
      <speed><xsl:value-of select="@speed"/></speed>
      <xsl:if test="@expire and @expire != ''">
        <expiry><xsl:value-of select="@expire"/></expiry>
      </xsl:if>
    </film>
  </xsl:template>


  <!-- Handle film processing details -->
  <xsl:template match="processing">
    <processing>
      <lab>
        <name><xsl:value-of select="@name"/></name>
        <address><xsl:value-of select="@address"/></address>
      </lab>
      <tag><xsl:value-of select="@tag"/></tag>
      <date><xsl:value-of select="@date"/></date>
    </processing>
  </xsl:template>


  <!-- Handle film load date -->
  <xsl:template match="roll/@load">
    <load>
      <date><xsl:value-of select="."/></date>
    </load>
  </xsl:template>


  <!-- Handle film unload date -->
  <xsl:template match="roll/@unload">
    <unload>
      <date><xsl:value-of select="."/></date>
    </unload>
  </xsl:template>


  <!-- Handle frame date information -->
  <xsl:template match="frames">
    <xsl:param name="fn" select="/.."/>
    <xsl:param name="exp" select="/.."/>
    <defaults>
      <frame>
        <scene>
          <occasion>
            <date><xsl:value-of select="@date"/></date>
          </occasion>
        </scene>
        <xsl:if test="position()=1">
          <xsl:apply-templates select="../camera"/>
        </xsl:if>
      </frame>
    </defaults>
    <xsl:comment/>
    <xsl:call-template name="frame-range">
      <xsl:with-param name="fn" select="$fn"/>
      <xsl:with-param name="exp" select="$exp"/>
      <xsl:with-param name="first" select="@first"/>
      <xsl:with-param name="last" select="@last"/>
    </xsl:call-template>
  </xsl:template>


  <!-- Construct the specified set of frame elements -->
  <xsl:template name="frame-range">
    <xsl:param name="fn" select="/.."/>
    <xsl:param name="exp" select="/.."/>
    <xsl:param name="first" select="0"/>
    <xsl:param name="last" select="0"/>
    
    <xsl:if test="$first &lt;= $last">
      <frame>
        <xsl:attribute name="id">
          <xsl:value-of select="format-number($first,'00')"/>
        </xsl:attribute>
        <xsl:attribute name="fn">
          <xsl:value-of select="$fn[number($first)]"/>
        </xsl:attribute>
        <!--
        <scene>
          <description>edit here</description>
        </scene>
        -->
        <xsl:if test="$exp/@frame[.=$first]">
          <exposure>
            <aperture>
              <xsl:value-of select="$exp[@frame=$first]/@aperture"/>
            </aperture>
            <shutter>
              <xsl:value-of select="$exp[@frame=$first]/@shutter"/>
            </shutter>
            <xsl:if test="$exp[@frame=$first]/@exp-comp != ''">
              <exp-comp>
                <xsl:value-of select="$exp[@frame=$first]/@exp-comp"/>
              </exp-comp>
          </xsl:if>
          </exposure>
        </xsl:if>
      </frame>
      <xsl:comment/>
      <xsl:call-template name="frame-range">
        <xsl:with-param name="fn" select="$fn"/>
        <xsl:with-param name="exp" select="$exp"/>
        <xsl:with-param name="first" select="$first+1"/>
        <xsl:with-param name="last" select="$last"/>
      </xsl:call-template>
    </xsl:if>

  </xsl:template>


</xsl:stylesheet>
