/*
 * Copyright (C) 2009  VMware, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** @file uniform_neg_location.c
 *
 * Based on Glean test based on Mesa test written by Bruce Merry.
 *
 * From the OpenGL 2.0 spec page 82 (page 96 of the PDF):
 * "If the value of location is -1, the Uniform* commands will silently ignore
 * the data passed in, and the current uniform values will not be changed.
 * [...]
 * If any of the following conditions occur, an INVALID OPERATION error is
 * generated by the Uniform* commands, and no uniform values are changed:
 * [...]
 * if no variable with a location of location exists in the program object
 * currently in use and location is not -1"
 */

#include "piglit-util-gl.h"

PIGLIT_GL_TEST_CONFIG_BEGIN

	config.supports_gl_compat_version = 20;
	config.khr_no_error_support = PIGLIT_HAS_ERRORS;

PIGLIT_GL_TEST_CONFIG_END

enum piglit_result
piglit_display(void)
{
	/* UNREACHED */
	return PIGLIT_FAIL;
}

void
piglit_init(int argc, char **argv)
{
	float data[4];
	bool pass = true;

	const char *vs_src = "#version 110\n"
		"void main() { gl_Position = vec4(1.0, 1.0, 1.0, 1.0); }\n";
	const GLuint prog = piglit_build_simple_program(vs_src, NULL);

	glUseProgram(prog);

	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;
	glUniform1i(-1, 1);
	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;
	glUniform1i(-200, 1);
	pass = piglit_check_gl_error(GL_INVALID_OPERATION) && pass;

	glUniformMatrix2fv(-1, 1, GL_FALSE, data);
	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;
	glUniformMatrix2fv(-200, 1, GL_FALSE, data);
	pass = piglit_check_gl_error(GL_INVALID_OPERATION) && pass;

	piglit_report_result(pass ? PIGLIT_PASS : PIGLIT_FAIL);
}
