#-*- coding:utf-8 -*-

#  Copyright © 2009-2015  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This line is not really needed, but leave it until glarea and gldraw are compiled with cython3
from __future__ import print_function, division

import sys


DEBUG = False
DEBUG_FUNC = DEBUG_MSG = DEBUG_RAND = DEBUG_ROTATE = False
DEBUG_DRAW = DEBUG_ALG = DEBUG_KEYS = DEBUG_PICK = DEBUG_MOUSEPOS = False
DEBUG_FPS = DEBUG_VFPS = DEBUG_NOLABEL = DEBUG_NOBEVEL = DEBUG_INVISIBLE = False
DEBUG_SHADER = DEBUG_NOVSHADER = DEBUG_NOFSHADER = DEBUG_NOSHADER = False
DEBUG_PUREPYTHON = DEBUG_INDEXONLY = DEBUG_LIVESHADER = False
DEBUG_LOG = DEBUG_LOGDEBUG = DEBUG_LOGGL = False
DEBUG_LIVEPLUGINS = False

__all__ = ['error', 'debug', 'debug_func', 'DEBUG',
          ] + [__n for __n in dir(sys.modules[__name__]) if __n.startswith('DEBUG_')]

def error(*args, **kwargs):
    print('ERROR:', *args, **kwargs)
    
debug = lambda *args, **kwargs: None
debug_func = lambda x: x

def set_flags(debug_flags):
    module = sys.modules[__name__]
    module.DEBUG = True
    
    for flag in debug_flags:
        setattr(module, 'DEBUG_' + flag.upper(), True)
        
    if module.DEBUG_LOGDEBUG or module.DEBUG_LOGGL:
        module.DEBUG_LOG = True
    if module.DEBUG_LOG:
        import logging
        logging.basicConfig(filename='pybik.log',
                            level=logging.DEBUG if module.DEBUG_LOGDEBUG else logging.INFO)
    if module.DEBUG_VFPS:
        module.DEBUG_FPS = True
    
    if module.DEBUG_FUNC:
        def _debug_pre_func(func, *args, **kwargs):
            def short_arg(arg):
                arg = str(arg)
                maxlen = 80 - debug_func.indent * 3 - 2
                if len(arg) > maxlen:
                    return arg[:maxlen]
                return arg
            try:
                func_name = func.__name__
            except AttributeError:
                func_name = func.__name__
            print('%s--%s' % ('  |'*debug_func.indent, func_name))
            debug_func.indent += 1
            for arg in args:
                try:
                    print('%s: %s' % ('  |'*debug_func.indent, short_arg(arg)))
                except Exception:
                    pass
            for kw, arg in kwargs:
                try:
                    print('%s: %s=%s' % ('  |'*debug_func.indent, kw, short_arg(arg)))
                except Exception:
                    pass
        def debug_func(func):
            def ret_func(*args, **kwargs):
                _debug_pre_func(func, *args, **kwargs)
                try:
                    return func(*args, **kwargs)
                except Exception as e:
                    if debug_func.last_exc != e:
                        print('  X'*debug_func.indent)
                        debug_func.last_exc = e
                    raise
                finally:
                    debug_func.indent -= 1
                    print('  |'*debug_func.indent + "--'")
            try:
                ret_func.__dict__ = func.__dict__
            except AttributeError:
                pass
            ret_func.__doc__ = func.__doc__
            ret_func.__module__ = func.__module__
            ret_func.__name__ = func.__name__
            try:
                ret_func.__defaults__ = func.__defaults__
            except AttributeError:
                pass
            return ret_func
        debug_func.indent = 0
        debug_func.last_exc = None
        module.debug_func = debug_func
        
    if module.DEBUG_MSG:
        module.debug = print
        
