from __future__ import unicode_literals

from pybtex.bibtex.interpreter import (
    FunctionLiteral, Identifier, Integer, QuotedVar, String
)

bst = [[u'ENTRY',
  [Identifier(u'address'),
   Identifier(u'author'),
   Identifier(u'booktitle'),
   Identifier(u'chapter'),
   Identifier(u'edition'),
   Identifier(u'editor'),
   Identifier(u'howpublished'),
   Identifier(u'institution'),
   Identifier(u'journal'),
   Identifier(u'key'),
   Identifier(u'month'),
   Identifier(u'note'),
   Identifier(u'number'),
   Identifier(u'organization'),
   Identifier(u'pages'),
   Identifier(u'publisher'),
   Identifier(u'school'),
   Identifier(u'series'),
   Identifier(u'title'),
   Identifier(u'type'),
   Identifier(u'volume'),
   Identifier(u'year')],
  [],
  [Identifier(u'label')]],
 [u'INTEGERS',
  [Identifier(u'output.state'),
   Identifier(u'before.all'),
   Identifier(u'mid.sentence'),
   Identifier(u'after.sentence'),
   Identifier(u'after.block')]],
 [u'FUNCTION',
  [Identifier(u'init.state.consts')],
  [Integer(0),
   QuotedVar(u'before.all'),
   Identifier(u':='),
   Integer(1),
   QuotedVar(u'mid.sentence'),
   Identifier(u':='),
   Integer(2),
   QuotedVar(u'after.sentence'),
   Identifier(u':='),
   Integer(3),
   QuotedVar(u'after.block'),
   Identifier(u':=')]],
 [u'STRINGS', [Identifier(u's'), Identifier(u't')]],
 [u'FUNCTION',
  [Identifier(u'output.nonnull')],
  [QuotedVar(u's'),
   Identifier(u':='),
   Identifier(u'output.state'),
   Identifier(u'mid.sentence'),
   Identifier(u'='),
   FunctionLiteral([String(u', '), Identifier(u'*'), Identifier(u'write$')]),
   FunctionLiteral([Identifier(u'output.state'), Identifier(u'after.block'), Identifier(u'='), FunctionLiteral([Identifier(u'add.period$'), Identifier(u'write$'), Identifier(u'newline$'), String(u'\\newblock '), Identifier(u'write$')]), FunctionLiteral([Identifier(u'output.state'), Identifier(u'before.all'), Identifier(u'='), QuotedVar(u'write$'), FunctionLiteral([Identifier(u'add.period$'), String(u' '), Identifier(u'*'), Identifier(u'write$')]), Identifier(u'if$')]), Identifier(u'if$'), Identifier(u'mid.sentence'), QuotedVar(u'output.state'), Identifier(u':=')]),
   Identifier(u'if$'),
   Identifier(u's')]],
 [u'FUNCTION',
  [Identifier(u'output')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'pop$'),
   QuotedVar(u'output.nonnull'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'output.check')],
  [QuotedVar(u't'),
   Identifier(u':='),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), String(u'empty '), Identifier(u't'), Identifier(u'*'), String(u' in '), Identifier(u'*'), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]),
   QuotedVar(u'output.nonnull'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'output.bibitem')],
  [Identifier(u'newline$'),
   String(u'\\bibitem{'),
   Identifier(u'write$'),
   Identifier(u'cite$'),
   Identifier(u'write$'),
   String(u'}'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   String(u''),
   Identifier(u'before.all'),
   QuotedVar(u'output.state'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'fin.entry')],
  [Identifier(u'add.period$'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'new.block')],
  [Identifier(u'output.state'),
   Identifier(u'before.all'),
   Identifier(u'='),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'after.block'), QuotedVar(u'output.state'), Identifier(u':=')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'new.sentence')],
  [Identifier(u'output.state'),
   Identifier(u'after.block'),
   Identifier(u'='),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'output.state'), Identifier(u'before.all'), Identifier(u'='), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'after.sentence'), QuotedVar(u'output.state'), Identifier(u':=')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'not')],
  [FunctionLiteral([Integer(0)]),
   FunctionLiteral([Integer(1)]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'and')],
  [QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'pop$'), Integer(0)]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'or')],
  [FunctionLiteral([Identifier(u'pop$'), Integer(1)]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'new.block.checka')],
  [Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   QuotedVar(u'new.block'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'new.block.checkb')],
  [Identifier(u'empty$'),
   Identifier(u'swap$'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   QuotedVar(u'skip$'),
   QuotedVar(u'new.block'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'new.sentence.checka')],
  [Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   QuotedVar(u'new.sentence'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'new.sentence.checkb')],
  [Identifier(u'empty$'),
   Identifier(u'swap$'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   QuotedVar(u'skip$'),
   QuotedVar(u'new.sentence'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'field.or.null')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), String(u'')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'emphasize')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), String(u'')]),
   FunctionLiteral([String(u'{\\em '), Identifier(u'swap$'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'INTEGERS',
  [Identifier(u'nameptr'), Identifier(u'namesleft'), Identifier(u'numnames')]],
 [u'FUNCTION',
  [Identifier(u'format.names')],
  [QuotedVar(u's'),
   Identifier(u':='),
   Integer(1),
   QuotedVar(u'nameptr'),
   Identifier(u':='),
   Identifier(u's'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'numnames'),
   QuotedVar(u'namesleft'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'namesleft'), Integer(0), Identifier(u'>')]),
   FunctionLiteral([Identifier(u's'), Identifier(u'nameptr'), String(u'{ff~}{vv~}{ll}{, jj}'), Identifier(u'format.name$'), QuotedVar(u't'), Identifier(u':='), Identifier(u'nameptr'), Integer(1), Identifier(u'>'), FunctionLiteral([Identifier(u'namesleft'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u', '), Identifier(u'*'), Identifier(u't'), Identifier(u'*')]), FunctionLiteral([Identifier(u'numnames'), Integer(2), Identifier(u'>'), FunctionLiteral([String(u','), Identifier(u'*')]), QuotedVar(u'skip$'), Identifier(u'if$'), Identifier(u't'), String(u'others'), Identifier(u'='), FunctionLiteral([String(u' et~al.'), Identifier(u'*')]), FunctionLiteral([String(u' and '), Identifier(u'*'), Identifier(u't'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]), QuotedVar(u't'), Identifier(u'if$'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':='), Identifier(u'namesleft'), Integer(1), Identifier(u'-'), QuotedVar(u'namesleft'), Identifier(u':=')]),
   Identifier(u'while$')]],
 [u'FUNCTION',
  [Identifier(u'format.authors')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'format.names')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.editors')],
  [Identifier(u'editor'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'format.names'), Identifier(u'editor'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u', editors'), Identifier(u'*')]), FunctionLiteral([String(u', editor'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.title')],
  [Identifier(u'title'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'title'), String(u't'), Identifier(u'change.case$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'n.dashify')],
  [QuotedVar(u't'),
   Identifier(u':='),
   String(u''),
   FunctionLiteral([Identifier(u't'), Identifier(u'empty$'), Identifier(u'not')]),
   FunctionLiteral([Identifier(u't'), Integer(1), Integer(1), Identifier(u'substring$'), String(u'-'), Identifier(u'='), FunctionLiteral([Identifier(u't'), Integer(1), Integer(2), Identifier(u'substring$'), String(u'--'), Identifier(u'='), Identifier(u'not'), FunctionLiteral([String(u'--'), Identifier(u'*'), Identifier(u't'), Integer(2), Identifier(u'global.max$'), Identifier(u'substring$'), QuotedVar(u't'), Identifier(u':=')]), FunctionLiteral([FunctionLiteral([Identifier(u't'), Integer(1), Integer(1), Identifier(u'substring$'), String(u'-'), Identifier(u'=')]), FunctionLiteral([String(u'-'), Identifier(u'*'), Identifier(u't'), Integer(2), Identifier(u'global.max$'), Identifier(u'substring$'), QuotedVar(u't'), Identifier(u':=')]), Identifier(u'while$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u't'), Integer(1), Integer(1), Identifier(u'substring$'), Identifier(u'*'), Identifier(u't'), Integer(2), Identifier(u'global.max$'), Identifier(u'substring$'), QuotedVar(u't'), Identifier(u':=')]), Identifier(u'if$')]),
   Identifier(u'while$')]],
 [u'FUNCTION',
  [Identifier(u'format.date')],
  [Identifier(u'year'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'month'), Identifier(u'empty$'), FunctionLiteral([String(u'')]), FunctionLiteral([String(u"there's a month but no year in "), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), Identifier(u'month')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'month'), Identifier(u'empty$'), QuotedVar(u'year'), FunctionLiteral([Identifier(u'month'), String(u' '), Identifier(u'*'), Identifier(u'year'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle')],
  [Identifier(u'title'), Identifier(u'emphasize')]],
 [u'FUNCTION',
  [Identifier(u'tie.or.space.connect')],
  [Identifier(u'duplicate$'),
   Identifier(u'text.length$'),
   Integer(3),
   Identifier(u'<'),
   FunctionLiteral([String(u'~')]),
   FunctionLiteral([String(u' ')]),
   Identifier(u'if$'),
   Identifier(u'swap$'),
   Identifier(u'*'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'either.or.check')],
  [Identifier(u'empty$'),
   QuotedVar(u'pop$'),
   FunctionLiteral([String(u"can't use both "), Identifier(u'swap$'), Identifier(u'*'), String(u' fields in '), Identifier(u'*'), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.bvolume')],
  [Identifier(u'volume'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([String(u'volume'), Identifier(u'volume'), Identifier(u'tie.or.space.connect'), Identifier(u'series'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([String(u' of '), Identifier(u'*'), Identifier(u'series'), Identifier(u'emphasize'), Identifier(u'*')]), Identifier(u'if$'), String(u'volume and number'), Identifier(u'number'), Identifier(u'either.or.check')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.number.series')],
  [Identifier(u'volume'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'number'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'series'), Identifier(u'field.or.null')]), FunctionLiteral([Identifier(u'output.state'), Identifier(u'mid.sentence'), Identifier(u'='), FunctionLiteral([String(u'number')]), FunctionLiteral([String(u'Number')]), Identifier(u'if$'), Identifier(u'number'), Identifier(u'tie.or.space.connect'), Identifier(u'series'), Identifier(u'empty$'), FunctionLiteral([String(u"there's a number but no series in "), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]), FunctionLiteral([String(u' in '), Identifier(u'*'), Identifier(u'series'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]),
   FunctionLiteral([String(u'')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.edition')],
  [Identifier(u'edition'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'output.state'), Identifier(u'mid.sentence'), Identifier(u'='), FunctionLiteral([Identifier(u'edition'), String(u'l'), Identifier(u'change.case$'), String(u' edition'), Identifier(u'*')]), FunctionLiteral([Identifier(u'edition'), String(u't'), Identifier(u'change.case$'), String(u' edition'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'INTEGERS', [Identifier(u'multiresult')]],
 [u'FUNCTION',
  [Identifier(u'multi.page.check')],
  [QuotedVar(u't'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'multiresult'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'multiresult'), Identifier(u'not'), Identifier(u't'), Identifier(u'empty$'), Identifier(u'not'), Identifier(u'and')]),
   FunctionLiteral([Identifier(u't'), Integer(1), Integer(1), Identifier(u'substring$'), Identifier(u'duplicate$'), String(u'-'), Identifier(u'='), Identifier(u'swap$'), Identifier(u'duplicate$'), String(u','), Identifier(u'='), Identifier(u'swap$'), String(u'+'), Identifier(u'='), Identifier(u'or'), Identifier(u'or'), FunctionLiteral([Integer(1), QuotedVar(u'multiresult'), Identifier(u':=')]), FunctionLiteral([Identifier(u't'), Integer(2), Identifier(u'global.max$'), Identifier(u'substring$'), QuotedVar(u't'), Identifier(u':=')]), Identifier(u'if$')]),
   Identifier(u'while$'),
   Identifier(u'multiresult')]],
 [u'FUNCTION',
  [Identifier(u'format.pages')],
  [Identifier(u'pages'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'pages'), Identifier(u'multi.page.check'), FunctionLiteral([String(u'pages'), Identifier(u'pages'), Identifier(u'n.dashify'), Identifier(u'tie.or.space.connect')]), FunctionLiteral([String(u'page'), Identifier(u'pages'), Identifier(u'tie.or.space.connect')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.vol.num.pages')],
  [Identifier(u'volume'),
   Identifier(u'field.or.null'),
   Identifier(u'number'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([String(u'('), Identifier(u'number'), Identifier(u'*'), String(u')'), Identifier(u'*'), Identifier(u'*'), Identifier(u'volume'), Identifier(u'empty$'), FunctionLiteral([String(u"there's a number but no volume in "), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]), QuotedVar(u'skip$'), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'pages'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'pop$'), Identifier(u'format.pages')]), FunctionLiteral([String(u':'), Identifier(u'*'), Identifier(u'pages'), Identifier(u'n.dashify'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.chapter.pages')],
  [Identifier(u'chapter'),
   Identifier(u'empty$'),
   QuotedVar(u'format.pages'),
   FunctionLiteral([Identifier(u'type'), Identifier(u'empty$'), FunctionLiteral([String(u'chapter')]), FunctionLiteral([Identifier(u'type'), String(u'l'), Identifier(u'change.case$')]), Identifier(u'if$'), Identifier(u'chapter'), Identifier(u'tie.or.space.connect'), Identifier(u'pages'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([String(u', '), Identifier(u'*'), Identifier(u'format.pages'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.in.ed.booktitle')],
  [Identifier(u'booktitle'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([String(u'In '), Identifier(u'booktitle'), Identifier(u'emphasize'), Identifier(u'*')]), FunctionLiteral([String(u'In '), Identifier(u'format.editors'), Identifier(u'*'), String(u', '), Identifier(u'*'), Identifier(u'booktitle'), Identifier(u'emphasize'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'empty.misc.check')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   Identifier(u'title'),
   Identifier(u'empty$'),
   Identifier(u'howpublished'),
   Identifier(u'empty$'),
   Identifier(u'month'),
   Identifier(u'empty$'),
   Identifier(u'year'),
   Identifier(u'empty$'),
   Identifier(u'note'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   Identifier(u'and'),
   Identifier(u'and'),
   Identifier(u'and'),
   Identifier(u'and'),
   Identifier(u'key'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   Identifier(u'and'),
   FunctionLiteral([String(u'all relevant fields are empty in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.thesis.type')],
  [Identifier(u'type'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'type'), String(u't'), Identifier(u'change.case$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.tr.number')],
  [Identifier(u'type'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'Technical Report')]),
   QuotedVar(u'type'),
   Identifier(u'if$'),
   Identifier(u'number'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u't'), Identifier(u'change.case$')]),
   FunctionLiteral([Identifier(u'number'), Identifier(u'tie.or.space.connect')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.article.crossref')],
  [Identifier(u'key'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'journal'), Identifier(u'empty$'), FunctionLiteral([String(u'need key or journal for '), Identifier(u'cite$'), Identifier(u'*'), String(u' to crossref '), Identifier(u'*'), Identifier(u'crossref'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([String(u'In {\\em '), Identifier(u'journal'), Identifier(u'*'), String(u'\\/}'), Identifier(u'*')]), Identifier(u'if$')]),
   FunctionLiteral([String(u'In '), Identifier(u'key'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u' \\cite{'),
   Identifier(u'*'),
   Identifier(u'crossref'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.crossref.editor')],
  [Identifier(u'editor'),
   Integer(1),
   String(u'{vv~}{ll}'),
   Identifier(u'format.name$'),
   Identifier(u'editor'),
   Identifier(u'num.names$'),
   Identifier(u'duplicate$'),
   Integer(2),
   Identifier(u'>'),
   FunctionLiteral([Identifier(u'pop$'), String(u' et~al.'), Identifier(u'*')]),
   FunctionLiteral([Integer(2), Identifier(u'<'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'editor'), Integer(2), String(u'{ff }{vv }{ll}{ jj}'), Identifier(u'format.name$'), String(u'others'), Identifier(u'='), FunctionLiteral([String(u' et~al.'), Identifier(u'*')]), FunctionLiteral([String(u' and '), Identifier(u'*'), Identifier(u'editor'), Integer(2), String(u'{vv~}{ll}'), Identifier(u'format.name$'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.book.crossref')],
  [Identifier(u'volume'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'empty volume in '), Identifier(u'cite$'), Identifier(u'*'), String(u"'s crossref of "), Identifier(u'*'), Identifier(u'crossref'), Identifier(u'*'), Identifier(u'warning$'), String(u'In ')]),
   FunctionLiteral([String(u'Volume'), Identifier(u'volume'), Identifier(u'tie.or.space.connect'), String(u' of '), Identifier(u'*')]),
   Identifier(u'if$'),
   Identifier(u'editor'),
   Identifier(u'empty$'),
   Identifier(u'editor'),
   Identifier(u'field.or.null'),
   Identifier(u'author'),
   Identifier(u'field.or.null'),
   Identifier(u'='),
   Identifier(u'or'),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'series'), Identifier(u'empty$'), FunctionLiteral([String(u'need editor, key, or series for '), Identifier(u'cite$'), Identifier(u'*'), String(u' to crossref '), Identifier(u'*'), Identifier(u'crossref'), Identifier(u'*'), Identifier(u'warning$'), String(u''), Identifier(u'*')]), FunctionLiteral([String(u'{\\em '), Identifier(u'*'), Identifier(u'series'), Identifier(u'*'), String(u'\\/}'), Identifier(u'*')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'key'), Identifier(u'*')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.crossref.editor'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u' \\cite{'),
   Identifier(u'*'),
   Identifier(u'crossref'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.incoll.inproc.crossref')],
  [Identifier(u'editor'),
   Identifier(u'empty$'),
   Identifier(u'editor'),
   Identifier(u'field.or.null'),
   Identifier(u'author'),
   Identifier(u'field.or.null'),
   Identifier(u'='),
   Identifier(u'or'),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'booktitle'), Identifier(u'empty$'), FunctionLiteral([String(u'need editor, key, or booktitle for '), Identifier(u'cite$'), Identifier(u'*'), String(u' to crossref '), Identifier(u'*'), Identifier(u'crossref'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([String(u'In {\\em '), Identifier(u'booktitle'), Identifier(u'*'), String(u'\\/}'), Identifier(u'*')]), Identifier(u'if$')]), FunctionLiteral([String(u'In '), Identifier(u'key'), Identifier(u'*')]), Identifier(u'if$')]),
   FunctionLiteral([String(u'In '), Identifier(u'format.crossref.editor'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u' \\cite{'),
   Identifier(u'*'),
   Identifier(u'crossref'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'article')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'crossref'),
   Identifier(u'missing$'),
   FunctionLiteral([Identifier(u'journal'), Identifier(u'emphasize'), String(u'journal'), Identifier(u'output.check'), Identifier(u'format.vol.num.pages'), Identifier(u'output'), Identifier(u'format.date'), String(u'year'), Identifier(u'output.check')]),
   FunctionLiteral([Identifier(u'format.article.crossref'), Identifier(u'output.nonnull'), Identifier(u'format.pages'), Identifier(u'output')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'book')],
  [Identifier(u'output.bibitem'),
   Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'format.editors'), String(u'author and editor'), Identifier(u'output.check')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'output.nonnull'), Identifier(u'crossref'), Identifier(u'missing$'), FunctionLiteral([String(u'author and editor'), Identifier(u'editor'), Identifier(u'either.or.check')]), QuotedVar(u'skip$'), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'format.btitle'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'crossref'),
   Identifier(u'missing$'),
   FunctionLiteral([Identifier(u'format.bvolume'), Identifier(u'output'), Identifier(u'new.block'), Identifier(u'format.number.series'), Identifier(u'output'), Identifier(u'new.sentence'), Identifier(u'publisher'), String(u'publisher'), Identifier(u'output.check'), Identifier(u'address'), Identifier(u'output')]),
   FunctionLiteral([Identifier(u'new.block'), Identifier(u'format.book.crossref'), Identifier(u'output.nonnull')]),
   Identifier(u'if$'),
   Identifier(u'format.edition'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   String(u'year'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'booklet')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   Identifier(u'output'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'howpublished'),
   Identifier(u'address'),
   Identifier(u'new.block.checkb'),
   Identifier(u'howpublished'),
   Identifier(u'output'),
   Identifier(u'address'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   Identifier(u'output'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'inbook')],
  [Identifier(u'output.bibitem'),
   Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'format.editors'), String(u'author and editor'), Identifier(u'output.check')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'output.nonnull'), Identifier(u'crossref'), Identifier(u'missing$'), FunctionLiteral([String(u'author and editor'), Identifier(u'editor'), Identifier(u'either.or.check')]), QuotedVar(u'skip$'), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'format.btitle'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'crossref'),
   Identifier(u'missing$'),
   FunctionLiteral([Identifier(u'format.bvolume'), Identifier(u'output'), Identifier(u'format.chapter.pages'), String(u'chapter and pages'), Identifier(u'output.check'), Identifier(u'new.block'), Identifier(u'format.number.series'), Identifier(u'output'), Identifier(u'new.sentence'), Identifier(u'publisher'), String(u'publisher'), Identifier(u'output.check'), Identifier(u'address'), Identifier(u'output')]),
   FunctionLiteral([Identifier(u'format.chapter.pages'), String(u'chapter and pages'), Identifier(u'output.check'), Identifier(u'new.block'), Identifier(u'format.book.crossref'), Identifier(u'output.nonnull')]),
   Identifier(u'if$'),
   Identifier(u'format.edition'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   String(u'year'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'incollection')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'crossref'),
   Identifier(u'missing$'),
   FunctionLiteral([Identifier(u'format.in.ed.booktitle'), String(u'booktitle'), Identifier(u'output.check'), Identifier(u'format.bvolume'), Identifier(u'output'), Identifier(u'format.number.series'), Identifier(u'output'), Identifier(u'format.chapter.pages'), Identifier(u'output'), Identifier(u'new.sentence'), Identifier(u'publisher'), String(u'publisher'), Identifier(u'output.check'), Identifier(u'address'), Identifier(u'output'), Identifier(u'format.edition'), Identifier(u'output'), Identifier(u'format.date'), String(u'year'), Identifier(u'output.check')]),
   FunctionLiteral([Identifier(u'format.incoll.inproc.crossref'), Identifier(u'output.nonnull'), Identifier(u'format.chapter.pages'), Identifier(u'output')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'inproceedings')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'crossref'),
   Identifier(u'missing$'),
   FunctionLiteral([Identifier(u'format.in.ed.booktitle'), String(u'booktitle'), Identifier(u'output.check'), Identifier(u'format.bvolume'), Identifier(u'output'), Identifier(u'format.number.series'), Identifier(u'output'), Identifier(u'format.pages'), Identifier(u'output'), Identifier(u'address'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'organization'), Identifier(u'publisher'), Identifier(u'new.sentence.checkb'), Identifier(u'organization'), Identifier(u'output'), Identifier(u'publisher'), Identifier(u'output'), Identifier(u'format.date'), String(u'year'), Identifier(u'output.check')]), FunctionLiteral([Identifier(u'address'), Identifier(u'output.nonnull'), Identifier(u'format.date'), String(u'year'), Identifier(u'output.check'), Identifier(u'new.sentence'), Identifier(u'organization'), Identifier(u'output'), Identifier(u'publisher'), Identifier(u'output')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.incoll.inproc.crossref'), Identifier(u'output.nonnull'), Identifier(u'format.pages'), Identifier(u'output')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION', [Identifier(u'conference')], [Identifier(u'inproceedings')]],
 [u'FUNCTION',
  [Identifier(u'manual')],
  [Identifier(u'output.bibitem'),
   Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'organization'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'organization'), Identifier(u'output.nonnull'), Identifier(u'address'), Identifier(u'output')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'output.nonnull')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'format.btitle'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'organization'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'address'), Identifier(u'new.block.checka'), Identifier(u'address'), Identifier(u'output')]), QuotedVar(u'skip$'), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'organization'), Identifier(u'address'), Identifier(u'new.block.checkb'), Identifier(u'organization'), Identifier(u'output'), Identifier(u'address'), Identifier(u'output')]),
   Identifier(u'if$'),
   Identifier(u'format.edition'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   Identifier(u'output'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'mastersthesis')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   String(u"Master's thesis"),
   Identifier(u'format.thesis.type'),
   Identifier(u'output.nonnull'),
   Identifier(u'school'),
   String(u'school'),
   Identifier(u'output.check'),
   Identifier(u'address'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   String(u'year'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'misc')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   Identifier(u'output'),
   Identifier(u'title'),
   Identifier(u'howpublished'),
   Identifier(u'new.block.checkb'),
   Identifier(u'format.title'),
   Identifier(u'output'),
   Identifier(u'howpublished'),
   Identifier(u'new.block.checka'),
   Identifier(u'howpublished'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   Identifier(u'output'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry'),
   Identifier(u'empty.misc.check')]],
 [u'FUNCTION',
  [Identifier(u'phdthesis')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.btitle'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   String(u'PhD thesis'),
   Identifier(u'format.thesis.type'),
   Identifier(u'output.nonnull'),
   Identifier(u'school'),
   String(u'school'),
   Identifier(u'output.check'),
   Identifier(u'address'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   String(u'year'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'proceedings')],
  [Identifier(u'output.bibitem'),
   Identifier(u'editor'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'organization'), Identifier(u'output')]),
   FunctionLiteral([Identifier(u'format.editors'), Identifier(u'output.nonnull')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'format.btitle'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'format.bvolume'),
   Identifier(u'output'),
   Identifier(u'format.number.series'),
   Identifier(u'output'),
   Identifier(u'address'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'publisher'), Identifier(u'new.sentence.checka')]), FunctionLiteral([Identifier(u'organization'), Identifier(u'publisher'), Identifier(u'new.sentence.checkb'), Identifier(u'organization'), Identifier(u'output')]), Identifier(u'if$'), Identifier(u'publisher'), Identifier(u'output'), Identifier(u'format.date'), String(u'year'), Identifier(u'output.check')]),
   FunctionLiteral([Identifier(u'address'), Identifier(u'output.nonnull'), Identifier(u'format.date'), String(u'year'), Identifier(u'output.check'), Identifier(u'new.sentence'), Identifier(u'editor'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'organization'), Identifier(u'output')]), Identifier(u'if$'), Identifier(u'publisher'), Identifier(u'output')]),
   Identifier(u'if$'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'techreport')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.tr.number'),
   Identifier(u'output.nonnull'),
   Identifier(u'institution'),
   String(u'institution'),
   Identifier(u'output.check'),
   Identifier(u'address'),
   Identifier(u'output'),
   Identifier(u'format.date'),
   String(u'year'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'unpublished')],
  [Identifier(u'output.bibitem'),
   Identifier(u'format.authors'),
   String(u'author'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'format.title'),
   String(u'title'),
   Identifier(u'output.check'),
   Identifier(u'new.block'),
   Identifier(u'note'),
   String(u'note'),
   Identifier(u'output.check'),
   Identifier(u'format.date'),
   Identifier(u'output'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION', [Identifier(u'default.type')], [Identifier(u'misc')]],
 [u'MACRO', [Identifier(u'jan')], [String(u'January')]],
 [u'MACRO', [Identifier(u'feb')], [String(u'February')]],
 [u'MACRO', [Identifier(u'mar')], [String(u'March')]],
 [u'MACRO', [Identifier(u'apr')], [String(u'April')]],
 [u'MACRO', [Identifier(u'may')], [String(u'May')]],
 [u'MACRO', [Identifier(u'jun')], [String(u'June')]],
 [u'MACRO', [Identifier(u'jul')], [String(u'July')]],
 [u'MACRO', [Identifier(u'aug')], [String(u'August')]],
 [u'MACRO', [Identifier(u'sep')], [String(u'September')]],
 [u'MACRO', [Identifier(u'oct')], [String(u'October')]],
 [u'MACRO', [Identifier(u'nov')], [String(u'November')]],
 [u'MACRO', [Identifier(u'dec')], [String(u'December')]],
 [u'MACRO', [Identifier(u'acmcs')], [String(u'ACM Computing Surveys')]],
 [u'MACRO', [Identifier(u'acta')], [String(u'Acta Informatica')]],
 [u'MACRO', [Identifier(u'cacm')], [String(u'Communications of the ACM')]],
 [u'MACRO',
  [Identifier(u'ibmjrd')],
  [String(u'IBM Journal of Research and Development')]],
 [u'MACRO', [Identifier(u'ibmsj')], [String(u'IBM Systems Journal')]],
 [u'MACRO',
  [Identifier(u'ieeese')],
  [String(u'IEEE Transactions on Software Engineering')]],
 [u'MACRO',
  [Identifier(u'ieeetc')],
  [String(u'IEEE Transactions on Computers')]],
 [u'MACRO',
  [Identifier(u'ieeetcad')],
  [String(u'IEEE Transactions on Computer-Aided Design of Integrated Circuits')]],
 [u'MACRO', [Identifier(u'ipl')], [String(u'Information Processing Letters')]],
 [u'MACRO', [Identifier(u'jacm')], [String(u'Journal of the ACM')]],
 [u'MACRO',
  [Identifier(u'jcss')],
  [String(u'Journal of Computer and System Sciences')]],
 [u'MACRO',
  [Identifier(u'scp')],
  [String(u'Science of Computer Programming')]],
 [u'MACRO', [Identifier(u'sicomp')], [String(u'SIAM Journal on Computing')]],
 [u'MACRO',
  [Identifier(u'tocs')],
  [String(u'ACM Transactions on Computer Systems')]],
 [u'MACRO',
  [Identifier(u'tods')],
  [String(u'ACM Transactions on Database Systems')]],
 [u'MACRO', [Identifier(u'tog')], [String(u'ACM Transactions on Graphics')]],
 [u'MACRO',
  [Identifier(u'toms')],
  [String(u'ACM Transactions on Mathematical Software')]],
 [u'MACRO',
  [Identifier(u'toois')],
  [String(u'ACM Transactions on Office Information Systems')]],
 [u'MACRO',
  [Identifier(u'toplas')],
  [String(u'ACM Transactions on Programming Languages and Systems')]],
 [u'MACRO', [Identifier(u'tcs')], [String(u'Theoretical Computer Science')]],
 [u'READ'],
 [u'FUNCTION',
  [Identifier(u'sortify')],
  [Identifier(u'purify$'), String(u'l'), Identifier(u'change.case$')]],
 [u'INTEGERS', [Identifier(u'len')]],
 [u'FUNCTION',
  [Identifier(u'chop.word')],
  [QuotedVar(u's'),
   Identifier(u':='),
   QuotedVar(u'len'),
   Identifier(u':='),
   Identifier(u's'),
   Integer(1),
   Identifier(u'len'),
   Identifier(u'substring$'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u's'), Identifier(u'len'), Integer(1), Identifier(u'+'), Identifier(u'global.max$'), Identifier(u'substring$')]),
   QuotedVar(u's'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'sort.format.names')],
  [QuotedVar(u's'),
   Identifier(u':='),
   Integer(1),
   QuotedVar(u'nameptr'),
   Identifier(u':='),
   String(u''),
   Identifier(u's'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'numnames'),
   QuotedVar(u'namesleft'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'namesleft'), Integer(0), Identifier(u'>')]),
   FunctionLiteral([Identifier(u'nameptr'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u'   '), Identifier(u'*')]), QuotedVar(u'skip$'), Identifier(u'if$'), Identifier(u's'), Identifier(u'nameptr'), String(u'{vv{ } }{ll{ }}{  ff{ }}{  jj{ }}'), Identifier(u'format.name$'), QuotedVar(u't'), Identifier(u':='), Identifier(u'nameptr'), Identifier(u'numnames'), Identifier(u'='), Identifier(u't'), String(u'others'), Identifier(u'='), Identifier(u'and'), FunctionLiteral([String(u'et al'), Identifier(u'*')]), FunctionLiteral([Identifier(u't'), Identifier(u'sortify'), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':='), Identifier(u'namesleft'), Integer(1), Identifier(u'-'), QuotedVar(u'namesleft'), Identifier(u':=')]),
   Identifier(u'while$')]],
 [u'FUNCTION',
  [Identifier(u'sort.format.title')],
  [QuotedVar(u't'),
   Identifier(u':='),
   String(u'A '),
   Integer(2),
   String(u'An '),
   Integer(3),
   String(u'The '),
   Integer(4),
   Identifier(u't'),
   Identifier(u'chop.word'),
   Identifier(u'chop.word'),
   Identifier(u'chop.word'),
   Identifier(u'sortify'),
   Integer(1),
   Identifier(u'global.max$'),
   Identifier(u'substring$')]],
 [u'FUNCTION',
  [Identifier(u'author.sort')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), FunctionLiteral([String(u'to sort, need author or key in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'sort.format.names')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'author.editor.sort')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), FunctionLiteral([String(u'to sort, need author, editor, or key in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'sort.format.names')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'sort.format.names')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'author.organization.sort')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'organization'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), FunctionLiteral([String(u'to sort, need author, organization, or key in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify')]), Identifier(u'if$')]), FunctionLiteral([String(u'The '), Integer(4), Identifier(u'organization'), Identifier(u'chop.word'), Identifier(u'sortify')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'sort.format.names')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'editor.organization.sort')],
  [Identifier(u'editor'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'organization'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), FunctionLiteral([String(u'to sort, need editor, organization, or key in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify')]), Identifier(u'if$')]), FunctionLiteral([String(u'The '), Integer(4), Identifier(u'organization'), Identifier(u'chop.word'), Identifier(u'sortify')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'sort.format.names')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'presort')],
  [Identifier(u'type$'),
   String(u'book'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'inbook'),
   Identifier(u'='),
   Identifier(u'or'),
   QuotedVar(u'author.editor.sort'),
   FunctionLiteral([Identifier(u'type$'), String(u'proceedings'), Identifier(u'='), QuotedVar(u'editor.organization.sort'), FunctionLiteral([Identifier(u'type$'), String(u'manual'), Identifier(u'='), QuotedVar(u'author.organization.sort'), QuotedVar(u'author.sort'), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'year'),
   Identifier(u'field.or.null'),
   Identifier(u'sortify'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'title'),
   Identifier(u'field.or.null'),
   Identifier(u'sort.format.title'),
   Identifier(u'*'),
   Integer(1),
   Identifier(u'entry.max$'),
   Identifier(u'substring$'),
   QuotedVar(u'sort.key$'),
   Identifier(u':=')]],
 [u'ITERATE', [Identifier(u'presort')]],
 [u'SORT'],
 [u'STRINGS', [Identifier(u'longest.label')]],
 [u'INTEGERS',
  [Identifier(u'number.label'), Identifier(u'longest.label.width')]],
 [u'FUNCTION',
  [Identifier(u'initialize.longest.label')],
  [String(u''),
   QuotedVar(u'longest.label'),
   Identifier(u':='),
   Integer(1),
   QuotedVar(u'number.label'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'longest.label.width'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'longest.label.pass')],
  [Identifier(u'number.label'),
   Identifier(u'int.to.str$'),
   QuotedVar(u'label'),
   Identifier(u':='),
   Identifier(u'number.label'),
   Integer(1),
   Identifier(u'+'),
   QuotedVar(u'number.label'),
   Identifier(u':='),
   Identifier(u'label'),
   Identifier(u'width$'),
   Identifier(u'longest.label.width'),
   Identifier(u'>'),
   FunctionLiteral([Identifier(u'label'), QuotedVar(u'longest.label'), Identifier(u':='), Identifier(u'label'), Identifier(u'width$'), QuotedVar(u'longest.label.width'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'EXECUTE', [Identifier(u'initialize.longest.label')]],
 [u'ITERATE', [Identifier(u'longest.label.pass')]],
 [u'FUNCTION',
  [Identifier(u'begin.bib')],
  [Identifier(u'preamble$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'preamble$'), Identifier(u'write$'), Identifier(u'newline$')]),
   Identifier(u'if$'),
   String(u'\\begin{thebibliography}{'),
   Identifier(u'longest.label'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'EXECUTE', [Identifier(u'begin.bib')]],
 [u'EXECUTE', [Identifier(u'init.state.consts')]],
 [u'ITERATE', [Identifier(u'call.type$')]],
 [u'FUNCTION',
  [Identifier(u'end.bib')],
  [Identifier(u'newline$'),
   String(u'\\end{thebibliography}'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'EXECUTE', [Identifier(u'end.bib')]]]
