/* -*- mode: c -*- */

/* Licensed under a 3-clause BSD style license - see LICENSE.rst */

/*
 * "ufunc.c" is auto-generated by erfa_generator.py from the template
 * "ufunc.c.templ". Do *not* edit "ufunc.c" directly, instead edit
 * "ufunc.c.templ" and run erfa_generator.py from the source directory
 * to update it.
 */

/*
Note that this file is restricted to Python's Limited API, but we define the
corresponding macro dynamically in setup.py so it can be disabled for Python builds
that do not support it (e.g., 3.13t)
*/

#define NPY_NO_DEPRECATED_API NPY_1_7_API_VERSION
#include "Python.h"
#include "numpy/arrayobject.h"
#include "numpy/ufuncobject.h"
#include "erfa.h"
#include "erfaextra.h"

// Backported NumPy 2 API (can be removed if numpy 2 is required)
#if NPY_ABI_VERSION < 0x02000000
#define PyDataType_ELSIZE(descr) ((descr)->elsize)
#endif

// On gcc<10 we can run into the following:
//
//   error: dereferencing pointer to incomplete type 'PyTypeObject'
//
// As mentioned in https://github.com/numpy/numpy/issues/16970,
// the workaround is to define a fake _typeobject struct.

#if (defined Py_LIMITED_API) && !(defined PYPY_VERSION)
typedef struct _typeobject {
    int dummy;
};
#endif

#define MODULE_DOCSTRING \
    "Ufunc wrappers of the ERFA routines.\n\n" \
    "These ufuncs vectorize the ERFA functions assuming structured dtypes\n" \
    "for vector and matrix arguments. Status codes are vectors as well.\n" \
    "Python wrappers are also provided, which convert between\n" \
    "trailing dimensions and structured dtypes where necessary,\n" \
    "and combine status codes."
#define GET_LEAP_SECONDS_DOCSTRING \
    "get_leap_seconds()\n\n" \
    "Access the leap second table used in ERFA.\n\n" \
    "Returns\n" \
    "-------\n" \
    "leap_seconds : `~numpy.ndarray`\n" \
    "    With structured dtype `~erfa.dt_eraLEAPSECOND`,\n" \
    "    containing items 'year', 'month', and 'tai_utc'."
#define SET_LEAP_SECONDS_DOCSTRING \
    "set_leap_seconds([table])\n\n" \
    "Set the leap second table used in ERFA.\n\n" \
    "Parameters\n" \
    "----------\n" \
    "leap_seconds : array_like, optional\n" \
    "    With structured dtype `~erfa.dt_eraLEAPSECOND`,\n" \
    "    containing items 'year', 'month', and 'tai_utc'.\n" \
    "    If not given, reset to the ERFA built-in table.\n\n" \
    "Notes\n" \
    "-----\n" \
    "No sanity checks are done on the input; it is simply coerced\n" \
    "to the correct dtype."


static inline void copy_to_double3(char *ptr, npy_intp s, double d[3]) {
    char *p = ptr;
    int j;
    for (j = 0; j < 3; j++, p += s) {
        d[j] = *(double *)p;
    }
}

static inline void copy_from_double3(char *ptr, npy_intp s, double d[3]) {
    char *p = ptr;
    int j;
    for (j = 0; j < 3; j++, p += s) {
        *(double *)p = d[j];
    }
}

static inline void copy_to_double33(char *ptr, npy_intp s0, npy_intp s1,
                                    double d[3][3]) {
    char *p0 = ptr;
    int j0, j1;
    for (j0 = 0; j0 < 3; j0++, p0 += s0) {
        char *p1 = p0;
        for (j1 = 0; j1 < 3; j1++, p1 += s1) {
            d[j0][j1] = *(double *)p1;
        }
    }
}

static inline void copy_from_double33(char *ptr, npy_intp s0, npy_intp s1,
                                      double d[3][3]) {
    char *p = ptr;
    char *p0 = ptr;
    int j0, j1;
    for (j0 = 0; j0 < 3; j0++, p0 += s0) {
        char *p1 = p0;
        for (j1 = 0; j1 < 3; j1++, p1 += s1) {
            *(double *)p = d[j0][j1];
        }
    }
}

/* eraLDBODY is never returned, so we do not need a copy_from */
static inline void copy_to_eraLDBODY(char *ptr, npy_intp s, npy_intp n,
                                  eraLDBODY b[]) {
    char *p = ptr;
    npy_intp j;
    for (j = 0; j < n; j++, p += s) {
        b[j] = *(eraLDBODY *)p;
    }
}

/*
 * INNER LOOPS - iteratively call the erfa function for a chunk of data.
 *
 * For each argument:
 * char *<name> is the pointer to the data in memory;
 * npy_intp s_<name> is the number of bytes between successive elements;
 * <ctype> *_<name> is a correctly cast pointer to the current element;
 * (<ctype> _<name>, i.e., not a pointer, for status codes and return values)
 *
 * Notes:
 * 1. Some erfa function change elements in-place; in the ufunc, these "inout"
 *    arguments are treated as separate: data is copied from the input to the
 *    output, and the output is changed in-place by the erfa function.
 *    To reproduce the in-place behaviour, the input to the ufunc can be passed
 *    in as output as well -- as is done in the python wrapper (the copy will
 *    be omitted for this case).
 * 2. Any erfa function involving light deflection requires an struct
 *    eraLDBODY argument with a dimension that is user-defined. Those function
 *    are implemented as generalized ufuncs, with a signature in which the
 *    relevant variable is marked (i.e., '(),...,(n), (), ... -> (),...').
 *    In the inner loops, an appropriate copy is done if in the numpy array
 *    the n elements are not contiguous.
 * 3. Similar copies are done for erfa functions that require vectors or
 *    matrices, if the corresponding axes in the input or output operands are
 *    not contiguous.
 */

static void ufunc_loop_cal2jd(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *iy = *args++;
    npy_intp s_iy = *steps++;
    char *im = *args++;
    npy_intp s_im = *steps++;
    char *id = *args++;
    npy_intp s_id = *steps++;
    char *djm0 = *args++;
    npy_intp s_djm0 = *steps++;
    char *djm = *args++;
    npy_intp s_djm = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    int (*_iy);
    int (*_im);
    int (*_id);
    double (*_djm0);
    double (*_djm);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, iy += s_iy, im += s_im, id += s_id, djm0 += s_djm0, djm += s_djm, c_retval += s_c_retval) {
        _iy = ((int (*))iy);
        _im = ((int (*))im);
        _id = ((int (*))id);
        _djm0 = ((double (*))djm0);
        _djm = ((double (*))djm);
        _c_retval = eraCal2jd(*_iy, *_im, *_id, _djm0, _djm);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_epb(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dj1 = *args++;
    npy_intp s_dj1 = *steps++;
    char *dj2 = *args++;
    npy_intp s_dj2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, dj1 += s_dj1, dj2 += s_dj2, c_retval += s_c_retval) {
        _dj1 = ((double (*))dj1);
        _dj2 = ((double (*))dj2);
        _c_retval = eraEpb(*_dj1, *_dj2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_epb2jd(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epb = *args++;
    npy_intp s_epb = *steps++;
    char *djm0 = *args++;
    npy_intp s_djm0 = *steps++;
    char *djm = *args++;
    npy_intp s_djm = *steps++;
    double (*_epb);
    double (*_djm0);
    double (*_djm);
    for (i_o = 0; i_o < n_o;
         i_o++, epb += s_epb, djm0 += s_djm0, djm += s_djm) {
        _epb = ((double (*))epb);
        _djm0 = ((double (*))djm0);
        _djm = ((double (*))djm);
        eraEpb2jd(*_epb, _djm0, _djm);
    }
}

static void ufunc_loop_epj(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dj1 = *args++;
    npy_intp s_dj1 = *steps++;
    char *dj2 = *args++;
    npy_intp s_dj2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, dj1 += s_dj1, dj2 += s_dj2, c_retval += s_c_retval) {
        _dj1 = ((double (*))dj1);
        _dj2 = ((double (*))dj2);
        _c_retval = eraEpj(*_dj1, *_dj2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_epj2jd(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *djm0 = *args++;
    npy_intp s_djm0 = *steps++;
    char *djm = *args++;
    npy_intp s_djm = *steps++;
    double (*_epj);
    double (*_djm0);
    double (*_djm);
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, djm0 += s_djm0, djm += s_djm) {
        _epj = ((double (*))epj);
        _djm0 = ((double (*))djm0);
        _djm = ((double (*))djm);
        eraEpj2jd(*_epj, _djm0, _djm);
    }
}

static void ufunc_loop_jd2cal(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dj1 = *args++;
    npy_intp s_dj1 = *steps++;
    char *dj2 = *args++;
    npy_intp s_dj2 = *steps++;
    char *iy = *args++;
    npy_intp s_iy = *steps++;
    char *im = *args++;
    npy_intp s_im = *steps++;
    char *id = *args++;
    npy_intp s_id = *steps++;
    char *fd = *args++;
    npy_intp s_fd = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_dj1);
    double (*_dj2);
    int (*_iy);
    int (*_im);
    int (*_id);
    double (*_fd);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, dj1 += s_dj1, dj2 += s_dj2, iy += s_iy, im += s_im, id += s_id, fd += s_fd, c_retval += s_c_retval) {
        _dj1 = ((double (*))dj1);
        _dj2 = ((double (*))dj2);
        _iy = ((int (*))iy);
        _im = ((int (*))im);
        _id = ((int (*))id);
        _fd = ((double (*))fd);
        _c_retval = eraJd2cal(*_dj1, *_dj2, _iy, _im, _id, _fd);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_jdcalf(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ndp = *args++;
    npy_intp s_ndp = *steps++;
    char *dj1 = *args++;
    npy_intp s_dj1 = *steps++;
    char *dj2 = *args++;
    npy_intp s_dj2 = *steps++;
    char *iymdf = *args++;
    npy_intp s_iymdf = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    int (*_ndp);
    double (*_dj1);
    double (*_dj2);
    int (*_iymdf)[4];
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ndp += s_ndp, dj1 += s_dj1, dj2 += s_dj2, iymdf += s_iymdf, c_retval += s_c_retval) {
        _ndp = ((int (*))ndp);
        _dj1 = ((double (*))dj1);
        _dj2 = ((double (*))dj2);
        _iymdf = ((int (*)[4])iymdf);
        _c_retval = eraJdcalf(*_ndp, *_dj1, *_dj2, *_iymdf);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ab(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pnat = *args++;
    npy_intp s_pnat = *steps++;
    char *v = *args++;
    npy_intp s_v = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *bm1 = *args++;
    npy_intp s_bm1 = *steps++;
    char *ppr = *args++;
    npy_intp s_ppr = *steps++;
    double b_pnat[3];
    double (*_pnat)[3] = &b_pnat;
    double b_v[3];
    double (*_v)[3] = &b_v;
    double (*_s);
    double (*_bm1);
    double b_ppr[3];
    double (*_ppr)[3] = &b_ppr;
    npy_intp is_pnat0 = *steps++;
    int copy_pnat = (is_pnat0 != sizeof(double));
    npy_intp is_v0 = *steps++;
    int copy_v = (is_v0 != sizeof(double));
    npy_intp is_ppr0 = *steps++;
    int copy_ppr = (is_ppr0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, pnat += s_pnat, v += s_v, s += s_s, bm1 += s_bm1, ppr += s_ppr) {
        if (copy_pnat) {
            copy_to_double3(pnat, is_pnat0, *_pnat);
        }
        else {
            _pnat = ((double (*)[3])pnat);
        }
        if (copy_v) {
            copy_to_double3(v, is_v0, *_v);
        }
        else {
            _v = ((double (*)[3])v);
        }
        _s = ((double (*))s);
        _bm1 = ((double (*))bm1);
        if (!copy_ppr) {
            _ppr = ((double (*)[3])ppr);
        }
        eraAb(*_pnat, *_v, *_s, *_bm1, *_ppr);
        if (copy_ppr) {
            copy_from_double3(ppr, is_ppr0, *_ppr);
        }
    }
}

static void ufunc_loop_apcg(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *ebpv = *args++;
    npy_intp s_ebpv = *steps++;
    char *ehp = *args++;
    npy_intp s_ehp = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_ebpv)[2][3];
    double b_ehp[3];
    double (*_ehp)[3] = &b_ehp;
    eraASTROM (*_astrom);
    npy_intp is_ehp0 = *steps++;
    int copy_ehp = (is_ehp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, ebpv += s_ebpv, ehp += s_ehp, astrom += s_astrom) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _ebpv = ((double (*)[2][3])ebpv);
        if (copy_ehp) {
            copy_to_double3(ehp, is_ehp0, *_ehp);
        }
        else {
            _ehp = ((double (*)[3])ehp);
        }
        _astrom = ((eraASTROM (*))astrom);
        eraApcg(*_date1, *_date2, *_ebpv, *_ehp, _astrom);
    }
}

static void ufunc_loop_apcg13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_date1);
    double (*_date2);
    eraASTROM (*_astrom);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, astrom += s_astrom) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _astrom = ((eraASTROM (*))astrom);
        eraApcg13(*_date1, *_date2, _astrom);
    }
}

static void ufunc_loop_apci(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *ebpv = *args++;
    npy_intp s_ebpv = *steps++;
    char *ehp = *args++;
    npy_intp s_ehp = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_ebpv)[2][3];
    double b_ehp[3];
    double (*_ehp)[3] = &b_ehp;
    double (*_x);
    double (*_y);
    double (*_s);
    eraASTROM (*_astrom);
    npy_intp is_ehp0 = *steps++;
    int copy_ehp = (is_ehp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, ebpv += s_ebpv, ehp += s_ehp, x += s_x, y += s_y, s += s_s, astrom += s_astrom) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _ebpv = ((double (*)[2][3])ebpv);
        if (copy_ehp) {
            copy_to_double3(ehp, is_ehp0, *_ehp);
        }
        else {
            _ehp = ((double (*)[3])ehp);
        }
        _x = ((double (*))x);
        _y = ((double (*))y);
        _s = ((double (*))s);
        _astrom = ((eraASTROM (*))astrom);
        eraApci(*_date1, *_date2, *_ebpv, *_ehp, *_x, *_y, *_s, _astrom);
    }
}

static void ufunc_loop_apci13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *eo = *args++;
    npy_intp s_eo = *steps++;
    double (*_date1);
    double (*_date2);
    eraASTROM (*_astrom);
    double (*_eo);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, astrom += s_astrom, eo += s_eo) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _astrom = ((eraASTROM (*))astrom);
        _eo = ((double (*))eo);
        eraApci13(*_date1, *_date2, _astrom, _eo);
    }
}

static void ufunc_loop_apco(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *ebpv = *args++;
    npy_intp s_ebpv = *steps++;
    char *ehp = *args++;
    npy_intp s_ehp = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *sp = *args++;
    npy_intp s_sp = *steps++;
    char *refa = *args++;
    npy_intp s_refa = *steps++;
    char *refb = *args++;
    npy_intp s_refb = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_ebpv)[2][3];
    double b_ehp[3];
    double (*_ehp)[3] = &b_ehp;
    double (*_x);
    double (*_y);
    double (*_s);
    double (*_theta);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_sp);
    double (*_refa);
    double (*_refb);
    eraASTROM (*_astrom);
    npy_intp is_ehp0 = *steps++;
    int copy_ehp = (is_ehp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, ebpv += s_ebpv, ehp += s_ehp, x += s_x, y += s_y, s += s_s, theta += s_theta, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, sp += s_sp, refa += s_refa, refb += s_refb, astrom += s_astrom) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _ebpv = ((double (*)[2][3])ebpv);
        if (copy_ehp) {
            copy_to_double3(ehp, is_ehp0, *_ehp);
        }
        else {
            _ehp = ((double (*)[3])ehp);
        }
        _x = ((double (*))x);
        _y = ((double (*))y);
        _s = ((double (*))s);
        _theta = ((double (*))theta);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _sp = ((double (*))sp);
        _refa = ((double (*))refa);
        _refb = ((double (*))refb);
        _astrom = ((eraASTROM (*))astrom);
        eraApco(*_date1, *_date2, *_ebpv, *_ehp, *_x, *_y, *_s, *_theta, *_elong, *_phi, *_hm, *_xp, *_yp, *_sp, *_refa, *_refb, _astrom);
    }
}

static void ufunc_loop_apco13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *eo = *args++;
    npy_intp s_eo = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    eraASTROM (*_astrom);
    double (*_eo);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, astrom += s_astrom, eo += s_eo, c_retval += s_c_retval) {
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _astrom = ((eraASTROM (*))astrom);
        _eo = ((double (*))eo);
        _c_retval = eraApco13(*_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _astrom, _eo);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_apcs(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *ebpv = *args++;
    npy_intp s_ebpv = *steps++;
    char *ehp = *args++;
    npy_intp s_ehp = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_pv)[2][3];
    double (*_ebpv)[2][3];
    double b_ehp[3];
    double (*_ehp)[3] = &b_ehp;
    eraASTROM (*_astrom);
    npy_intp is_ehp0 = *steps++;
    int copy_ehp = (is_ehp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, pv += s_pv, ebpv += s_ebpv, ehp += s_ehp, astrom += s_astrom) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _pv = ((double (*)[2][3])pv);
        _ebpv = ((double (*)[2][3])ebpv);
        if (copy_ehp) {
            copy_to_double3(ehp, is_ehp0, *_ehp);
        }
        else {
            _ehp = ((double (*)[3])ehp);
        }
        _astrom = ((eraASTROM (*))astrom);
        eraApcs(*_date1, *_date2, *_pv, *_ebpv, *_ehp, _astrom);
    }
}

static void ufunc_loop_apcs13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_pv)[2][3];
    eraASTROM (*_astrom);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, pv += s_pv, astrom += s_astrom) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _pv = ((double (*)[2][3])pv);
        _astrom = ((eraASTROM (*))astrom);
        eraApcs13(*_date1, *_date2, *_pv, _astrom);
    }
}

static void ufunc_loop_aper(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *astrom_in = *args++;
    npy_intp s_astrom_in = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_theta);
    eraASTROM (*_astrom);
    for (i_o = 0; i_o < n_o;
         i_o++, theta += s_theta, astrom += s_astrom, astrom_in += s_astrom_in) {
        _theta = ((double (*))theta);
        _astrom = ((eraASTROM (*))astrom);
        if (astrom_in != astrom) {
            memcpy(astrom, astrom_in, 1*sizeof(eraASTROM));
        }
        eraAper(*_theta, _astrom);
    }
}

static void ufunc_loop_aper13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *astrom_in = *args++;
    npy_intp s_astrom_in = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_ut11);
    double (*_ut12);
    eraASTROM (*_astrom);
    for (i_o = 0; i_o < n_o;
         i_o++, ut11 += s_ut11, ut12 += s_ut12, astrom += s_astrom, astrom_in += s_astrom_in) {
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _astrom = ((eraASTROM (*))astrom);
        if (astrom_in != astrom) {
            memcpy(astrom, astrom_in, 1*sizeof(eraASTROM));
        }
        eraAper13(*_ut11, *_ut12, _astrom);
    }
}

static void ufunc_loop_apio(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *sp = *args++;
    npy_intp s_sp = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *refa = *args++;
    npy_intp s_refa = *steps++;
    char *refb = *args++;
    npy_intp s_refb = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    double (*_sp);
    double (*_theta);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_refa);
    double (*_refb);
    eraASTROM (*_astrom);
    for (i_o = 0; i_o < n_o;
         i_o++, sp += s_sp, theta += s_theta, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, refa += s_refa, refb += s_refb, astrom += s_astrom) {
        _sp = ((double (*))sp);
        _theta = ((double (*))theta);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _refa = ((double (*))refa);
        _refb = ((double (*))refb);
        _astrom = ((eraASTROM (*))astrom);
        eraApio(*_sp, *_theta, *_elong, *_phi, *_hm, *_xp, *_yp, *_refa, *_refb, _astrom);
    }
}

static void ufunc_loop_apio13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    eraASTROM (*_astrom);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, astrom += s_astrom, c_retval += s_c_retval) {
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _astrom = ((eraASTROM (*))astrom);
        _c_retval = eraApio13(*_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _astrom);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_atcc13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *ra = *args++;
    npy_intp s_ra = *steps++;
    char *da = *args++;
    npy_intp s_da = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_date1);
    double (*_date2);
    double (*_ra);
    double (*_da);
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, date1 += s_date1, date2 += s_date2, ra += s_ra, da += s_da) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _ra = ((double (*))ra);
        _da = ((double (*))da);
        eraAtcc13(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_date1, *_date2, _ra, _da);
    }
}

static void ufunc_loop_atccq(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *ra = *args++;
    npy_intp s_ra = *steps++;
    char *da = *args++;
    npy_intp s_da = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    eraASTROM (*_astrom);
    double (*_ra);
    double (*_da);
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, astrom += s_astrom, ra += s_ra, da += s_da) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _astrom = ((eraASTROM (*))astrom);
        _ra = ((double (*))ra);
        _da = ((double (*))da);
        eraAtccq(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, _astrom, _ra, _da);
    }
}

static void ufunc_loop_atci13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *eo = *args++;
    npy_intp s_eo = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_date1);
    double (*_date2);
    double (*_ri);
    double (*_di);
    double (*_eo);
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, date1 += s_date1, date2 += s_date2, ri += s_ri, di += s_di, eo += s_eo) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _eo = ((double (*))eo);
        eraAtci13(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_date1, *_date2, _ri, _di, _eo);
    }
}

static void ufunc_loop_atciq(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    eraASTROM (*_astrom);
    double (*_ri);
    double (*_di);
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, astrom += s_astrom, ri += s_ri, di += s_di) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _astrom = ((eraASTROM (*))astrom);
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        eraAtciq(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, _astrom, _ri, _di);
    }
}

static void ufunc_loop_atciqn(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    eraASTROM (*_astrom);
    eraLDBODY (*_b);
    double (*_ri);
    double (*_di);
    npy_intp nb = dimensions[0];
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(eraLDBODY));
    if (copy_b) {
        // Note that we can't use PyArray_malloc here as it is an alias to PyMem_RawMalloc
        // which is not available in the Python limited API
        _b = malloc(nb * sizeof(eraLDBODY));
        if (_b == NULL) {
            PyErr_NoMemory();
            return;
        }
    }
    else {
        _b = NULL;
    }
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, astrom += s_astrom, b += s_b, ri += s_ri, di += s_di) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _astrom = ((eraASTROM (*))astrom);
        if (copy_b) {
            copy_to_eraLDBODY(b, is_b0, nb, _b);
        }
        else {
            _b = ((eraLDBODY (*))b);
        }
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        eraAtciqn(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, _astrom, nb, _b, _ri, _di);
    }
}

static void ufunc_loop_atciqz(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    double (*_rc);
    double (*_dc);
    eraASTROM (*_astrom);
    double (*_ri);
    double (*_di);
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, astrom += s_astrom, ri += s_ri, di += s_di) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _astrom = ((eraASTROM (*))astrom);
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        eraAtciqz(*_rc, *_dc, _astrom, _ri, _di);
    }
}

static void ufunc_loop_atco13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *aob = *args++;
    npy_intp s_aob = *steps++;
    char *zob = *args++;
    npy_intp s_zob = *steps++;
    char *hob = *args++;
    npy_intp s_hob = *steps++;
    char *dob = *args++;
    npy_intp s_dob = *steps++;
    char *rob = *args++;
    npy_intp s_rob = *steps++;
    char *eo = *args++;
    npy_intp s_eo = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_aob);
    double (*_zob);
    double (*_hob);
    double (*_dob);
    double (*_rob);
    double (*_eo);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, aob += s_aob, zob += s_zob, hob += s_hob, dob += s_dob, rob += s_rob, eo += s_eo, c_retval += s_c_retval) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _aob = ((double (*))aob);
        _zob = ((double (*))zob);
        _hob = ((double (*))hob);
        _dob = ((double (*))dob);
        _rob = ((double (*))rob);
        _eo = ((double (*))eo);
        _c_retval = eraAtco13(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _aob, _zob, _hob, _dob, _rob, _eo);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_atic13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *eo = *args++;
    npy_intp s_eo = *steps++;
    double (*_ri);
    double (*_di);
    double (*_date1);
    double (*_date2);
    double (*_rc);
    double (*_dc);
    double (*_eo);
    for (i_o = 0; i_o < n_o;
         i_o++, ri += s_ri, di += s_di, date1 += s_date1, date2 += s_date2, rc += s_rc, dc += s_dc, eo += s_eo) {
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _eo = ((double (*))eo);
        eraAtic13(*_ri, *_di, *_date1, *_date2, _rc, _dc, _eo);
    }
}

static void ufunc_loop_aticq(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    double (*_ri);
    double (*_di);
    eraASTROM (*_astrom);
    double (*_rc);
    double (*_dc);
    for (i_o = 0; i_o < n_o;
         i_o++, ri += s_ri, di += s_di, astrom += s_astrom, rc += s_rc, dc += s_dc) {
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _astrom = ((eraASTROM (*))astrom);
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        eraAticq(*_ri, *_di, _astrom, _rc, _dc);
    }
}

static void ufunc_loop_aticqn(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    double (*_ri);
    double (*_di);
    eraASTROM (*_astrom);
    eraLDBODY (*_b);
    double (*_rc);
    double (*_dc);
    npy_intp nb = dimensions[0];
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(eraLDBODY));
    if (copy_b) {
        // Note that we can't use PyArray_malloc here as it is an alias to PyMem_RawMalloc
        // which is not available in the Python limited API
        _b = malloc(nb * sizeof(eraLDBODY));
        if (_b == NULL) {
            PyErr_NoMemory();
            return;
        }
    }
    else {
        _b = NULL;
    }
    for (i_o = 0; i_o < n_o;
         i_o++, ri += s_ri, di += s_di, astrom += s_astrom, b += s_b, rc += s_rc, dc += s_dc) {
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _astrom = ((eraASTROM (*))astrom);
        if (copy_b) {
            copy_to_eraLDBODY(b, is_b0, nb, _b);
        }
        else {
            _b = ((eraLDBODY (*))b);
        }
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        eraAticqn(*_ri, *_di, _astrom, nb, _b, _rc, _dc);
    }
}

static void ufunc_loop_atio13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *aob = *args++;
    npy_intp s_aob = *steps++;
    char *zob = *args++;
    npy_intp s_zob = *steps++;
    char *hob = *args++;
    npy_intp s_hob = *steps++;
    char *dob = *args++;
    npy_intp s_dob = *steps++;
    char *rob = *args++;
    npy_intp s_rob = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ri);
    double (*_di);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_aob);
    double (*_zob);
    double (*_hob);
    double (*_dob);
    double (*_rob);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ri += s_ri, di += s_di, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, aob += s_aob, zob += s_zob, hob += s_hob, dob += s_dob, rob += s_rob, c_retval += s_c_retval) {
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _aob = ((double (*))aob);
        _zob = ((double (*))zob);
        _hob = ((double (*))hob);
        _dob = ((double (*))dob);
        _rob = ((double (*))rob);
        _c_retval = eraAtio13(*_ri, *_di, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _aob, _zob, _hob, _dob, _rob);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_atioq(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *aob = *args++;
    npy_intp s_aob = *steps++;
    char *zob = *args++;
    npy_intp s_zob = *steps++;
    char *hob = *args++;
    npy_intp s_hob = *steps++;
    char *dob = *args++;
    npy_intp s_dob = *steps++;
    char *rob = *args++;
    npy_intp s_rob = *steps++;
    double (*_ri);
    double (*_di);
    eraASTROM (*_astrom);
    double (*_aob);
    double (*_zob);
    double (*_hob);
    double (*_dob);
    double (*_rob);
    for (i_o = 0; i_o < n_o;
         i_o++, ri += s_ri, di += s_di, astrom += s_astrom, aob += s_aob, zob += s_zob, hob += s_hob, dob += s_dob, rob += s_rob) {
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _astrom = ((eraASTROM (*))astrom);
        _aob = ((double (*))aob);
        _zob = ((double (*))zob);
        _hob = ((double (*))hob);
        _dob = ((double (*))dob);
        _rob = ((double (*))rob);
        eraAtioq(*_ri, *_di, _astrom, _aob, _zob, _hob, _dob, _rob);
    }
}

static void ufunc_loop_atoc13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *type = *args++;
    npy_intp s_type = *steps++;
    char *ob1 = *args++;
    npy_intp s_ob1 = *steps++;
    char *ob2 = *args++;
    npy_intp s_ob2 = *steps++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    const char (*_type);
    double (*_ob1);
    double (*_ob2);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_rc);
    double (*_dc);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, type += s_type, ob1 += s_ob1, ob2 += s_ob2, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, rc += s_rc, dc += s_dc, c_retval += s_c_retval) {
        _type = ((const char (*))type);
        _ob1 = ((double (*))ob1);
        _ob2 = ((double (*))ob2);
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _c_retval = eraAtoc13(_type, *_ob1, *_ob2, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _rc, _dc);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_atoi13(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *type = *args++;
    npy_intp s_type = *steps++;
    char *ob1 = *args++;
    npy_intp s_ob1 = *steps++;
    char *ob2 = *args++;
    npy_intp s_ob2 = *steps++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    const char (*_type);
    double (*_ob1);
    double (*_ob2);
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_ri);
    double (*_di);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, type += s_type, ob1 += s_ob1, ob2 += s_ob2, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, ri += s_ri, di += s_di, c_retval += s_c_retval) {
        _type = ((const char (*))type);
        _ob1 = ((double (*))ob1);
        _ob2 = ((double (*))ob2);
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        _c_retval = eraAtoi13(_type, *_ob1, *_ob2, *_utc1, *_utc2, *_dut1, *_elong, *_phi, *_hm, *_xp, *_yp, *_phpa, *_tc, *_rh, *_wl, _ri, _di);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_atoiq(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *type = *args++;
    npy_intp s_type = *steps++;
    char *ob1 = *args++;
    npy_intp s_ob1 = *steps++;
    char *ob2 = *args++;
    npy_intp s_ob2 = *steps++;
    char *astrom = *args++;
    npy_intp s_astrom = *steps++;
    char *ri = *args++;
    npy_intp s_ri = *steps++;
    char *di = *args++;
    npy_intp s_di = *steps++;
    const char (*_type);
    double (*_ob1);
    double (*_ob2);
    eraASTROM (*_astrom);
    double (*_ri);
    double (*_di);
    for (i_o = 0; i_o < n_o;
         i_o++, type += s_type, ob1 += s_ob1, ob2 += s_ob2, astrom += s_astrom, ri += s_ri, di += s_di) {
        _type = ((const char (*))type);
        _ob1 = ((double (*))ob1);
        _ob2 = ((double (*))ob2);
        _astrom = ((eraASTROM (*))astrom);
        _ri = ((double (*))ri);
        _di = ((double (*))di);
        eraAtoiq(_type, *_ob1, *_ob2, _astrom, _ri, _di);
    }
}

static void ufunc_loop_ld(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *bm = *args++;
    npy_intp s_bm = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *q = *args++;
    npy_intp s_q = *steps++;
    char *e = *args++;
    npy_intp s_e = *steps++;
    char *em = *args++;
    npy_intp s_em = *steps++;
    char *dlim = *args++;
    npy_intp s_dlim = *steps++;
    char *p1 = *args++;
    npy_intp s_p1 = *steps++;
    double (*_bm);
    double b_p[3];
    double (*_p)[3] = &b_p;
    double b_q[3];
    double (*_q)[3] = &b_q;
    double b_e[3];
    double (*_e)[3] = &b_e;
    double (*_em);
    double (*_dlim);
    double b_p1[3];
    double (*_p1)[3] = &b_p1;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_q0 = *steps++;
    int copy_q = (is_q0 != sizeof(double));
    npy_intp is_e0 = *steps++;
    int copy_e = (is_e0 != sizeof(double));
    npy_intp is_p10 = *steps++;
    int copy_p1 = (is_p10 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, bm += s_bm, p += s_p, q += s_q, e += s_e, em += s_em, dlim += s_dlim, p1 += s_p1) {
        _bm = ((double (*))bm);
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        if (copy_q) {
            copy_to_double3(q, is_q0, *_q);
        }
        else {
            _q = ((double (*)[3])q);
        }
        if (copy_e) {
            copy_to_double3(e, is_e0, *_e);
        }
        else {
            _e = ((double (*)[3])e);
        }
        _em = ((double (*))em);
        _dlim = ((double (*))dlim);
        if (!copy_p1) {
            _p1 = ((double (*)[3])p1);
        }
        eraLd(*_bm, *_p, *_q, *_e, *_em, *_dlim, *_p1);
        if (copy_p1) {
            copy_from_double3(p1, is_p10, *_p1);
        }
    }
}

static void ufunc_loop_ldn(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *ob = *args++;
    npy_intp s_ob = *steps++;
    char *sc = *args++;
    npy_intp s_sc = *steps++;
    char *sn = *args++;
    npy_intp s_sn = *steps++;
    eraLDBODY (*_b);
    double b_ob[3];
    double (*_ob)[3] = &b_ob;
    double b_sc[3];
    double (*_sc)[3] = &b_sc;
    double b_sn[3];
    double (*_sn)[3] = &b_sn;
    npy_intp nb = dimensions[0];
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(eraLDBODY));
    npy_intp is_ob0 = *steps++;
    int copy_ob = (is_ob0 != sizeof(double));
    npy_intp is_sc0 = *steps++;
    int copy_sc = (is_sc0 != sizeof(double));
    npy_intp is_sn0 = *steps++;
    int copy_sn = (is_sn0 != sizeof(double));
    if (copy_b) {
        // Note that we can't use PyArray_malloc here as it is an alias to PyMem_RawMalloc
        // which is not available in the Python limited API
        _b = malloc(nb * sizeof(eraLDBODY));
        if (_b == NULL) {
            PyErr_NoMemory();
            return;
        }
    }
    else {
        _b = NULL;
    }
    for (i_o = 0; i_o < n_o;
         i_o++, b += s_b, ob += s_ob, sc += s_sc, sn += s_sn) {
        if (copy_b) {
            copy_to_eraLDBODY(b, is_b0, nb, _b);
        }
        else {
            _b = ((eraLDBODY (*))b);
        }
        if (copy_ob) {
            copy_to_double3(ob, is_ob0, *_ob);
        }
        else {
            _ob = ((double (*)[3])ob);
        }
        if (copy_sc) {
            copy_to_double3(sc, is_sc0, *_sc);
        }
        else {
            _sc = ((double (*)[3])sc);
        }
        if (!copy_sn) {
            _sn = ((double (*)[3])sn);
        }
        eraLdn(nb, _b, *_ob, *_sc, *_sn);
        if (copy_sn) {
            copy_from_double3(sn, is_sn0, *_sn);
        }
    }
}

static void ufunc_loop_ldsun(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *e = *args++;
    npy_intp s_e = *steps++;
    char *em = *args++;
    npy_intp s_em = *steps++;
    char *p1 = *args++;
    npy_intp s_p1 = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double b_e[3];
    double (*_e)[3] = &b_e;
    double (*_em);
    double b_p1[3];
    double (*_p1)[3] = &b_p1;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_e0 = *steps++;
    int copy_e = (is_e0 != sizeof(double));
    npy_intp is_p10 = *steps++;
    int copy_p1 = (is_p10 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, e += s_e, em += s_em, p1 += s_p1) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        if (copy_e) {
            copy_to_double3(e, is_e0, *_e);
        }
        else {
            _e = ((double (*)[3])e);
        }
        _em = ((double (*))em);
        if (!copy_p1) {
            _p1 = ((double (*)[3])p1);
        }
        eraLdsun(*_p, *_e, *_em, *_p1);
        if (copy_p1) {
            copy_from_double3(p1, is_p10, *_p1);
        }
    }
}

static void ufunc_loop_pmpx(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc = *args++;
    npy_intp s_rc = *steps++;
    char *dc = *args++;
    npy_intp s_dc = *steps++;
    char *pr = *args++;
    npy_intp s_pr = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *pmt = *args++;
    npy_intp s_pmt = *steps++;
    char *pob = *args++;
    npy_intp s_pob = *steps++;
    char *pco = *args++;
    npy_intp s_pco = *steps++;
    double (*_rc);
    double (*_dc);
    double (*_pr);
    double (*_pd);
    double (*_px);
    double (*_rv);
    double (*_pmt);
    double b_pob[3];
    double (*_pob)[3] = &b_pob;
    double b_pco[3];
    double (*_pco)[3] = &b_pco;
    npy_intp is_pob0 = *steps++;
    int copy_pob = (is_pob0 != sizeof(double));
    npy_intp is_pco0 = *steps++;
    int copy_pco = (is_pco0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, rc += s_rc, dc += s_dc, pr += s_pr, pd += s_pd, px += s_px, rv += s_rv, pmt += s_pmt, pob += s_pob, pco += s_pco) {
        _rc = ((double (*))rc);
        _dc = ((double (*))dc);
        _pr = ((double (*))pr);
        _pd = ((double (*))pd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _pmt = ((double (*))pmt);
        if (copy_pob) {
            copy_to_double3(pob, is_pob0, *_pob);
        }
        else {
            _pob = ((double (*)[3])pob);
        }
        if (!copy_pco) {
            _pco = ((double (*)[3])pco);
        }
        eraPmpx(*_rc, *_dc, *_pr, *_pd, *_px, *_rv, *_pmt, *_pob, *_pco);
        if (copy_pco) {
            copy_from_double3(pco, is_pco0, *_pco);
        }
    }
}

static void ufunc_loop_pmsafe(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ra1 = *args++;
    npy_intp s_ra1 = *steps++;
    char *dec1 = *args++;
    npy_intp s_dec1 = *steps++;
    char *pmr1 = *args++;
    npy_intp s_pmr1 = *steps++;
    char *pmd1 = *args++;
    npy_intp s_pmd1 = *steps++;
    char *px1 = *args++;
    npy_intp s_px1 = *steps++;
    char *rv1 = *args++;
    npy_intp s_rv1 = *steps++;
    char *ep1a = *args++;
    npy_intp s_ep1a = *steps++;
    char *ep1b = *args++;
    npy_intp s_ep1b = *steps++;
    char *ep2a = *args++;
    npy_intp s_ep2a = *steps++;
    char *ep2b = *args++;
    npy_intp s_ep2b = *steps++;
    char *ra2 = *args++;
    npy_intp s_ra2 = *steps++;
    char *dec2 = *args++;
    npy_intp s_dec2 = *steps++;
    char *pmr2 = *args++;
    npy_intp s_pmr2 = *steps++;
    char *pmd2 = *args++;
    npy_intp s_pmd2 = *steps++;
    char *px2 = *args++;
    npy_intp s_px2 = *steps++;
    char *rv2 = *args++;
    npy_intp s_rv2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ra1);
    double (*_dec1);
    double (*_pmr1);
    double (*_pmd1);
    double (*_px1);
    double (*_rv1);
    double (*_ep1a);
    double (*_ep1b);
    double (*_ep2a);
    double (*_ep2b);
    double (*_ra2);
    double (*_dec2);
    double (*_pmr2);
    double (*_pmd2);
    double (*_px2);
    double (*_rv2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ra1 += s_ra1, dec1 += s_dec1, pmr1 += s_pmr1, pmd1 += s_pmd1, px1 += s_px1, rv1 += s_rv1, ep1a += s_ep1a, ep1b += s_ep1b, ep2a += s_ep2a, ep2b += s_ep2b, ra2 += s_ra2, dec2 += s_dec2, pmr2 += s_pmr2, pmd2 += s_pmd2, px2 += s_px2, rv2 += s_rv2, c_retval += s_c_retval) {
        _ra1 = ((double (*))ra1);
        _dec1 = ((double (*))dec1);
        _pmr1 = ((double (*))pmr1);
        _pmd1 = ((double (*))pmd1);
        _px1 = ((double (*))px1);
        _rv1 = ((double (*))rv1);
        _ep1a = ((double (*))ep1a);
        _ep1b = ((double (*))ep1b);
        _ep2a = ((double (*))ep2a);
        _ep2b = ((double (*))ep2b);
        _ra2 = ((double (*))ra2);
        _dec2 = ((double (*))dec2);
        _pmr2 = ((double (*))pmr2);
        _pmd2 = ((double (*))pmd2);
        _px2 = ((double (*))px2);
        _rv2 = ((double (*))rv2);
        _c_retval = eraPmsafe(*_ra1, *_dec1, *_pmr1, *_pmd1, *_px1, *_rv1, *_ep1a, *_ep1b, *_ep2a, *_ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_pvtob(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *hm = *args++;
    npy_intp s_hm = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *sp = *args++;
    npy_intp s_sp = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    double (*_elong);
    double (*_phi);
    double (*_hm);
    double (*_xp);
    double (*_yp);
    double (*_sp);
    double (*_theta);
    double (*_pv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, elong += s_elong, phi += s_phi, hm += s_hm, xp += s_xp, yp += s_yp, sp += s_sp, theta += s_theta, pv += s_pv) {
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _hm = ((double (*))hm);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _sp = ((double (*))sp);
        _theta = ((double (*))theta);
        _pv = ((double (*)[2][3])pv);
        eraPvtob(*_elong, *_phi, *_hm, *_xp, *_yp, *_sp, *_theta, *_pv);
    }
}

static void ufunc_loop_refco(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *phpa = *args++;
    npy_intp s_phpa = *steps++;
    char *tc = *args++;
    npy_intp s_tc = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *wl = *args++;
    npy_intp s_wl = *steps++;
    char *refa = *args++;
    npy_intp s_refa = *steps++;
    char *refb = *args++;
    npy_intp s_refb = *steps++;
    double (*_phpa);
    double (*_tc);
    double (*_rh);
    double (*_wl);
    double (*_refa);
    double (*_refb);
    for (i_o = 0; i_o < n_o;
         i_o++, phpa += s_phpa, tc += s_tc, rh += s_rh, wl += s_wl, refa += s_refa, refb += s_refb) {
        _phpa = ((double (*))phpa);
        _tc = ((double (*))tc);
        _rh = ((double (*))rh);
        _wl = ((double (*))wl);
        _refa = ((double (*))refa);
        _refb = ((double (*))refb);
        eraRefco(*_phpa, *_tc, *_rh, *_wl, _refa, _refb);
    }
}

static void ufunc_loop_epv00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *pvh = *args++;
    npy_intp s_pvh = *steps++;
    char *pvb = *args++;
    npy_intp s_pvb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_pvh)[2][3];
    double (*_pvb)[2][3];
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, pvh += s_pvh, pvb += s_pvb, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _pvh = ((double (*)[2][3])pvh);
        _pvb = ((double (*)[2][3])pvb);
        _c_retval = eraEpv00(*_date1, *_date2, *_pvh, *_pvb);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_moon98(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_pv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, pv += s_pv) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _pv = ((double (*)[2][3])pv);
        eraMoon98(*_date1, *_date2, *_pv);
    }
}

static void ufunc_loop_plan94(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *np = *args++;
    npy_intp s_np = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    int (*_np);
    double (*_pv)[2][3];
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, np += s_np, pv += s_pv, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _np = ((int (*))np);
        _pv = ((double (*)[2][3])pv);
        _c_retval = eraPlan94(*_date1, *_date2, *_np, *_pv);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fad03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFad03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fae03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFae03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_faf03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFaf03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_faju03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFaju03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fal03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFal03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_falp03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFalp03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fama03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFama03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fame03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFame03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fane03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFane03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_faom03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFaom03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fapa03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFapa03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fasa03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFasa03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_faur03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFaur03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fave03(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *t = *args++;
    npy_intp s_t = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_t);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, t += s_t, c_retval += s_c_retval) {
        _t = ((double (*))t);
        _c_retval = eraFave03(*_t);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_bi00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dpsibi = *args++;
    npy_intp s_dpsibi = *steps++;
    char *depsbi = *args++;
    npy_intp s_depsbi = *steps++;
    char *dra = *args++;
    npy_intp s_dra = *steps++;
    double (*_dpsibi);
    double (*_depsbi);
    double (*_dra);
    for (i_o = 0; i_o < n_o;
         i_o++, dpsibi += s_dpsibi, depsbi += s_depsbi, dra += s_dra) {
        _dpsibi = ((double (*))dpsibi);
        _depsbi = ((double (*))depsbi);
        _dra = ((double (*))dra);
        eraBi00(_dpsibi, _depsbi, _dra);
    }
}

static void ufunc_loop_bp00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rb += s_rb, rp += s_rp, rbp += s_rbp) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        eraBp00(*_date1, *_date2, *_rb, *_rp, *_rbp);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
    }
}

static void ufunc_loop_bp06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rb += s_rb, rp += s_rp, rbp += s_rbp) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        eraBp06(*_date1, *_date2, *_rb, *_rp, *_rbp);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
    }
}

static void ufunc_loop_bpn2xy(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    double (*_x);
    double (*_y);
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, rbpn += s_rbpn, x += s_x, y += s_y) {
        if (copy_rbpn) {
            copy_to_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
        else {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        _x = ((double (*))x);
        _y = ((double (*))y);
        eraBpn2xy(*_rbpn, _x, _y);
    }
}

static void ufunc_loop_c2i00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rc2i += s_rc2i) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rc2i) {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        eraC2i00a(*_date1, *_date2, *_rc2i);
        if (copy_rc2i) {
            copy_from_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
    }
}

static void ufunc_loop_c2i00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rc2i += s_rc2i) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rc2i) {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        eraC2i00b(*_date1, *_date2, *_rc2i);
        if (copy_rc2i) {
            copy_from_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
    }
}

static void ufunc_loop_c2i06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rc2i += s_rc2i) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rc2i) {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        eraC2i06a(*_date1, *_date2, *_rc2i);
        if (copy_rc2i) {
            copy_from_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
    }
}

static void ufunc_loop_c2ibpn(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rbpn += s_rbpn, rc2i += s_rc2i) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (copy_rbpn) {
            copy_to_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
        else {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        if (!copy_rc2i) {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        eraC2ibpn(*_date1, *_date2, *_rbpn, *_rc2i);
        if (copy_rc2i) {
            copy_from_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
    }
}

static void ufunc_loop_c2ixy(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y, rc2i += s_rc2i) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        if (!copy_rc2i) {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        eraC2ixy(*_date1, *_date2, *_x, *_y, *_rc2i);
        if (copy_rc2i) {
            copy_from_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
    }
}

static void ufunc_loop_c2ixys(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    double (*_x);
    double (*_y);
    double (*_s);
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, x += s_x, y += s_y, s += s_s, rc2i += s_rc2i) {
        _x = ((double (*))x);
        _y = ((double (*))y);
        _s = ((double (*))s);
        if (!copy_rc2i) {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        eraC2ixys(*_x, *_y, *_s, *_rc2i);
        if (copy_rc2i) {
            copy_from_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
    }
}

static void ufunc_loop_c2t00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_xp);
    double (*_yp);
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, tta += s_tta, ttb += s_ttb, uta += s_uta, utb += s_utb, xp += s_xp, yp += s_yp, rc2t += s_rc2t) {
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2t00a(*_tta, *_ttb, *_uta, *_utb, *_xp, *_yp, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_c2t00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_xp);
    double (*_yp);
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, tta += s_tta, ttb += s_ttb, uta += s_uta, utb += s_utb, xp += s_xp, yp += s_yp, rc2t += s_rc2t) {
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2t00b(*_tta, *_ttb, *_uta, *_utb, *_xp, *_yp, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_c2t06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_xp);
    double (*_yp);
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, tta += s_tta, ttb += s_ttb, uta += s_uta, utb += s_utb, xp += s_xp, yp += s_yp, rc2t += s_rc2t) {
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2t06a(*_tta, *_ttb, *_uta, *_utb, *_xp, *_yp, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_c2tcio(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rc2i = *args++;
    npy_intp s_rc2i = *steps++;
    char *era = *args++;
    npy_intp s_era = *steps++;
    char *rpom = *args++;
    npy_intp s_rpom = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double b_rc2i[3][3];
    double (*_rc2i)[3][3] = &b_rc2i;
    double (*_era);
    double b_rpom[3][3];
    double (*_rpom)[3][3] = &b_rpom;
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rc2i0 = *steps++;
    npy_intp is_rc2i1 = *steps++;
    int copy_rc2i = (is_rc2i1 != sizeof(double) ||
              is_rc2i0 != 3 * sizeof(double));
    npy_intp is_rpom0 = *steps++;
    npy_intp is_rpom1 = *steps++;
    int copy_rpom = (is_rpom1 != sizeof(double) ||
              is_rpom0 != 3 * sizeof(double));
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, rc2i += s_rc2i, era += s_era, rpom += s_rpom, rc2t += s_rc2t) {
        if (copy_rc2i) {
            copy_to_double33(rc2i, is_rc2i0, is_rc2i1, *_rc2i);
        }
        else {
            _rc2i = ((double (*)[3][3])rc2i);
        }
        _era = ((double (*))era);
        if (copy_rpom) {
            copy_to_double33(rpom, is_rpom0, is_rpom1, *_rpom);
        }
        else {
            _rpom = ((double (*)[3][3])rpom);
        }
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2tcio(*_rc2i, *_era, *_rpom, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_c2teqx(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    char *gst = *args++;
    npy_intp s_gst = *steps++;
    char *rpom = *args++;
    npy_intp s_rpom = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    double (*_gst);
    double b_rpom[3][3];
    double (*_rpom)[3][3] = &b_rpom;
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    npy_intp is_rpom0 = *steps++;
    npy_intp is_rpom1 = *steps++;
    int copy_rpom = (is_rpom1 != sizeof(double) ||
              is_rpom0 != 3 * sizeof(double));
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, rbpn += s_rbpn, gst += s_gst, rpom += s_rpom, rc2t += s_rc2t) {
        if (copy_rbpn) {
            copy_to_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
        else {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        _gst = ((double (*))gst);
        if (copy_rpom) {
            copy_to_double33(rpom, is_rpom0, is_rpom1, *_rpom);
        }
        else {
            _rpom = ((double (*)[3][3])rpom);
        }
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2teqx(*_rbpn, *_gst, *_rpom, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_c2tpe(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_dpsi);
    double (*_deps);
    double (*_xp);
    double (*_yp);
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, tta += s_tta, ttb += s_ttb, uta += s_uta, utb += s_utb, dpsi += s_dpsi, deps += s_deps, xp += s_xp, yp += s_yp, rc2t += s_rc2t) {
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2tpe(*_tta, *_ttb, *_uta, *_utb, *_dpsi, *_deps, *_xp, *_yp, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_c2txy(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *rc2t = *args++;
    npy_intp s_rc2t = *steps++;
    double (*_tta);
    double (*_ttb);
    double (*_uta);
    double (*_utb);
    double (*_x);
    double (*_y);
    double (*_xp);
    double (*_yp);
    double b_rc2t[3][3];
    double (*_rc2t)[3][3] = &b_rc2t;
    npy_intp is_rc2t0 = *steps++;
    npy_intp is_rc2t1 = *steps++;
    int copy_rc2t = (is_rc2t1 != sizeof(double) ||
              is_rc2t0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, tta += s_tta, ttb += s_ttb, uta += s_uta, utb += s_utb, x += s_x, y += s_y, xp += s_xp, yp += s_yp, rc2t += s_rc2t) {
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _x = ((double (*))x);
        _y = ((double (*))y);
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        if (!copy_rc2t) {
            _rc2t = ((double (*)[3][3])rc2t);
        }
        eraC2txy(*_tta, *_ttb, *_uta, *_utb, *_x, *_y, *_xp, *_yp, *_rc2t);
        if (copy_rc2t) {
            copy_from_double33(rc2t, is_rc2t0, is_rc2t1, *_rc2t);
        }
    }
}

static void ufunc_loop_eo06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraEo06a(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_eors(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rnpb = *args++;
    npy_intp s_rnpb = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double b_rnpb[3][3];
    double (*_rnpb)[3][3] = &b_rnpb;
    double (*_s);
    double _c_retval;
    npy_intp is_rnpb0 = *steps++;
    npy_intp is_rnpb1 = *steps++;
    int copy_rnpb = (is_rnpb1 != sizeof(double) ||
              is_rnpb0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, rnpb += s_rnpb, s += s_s, c_retval += s_c_retval) {
        if (copy_rnpb) {
            copy_to_double33(rnpb, is_rnpb0, is_rnpb1, *_rnpb);
        }
        else {
            _rnpb = ((double (*)[3][3])rnpb);
        }
        _s = ((double (*))s);
        _c_retval = eraEors(*_rnpb, *_s);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fw2m(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *gamb = *args++;
    npy_intp s_gamb = *steps++;
    char *phib = *args++;
    npy_intp s_phib = *steps++;
    char *psi = *args++;
    npy_intp s_psi = *steps++;
    char *eps = *args++;
    npy_intp s_eps = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double (*_gamb);
    double (*_phib);
    double (*_psi);
    double (*_eps);
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, gamb += s_gamb, phib += s_phib, psi += s_psi, eps += s_eps, r += s_r) {
        _gamb = ((double (*))gamb);
        _phib = ((double (*))phib);
        _psi = ((double (*))psi);
        _eps = ((double (*))eps);
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        eraFw2m(*_gamb, *_phib, *_psi, *_eps, *_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_fw2xy(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *gamb = *args++;
    npy_intp s_gamb = *steps++;
    char *phib = *args++;
    npy_intp s_phib = *steps++;
    char *psi = *args++;
    npy_intp s_psi = *steps++;
    char *eps = *args++;
    npy_intp s_eps = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    double (*_gamb);
    double (*_phib);
    double (*_psi);
    double (*_eps);
    double (*_x);
    double (*_y);
    for (i_o = 0; i_o < n_o;
         i_o++, gamb += s_gamb, phib += s_phib, psi += s_psi, eps += s_eps, x += s_x, y += s_y) {
        _gamb = ((double (*))gamb);
        _phib = ((double (*))phib);
        _psi = ((double (*))psi);
        _eps = ((double (*))eps);
        _x = ((double (*))x);
        _y = ((double (*))y);
        eraFw2xy(*_gamb, *_phib, *_psi, *_eps, _x, _y);
    }
}

static void ufunc_loop_ltp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    double (*_epj);
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, rp += s_rp) {
        _epj = ((double (*))epj);
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        eraLtp(*_epj, *_rp);
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
    }
}

static void ufunc_loop_ltpb(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *rpb = *args++;
    npy_intp s_rpb = *steps++;
    double (*_epj);
    double b_rpb[3][3];
    double (*_rpb)[3][3] = &b_rpb;
    npy_intp is_rpb0 = *steps++;
    npy_intp is_rpb1 = *steps++;
    int copy_rpb = (is_rpb1 != sizeof(double) ||
              is_rpb0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, rpb += s_rpb) {
        _epj = ((double (*))epj);
        if (!copy_rpb) {
            _rpb = ((double (*)[3][3])rpb);
        }
        eraLtpb(*_epj, *_rpb);
        if (copy_rpb) {
            copy_from_double33(rpb, is_rpb0, is_rpb1, *_rpb);
        }
    }
}

static void ufunc_loop_ltpecl(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *vec = *args++;
    npy_intp s_vec = *steps++;
    double (*_epj);
    double b_vec[3];
    double (*_vec)[3] = &b_vec;
    npy_intp is_vec0 = *steps++;
    int copy_vec = (is_vec0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, vec += s_vec) {
        _epj = ((double (*))epj);
        if (!copy_vec) {
            _vec = ((double (*)[3])vec);
        }
        eraLtpecl(*_epj, *_vec);
        if (copy_vec) {
            copy_from_double3(vec, is_vec0, *_vec);
        }
    }
}

static void ufunc_loop_ltpequ(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *veq = *args++;
    npy_intp s_veq = *steps++;
    double (*_epj);
    double b_veq[3];
    double (*_veq)[3] = &b_veq;
    npy_intp is_veq0 = *steps++;
    int copy_veq = (is_veq0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, veq += s_veq) {
        _epj = ((double (*))epj);
        if (!copy_veq) {
            _veq = ((double (*)[3])veq);
        }
        eraLtpequ(*_epj, *_veq);
        if (copy_veq) {
            copy_from_double3(veq, is_veq0, *_veq);
        }
    }
}

static void ufunc_loop_num00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rmatn = *args++;
    npy_intp s_rmatn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rmatn[3][3];
    double (*_rmatn)[3][3] = &b_rmatn;
    npy_intp is_rmatn0 = *steps++;
    npy_intp is_rmatn1 = *steps++;
    int copy_rmatn = (is_rmatn1 != sizeof(double) ||
              is_rmatn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rmatn += s_rmatn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rmatn) {
            _rmatn = ((double (*)[3][3])rmatn);
        }
        eraNum00a(*_date1, *_date2, *_rmatn);
        if (copy_rmatn) {
            copy_from_double33(rmatn, is_rmatn0, is_rmatn1, *_rmatn);
        }
    }
}

static void ufunc_loop_num00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rmatn = *args++;
    npy_intp s_rmatn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rmatn[3][3];
    double (*_rmatn)[3][3] = &b_rmatn;
    npy_intp is_rmatn0 = *steps++;
    npy_intp is_rmatn1 = *steps++;
    int copy_rmatn = (is_rmatn1 != sizeof(double) ||
              is_rmatn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rmatn += s_rmatn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rmatn) {
            _rmatn = ((double (*)[3][3])rmatn);
        }
        eraNum00b(*_date1, *_date2, *_rmatn);
        if (copy_rmatn) {
            copy_from_double33(rmatn, is_rmatn0, is_rmatn1, *_rmatn);
        }
    }
}

static void ufunc_loop_num06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rmatn = *args++;
    npy_intp s_rmatn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rmatn[3][3];
    double (*_rmatn)[3][3] = &b_rmatn;
    npy_intp is_rmatn0 = *steps++;
    npy_intp is_rmatn1 = *steps++;
    int copy_rmatn = (is_rmatn1 != sizeof(double) ||
              is_rmatn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rmatn += s_rmatn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rmatn) {
            _rmatn = ((double (*)[3][3])rmatn);
        }
        eraNum06a(*_date1, *_date2, *_rmatn);
        if (copy_rmatn) {
            copy_from_double33(rmatn, is_rmatn0, is_rmatn1, *_rmatn);
        }
    }
}

static void ufunc_loop_numat(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *rmatn = *args++;
    npy_intp s_rmatn = *steps++;
    double (*_epsa);
    double (*_dpsi);
    double (*_deps);
    double b_rmatn[3][3];
    double (*_rmatn)[3][3] = &b_rmatn;
    npy_intp is_rmatn0 = *steps++;
    npy_intp is_rmatn1 = *steps++;
    int copy_rmatn = (is_rmatn1 != sizeof(double) ||
              is_rmatn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, epsa += s_epsa, dpsi += s_dpsi, deps += s_deps, rmatn += s_rmatn) {
        _epsa = ((double (*))epsa);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        if (!copy_rmatn) {
            _rmatn = ((double (*)[3][3])rmatn);
        }
        eraNumat(*_epsa, *_dpsi, *_deps, *_rmatn);
        if (copy_rmatn) {
            copy_from_double33(rmatn, is_rmatn0, is_rmatn1, *_rmatn);
        }
    }
}

static void ufunc_loop_nut00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        eraNut00a(*_date1, *_date2, _dpsi, _deps);
    }
}

static void ufunc_loop_nut00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        eraNut00b(*_date1, *_date2, _dpsi, _deps);
    }
}

static void ufunc_loop_nut06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        eraNut06a(*_date1, *_date2, _dpsi, _deps);
    }
}

static void ufunc_loop_nut80(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        eraNut80(*_date1, *_date2, _dpsi, _deps);
    }
}

static void ufunc_loop_nutm80(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rmatn = *args++;
    npy_intp s_rmatn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rmatn[3][3];
    double (*_rmatn)[3][3] = &b_rmatn;
    npy_intp is_rmatn0 = *steps++;
    npy_intp is_rmatn1 = *steps++;
    int copy_rmatn = (is_rmatn1 != sizeof(double) ||
              is_rmatn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rmatn += s_rmatn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rmatn) {
            _rmatn = ((double (*)[3][3])rmatn);
        }
        eraNutm80(*_date1, *_date2, *_rmatn);
        if (copy_rmatn) {
            copy_from_double33(rmatn, is_rmatn0, is_rmatn1, *_rmatn);
        }
    }
}

static void ufunc_loop_obl06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraObl06(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_obl80(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraObl80(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_p06e(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *eps0 = *args++;
    npy_intp s_eps0 = *steps++;
    char *psia = *args++;
    npy_intp s_psia = *steps++;
    char *oma = *args++;
    npy_intp s_oma = *steps++;
    char *bpa = *args++;
    npy_intp s_bpa = *steps++;
    char *bqa = *args++;
    npy_intp s_bqa = *steps++;
    char *pia = *args++;
    npy_intp s_pia = *steps++;
    char *bpia = *args++;
    npy_intp s_bpia = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *chia = *args++;
    npy_intp s_chia = *steps++;
    char *za = *args++;
    npy_intp s_za = *steps++;
    char *zetaa = *args++;
    npy_intp s_zetaa = *steps++;
    char *thetaa = *args++;
    npy_intp s_thetaa = *steps++;
    char *pa = *args++;
    npy_intp s_pa = *steps++;
    char *gam = *args++;
    npy_intp s_gam = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *psi = *args++;
    npy_intp s_psi = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_eps0);
    double (*_psia);
    double (*_oma);
    double (*_bpa);
    double (*_bqa);
    double (*_pia);
    double (*_bpia);
    double (*_epsa);
    double (*_chia);
    double (*_za);
    double (*_zetaa);
    double (*_thetaa);
    double (*_pa);
    double (*_gam);
    double (*_phi);
    double (*_psi);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, eps0 += s_eps0, psia += s_psia, oma += s_oma, bpa += s_bpa, bqa += s_bqa, pia += s_pia, bpia += s_bpia, epsa += s_epsa, chia += s_chia, za += s_za, zetaa += s_zetaa, thetaa += s_thetaa, pa += s_pa, gam += s_gam, phi += s_phi, psi += s_psi) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _eps0 = ((double (*))eps0);
        _psia = ((double (*))psia);
        _oma = ((double (*))oma);
        _bpa = ((double (*))bpa);
        _bqa = ((double (*))bqa);
        _pia = ((double (*))pia);
        _bpia = ((double (*))bpia);
        _epsa = ((double (*))epsa);
        _chia = ((double (*))chia);
        _za = ((double (*))za);
        _zetaa = ((double (*))zetaa);
        _thetaa = ((double (*))thetaa);
        _pa = ((double (*))pa);
        _gam = ((double (*))gam);
        _phi = ((double (*))phi);
        _psi = ((double (*))psi);
        eraP06e(*_date1, *_date2, _eps0, _psia, _oma, _bpa, _bqa, _pia, _bpia, _epsa, _chia, _za, _zetaa, _thetaa, _pa, _gam, _phi, _psi);
    }
}

static void ufunc_loop_pb06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *bzeta = *args++;
    npy_intp s_bzeta = *steps++;
    char *bz = *args++;
    npy_intp s_bz = *steps++;
    char *btheta = *args++;
    npy_intp s_btheta = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_bzeta);
    double (*_bz);
    double (*_btheta);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, bzeta += s_bzeta, bz += s_bz, btheta += s_btheta) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _bzeta = ((double (*))bzeta);
        _bz = ((double (*))bz);
        _btheta = ((double (*))btheta);
        eraPb06(*_date1, *_date2, _bzeta, _bz, _btheta);
    }
}

static void ufunc_loop_pfw06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *gamb = *args++;
    npy_intp s_gamb = *steps++;
    char *phib = *args++;
    npy_intp s_phib = *steps++;
    char *psib = *args++;
    npy_intp s_psib = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_gamb);
    double (*_phib);
    double (*_psib);
    double (*_epsa);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, gamb += s_gamb, phib += s_phib, psib += s_psib, epsa += s_epsa) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _gamb = ((double (*))gamb);
        _phib = ((double (*))phib);
        _psib = ((double (*))psib);
        _epsa = ((double (*))epsa);
        eraPfw06(*_date1, *_date2, _gamb, _phib, _psib, _epsa);
    }
}

static void ufunc_loop_pmat00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rbp += s_rbp) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        eraPmat00(*_date1, *_date2, *_rbp);
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
    }
}

static void ufunc_loop_pmat06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rbp += s_rbp) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        eraPmat06(*_date1, *_date2, *_rbp);
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
    }
}

static void ufunc_loop_pmat76(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rmatp = *args++;
    npy_intp s_rmatp = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rmatp[3][3];
    double (*_rmatp)[3][3] = &b_rmatp;
    npy_intp is_rmatp0 = *steps++;
    npy_intp is_rmatp1 = *steps++;
    int copy_rmatp = (is_rmatp1 != sizeof(double) ||
              is_rmatp0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rmatp += s_rmatp) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rmatp) {
            _rmatp = ((double (*)[3][3])rmatp);
        }
        eraPmat76(*_date1, *_date2, *_rmatp);
        if (copy_rmatp) {
            copy_from_double33(rmatp, is_rmatp0, is_rmatp1, *_rmatp);
        }
    }
}

static void ufunc_loop_pn00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    char *rn = *args++;
    npy_intp s_rn = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    double b_rn[3][3];
    double (*_rn)[3][3] = &b_rn;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    npy_intp is_rn0 = *steps++;
    npy_intp is_rn1 = *steps++;
    int copy_rn = (is_rn1 != sizeof(double) ||
              is_rn0 != 3 * sizeof(double));
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps, epsa += s_epsa, rb += s_rb, rp += s_rp, rbp += s_rbp, rn += s_rn, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        _epsa = ((double (*))epsa);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        if (!copy_rn) {
            _rn = ((double (*)[3][3])rn);
        }
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPn00(*_date1, *_date2, *_dpsi, *_deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
        if (copy_rn) {
            copy_from_double33(rn, is_rn0, is_rn1, *_rn);
        }
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pn00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    char *rn = *args++;
    npy_intp s_rn = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    double b_rn[3][3];
    double (*_rn)[3][3] = &b_rn;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    npy_intp is_rn0 = *steps++;
    npy_intp is_rn1 = *steps++;
    int copy_rn = (is_rn1 != sizeof(double) ||
              is_rn0 != 3 * sizeof(double));
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps, epsa += s_epsa, rb += s_rb, rp += s_rp, rbp += s_rbp, rn += s_rn, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        _epsa = ((double (*))epsa);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        if (!copy_rn) {
            _rn = ((double (*)[3][3])rn);
        }
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPn00a(*_date1, *_date2, _dpsi, _deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
        if (copy_rn) {
            copy_from_double33(rn, is_rn0, is_rn1, *_rn);
        }
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pn00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    char *rn = *args++;
    npy_intp s_rn = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    double b_rn[3][3];
    double (*_rn)[3][3] = &b_rn;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    npy_intp is_rn0 = *steps++;
    npy_intp is_rn1 = *steps++;
    int copy_rn = (is_rn1 != sizeof(double) ||
              is_rn0 != 3 * sizeof(double));
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps, epsa += s_epsa, rb += s_rb, rp += s_rp, rbp += s_rbp, rn += s_rn, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        _epsa = ((double (*))epsa);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        if (!copy_rn) {
            _rn = ((double (*)[3][3])rn);
        }
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPn00b(*_date1, *_date2, _dpsi, _deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
        if (copy_rn) {
            copy_from_double33(rn, is_rn0, is_rn1, *_rn);
        }
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pn06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    char *rn = *args++;
    npy_intp s_rn = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    double b_rn[3][3];
    double (*_rn)[3][3] = &b_rn;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    npy_intp is_rn0 = *steps++;
    npy_intp is_rn1 = *steps++;
    int copy_rn = (is_rn1 != sizeof(double) ||
              is_rn0 != 3 * sizeof(double));
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps, epsa += s_epsa, rb += s_rb, rp += s_rp, rbp += s_rbp, rn += s_rn, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        _epsa = ((double (*))epsa);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        if (!copy_rn) {
            _rn = ((double (*)[3][3])rn);
        }
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPn06(*_date1, *_date2, *_dpsi, *_deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
        if (copy_rn) {
            copy_from_double33(rn, is_rn0, is_rn1, *_rn);
        }
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pn06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *deps = *args++;
    npy_intp s_deps = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *rb = *args++;
    npy_intp s_rb = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    char *rbp = *args++;
    npy_intp s_rbp = *steps++;
    char *rn = *args++;
    npy_intp s_rn = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsi);
    double (*_deps);
    double (*_epsa);
    double b_rb[3][3];
    double (*_rb)[3][3] = &b_rb;
    double b_rp[3][3];
    double (*_rp)[3][3] = &b_rp;
    double b_rbp[3][3];
    double (*_rbp)[3][3] = &b_rbp;
    double b_rn[3][3];
    double (*_rn)[3][3] = &b_rn;
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rb0 = *steps++;
    npy_intp is_rb1 = *steps++;
    int copy_rb = (is_rb1 != sizeof(double) ||
              is_rb0 != 3 * sizeof(double));
    npy_intp is_rp0 = *steps++;
    npy_intp is_rp1 = *steps++;
    int copy_rp = (is_rp1 != sizeof(double) ||
              is_rp0 != 3 * sizeof(double));
    npy_intp is_rbp0 = *steps++;
    npy_intp is_rbp1 = *steps++;
    int copy_rbp = (is_rbp1 != sizeof(double) ||
              is_rbp0 != 3 * sizeof(double));
    npy_intp is_rn0 = *steps++;
    npy_intp is_rn1 = *steps++;
    int copy_rn = (is_rn1 != sizeof(double) ||
              is_rn0 != 3 * sizeof(double));
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsi += s_dpsi, deps += s_deps, epsa += s_epsa, rb += s_rb, rp += s_rp, rbp += s_rbp, rn += s_rn, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsi = ((double (*))dpsi);
        _deps = ((double (*))deps);
        _epsa = ((double (*))epsa);
        if (!copy_rb) {
            _rb = ((double (*)[3][3])rb);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3][3])rp);
        }
        if (!copy_rbp) {
            _rbp = ((double (*)[3][3])rbp);
        }
        if (!copy_rn) {
            _rn = ((double (*)[3][3])rn);
        }
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPn06a(*_date1, *_date2, _dpsi, _deps, _epsa, *_rb, *_rp, *_rbp, *_rn, *_rbpn);
        if (copy_rb) {
            copy_from_double33(rb, is_rb0, is_rb1, *_rb);
        }
        if (copy_rp) {
            copy_from_double33(rp, is_rp0, is_rp1, *_rp);
        }
        if (copy_rbp) {
            copy_from_double33(rbp, is_rbp0, is_rbp1, *_rbp);
        }
        if (copy_rn) {
            copy_from_double33(rn, is_rn0, is_rn1, *_rn);
        }
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pnm00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPnm00a(*_date1, *_date2, *_rbpn);
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pnm00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPnm00b(*_date1, *_date2, *_rbpn);
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pnm06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rbpn = *args++;
    npy_intp s_rbpn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rbpn[3][3];
    double (*_rbpn)[3][3] = &b_rbpn;
    npy_intp is_rbpn0 = *steps++;
    npy_intp is_rbpn1 = *steps++;
    int copy_rbpn = (is_rbpn1 != sizeof(double) ||
              is_rbpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rbpn += s_rbpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rbpn) {
            _rbpn = ((double (*)[3][3])rbpn);
        }
        eraPnm06a(*_date1, *_date2, *_rbpn);
        if (copy_rbpn) {
            copy_from_double33(rbpn, is_rbpn0, is_rbpn1, *_rbpn);
        }
    }
}

static void ufunc_loop_pnm80(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rmatpn = *args++;
    npy_intp s_rmatpn = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rmatpn[3][3];
    double (*_rmatpn)[3][3] = &b_rmatpn;
    npy_intp is_rmatpn0 = *steps++;
    npy_intp is_rmatpn1 = *steps++;
    int copy_rmatpn = (is_rmatpn1 != sizeof(double) ||
              is_rmatpn0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rmatpn += s_rmatpn) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rmatpn) {
            _rmatpn = ((double (*)[3][3])rmatpn);
        }
        eraPnm80(*_date1, *_date2, *_rmatpn);
        if (copy_rmatpn) {
            copy_from_double33(rmatpn, is_rmatpn0, is_rmatpn1, *_rmatpn);
        }
    }
}

static void ufunc_loop_pom00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *xp = *args++;
    npy_intp s_xp = *steps++;
    char *yp = *args++;
    npy_intp s_yp = *steps++;
    char *sp = *args++;
    npy_intp s_sp = *steps++;
    char *rpom = *args++;
    npy_intp s_rpom = *steps++;
    double (*_xp);
    double (*_yp);
    double (*_sp);
    double b_rpom[3][3];
    double (*_rpom)[3][3] = &b_rpom;
    npy_intp is_rpom0 = *steps++;
    npy_intp is_rpom1 = *steps++;
    int copy_rpom = (is_rpom1 != sizeof(double) ||
              is_rpom0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, xp += s_xp, yp += s_yp, sp += s_sp, rpom += s_rpom) {
        _xp = ((double (*))xp);
        _yp = ((double (*))yp);
        _sp = ((double (*))sp);
        if (!copy_rpom) {
            _rpom = ((double (*)[3][3])rpom);
        }
        eraPom00(*_xp, *_yp, *_sp, *_rpom);
        if (copy_rpom) {
            copy_from_double33(rpom, is_rpom0, is_rpom1, *_rpom);
        }
    }
}

static void ufunc_loop_pr00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dpsipr = *args++;
    npy_intp s_dpsipr = *steps++;
    char *depspr = *args++;
    npy_intp s_depspr = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dpsipr);
    double (*_depspr);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dpsipr += s_dpsipr, depspr += s_depspr) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dpsipr = ((double (*))dpsipr);
        _depspr = ((double (*))depspr);
        eraPr00(*_date1, *_date2, _dpsipr, _depspr);
    }
}

static void ufunc_loop_prec76(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date01 = *args++;
    npy_intp s_date01 = *steps++;
    char *date02 = *args++;
    npy_intp s_date02 = *steps++;
    char *date11 = *args++;
    npy_intp s_date11 = *steps++;
    char *date12 = *args++;
    npy_intp s_date12 = *steps++;
    char *zeta = *args++;
    npy_intp s_zeta = *steps++;
    char *z = *args++;
    npy_intp s_z = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    double (*_date01);
    double (*_date02);
    double (*_date11);
    double (*_date12);
    double (*_zeta);
    double (*_z);
    double (*_theta);
    for (i_o = 0; i_o < n_o;
         i_o++, date01 += s_date01, date02 += s_date02, date11 += s_date11, date12 += s_date12, zeta += s_zeta, z += s_z, theta += s_theta) {
        _date01 = ((double (*))date01);
        _date02 = ((double (*))date02);
        _date11 = ((double (*))date11);
        _date12 = ((double (*))date12);
        _zeta = ((double (*))zeta);
        _z = ((double (*))z);
        _theta = ((double (*))theta);
        eraPrec76(*_date01, *_date02, *_date11, *_date12, _zeta, _z, _theta);
    }
}

static void ufunc_loop_s00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        _c_retval = eraS00(*_date1, *_date2, *_x, *_y);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_s00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraS00a(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_s00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraS00b(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_s06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        _c_retval = eraS06(*_date1, *_date2, *_x, *_y);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_s06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraS06a(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_sp00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraSp00(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_xy06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        eraXy06(*_date1, *_date2, _x, _y);
    }
}

static void ufunc_loop_xys00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_s);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y, s += s_s) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        _s = ((double (*))s);
        eraXys00a(*_date1, *_date2, _x, _y, _s);
    }
}

static void ufunc_loop_xys00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_s);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y, s += s_s) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        _s = ((double (*))s);
        eraXys00b(*_date1, *_date2, _x, _y, _s);
    }
}

static void ufunc_loop_xys06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *x = *args++;
    npy_intp s_x = *steps++;
    char *y = *args++;
    npy_intp s_y = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_x);
    double (*_y);
    double (*_s);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, x += s_x, y += s_y, s += s_s) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _x = ((double (*))x);
        _y = ((double (*))y);
        _s = ((double (*))s);
        eraXys06a(*_date1, *_date2, _x, _y, _s);
    }
}

static void ufunc_loop_ee00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *epsa = *args++;
    npy_intp s_epsa = *steps++;
    char *dpsi = *args++;
    npy_intp s_dpsi = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_epsa);
    double (*_dpsi);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, epsa += s_epsa, dpsi += s_dpsi, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _epsa = ((double (*))epsa);
        _dpsi = ((double (*))dpsi);
        _c_retval = eraEe00(*_date1, *_date2, *_epsa, *_dpsi);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ee00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraEe00a(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ee00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraEe00b(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ee06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraEe06a(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_eect00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraEect00(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_eqeq94(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _c_retval = eraEqeq94(*_date1, *_date2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_era00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dj1 = *args++;
    npy_intp s_dj1 = *steps++;
    char *dj2 = *args++;
    npy_intp s_dj2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, dj1 += s_dj1, dj2 += s_dj2, c_retval += s_c_retval) {
        _dj1 = ((double (*))dj1);
        _dj2 = ((double (*))dj2);
        _c_retval = eraEra00(*_dj1, *_dj2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gmst00(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, tta += s_tta, ttb += s_ttb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _c_retval = eraGmst00(*_uta, *_utb, *_tta, *_ttb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gmst06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, tta += s_tta, ttb += s_ttb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _c_retval = eraGmst06(*_uta, *_utb, *_tta, *_ttb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gmst82(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dj1 = *args++;
    npy_intp s_dj1 = *steps++;
    char *dj2 = *args++;
    npy_intp s_dj2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_dj1);
    double (*_dj2);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, dj1 += s_dj1, dj2 += s_dj2, c_retval += s_c_retval) {
        _dj1 = ((double (*))dj1);
        _dj2 = ((double (*))dj2);
        _c_retval = eraGmst82(*_dj1, *_dj2);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gst00a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, tta += s_tta, ttb += s_ttb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _c_retval = eraGst00a(*_uta, *_utb, *_tta, *_ttb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gst00b(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _c_retval = eraGst00b(*_uta, *_utb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gst06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *rnpb = *args++;
    npy_intp s_rnpb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double b_rnpb[3][3];
    double (*_rnpb)[3][3] = &b_rnpb;
    double _c_retval;
    npy_intp is_rnpb0 = *steps++;
    npy_intp is_rnpb1 = *steps++;
    int copy_rnpb = (is_rnpb1 != sizeof(double) ||
              is_rnpb0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, tta += s_tta, ttb += s_ttb, rnpb += s_rnpb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        if (copy_rnpb) {
            copy_to_double33(rnpb, is_rnpb0, is_rnpb1, *_rnpb);
        }
        else {
            _rnpb = ((double (*)[3][3])rnpb);
        }
        _c_retval = eraGst06(*_uta, *_utb, *_tta, *_ttb, *_rnpb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gst06a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *tta = *args++;
    npy_intp s_tta = *steps++;
    char *ttb = *args++;
    npy_intp s_ttb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double (*_tta);
    double (*_ttb);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, tta += s_tta, ttb += s_ttb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _tta = ((double (*))tta);
        _ttb = ((double (*))ttb);
        _c_retval = eraGst06a(*_uta, *_utb, *_tta, *_ttb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gst94(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *uta = *args++;
    npy_intp s_uta = *steps++;
    char *utb = *args++;
    npy_intp s_utb = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_uta);
    double (*_utb);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, uta += s_uta, utb += s_utb, c_retval += s_c_retval) {
        _uta = ((double (*))uta);
        _utb = ((double (*))utb);
        _c_retval = eraGst94(*_uta, *_utb);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_pvstar(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *ra = *args++;
    npy_intp s_ra = *steps++;
    char *dec = *args++;
    npy_intp s_dec = *steps++;
    char *pmr = *args++;
    npy_intp s_pmr = *steps++;
    char *pmd = *args++;
    npy_intp s_pmd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_pv)[2][3];
    double (*_ra);
    double (*_dec);
    double (*_pmr);
    double (*_pmd);
    double (*_px);
    double (*_rv);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, pv += s_pv, ra += s_ra, dec += s_dec, pmr += s_pmr, pmd += s_pmd, px += s_px, rv += s_rv, c_retval += s_c_retval) {
        _pv = ((double (*)[2][3])pv);
        _ra = ((double (*))ra);
        _dec = ((double (*))dec);
        _pmr = ((double (*))pmr);
        _pmd = ((double (*))pmd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _c_retval = eraPvstar(*_pv, _ra, _dec, _pmr, _pmd, _px, _rv);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_starpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ra = *args++;
    npy_intp s_ra = *steps++;
    char *dec = *args++;
    npy_intp s_dec = *steps++;
    char *pmr = *args++;
    npy_intp s_pmr = *steps++;
    char *pmd = *args++;
    npy_intp s_pmd = *steps++;
    char *px = *args++;
    npy_intp s_px = *steps++;
    char *rv = *args++;
    npy_intp s_rv = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ra);
    double (*_dec);
    double (*_pmr);
    double (*_pmd);
    double (*_px);
    double (*_rv);
    double (*_pv)[2][3];
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ra += s_ra, dec += s_dec, pmr += s_pmr, pmd += s_pmd, px += s_px, rv += s_rv, pv += s_pv, c_retval += s_c_retval) {
        _ra = ((double (*))ra);
        _dec = ((double (*))dec);
        _pmr = ((double (*))pmr);
        _pmd = ((double (*))pmd);
        _px = ((double (*))px);
        _rv = ((double (*))rv);
        _pv = ((double (*)[2][3])pv);
        _c_retval = eraStarpv(*_ra, *_dec, *_pmr, *_pmd, *_px, *_rv, *_pv);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_fk425(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r1950 = *args++;
    npy_intp s_r1950 = *steps++;
    char *d1950 = *args++;
    npy_intp s_d1950 = *steps++;
    char *dr1950 = *args++;
    npy_intp s_dr1950 = *steps++;
    char *dd1950 = *args++;
    npy_intp s_dd1950 = *steps++;
    char *p1950 = *args++;
    npy_intp s_p1950 = *steps++;
    char *v1950 = *args++;
    npy_intp s_v1950 = *steps++;
    char *r2000 = *args++;
    npy_intp s_r2000 = *steps++;
    char *d2000 = *args++;
    npy_intp s_d2000 = *steps++;
    char *dr2000 = *args++;
    npy_intp s_dr2000 = *steps++;
    char *dd2000 = *args++;
    npy_intp s_dd2000 = *steps++;
    char *p2000 = *args++;
    npy_intp s_p2000 = *steps++;
    char *v2000 = *args++;
    npy_intp s_v2000 = *steps++;
    double (*_r1950);
    double (*_d1950);
    double (*_dr1950);
    double (*_dd1950);
    double (*_p1950);
    double (*_v1950);
    double (*_r2000);
    double (*_d2000);
    double (*_dr2000);
    double (*_dd2000);
    double (*_p2000);
    double (*_v2000);
    for (i_o = 0; i_o < n_o;
         i_o++, r1950 += s_r1950, d1950 += s_d1950, dr1950 += s_dr1950, dd1950 += s_dd1950, p1950 += s_p1950, v1950 += s_v1950, r2000 += s_r2000, d2000 += s_d2000, dr2000 += s_dr2000, dd2000 += s_dd2000, p2000 += s_p2000, v2000 += s_v2000) {
        _r1950 = ((double (*))r1950);
        _d1950 = ((double (*))d1950);
        _dr1950 = ((double (*))dr1950);
        _dd1950 = ((double (*))dd1950);
        _p1950 = ((double (*))p1950);
        _v1950 = ((double (*))v1950);
        _r2000 = ((double (*))r2000);
        _d2000 = ((double (*))d2000);
        _dr2000 = ((double (*))dr2000);
        _dd2000 = ((double (*))dd2000);
        _p2000 = ((double (*))p2000);
        _v2000 = ((double (*))v2000);
        eraFk425(*_r1950, *_d1950, *_dr1950, *_dd1950, *_p1950, *_v1950, _r2000, _d2000, _dr2000, _dd2000, _p2000, _v2000);
    }
}

static void ufunc_loop_fk45z(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r1950 = *args++;
    npy_intp s_r1950 = *steps++;
    char *d1950 = *args++;
    npy_intp s_d1950 = *steps++;
    char *bepoch = *args++;
    npy_intp s_bepoch = *steps++;
    char *r2000 = *args++;
    npy_intp s_r2000 = *steps++;
    char *d2000 = *args++;
    npy_intp s_d2000 = *steps++;
    double (*_r1950);
    double (*_d1950);
    double (*_bepoch);
    double (*_r2000);
    double (*_d2000);
    for (i_o = 0; i_o < n_o;
         i_o++, r1950 += s_r1950, d1950 += s_d1950, bepoch += s_bepoch, r2000 += s_r2000, d2000 += s_d2000) {
        _r1950 = ((double (*))r1950);
        _d1950 = ((double (*))d1950);
        _bepoch = ((double (*))bepoch);
        _r2000 = ((double (*))r2000);
        _d2000 = ((double (*))d2000);
        eraFk45z(*_r1950, *_d1950, *_bepoch, _r2000, _d2000);
    }
}

static void ufunc_loop_fk524(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r2000 = *args++;
    npy_intp s_r2000 = *steps++;
    char *d2000 = *args++;
    npy_intp s_d2000 = *steps++;
    char *dr2000 = *args++;
    npy_intp s_dr2000 = *steps++;
    char *dd2000 = *args++;
    npy_intp s_dd2000 = *steps++;
    char *p2000 = *args++;
    npy_intp s_p2000 = *steps++;
    char *v2000 = *args++;
    npy_intp s_v2000 = *steps++;
    char *r1950 = *args++;
    npy_intp s_r1950 = *steps++;
    char *d1950 = *args++;
    npy_intp s_d1950 = *steps++;
    char *dr1950 = *args++;
    npy_intp s_dr1950 = *steps++;
    char *dd1950 = *args++;
    npy_intp s_dd1950 = *steps++;
    char *p1950 = *args++;
    npy_intp s_p1950 = *steps++;
    char *v1950 = *args++;
    npy_intp s_v1950 = *steps++;
    double (*_r2000);
    double (*_d2000);
    double (*_dr2000);
    double (*_dd2000);
    double (*_p2000);
    double (*_v2000);
    double (*_r1950);
    double (*_d1950);
    double (*_dr1950);
    double (*_dd1950);
    double (*_p1950);
    double (*_v1950);
    for (i_o = 0; i_o < n_o;
         i_o++, r2000 += s_r2000, d2000 += s_d2000, dr2000 += s_dr2000, dd2000 += s_dd2000, p2000 += s_p2000, v2000 += s_v2000, r1950 += s_r1950, d1950 += s_d1950, dr1950 += s_dr1950, dd1950 += s_dd1950, p1950 += s_p1950, v1950 += s_v1950) {
        _r2000 = ((double (*))r2000);
        _d2000 = ((double (*))d2000);
        _dr2000 = ((double (*))dr2000);
        _dd2000 = ((double (*))dd2000);
        _p2000 = ((double (*))p2000);
        _v2000 = ((double (*))v2000);
        _r1950 = ((double (*))r1950);
        _d1950 = ((double (*))d1950);
        _dr1950 = ((double (*))dr1950);
        _dd1950 = ((double (*))dd1950);
        _p1950 = ((double (*))p1950);
        _v1950 = ((double (*))v1950);
        eraFk524(*_r2000, *_d2000, *_dr2000, *_dd2000, *_p2000, *_v2000, _r1950, _d1950, _dr1950, _dd1950, _p1950, _v1950);
    }
}

static void ufunc_loop_fk52h(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r5 = *args++;
    npy_intp s_r5 = *steps++;
    char *d5 = *args++;
    npy_intp s_d5 = *steps++;
    char *dr5 = *args++;
    npy_intp s_dr5 = *steps++;
    char *dd5 = *args++;
    npy_intp s_dd5 = *steps++;
    char *px5 = *args++;
    npy_intp s_px5 = *steps++;
    char *rv5 = *args++;
    npy_intp s_rv5 = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *dh = *args++;
    npy_intp s_dh = *steps++;
    char *drh = *args++;
    npy_intp s_drh = *steps++;
    char *ddh = *args++;
    npy_intp s_ddh = *steps++;
    char *pxh = *args++;
    npy_intp s_pxh = *steps++;
    char *rvh = *args++;
    npy_intp s_rvh = *steps++;
    double (*_r5);
    double (*_d5);
    double (*_dr5);
    double (*_dd5);
    double (*_px5);
    double (*_rv5);
    double (*_rh);
    double (*_dh);
    double (*_drh);
    double (*_ddh);
    double (*_pxh);
    double (*_rvh);
    for (i_o = 0; i_o < n_o;
         i_o++, r5 += s_r5, d5 += s_d5, dr5 += s_dr5, dd5 += s_dd5, px5 += s_px5, rv5 += s_rv5, rh += s_rh, dh += s_dh, drh += s_drh, ddh += s_ddh, pxh += s_pxh, rvh += s_rvh) {
        _r5 = ((double (*))r5);
        _d5 = ((double (*))d5);
        _dr5 = ((double (*))dr5);
        _dd5 = ((double (*))dd5);
        _px5 = ((double (*))px5);
        _rv5 = ((double (*))rv5);
        _rh = ((double (*))rh);
        _dh = ((double (*))dh);
        _drh = ((double (*))drh);
        _ddh = ((double (*))ddh);
        _pxh = ((double (*))pxh);
        _rvh = ((double (*))rvh);
        eraFk52h(*_r5, *_d5, *_dr5, *_dd5, *_px5, *_rv5, _rh, _dh, _drh, _ddh, _pxh, _rvh);
    }
}

static void ufunc_loop_fk54z(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r2000 = *args++;
    npy_intp s_r2000 = *steps++;
    char *d2000 = *args++;
    npy_intp s_d2000 = *steps++;
    char *bepoch = *args++;
    npy_intp s_bepoch = *steps++;
    char *r1950 = *args++;
    npy_intp s_r1950 = *steps++;
    char *d1950 = *args++;
    npy_intp s_d1950 = *steps++;
    char *dr1950 = *args++;
    npy_intp s_dr1950 = *steps++;
    char *dd1950 = *args++;
    npy_intp s_dd1950 = *steps++;
    double (*_r2000);
    double (*_d2000);
    double (*_bepoch);
    double (*_r1950);
    double (*_d1950);
    double (*_dr1950);
    double (*_dd1950);
    for (i_o = 0; i_o < n_o;
         i_o++, r2000 += s_r2000, d2000 += s_d2000, bepoch += s_bepoch, r1950 += s_r1950, d1950 += s_d1950, dr1950 += s_dr1950, dd1950 += s_dd1950) {
        _r2000 = ((double (*))r2000);
        _d2000 = ((double (*))d2000);
        _bepoch = ((double (*))bepoch);
        _r1950 = ((double (*))r1950);
        _d1950 = ((double (*))d1950);
        _dr1950 = ((double (*))dr1950);
        _dd1950 = ((double (*))dd1950);
        eraFk54z(*_r2000, *_d2000, *_bepoch, _r1950, _d1950, _dr1950, _dd1950);
    }
}

static void ufunc_loop_fk5hip(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r5h = *args++;
    npy_intp s_r5h = *steps++;
    char *s5h = *args++;
    npy_intp s_s5h = *steps++;
    double b_r5h[3][3];
    double (*_r5h)[3][3] = &b_r5h;
    double b_s5h[3];
    double (*_s5h)[3] = &b_s5h;
    npy_intp is_r5h0 = *steps++;
    npy_intp is_r5h1 = *steps++;
    int copy_r5h = (is_r5h1 != sizeof(double) ||
              is_r5h0 != 3 * sizeof(double));
    npy_intp is_s5h0 = *steps++;
    int copy_s5h = (is_s5h0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r5h += s_r5h, s5h += s_s5h) {
        if (!copy_r5h) {
            _r5h = ((double (*)[3][3])r5h);
        }
        if (!copy_s5h) {
            _s5h = ((double (*)[3])s5h);
        }
        eraFk5hip(*_r5h, *_s5h);
        if (copy_r5h) {
            copy_from_double33(r5h, is_r5h0, is_r5h1, *_r5h);
        }
        if (copy_s5h) {
            copy_from_double3(s5h, is_s5h0, *_s5h);
        }
    }
}

static void ufunc_loop_fk5hz(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r5 = *args++;
    npy_intp s_r5 = *steps++;
    char *d5 = *args++;
    npy_intp s_d5 = *steps++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *dh = *args++;
    npy_intp s_dh = *steps++;
    double (*_r5);
    double (*_d5);
    double (*_date1);
    double (*_date2);
    double (*_rh);
    double (*_dh);
    for (i_o = 0; i_o < n_o;
         i_o++, r5 += s_r5, d5 += s_d5, date1 += s_date1, date2 += s_date2, rh += s_rh, dh += s_dh) {
        _r5 = ((double (*))r5);
        _d5 = ((double (*))d5);
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _rh = ((double (*))rh);
        _dh = ((double (*))dh);
        eraFk5hz(*_r5, *_d5, *_date1, *_date2, _rh, _dh);
    }
}

static void ufunc_loop_h2fk5(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *dh = *args++;
    npy_intp s_dh = *steps++;
    char *drh = *args++;
    npy_intp s_drh = *steps++;
    char *ddh = *args++;
    npy_intp s_ddh = *steps++;
    char *pxh = *args++;
    npy_intp s_pxh = *steps++;
    char *rvh = *args++;
    npy_intp s_rvh = *steps++;
    char *r5 = *args++;
    npy_intp s_r5 = *steps++;
    char *d5 = *args++;
    npy_intp s_d5 = *steps++;
    char *dr5 = *args++;
    npy_intp s_dr5 = *steps++;
    char *dd5 = *args++;
    npy_intp s_dd5 = *steps++;
    char *px5 = *args++;
    npy_intp s_px5 = *steps++;
    char *rv5 = *args++;
    npy_intp s_rv5 = *steps++;
    double (*_rh);
    double (*_dh);
    double (*_drh);
    double (*_ddh);
    double (*_pxh);
    double (*_rvh);
    double (*_r5);
    double (*_d5);
    double (*_dr5);
    double (*_dd5);
    double (*_px5);
    double (*_rv5);
    for (i_o = 0; i_o < n_o;
         i_o++, rh += s_rh, dh += s_dh, drh += s_drh, ddh += s_ddh, pxh += s_pxh, rvh += s_rvh, r5 += s_r5, d5 += s_d5, dr5 += s_dr5, dd5 += s_dd5, px5 += s_px5, rv5 += s_rv5) {
        _rh = ((double (*))rh);
        _dh = ((double (*))dh);
        _drh = ((double (*))drh);
        _ddh = ((double (*))ddh);
        _pxh = ((double (*))pxh);
        _rvh = ((double (*))rvh);
        _r5 = ((double (*))r5);
        _d5 = ((double (*))d5);
        _dr5 = ((double (*))dr5);
        _dd5 = ((double (*))dd5);
        _px5 = ((double (*))px5);
        _rv5 = ((double (*))rv5);
        eraH2fk5(*_rh, *_dh, *_drh, *_ddh, *_pxh, *_rvh, _r5, _d5, _dr5, _dd5, _px5, _rv5);
    }
}

static void ufunc_loop_hfk5z(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *rh = *args++;
    npy_intp s_rh = *steps++;
    char *dh = *args++;
    npy_intp s_dh = *steps++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *r5 = *args++;
    npy_intp s_r5 = *steps++;
    char *d5 = *args++;
    npy_intp s_d5 = *steps++;
    char *dr5 = *args++;
    npy_intp s_dr5 = *steps++;
    char *dd5 = *args++;
    npy_intp s_dd5 = *steps++;
    double (*_rh);
    double (*_dh);
    double (*_date1);
    double (*_date2);
    double (*_r5);
    double (*_d5);
    double (*_dr5);
    double (*_dd5);
    for (i_o = 0; i_o < n_o;
         i_o++, rh += s_rh, dh += s_dh, date1 += s_date1, date2 += s_date2, r5 += s_r5, d5 += s_d5, dr5 += s_dr5, dd5 += s_dd5) {
        _rh = ((double (*))rh);
        _dh = ((double (*))dh);
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _r5 = ((double (*))r5);
        _d5 = ((double (*))d5);
        _dr5 = ((double (*))dr5);
        _dd5 = ((double (*))dd5);
        eraHfk5z(*_rh, *_dh, *_date1, *_date2, _r5, _d5, _dr5, _dd5);
    }
}

static void ufunc_loop_starpm(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ra1 = *args++;
    npy_intp s_ra1 = *steps++;
    char *dec1 = *args++;
    npy_intp s_dec1 = *steps++;
    char *pmr1 = *args++;
    npy_intp s_pmr1 = *steps++;
    char *pmd1 = *args++;
    npy_intp s_pmd1 = *steps++;
    char *px1 = *args++;
    npy_intp s_px1 = *steps++;
    char *rv1 = *args++;
    npy_intp s_rv1 = *steps++;
    char *ep1a = *args++;
    npy_intp s_ep1a = *steps++;
    char *ep1b = *args++;
    npy_intp s_ep1b = *steps++;
    char *ep2a = *args++;
    npy_intp s_ep2a = *steps++;
    char *ep2b = *args++;
    npy_intp s_ep2b = *steps++;
    char *ra2 = *args++;
    npy_intp s_ra2 = *steps++;
    char *dec2 = *args++;
    npy_intp s_dec2 = *steps++;
    char *pmr2 = *args++;
    npy_intp s_pmr2 = *steps++;
    char *pmd2 = *args++;
    npy_intp s_pmd2 = *steps++;
    char *px2 = *args++;
    npy_intp s_px2 = *steps++;
    char *rv2 = *args++;
    npy_intp s_rv2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ra1);
    double (*_dec1);
    double (*_pmr1);
    double (*_pmd1);
    double (*_px1);
    double (*_rv1);
    double (*_ep1a);
    double (*_ep1b);
    double (*_ep2a);
    double (*_ep2b);
    double (*_ra2);
    double (*_dec2);
    double (*_pmr2);
    double (*_pmd2);
    double (*_px2);
    double (*_rv2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ra1 += s_ra1, dec1 += s_dec1, pmr1 += s_pmr1, pmd1 += s_pmd1, px1 += s_px1, rv1 += s_rv1, ep1a += s_ep1a, ep1b += s_ep1b, ep2a += s_ep2a, ep2b += s_ep2b, ra2 += s_ra2, dec2 += s_dec2, pmr2 += s_pmr2, pmd2 += s_pmd2, px2 += s_px2, rv2 += s_rv2, c_retval += s_c_retval) {
        _ra1 = ((double (*))ra1);
        _dec1 = ((double (*))dec1);
        _pmr1 = ((double (*))pmr1);
        _pmd1 = ((double (*))pmd1);
        _px1 = ((double (*))px1);
        _rv1 = ((double (*))rv1);
        _ep1a = ((double (*))ep1a);
        _ep1b = ((double (*))ep1b);
        _ep2a = ((double (*))ep2a);
        _ep2b = ((double (*))ep2b);
        _ra2 = ((double (*))ra2);
        _dec2 = ((double (*))dec2);
        _pmr2 = ((double (*))pmr2);
        _pmd2 = ((double (*))pmd2);
        _px2 = ((double (*))px2);
        _rv2 = ((double (*))rv2);
        _c_retval = eraStarpm(*_ra1, *_dec1, *_pmr1, *_pmd1, *_px1, *_rv1, *_ep1a, *_ep1b, *_ep2a, *_ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_eceq06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dl = *args++;
    npy_intp s_dl = *steps++;
    char *db = *args++;
    npy_intp s_db = *steps++;
    char *dr = *args++;
    npy_intp s_dr = *steps++;
    char *dd = *args++;
    npy_intp s_dd = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dl);
    double (*_db);
    double (*_dr);
    double (*_dd);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dl += s_dl, db += s_db, dr += s_dr, dd += s_dd) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dl = ((double (*))dl);
        _db = ((double (*))db);
        _dr = ((double (*))dr);
        _dd = ((double (*))dd);
        eraEceq06(*_date1, *_date2, *_dl, *_db, _dr, _dd);
    }
}

static void ufunc_loop_ecm06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *rm = *args++;
    npy_intp s_rm = *steps++;
    double (*_date1);
    double (*_date2);
    double b_rm[3][3];
    double (*_rm)[3][3] = &b_rm;
    npy_intp is_rm0 = *steps++;
    npy_intp is_rm1 = *steps++;
    int copy_rm = (is_rm1 != sizeof(double) ||
              is_rm0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, rm += s_rm) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        if (!copy_rm) {
            _rm = ((double (*)[3][3])rm);
        }
        eraEcm06(*_date1, *_date2, *_rm);
        if (copy_rm) {
            copy_from_double33(rm, is_rm0, is_rm1, *_rm);
        }
    }
}

static void ufunc_loop_eqec06(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *dr = *args++;
    npy_intp s_dr = *steps++;
    char *dd = *args++;
    npy_intp s_dd = *steps++;
    char *dl = *args++;
    npy_intp s_dl = *steps++;
    char *db = *args++;
    npy_intp s_db = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_dr);
    double (*_dd);
    double (*_dl);
    double (*_db);
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, dr += s_dr, dd += s_dd, dl += s_dl, db += s_db) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _dr = ((double (*))dr);
        _dd = ((double (*))dd);
        _dl = ((double (*))dl);
        _db = ((double (*))db);
        eraEqec06(*_date1, *_date2, *_dr, *_dd, _dl, _db);
    }
}

static void ufunc_loop_lteceq(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *dl = *args++;
    npy_intp s_dl = *steps++;
    char *db = *args++;
    npy_intp s_db = *steps++;
    char *dr = *args++;
    npy_intp s_dr = *steps++;
    char *dd = *args++;
    npy_intp s_dd = *steps++;
    double (*_epj);
    double (*_dl);
    double (*_db);
    double (*_dr);
    double (*_dd);
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, dl += s_dl, db += s_db, dr += s_dr, dd += s_dd) {
        _epj = ((double (*))epj);
        _dl = ((double (*))dl);
        _db = ((double (*))db);
        _dr = ((double (*))dr);
        _dd = ((double (*))dd);
        eraLteceq(*_epj, *_dl, *_db, _dr, _dd);
    }
}

static void ufunc_loop_ltecm(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *rm = *args++;
    npy_intp s_rm = *steps++;
    double (*_epj);
    double b_rm[3][3];
    double (*_rm)[3][3] = &b_rm;
    npy_intp is_rm0 = *steps++;
    npy_intp is_rm1 = *steps++;
    int copy_rm = (is_rm1 != sizeof(double) ||
              is_rm0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, rm += s_rm) {
        _epj = ((double (*))epj);
        if (!copy_rm) {
            _rm = ((double (*)[3][3])rm);
        }
        eraLtecm(*_epj, *_rm);
        if (copy_rm) {
            copy_from_double33(rm, is_rm0, is_rm1, *_rm);
        }
    }
}

static void ufunc_loop_lteqec(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *epj = *args++;
    npy_intp s_epj = *steps++;
    char *dr = *args++;
    npy_intp s_dr = *steps++;
    char *dd = *args++;
    npy_intp s_dd = *steps++;
    char *dl = *args++;
    npy_intp s_dl = *steps++;
    char *db = *args++;
    npy_intp s_db = *steps++;
    double (*_epj);
    double (*_dr);
    double (*_dd);
    double (*_dl);
    double (*_db);
    for (i_o = 0; i_o < n_o;
         i_o++, epj += s_epj, dr += s_dr, dd += s_dd, dl += s_dl, db += s_db) {
        _epj = ((double (*))epj);
        _dr = ((double (*))dr);
        _dd = ((double (*))dd);
        _dl = ((double (*))dl);
        _db = ((double (*))db);
        eraLteqec(*_epj, *_dr, *_dd, _dl, _db);
    }
}

static void ufunc_loop_g2icrs(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dl = *args++;
    npy_intp s_dl = *steps++;
    char *db = *args++;
    npy_intp s_db = *steps++;
    char *dr = *args++;
    npy_intp s_dr = *steps++;
    char *dd = *args++;
    npy_intp s_dd = *steps++;
    double (*_dl);
    double (*_db);
    double (*_dr);
    double (*_dd);
    for (i_o = 0; i_o < n_o;
         i_o++, dl += s_dl, db += s_db, dr += s_dr, dd += s_dd) {
        _dl = ((double (*))dl);
        _db = ((double (*))db);
        _dr = ((double (*))dr);
        _dd = ((double (*))dd);
        eraG2icrs(*_dl, *_db, _dr, _dd);
    }
}

static void ufunc_loop_icrs2g(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dr = *args++;
    npy_intp s_dr = *steps++;
    char *dd = *args++;
    npy_intp s_dd = *steps++;
    char *dl = *args++;
    npy_intp s_dl = *steps++;
    char *db = *args++;
    npy_intp s_db = *steps++;
    double (*_dr);
    double (*_dd);
    double (*_dl);
    double (*_db);
    for (i_o = 0; i_o < n_o;
         i_o++, dr += s_dr, dd += s_dd, dl += s_dl, db += s_db) {
        _dr = ((double (*))dr);
        _dd = ((double (*))dd);
        _dl = ((double (*))dl);
        _db = ((double (*))db);
        eraIcrs2g(*_dr, *_dd, _dl, _db);
    }
}

static void ufunc_loop_eform(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *n = *args++;
    npy_intp s_n = *steps++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *f = *args++;
    npy_intp s_f = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    int (*_n);
    double (*_a);
    double (*_f);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, n += s_n, a += s_a, f += s_f, c_retval += s_c_retval) {
        _n = ((int (*))n);
        _a = ((double (*))a);
        _f = ((double (*))f);
        _c_retval = eraEform(*_n, _a, _f);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gc2gd(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *n = *args++;
    npy_intp s_n = *steps++;
    char *xyz = *args++;
    npy_intp s_xyz = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *height = *args++;
    npy_intp s_height = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    int (*_n);
    double b_xyz[3];
    double (*_xyz)[3] = &b_xyz;
    double (*_elong);
    double (*_phi);
    double (*_height);
    int _c_retval;
    npy_intp is_xyz0 = *steps++;
    int copy_xyz = (is_xyz0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, n += s_n, xyz += s_xyz, elong += s_elong, phi += s_phi, height += s_height, c_retval += s_c_retval) {
        _n = ((int (*))n);
        if (copy_xyz) {
            copy_to_double3(xyz, is_xyz0, *_xyz);
        }
        else {
            _xyz = ((double (*)[3])xyz);
        }
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _height = ((double (*))height);
        _c_retval = eraGc2gd(*_n, *_xyz, _elong, _phi, _height);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gc2gde(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *f = *args++;
    npy_intp s_f = *steps++;
    char *xyz = *args++;
    npy_intp s_xyz = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *height = *args++;
    npy_intp s_height = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_a);
    double (*_f);
    double b_xyz[3];
    double (*_xyz)[3] = &b_xyz;
    double (*_elong);
    double (*_phi);
    double (*_height);
    int _c_retval;
    npy_intp is_xyz0 = *steps++;
    int copy_xyz = (is_xyz0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, f += s_f, xyz += s_xyz, elong += s_elong, phi += s_phi, height += s_height, c_retval += s_c_retval) {
        _a = ((double (*))a);
        _f = ((double (*))f);
        if (copy_xyz) {
            copy_to_double3(xyz, is_xyz0, *_xyz);
        }
        else {
            _xyz = ((double (*)[3])xyz);
        }
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _height = ((double (*))height);
        _c_retval = eraGc2gde(*_a, *_f, *_xyz, _elong, _phi, _height);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_gd2gc(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *n = *args++;
    npy_intp s_n = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *height = *args++;
    npy_intp s_height = *steps++;
    char *xyz = *args++;
    npy_intp s_xyz = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    int (*_n);
    double (*_elong);
    double (*_phi);
    double (*_height);
    double b_xyz[3];
    double (*_xyz)[3] = &b_xyz;
    int _c_retval;
    npy_intp is_xyz0 = *steps++;
    int copy_xyz = (is_xyz0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, n += s_n, elong += s_elong, phi += s_phi, height += s_height, xyz += s_xyz, c_retval += s_c_retval) {
        _n = ((int (*))n);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _height = ((double (*))height);
        if (!copy_xyz) {
            _xyz = ((double (*)[3])xyz);
        }
        _c_retval = eraGd2gc(*_n, *_elong, *_phi, *_height, *_xyz);
        *((int *)c_retval) = _c_retval;
        if (copy_xyz) {
            copy_from_double3(xyz, is_xyz0, *_xyz);
        }
    }
}

static void ufunc_loop_gd2gce(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *f = *args++;
    npy_intp s_f = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *height = *args++;
    npy_intp s_height = *steps++;
    char *xyz = *args++;
    npy_intp s_xyz = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_a);
    double (*_f);
    double (*_elong);
    double (*_phi);
    double (*_height);
    double b_xyz[3];
    double (*_xyz)[3] = &b_xyz;
    int _c_retval;
    npy_intp is_xyz0 = *steps++;
    int copy_xyz = (is_xyz0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, f += s_f, elong += s_elong, phi += s_phi, height += s_height, xyz += s_xyz, c_retval += s_c_retval) {
        _a = ((double (*))a);
        _f = ((double (*))f);
        _elong = ((double (*))elong);
        _phi = ((double (*))phi);
        _height = ((double (*))height);
        if (!copy_xyz) {
            _xyz = ((double (*)[3])xyz);
        }
        _c_retval = eraGd2gce(*_a, *_f, *_elong, *_phi, *_height, *_xyz);
        *((int *)c_retval) = _c_retval;
        if (copy_xyz) {
            copy_from_double3(xyz, is_xyz0, *_xyz);
        }
    }
}

static void ufunc_loop_d2dtf(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *scale = *args++;
    npy_intp s_scale = *steps++;
    char *ndp = *args++;
    npy_intp s_ndp = *steps++;
    char *d1 = *args++;
    npy_intp s_d1 = *steps++;
    char *d2 = *args++;
    npy_intp s_d2 = *steps++;
    char *iy = *args++;
    npy_intp s_iy = *steps++;
    char *im = *args++;
    npy_intp s_im = *steps++;
    char *id = *args++;
    npy_intp s_id = *steps++;
    char *ihmsf = *args++;
    npy_intp s_ihmsf = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    const char (*_scale);
    int (*_ndp);
    double (*_d1);
    double (*_d2);
    int (*_iy);
    int (*_im);
    int (*_id);
    int (*_ihmsf)[4];
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, scale += s_scale, ndp += s_ndp, d1 += s_d1, d2 += s_d2, iy += s_iy, im += s_im, id += s_id, ihmsf += s_ihmsf, c_retval += s_c_retval) {
        _scale = ((const char (*))scale);
        _ndp = ((int (*))ndp);
        _d1 = ((double (*))d1);
        _d2 = ((double (*))d2);
        _iy = ((int (*))iy);
        _im = ((int (*))im);
        _id = ((int (*))id);
        _ihmsf = ((int (*)[4])ihmsf);
        _c_retval = eraD2dtf(_scale, *_ndp, *_d1, *_d2, _iy, _im, _id, *_ihmsf);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_dat(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *iy = *args++;
    npy_intp s_iy = *steps++;
    char *im = *args++;
    npy_intp s_im = *steps++;
    char *id = *args++;
    npy_intp s_id = *steps++;
    char *fd = *args++;
    npy_intp s_fd = *steps++;
    char *deltat = *args++;
    npy_intp s_deltat = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    int (*_iy);
    int (*_im);
    int (*_id);
    double (*_fd);
    double (*_deltat);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, iy += s_iy, im += s_im, id += s_id, fd += s_fd, deltat += s_deltat, c_retval += s_c_retval) {
        _iy = ((int (*))iy);
        _im = ((int (*))im);
        _id = ((int (*))id);
        _fd = ((double (*))fd);
        _deltat = ((double (*))deltat);
        _c_retval = eraDat(*_iy, *_im, *_id, *_fd, _deltat);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_dtdb(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *date1 = *args++;
    npy_intp s_date1 = *steps++;
    char *date2 = *args++;
    npy_intp s_date2 = *steps++;
    char *ut = *args++;
    npy_intp s_ut = *steps++;
    char *elong = *args++;
    npy_intp s_elong = *steps++;
    char *u = *args++;
    npy_intp s_u = *steps++;
    char *v = *args++;
    npy_intp s_v = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_date1);
    double (*_date2);
    double (*_ut);
    double (*_elong);
    double (*_u);
    double (*_v);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, date1 += s_date1, date2 += s_date2, ut += s_ut, elong += s_elong, u += s_u, v += s_v, c_retval += s_c_retval) {
        _date1 = ((double (*))date1);
        _date2 = ((double (*))date2);
        _ut = ((double (*))ut);
        _elong = ((double (*))elong);
        _u = ((double (*))u);
        _v = ((double (*))v);
        _c_retval = eraDtdb(*_date1, *_date2, *_ut, *_elong, *_u, *_v);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_dtf2d(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *scale = *args++;
    npy_intp s_scale = *steps++;
    char *iy = *args++;
    npy_intp s_iy = *steps++;
    char *im = *args++;
    npy_intp s_im = *steps++;
    char *id = *args++;
    npy_intp s_id = *steps++;
    char *ihr = *args++;
    npy_intp s_ihr = *steps++;
    char *imn = *args++;
    npy_intp s_imn = *steps++;
    char *sec = *args++;
    npy_intp s_sec = *steps++;
    char *d1 = *args++;
    npy_intp s_d1 = *steps++;
    char *d2 = *args++;
    npy_intp s_d2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    const char (*_scale);
    int (*_iy);
    int (*_im);
    int (*_id);
    int (*_ihr);
    int (*_imn);
    double (*_sec);
    double (*_d1);
    double (*_d2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, scale += s_scale, iy += s_iy, im += s_im, id += s_id, ihr += s_ihr, imn += s_imn, sec += s_sec, d1 += s_d1, d2 += s_d2, c_retval += s_c_retval) {
        _scale = ((const char (*))scale);
        _iy = ((int (*))iy);
        _im = ((int (*))im);
        _id = ((int (*))id);
        _ihr = ((int (*))ihr);
        _imn = ((int (*))imn);
        _sec = ((double (*))sec);
        _d1 = ((double (*))d1);
        _d2 = ((double (*))d2);
        _c_retval = eraDtf2d(_scale, *_iy, *_im, *_id, *_ihr, *_imn, *_sec, _d1, _d2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_taitt(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tai1 = *args++;
    npy_intp s_tai1 = *steps++;
    char *tai2 = *args++;
    npy_intp s_tai2 = *steps++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tai1);
    double (*_tai2);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tai1 += s_tai1, tai2 += s_tai2, tt1 += s_tt1, tt2 += s_tt2, c_retval += s_c_retval) {
        _tai1 = ((double (*))tai1);
        _tai2 = ((double (*))tai2);
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _c_retval = eraTaitt(*_tai1, *_tai2, _tt1, _tt2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_taiut1(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tai1 = *args++;
    npy_intp s_tai1 = *steps++;
    char *tai2 = *args++;
    npy_intp s_tai2 = *steps++;
    char *dta = *args++;
    npy_intp s_dta = *steps++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tai1);
    double (*_tai2);
    double (*_dta);
    double (*_ut11);
    double (*_ut12);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tai1 += s_tai1, tai2 += s_tai2, dta += s_dta, ut11 += s_ut11, ut12 += s_ut12, c_retval += s_c_retval) {
        _tai1 = ((double (*))tai1);
        _tai2 = ((double (*))tai2);
        _dta = ((double (*))dta);
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _c_retval = eraTaiut1(*_tai1, *_tai2, *_dta, _ut11, _ut12);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_taiutc(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tai1 = *args++;
    npy_intp s_tai1 = *steps++;
    char *tai2 = *args++;
    npy_intp s_tai2 = *steps++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tai1);
    double (*_tai2);
    double (*_utc1);
    double (*_utc2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tai1 += s_tai1, tai2 += s_tai2, utc1 += s_utc1, utc2 += s_utc2, c_retval += s_c_retval) {
        _tai1 = ((double (*))tai1);
        _tai2 = ((double (*))tai2);
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _c_retval = eraTaiutc(*_tai1, *_tai2, _utc1, _utc2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tcbtdb(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tcb1 = *args++;
    npy_intp s_tcb1 = *steps++;
    char *tcb2 = *args++;
    npy_intp s_tcb2 = *steps++;
    char *tdb1 = *args++;
    npy_intp s_tdb1 = *steps++;
    char *tdb2 = *args++;
    npy_intp s_tdb2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tcb1);
    double (*_tcb2);
    double (*_tdb1);
    double (*_tdb2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tcb1 += s_tcb1, tcb2 += s_tcb2, tdb1 += s_tdb1, tdb2 += s_tdb2, c_retval += s_c_retval) {
        _tcb1 = ((double (*))tcb1);
        _tcb2 = ((double (*))tcb2);
        _tdb1 = ((double (*))tdb1);
        _tdb2 = ((double (*))tdb2);
        _c_retval = eraTcbtdb(*_tcb1, *_tcb2, _tdb1, _tdb2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tcgtt(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tcg1 = *args++;
    npy_intp s_tcg1 = *steps++;
    char *tcg2 = *args++;
    npy_intp s_tcg2 = *steps++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tcg1);
    double (*_tcg2);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tcg1 += s_tcg1, tcg2 += s_tcg2, tt1 += s_tt1, tt2 += s_tt2, c_retval += s_c_retval) {
        _tcg1 = ((double (*))tcg1);
        _tcg2 = ((double (*))tcg2);
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _c_retval = eraTcgtt(*_tcg1, *_tcg2, _tt1, _tt2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tdbtcb(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tdb1 = *args++;
    npy_intp s_tdb1 = *steps++;
    char *tdb2 = *args++;
    npy_intp s_tdb2 = *steps++;
    char *tcb1 = *args++;
    npy_intp s_tcb1 = *steps++;
    char *tcb2 = *args++;
    npy_intp s_tcb2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tdb1);
    double (*_tdb2);
    double (*_tcb1);
    double (*_tcb2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tdb1 += s_tdb1, tdb2 += s_tdb2, tcb1 += s_tcb1, tcb2 += s_tcb2, c_retval += s_c_retval) {
        _tdb1 = ((double (*))tdb1);
        _tdb2 = ((double (*))tdb2);
        _tcb1 = ((double (*))tcb1);
        _tcb2 = ((double (*))tcb2);
        _c_retval = eraTdbtcb(*_tdb1, *_tdb2, _tcb1, _tcb2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tdbtt(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tdb1 = *args++;
    npy_intp s_tdb1 = *steps++;
    char *tdb2 = *args++;
    npy_intp s_tdb2 = *steps++;
    char *dtr = *args++;
    npy_intp s_dtr = *steps++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tdb1);
    double (*_tdb2);
    double (*_dtr);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tdb1 += s_tdb1, tdb2 += s_tdb2, dtr += s_dtr, tt1 += s_tt1, tt2 += s_tt2, c_retval += s_c_retval) {
        _tdb1 = ((double (*))tdb1);
        _tdb2 = ((double (*))tdb2);
        _dtr = ((double (*))dtr);
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _c_retval = eraTdbtt(*_tdb1, *_tdb2, *_dtr, _tt1, _tt2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tttai(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *tai1 = *args++;
    npy_intp s_tai1 = *steps++;
    char *tai2 = *args++;
    npy_intp s_tai2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tt1);
    double (*_tt2);
    double (*_tai1);
    double (*_tai2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tt1 += s_tt1, tt2 += s_tt2, tai1 += s_tai1, tai2 += s_tai2, c_retval += s_c_retval) {
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _tai1 = ((double (*))tai1);
        _tai2 = ((double (*))tai2);
        _c_retval = eraTttai(*_tt1, *_tt2, _tai1, _tai2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tttcg(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *tcg1 = *args++;
    npy_intp s_tcg1 = *steps++;
    char *tcg2 = *args++;
    npy_intp s_tcg2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tt1);
    double (*_tt2);
    double (*_tcg1);
    double (*_tcg2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tt1 += s_tt1, tt2 += s_tt2, tcg1 += s_tcg1, tcg2 += s_tcg2, c_retval += s_c_retval) {
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _tcg1 = ((double (*))tcg1);
        _tcg2 = ((double (*))tcg2);
        _c_retval = eraTttcg(*_tt1, *_tt2, _tcg1, _tcg2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tttdb(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *dtr = *args++;
    npy_intp s_dtr = *steps++;
    char *tdb1 = *args++;
    npy_intp s_tdb1 = *steps++;
    char *tdb2 = *args++;
    npy_intp s_tdb2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tt1);
    double (*_tt2);
    double (*_dtr);
    double (*_tdb1);
    double (*_tdb2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tt1 += s_tt1, tt2 += s_tt2, dtr += s_dtr, tdb1 += s_tdb1, tdb2 += s_tdb2, c_retval += s_c_retval) {
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _dtr = ((double (*))dtr);
        _tdb1 = ((double (*))tdb1);
        _tdb2 = ((double (*))tdb2);
        _c_retval = eraTttdb(*_tt1, *_tt2, *_dtr, _tdb1, _tdb2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ttut1(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *dt = *args++;
    npy_intp s_dt = *steps++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_tt1);
    double (*_tt2);
    double (*_dt);
    double (*_ut11);
    double (*_ut12);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, tt1 += s_tt1, tt2 += s_tt2, dt += s_dt, ut11 += s_ut11, ut12 += s_ut12, c_retval += s_c_retval) {
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _dt = ((double (*))dt);
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _c_retval = eraTtut1(*_tt1, *_tt2, *_dt, _ut11, _ut12);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ut1tai(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *dta = *args++;
    npy_intp s_dta = *steps++;
    char *tai1 = *args++;
    npy_intp s_tai1 = *steps++;
    char *tai2 = *args++;
    npy_intp s_tai2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ut11);
    double (*_ut12);
    double (*_dta);
    double (*_tai1);
    double (*_tai2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ut11 += s_ut11, ut12 += s_ut12, dta += s_dta, tai1 += s_tai1, tai2 += s_tai2, c_retval += s_c_retval) {
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _dta = ((double (*))dta);
        _tai1 = ((double (*))tai1);
        _tai2 = ((double (*))tai2);
        _c_retval = eraUt1tai(*_ut11, *_ut12, *_dta, _tai1, _tai2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ut1tt(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *dt = *args++;
    npy_intp s_dt = *steps++;
    char *tt1 = *args++;
    npy_intp s_tt1 = *steps++;
    char *tt2 = *args++;
    npy_intp s_tt2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ut11);
    double (*_ut12);
    double (*_dt);
    double (*_tt1);
    double (*_tt2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ut11 += s_ut11, ut12 += s_ut12, dt += s_dt, tt1 += s_tt1, tt2 += s_tt2, c_retval += s_c_retval) {
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _dt = ((double (*))dt);
        _tt1 = ((double (*))tt1);
        _tt2 = ((double (*))tt2);
        _c_retval = eraUt1tt(*_ut11, *_ut12, *_dt, _tt1, _tt2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ut1utc(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ut11);
    double (*_ut12);
    double (*_dut1);
    double (*_utc1);
    double (*_utc2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ut11 += s_ut11, ut12 += s_ut12, dut1 += s_dut1, utc1 += s_utc1, utc2 += s_utc2, c_retval += s_c_retval) {
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _dut1 = ((double (*))dut1);
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _c_retval = eraUt1utc(*_ut11, *_ut12, *_dut1, _utc1, _utc2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_utctai(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *tai1 = *args++;
    npy_intp s_tai1 = *steps++;
    char *tai2 = *args++;
    npy_intp s_tai2 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_utc1);
    double (*_utc2);
    double (*_tai1);
    double (*_tai2);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, utc1 += s_utc1, utc2 += s_utc2, tai1 += s_tai1, tai2 += s_tai2, c_retval += s_c_retval) {
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _tai1 = ((double (*))tai1);
        _tai2 = ((double (*))tai2);
        _c_retval = eraUtctai(*_utc1, *_utc2, _tai1, _tai2);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_utcut1(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *utc1 = *args++;
    npy_intp s_utc1 = *steps++;
    char *utc2 = *args++;
    npy_intp s_utc2 = *steps++;
    char *dut1 = *args++;
    npy_intp s_dut1 = *steps++;
    char *ut11 = *args++;
    npy_intp s_ut11 = *steps++;
    char *ut12 = *args++;
    npy_intp s_ut12 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_utc1);
    double (*_utc2);
    double (*_dut1);
    double (*_ut11);
    double (*_ut12);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, utc1 += s_utc1, utc2 += s_utc2, dut1 += s_dut1, ut11 += s_ut11, ut12 += s_ut12, c_retval += s_c_retval) {
        _utc1 = ((double (*))utc1);
        _utc2 = ((double (*))utc2);
        _dut1 = ((double (*))dut1);
        _ut11 = ((double (*))ut11);
        _ut12 = ((double (*))ut12);
        _c_retval = eraUtcut1(*_utc1, *_utc2, *_dut1, _ut11, _ut12);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_ae2hd(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *az = *args++;
    npy_intp s_az = *steps++;
    char *el = *args++;
    npy_intp s_el = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *ha = *args++;
    npy_intp s_ha = *steps++;
    char *dec = *args++;
    npy_intp s_dec = *steps++;
    double (*_az);
    double (*_el);
    double (*_phi);
    double (*_ha);
    double (*_dec);
    for (i_o = 0; i_o < n_o;
         i_o++, az += s_az, el += s_el, phi += s_phi, ha += s_ha, dec += s_dec) {
        _az = ((double (*))az);
        _el = ((double (*))el);
        _phi = ((double (*))phi);
        _ha = ((double (*))ha);
        _dec = ((double (*))dec);
        eraAe2hd(*_az, *_el, *_phi, _ha, _dec);
    }
}

static void ufunc_loop_hd2ae(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ha = *args++;
    npy_intp s_ha = *steps++;
    char *dec = *args++;
    npy_intp s_dec = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *az = *args++;
    npy_intp s_az = *steps++;
    char *el = *args++;
    npy_intp s_el = *steps++;
    double (*_ha);
    double (*_dec);
    double (*_phi);
    double (*_az);
    double (*_el);
    for (i_o = 0; i_o < n_o;
         i_o++, ha += s_ha, dec += s_dec, phi += s_phi, az += s_az, el += s_el) {
        _ha = ((double (*))ha);
        _dec = ((double (*))dec);
        _phi = ((double (*))phi);
        _az = ((double (*))az);
        _el = ((double (*))el);
        eraHd2ae(*_ha, *_dec, *_phi, _az, _el);
    }
}

static void ufunc_loop_hd2pa(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ha = *args++;
    npy_intp s_ha = *steps++;
    char *dec = *args++;
    npy_intp s_dec = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_ha);
    double (*_dec);
    double (*_phi);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, ha += s_ha, dec += s_dec, phi += s_phi, c_retval += s_c_retval) {
        _ha = ((double (*))ha);
        _dec = ((double (*))dec);
        _phi = ((double (*))phi);
        _c_retval = eraHd2pa(*_ha, *_dec, *_phi);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tpors(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *xi = *args++;
    npy_intp s_xi = *steps++;
    char *eta = *args++;
    npy_intp s_eta = *steps++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *a01 = *args++;
    npy_intp s_a01 = *steps++;
    char *b01 = *args++;
    npy_intp s_b01 = *steps++;
    char *a02 = *args++;
    npy_intp s_a02 = *steps++;
    char *b02 = *args++;
    npy_intp s_b02 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_xi);
    double (*_eta);
    double (*_a);
    double (*_b);
    double (*_a01);
    double (*_b01);
    double (*_a02);
    double (*_b02);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, xi += s_xi, eta += s_eta, a += s_a, b += s_b, a01 += s_a01, b01 += s_b01, a02 += s_a02, b02 += s_b02, c_retval += s_c_retval) {
        _xi = ((double (*))xi);
        _eta = ((double (*))eta);
        _a = ((double (*))a);
        _b = ((double (*))b);
        _a01 = ((double (*))a01);
        _b01 = ((double (*))b01);
        _a02 = ((double (*))a02);
        _b02 = ((double (*))b02);
        _c_retval = eraTpors(*_xi, *_eta, *_a, *_b, _a01, _b01, _a02, _b02);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tporv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *xi = *args++;
    npy_intp s_xi = *steps++;
    char *eta = *args++;
    npy_intp s_eta = *steps++;
    char *v = *args++;
    npy_intp s_v = *steps++;
    char *v01 = *args++;
    npy_intp s_v01 = *steps++;
    char *v02 = *args++;
    npy_intp s_v02 = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_xi);
    double (*_eta);
    double b_v[3];
    double (*_v)[3] = &b_v;
    double b_v01[3];
    double (*_v01)[3] = &b_v01;
    double b_v02[3];
    double (*_v02)[3] = &b_v02;
    int _c_retval;
    npy_intp is_v0 = *steps++;
    int copy_v = (is_v0 != sizeof(double));
    npy_intp is_v010 = *steps++;
    int copy_v01 = (is_v010 != sizeof(double));
    npy_intp is_v020 = *steps++;
    int copy_v02 = (is_v020 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, xi += s_xi, eta += s_eta, v += s_v, v01 += s_v01, v02 += s_v02, c_retval += s_c_retval) {
        _xi = ((double (*))xi);
        _eta = ((double (*))eta);
        if (copy_v) {
            copy_to_double3(v, is_v0, *_v);
        }
        else {
            _v = ((double (*)[3])v);
        }
        if (!copy_v01) {
            _v01 = ((double (*)[3])v01);
        }
        if (!copy_v02) {
            _v02 = ((double (*)[3])v02);
        }
        _c_retval = eraTporv(*_xi, *_eta, *_v, *_v01, *_v02);
        *((int *)c_retval) = _c_retval;
        if (copy_v01) {
            copy_from_double3(v01, is_v010, *_v01);
        }
        if (copy_v02) {
            copy_from_double3(v02, is_v020, *_v02);
        }
    }
}

static void ufunc_loop_tpsts(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *xi = *args++;
    npy_intp s_xi = *steps++;
    char *eta = *args++;
    npy_intp s_eta = *steps++;
    char *a0 = *args++;
    npy_intp s_a0 = *steps++;
    char *b0 = *args++;
    npy_intp s_b0 = *steps++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    double (*_xi);
    double (*_eta);
    double (*_a0);
    double (*_b0);
    double (*_a);
    double (*_b);
    for (i_o = 0; i_o < n_o;
         i_o++, xi += s_xi, eta += s_eta, a0 += s_a0, b0 += s_b0, a += s_a, b += s_b) {
        _xi = ((double (*))xi);
        _eta = ((double (*))eta);
        _a0 = ((double (*))a0);
        _b0 = ((double (*))b0);
        _a = ((double (*))a);
        _b = ((double (*))b);
        eraTpsts(*_xi, *_eta, *_a0, *_b0, _a, _b);
    }
}

static void ufunc_loop_tpstv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *xi = *args++;
    npy_intp s_xi = *steps++;
    char *eta = *args++;
    npy_intp s_eta = *steps++;
    char *v0 = *args++;
    npy_intp s_v0 = *steps++;
    char *v = *args++;
    npy_intp s_v = *steps++;
    double (*_xi);
    double (*_eta);
    double b_v0[3];
    double (*_v0)[3] = &b_v0;
    double b_v[3];
    double (*_v)[3] = &b_v;
    npy_intp is_v00 = *steps++;
    int copy_v0 = (is_v00 != sizeof(double));
    npy_intp is_v0 = *steps++;
    int copy_v = (is_v0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, xi += s_xi, eta += s_eta, v0 += s_v0, v += s_v) {
        _xi = ((double (*))xi);
        _eta = ((double (*))eta);
        if (copy_v0) {
            copy_to_double3(v0, is_v00, *_v0);
        }
        else {
            _v0 = ((double (*)[3])v0);
        }
        if (!copy_v) {
            _v = ((double (*)[3])v);
        }
        eraTpstv(*_xi, *_eta, *_v0, *_v);
        if (copy_v) {
            copy_from_double3(v, is_v0, *_v);
        }
    }
}

static void ufunc_loop_tpxes(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *a0 = *args++;
    npy_intp s_a0 = *steps++;
    char *b0 = *args++;
    npy_intp s_b0 = *steps++;
    char *xi = *args++;
    npy_intp s_xi = *steps++;
    char *eta = *args++;
    npy_intp s_eta = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_a);
    double (*_b);
    double (*_a0);
    double (*_b0);
    double (*_xi);
    double (*_eta);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, a0 += s_a0, b0 += s_b0, xi += s_xi, eta += s_eta, c_retval += s_c_retval) {
        _a = ((double (*))a);
        _b = ((double (*))b);
        _a0 = ((double (*))a0);
        _b0 = ((double (*))b0);
        _xi = ((double (*))xi);
        _eta = ((double (*))eta);
        _c_retval = eraTpxes(*_a, *_b, *_a0, *_b0, _xi, _eta);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tpxev(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *v = *args++;
    npy_intp s_v = *steps++;
    char *v0 = *args++;
    npy_intp s_v0 = *steps++;
    char *xi = *args++;
    npy_intp s_xi = *steps++;
    char *eta = *args++;
    npy_intp s_eta = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double b_v[3];
    double (*_v)[3] = &b_v;
    double b_v0[3];
    double (*_v0)[3] = &b_v0;
    double (*_xi);
    double (*_eta);
    int _c_retval;
    npy_intp is_v0 = *steps++;
    int copy_v = (is_v0 != sizeof(double));
    npy_intp is_v00 = *steps++;
    int copy_v0 = (is_v00 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, v += s_v, v0 += s_v0, xi += s_xi, eta += s_eta, c_retval += s_c_retval) {
        if (copy_v) {
            copy_to_double3(v, is_v0, *_v);
        }
        else {
            _v = ((double (*)[3])v);
        }
        if (copy_v0) {
            copy_to_double3(v0, is_v00, *_v0);
        }
        else {
            _v0 = ((double (*)[3])v0);
        }
        _xi = ((double (*))xi);
        _eta = ((double (*))eta);
        _c_retval = eraTpxev(*_v, *_v0, _xi, _eta);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_a2af(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ndp = *args++;
    npy_intp s_ndp = *steps++;
    char *angle = *args++;
    npy_intp s_angle = *steps++;
    char *sign = *args++;
    npy_intp s_sign = *steps++;
    char *idmsf = *args++;
    npy_intp s_idmsf = *steps++;
    int (*_ndp);
    double (*_angle);
    char (*_sign);
    int (*_idmsf)[4];
    for (i_o = 0; i_o < n_o;
         i_o++, ndp += s_ndp, angle += s_angle, sign += s_sign, idmsf += s_idmsf) {
        _ndp = ((int (*))ndp);
        _angle = ((double (*))angle);
        _sign = ((char (*))sign);
        _idmsf = ((int (*)[4])idmsf);
        eraA2af(*_ndp, *_angle, _sign, *_idmsf);
    }
}

static void ufunc_loop_a2tf(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ndp = *args++;
    npy_intp s_ndp = *steps++;
    char *angle = *args++;
    npy_intp s_angle = *steps++;
    char *sign = *args++;
    npy_intp s_sign = *steps++;
    char *ihmsf = *args++;
    npy_intp s_ihmsf = *steps++;
    int (*_ndp);
    double (*_angle);
    char (*_sign);
    int (*_ihmsf)[4];
    for (i_o = 0; i_o < n_o;
         i_o++, ndp += s_ndp, angle += s_angle, sign += s_sign, ihmsf += s_ihmsf) {
        _ndp = ((int (*))ndp);
        _angle = ((double (*))angle);
        _sign = ((char (*))sign);
        _ihmsf = ((int (*)[4])ihmsf);
        eraA2tf(*_ndp, *_angle, _sign, *_ihmsf);
    }
}

static void ufunc_loop_af2a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *ideg = *args++;
    npy_intp s_ideg = *steps++;
    char *iamin = *args++;
    npy_intp s_iamin = *steps++;
    char *asec = *args++;
    npy_intp s_asec = *steps++;
    char *rad = *args++;
    npy_intp s_rad = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    char (*_s);
    int (*_ideg);
    int (*_iamin);
    double (*_asec);
    double (*_rad);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, s += s_s, ideg += s_ideg, iamin += s_iamin, asec += s_asec, rad += s_rad, c_retval += s_c_retval) {
        _s = ((char (*))s);
        _ideg = ((int (*))ideg);
        _iamin = ((int (*))iamin);
        _asec = ((double (*))asec);
        _rad = ((double (*))rad);
        _c_retval = eraAf2a(*_s, *_ideg, *_iamin, *_asec, _rad);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_anp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_a);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, c_retval += s_c_retval) {
        _a = ((double (*))a);
        _c_retval = eraAnp(*_a);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_anpm(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_a);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, c_retval += s_c_retval) {
        _a = ((double (*))a);
        _c_retval = eraAnpm(*_a);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_d2tf(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *ndp = *args++;
    npy_intp s_ndp = *steps++;
    char *days = *args++;
    npy_intp s_days = *steps++;
    char *sign = *args++;
    npy_intp s_sign = *steps++;
    char *ihmsf = *args++;
    npy_intp s_ihmsf = *steps++;
    int (*_ndp);
    double (*_days);
    char (*_sign);
    int (*_ihmsf)[4];
    for (i_o = 0; i_o < n_o;
         i_o++, ndp += s_ndp, days += s_days, sign += s_sign, ihmsf += s_ihmsf) {
        _ndp = ((int (*))ndp);
        _days = ((double (*))days);
        _sign = ((char (*))sign);
        _ihmsf = ((int (*)[4])ihmsf);
        eraD2tf(*_ndp, *_days, _sign, *_ihmsf);
    }
}

static void ufunc_loop_tf2a(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *ihour = *args++;
    npy_intp s_ihour = *steps++;
    char *imin = *args++;
    npy_intp s_imin = *steps++;
    char *sec = *args++;
    npy_intp s_sec = *steps++;
    char *rad = *args++;
    npy_intp s_rad = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    char (*_s);
    int (*_ihour);
    int (*_imin);
    double (*_sec);
    double (*_rad);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, s += s_s, ihour += s_ihour, imin += s_imin, sec += s_sec, rad += s_rad, c_retval += s_c_retval) {
        _s = ((char (*))s);
        _ihour = ((int (*))ihour);
        _imin = ((int (*))imin);
        _sec = ((double (*))sec);
        _rad = ((double (*))rad);
        _c_retval = eraTf2a(*_s, *_ihour, *_imin, *_sec, _rad);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_tf2d(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *ihour = *args++;
    npy_intp s_ihour = *steps++;
    char *imin = *args++;
    npy_intp s_imin = *steps++;
    char *sec = *args++;
    npy_intp s_sec = *steps++;
    char *days = *args++;
    npy_intp s_days = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    char (*_s);
    int (*_ihour);
    int (*_imin);
    double (*_sec);
    double (*_days);
    int _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, s += s_s, ihour += s_ihour, imin += s_imin, sec += s_sec, days += s_days, c_retval += s_c_retval) {
        _s = ((char (*))s);
        _ihour = ((int (*))ihour);
        _imin = ((int (*))imin);
        _sec = ((double (*))sec);
        _days = ((double (*))days);
        _c_retval = eraTf2d(*_s, *_ihour, *_imin, *_sec, _days);
        *((int *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_rx(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *r_in = *args++;
    npy_intp s_r_in = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double (*_phi);
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_r_in0 = *steps++;
    npy_intp is_r_in1 = *steps++;
    int copy_r_in = (is_r_in1 != sizeof(double) ||
              is_r_in0 != 3 * sizeof(double));
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, phi += s_phi, r += s_r, r_in += s_r_in) {
        _phi = ((double (*))phi);
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        if (copy_r_in || r != r_in) {
            copy_to_double33(r_in, is_r_in0, is_r_in1, *_r);
        }
        eraRx(*_phi, *_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_ry(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *r_in = *args++;
    npy_intp s_r_in = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double (*_theta);
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_r_in0 = *steps++;
    npy_intp is_r_in1 = *steps++;
    int copy_r_in = (is_r_in1 != sizeof(double) ||
              is_r_in0 != 3 * sizeof(double));
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, theta += s_theta, r += s_r, r_in += s_r_in) {
        _theta = ((double (*))theta);
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        if (copy_r_in || r != r_in) {
            copy_to_double33(r_in, is_r_in0, is_r_in1, *_r);
        }
        eraRy(*_theta, *_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_rz(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *psi = *args++;
    npy_intp s_psi = *steps++;
    char *r_in = *args++;
    npy_intp s_r_in = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double (*_psi);
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_r_in0 = *steps++;
    npy_intp is_r_in1 = *steps++;
    int copy_r_in = (is_r_in1 != sizeof(double) ||
              is_r_in0 != 3 * sizeof(double));
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, psi += s_psi, r += s_r, r_in += s_r_in) {
        _psi = ((double (*))psi);
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        if (copy_r_in || r != r_in) {
            copy_to_double33(r_in, is_r_in0, is_r_in1, *_r);
        }
        eraRz(*_psi, *_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_cp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *c = *args++;
    npy_intp s_c = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double b_c[3];
    double (*_c)[3] = &b_c;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_c0 = *steps++;
    int copy_c = (is_c0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, c += s_c) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        if (!copy_c) {
            _c = ((double (*)[3])c);
        }
        eraCp(*_p, *_c);
        if (copy_c) {
            copy_from_double3(c, is_c0, *_c);
        }
    }
}

static void ufunc_loop_cpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *c = *args++;
    npy_intp s_c = *steps++;
    double (*_pv)[2][3];
    double (*_c)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, pv += s_pv, c += s_c) {
        _pv = ((double (*)[2][3])pv);
        _c = ((double (*)[2][3])c);
        eraCpv(*_pv, *_c);
    }
}

static void ufunc_loop_cr(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *c = *args++;
    npy_intp s_c = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double b_c[3][3];
    double (*_c)[3][3] = &b_c;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    npy_intp is_c0 = *steps++;
    npy_intp is_c1 = *steps++;
    int copy_c = (is_c1 != sizeof(double) ||
              is_c0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, c += s_c) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        if (!copy_c) {
            _c = ((double (*)[3][3])c);
        }
        eraCr(*_r, *_c);
        if (copy_c) {
            copy_from_double33(c, is_c0, is_c1, *_c);
        }
    }
}

static void ufunc_loop_p2pv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double (*_pv)[2][3];
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, pv += s_pv) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        _pv = ((double (*)[2][3])pv);
        eraP2pv(*_p, *_pv);
    }
}

static void ufunc_loop_pv2p(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    double (*_pv)[2][3];
    double b_p[3];
    double (*_p)[3] = &b_p;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, pv += s_pv, p += s_p) {
        _pv = ((double (*)[2][3])pv);
        if (!copy_p) {
            _p = ((double (*)[3])p);
        }
        eraPv2p(*_pv, *_p);
        if (copy_p) {
            copy_from_double3(p, is_p0, *_p);
        }
    }
}

static void ufunc_loop_ir(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r) {
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        eraIr(*_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_zp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p) {
        if (!copy_p) {
            _p = ((double (*)[3])p);
        }
        eraZp(*_p);
        if (copy_p) {
            copy_from_double3(p, is_p0, *_p);
        }
    }
}

static void ufunc_loop_zpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    double (*_pv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, pv += s_pv) {
        _pv = ((double (*)[2][3])pv);
        eraZpv(*_pv);
    }
}

static void ufunc_loop_zr(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r) {
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        eraZr(*_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_rxr(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *atb = *args++;
    npy_intp s_atb = *steps++;
    double b_a[3][3];
    double (*_a)[3][3] = &b_a;
    double b_b[3][3];
    double (*_b)[3][3] = &b_b;
    double b_atb[3][3];
    double (*_atb)[3][3] = &b_atb;
    npy_intp is_a0 = *steps++;
    npy_intp is_a1 = *steps++;
    int copy_a = (is_a1 != sizeof(double) ||
              is_a0 != 3 * sizeof(double));
    npy_intp is_b0 = *steps++;
    npy_intp is_b1 = *steps++;
    int copy_b = (is_b1 != sizeof(double) ||
              is_b0 != 3 * sizeof(double));
    npy_intp is_atb0 = *steps++;
    npy_intp is_atb1 = *steps++;
    int copy_atb = (is_atb1 != sizeof(double) ||
              is_atb0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, atb += s_atb) {
        if (copy_a) {
            copy_to_double33(a, is_a0, is_a1, *_a);
        }
        else {
            _a = ((double (*)[3][3])a);
        }
        if (copy_b) {
            copy_to_double33(b, is_b0, is_b1, *_b);
        }
        else {
            _b = ((double (*)[3][3])b);
        }
        if (!copy_atb) {
            _atb = ((double (*)[3][3])atb);
        }
        eraRxr(*_a, *_b, *_atb);
        if (copy_atb) {
            copy_from_double33(atb, is_atb0, is_atb1, *_atb);
        }
    }
}

static void ufunc_loop_tr(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *rt = *args++;
    npy_intp s_rt = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double b_rt[3][3];
    double (*_rt)[3][3] = &b_rt;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    npy_intp is_rt0 = *steps++;
    npy_intp is_rt1 = *steps++;
    int copy_rt = (is_rt1 != sizeof(double) ||
              is_rt0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, rt += s_rt) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        if (!copy_rt) {
            _rt = ((double (*)[3][3])rt);
        }
        eraTr(*_r, *_rt);
        if (copy_rt) {
            copy_from_double33(rt, is_rt0, is_rt1, *_rt);
        }
    }
}

static void ufunc_loop_rxp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *rp = *args++;
    npy_intp s_rp = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double b_rp[3];
    double (*_rp)[3] = &b_rp;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_rp0 = *steps++;
    int copy_rp = (is_rp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, p += s_p, rp += s_rp) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        if (!copy_rp) {
            _rp = ((double (*)[3])rp);
        }
        eraRxp(*_r, *_p, *_rp);
        if (copy_rp) {
            copy_from_double3(rp, is_rp0, *_rp);
        }
    }
}

static void ufunc_loop_rxpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *rpv = *args++;
    npy_intp s_rpv = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double (*_pv)[2][3];
    double (*_rpv)[2][3];
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, pv += s_pv, rpv += s_rpv) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        _pv = ((double (*)[2][3])pv);
        _rpv = ((double (*)[2][3])rpv);
        eraRxpv(*_r, *_pv, *_rpv);
    }
}

static void ufunc_loop_trxp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *trp = *args++;
    npy_intp s_trp = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double b_trp[3];
    double (*_trp)[3] = &b_trp;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_trp0 = *steps++;
    int copy_trp = (is_trp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, p += s_p, trp += s_trp) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        if (!copy_trp) {
            _trp = ((double (*)[3])trp);
        }
        eraTrxp(*_r, *_p, *_trp);
        if (copy_trp) {
            copy_from_double3(trp, is_trp0, *_trp);
        }
    }
}

static void ufunc_loop_trxpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *trpv = *args++;
    npy_intp s_trpv = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double (*_pv)[2][3];
    double (*_trpv)[2][3];
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, pv += s_pv, trpv += s_trpv) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        _pv = ((double (*)[2][3])pv);
        _trpv = ((double (*)[2][3])trpv);
        eraTrxpv(*_r, *_pv, *_trpv);
    }
}

static void ufunc_loop_rm2v(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *w = *args++;
    npy_intp s_w = *steps++;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    double b_w[3];
    double (*_w)[3] = &b_w;
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    npy_intp is_w0 = *steps++;
    int copy_w = (is_w0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, r += s_r, w += s_w) {
        if (copy_r) {
            copy_to_double33(r, is_r0, is_r1, *_r);
        }
        else {
            _r = ((double (*)[3][3])r);
        }
        if (!copy_w) {
            _w = ((double (*)[3])w);
        }
        eraRm2v(*_r, *_w);
        if (copy_w) {
            copy_from_double3(w, is_w0, *_w);
        }
    }
}

static void ufunc_loop_rv2m(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *w = *args++;
    npy_intp s_w = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double b_w[3];
    double (*_w)[3] = &b_w;
    double b_r[3][3];
    double (*_r)[3][3] = &b_r;
    npy_intp is_w0 = *steps++;
    int copy_w = (is_w0 != sizeof(double));
    npy_intp is_r0 = *steps++;
    npy_intp is_r1 = *steps++;
    int copy_r = (is_r1 != sizeof(double) ||
              is_r0 != 3 * sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, w += s_w, r += s_r) {
        if (copy_w) {
            copy_to_double3(w, is_w0, *_w);
        }
        else {
            _w = ((double (*)[3])w);
        }
        if (!copy_r) {
            _r = ((double (*)[3][3])r);
        }
        eraRv2m(*_w, *_r);
        if (copy_r) {
            copy_from_double33(r, is_r0, is_r1, *_r);
        }
    }
}

static void ufunc_loop_pap(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double b_b[3];
    double (*_b)[3] = &b_b;
    double _c_retval;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, c_retval += s_c_retval) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        _c_retval = eraPap(*_a, *_b);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_pas(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *al = *args++;
    npy_intp s_al = *steps++;
    char *ap = *args++;
    npy_intp s_ap = *steps++;
    char *bl = *args++;
    npy_intp s_bl = *steps++;
    char *bp = *args++;
    npy_intp s_bp = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_al);
    double (*_ap);
    double (*_bl);
    double (*_bp);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, al += s_al, ap += s_ap, bl += s_bl, bp += s_bp, c_retval += s_c_retval) {
        _al = ((double (*))al);
        _ap = ((double (*))ap);
        _bl = ((double (*))bl);
        _bp = ((double (*))bp);
        _c_retval = eraPas(*_al, *_ap, *_bl, *_bp);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_sepp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double b_b[3];
    double (*_b)[3] = &b_b;
    double _c_retval;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, c_retval += s_c_retval) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        _c_retval = eraSepp(*_a, *_b);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_seps(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *al = *args++;
    npy_intp s_al = *steps++;
    char *ap = *args++;
    npy_intp s_ap = *steps++;
    char *bl = *args++;
    npy_intp s_bl = *steps++;
    char *bp = *args++;
    npy_intp s_bp = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double (*_al);
    double (*_ap);
    double (*_bl);
    double (*_bp);
    double _c_retval;
    for (i_o = 0; i_o < n_o;
         i_o++, al += s_al, ap += s_ap, bl += s_bl, bp += s_bp, c_retval += s_c_retval) {
        _al = ((double (*))al);
        _ap = ((double (*))ap);
        _bl = ((double (*))bl);
        _bp = ((double (*))bp);
        _c_retval = eraSeps(*_al, *_ap, *_bl, *_bp);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_c2s(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double (*_theta);
    double (*_phi);
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, theta += s_theta, phi += s_phi) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        _theta = ((double (*))theta);
        _phi = ((double (*))phi);
        eraC2s(*_p, _theta, _phi);
    }
}

static void ufunc_loop_p2s(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double (*_theta);
    double (*_phi);
    double (*_r);
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, theta += s_theta, phi += s_phi, r += s_r) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        _theta = ((double (*))theta);
        _phi = ((double (*))phi);
        _r = ((double (*))r);
        eraP2s(*_p, _theta, _phi, _r);
    }
}

static void ufunc_loop_pv2s(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *td = *args++;
    npy_intp s_td = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *rd = *args++;
    npy_intp s_rd = *steps++;
    double (*_pv)[2][3];
    double (*_theta);
    double (*_phi);
    double (*_r);
    double (*_td);
    double (*_pd);
    double (*_rd);
    for (i_o = 0; i_o < n_o;
         i_o++, pv += s_pv, theta += s_theta, phi += s_phi, r += s_r, td += s_td, pd += s_pd, rd += s_rd) {
        _pv = ((double (*)[2][3])pv);
        _theta = ((double (*))theta);
        _phi = ((double (*))phi);
        _r = ((double (*))r);
        _td = ((double (*))td);
        _pd = ((double (*))pd);
        _rd = ((double (*))rd);
        eraPv2s(*_pv, _theta, _phi, _r, _td, _pd, _rd);
    }
}

static void ufunc_loop_s2c(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *c = *args++;
    npy_intp s_c = *steps++;
    double (*_theta);
    double (*_phi);
    double b_c[3];
    double (*_c)[3] = &b_c;
    npy_intp is_c0 = *steps++;
    int copy_c = (is_c0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, theta += s_theta, phi += s_phi, c += s_c) {
        _theta = ((double (*))theta);
        _phi = ((double (*))phi);
        if (!copy_c) {
            _c = ((double (*)[3])c);
        }
        eraS2c(*_theta, *_phi, *_c);
        if (copy_c) {
            copy_from_double3(c, is_c0, *_c);
        }
    }
}

static void ufunc_loop_s2p(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    double (*_theta);
    double (*_phi);
    double (*_r);
    double b_p[3];
    double (*_p)[3] = &b_p;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, theta += s_theta, phi += s_phi, r += s_r, p += s_p) {
        _theta = ((double (*))theta);
        _phi = ((double (*))phi);
        _r = ((double (*))r);
        if (!copy_p) {
            _p = ((double (*)[3])p);
        }
        eraS2p(*_theta, *_phi, *_r, *_p);
        if (copy_p) {
            copy_from_double3(p, is_p0, *_p);
        }
    }
}

static void ufunc_loop_s2pv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *theta = *args++;
    npy_intp s_theta = *steps++;
    char *phi = *args++;
    npy_intp s_phi = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *td = *args++;
    npy_intp s_td = *steps++;
    char *pd = *args++;
    npy_intp s_pd = *steps++;
    char *rd = *args++;
    npy_intp s_rd = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    double (*_theta);
    double (*_phi);
    double (*_r);
    double (*_td);
    double (*_pd);
    double (*_rd);
    double (*_pv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, theta += s_theta, phi += s_phi, r += s_r, td += s_td, pd += s_pd, rd += s_rd, pv += s_pv) {
        _theta = ((double (*))theta);
        _phi = ((double (*))phi);
        _r = ((double (*))r);
        _td = ((double (*))td);
        _pd = ((double (*))pd);
        _rd = ((double (*))rd);
        _pv = ((double (*)[2][3])pv);
        eraS2pv(*_theta, *_phi, *_r, *_td, *_pd, *_rd, *_pv);
    }
}

static void ufunc_loop_pdp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double b_b[3];
    double (*_b)[3] = &b_b;
    double _c_retval;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, c_retval += s_c_retval) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        _c_retval = eraPdp(*_a, *_b);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_pm(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *c_retval = *args++;
    npy_intp s_c_retval = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double _c_retval;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, c_retval += s_c_retval) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        _c_retval = eraPm(*_p);
        *((double *)c_retval) = _c_retval;
    }
}

static void ufunc_loop_pmp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *amb = *args++;
    npy_intp s_amb = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double b_b[3];
    double (*_b)[3] = &b_b;
    double b_amb[3];
    double (*_amb)[3] = &b_amb;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    npy_intp is_amb0 = *steps++;
    int copy_amb = (is_amb0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, amb += s_amb) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        if (!copy_amb) {
            _amb = ((double (*)[3])amb);
        }
        eraPmp(*_a, *_b, *_amb);
        if (copy_amb) {
            copy_from_double3(amb, is_amb0, *_amb);
        }
    }
}

static void ufunc_loop_pn(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *u = *args++;
    npy_intp s_u = *steps++;
    double b_p[3];
    double (*_p)[3] = &b_p;
    double (*_r);
    double b_u[3];
    double (*_u)[3] = &b_u;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_u0 = *steps++;
    int copy_u = (is_u0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, p += s_p, r += s_r, u += s_u) {
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        _r = ((double (*))r);
        if (!copy_u) {
            _u = ((double (*)[3])u);
        }
        eraPn(*_p, _r, *_u);
        if (copy_u) {
            copy_from_double3(u, is_u0, *_u);
        }
    }
}

static void ufunc_loop_ppp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *apb = *args++;
    npy_intp s_apb = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double b_b[3];
    double (*_b)[3] = &b_b;
    double b_apb[3];
    double (*_apb)[3] = &b_apb;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    npy_intp is_apb0 = *steps++;
    int copy_apb = (is_apb0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, apb += s_apb) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        if (!copy_apb) {
            _apb = ((double (*)[3])apb);
        }
        eraPpp(*_a, *_b, *_apb);
        if (copy_apb) {
            copy_from_double3(apb, is_apb0, *_apb);
        }
    }
}

static void ufunc_loop_ppsp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *apsb = *args++;
    npy_intp s_apsb = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double (*_s);
    double b_b[3];
    double (*_b)[3] = &b_b;
    double b_apsb[3];
    double (*_apsb)[3] = &b_apsb;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    npy_intp is_apsb0 = *steps++;
    int copy_apsb = (is_apsb0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, s += s_s, b += s_b, apsb += s_apsb) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        _s = ((double (*))s);
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        if (!copy_apsb) {
            _apsb = ((double (*)[3])apsb);
        }
        eraPpsp(*_a, *_s, *_b, *_apsb);
        if (copy_apsb) {
            copy_from_double3(apsb, is_apsb0, *_apsb);
        }
    }
}

static void ufunc_loop_pvdpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *adb = *args++;
    npy_intp s_adb = *steps++;
    double (*_a)[2][3];
    double (*_b)[2][3];
    double (*_adb)[2];
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, adb += s_adb) {
        _a = ((double (*)[2][3])a);
        _b = ((double (*)[2][3])b);
        _adb = ((double (*)[2])adb);
        eraPvdpv(*_a, *_b, *_adb);
    }
}

static void ufunc_loop_pvm(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *r = *args++;
    npy_intp s_r = *steps++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    double (*_pv)[2][3];
    double (*_r);
    double (*_s);
    for (i_o = 0; i_o < n_o;
         i_o++, pv += s_pv, r += s_r, s += s_s) {
        _pv = ((double (*)[2][3])pv);
        _r = ((double (*))r);
        _s = ((double (*))s);
        eraPvm(*_pv, _r, _s);
    }
}

static void ufunc_loop_pvmpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *amb = *args++;
    npy_intp s_amb = *steps++;
    double (*_a)[2][3];
    double (*_b)[2][3];
    double (*_amb)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, amb += s_amb) {
        _a = ((double (*)[2][3])a);
        _b = ((double (*)[2][3])b);
        _amb = ((double (*)[2][3])amb);
        eraPvmpv(*_a, *_b, *_amb);
    }
}

static void ufunc_loop_pvppv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *apb = *args++;
    npy_intp s_apb = *steps++;
    double (*_a)[2][3];
    double (*_b)[2][3];
    double (*_apb)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, apb += s_apb) {
        _a = ((double (*)[2][3])a);
        _b = ((double (*)[2][3])b);
        _apb = ((double (*)[2][3])apb);
        eraPvppv(*_a, *_b, *_apb);
    }
}

static void ufunc_loop_pvu(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dt = *args++;
    npy_intp s_dt = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *upv = *args++;
    npy_intp s_upv = *steps++;
    double (*_dt);
    double (*_pv)[2][3];
    double (*_upv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, dt += s_dt, pv += s_pv, upv += s_upv) {
        _dt = ((double (*))dt);
        _pv = ((double (*)[2][3])pv);
        _upv = ((double (*)[2][3])upv);
        eraPvu(*_dt, *_pv, *_upv);
    }
}

static void ufunc_loop_pvup(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *dt = *args++;
    npy_intp s_dt = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    double (*_dt);
    double (*_pv)[2][3];
    double b_p[3];
    double (*_p)[3] = &b_p;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, dt += s_dt, pv += s_pv, p += s_p) {
        _dt = ((double (*))dt);
        _pv = ((double (*)[2][3])pv);
        if (!copy_p) {
            _p = ((double (*)[3])p);
        }
        eraPvup(*_dt, *_pv, *_p);
        if (copy_p) {
            copy_from_double3(p, is_p0, *_p);
        }
    }
}

static void ufunc_loop_pvxpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *axb = *args++;
    npy_intp s_axb = *steps++;
    double (*_a)[2][3];
    double (*_b)[2][3];
    double (*_axb)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, axb += s_axb) {
        _a = ((double (*)[2][3])a);
        _b = ((double (*)[2][3])b);
        _axb = ((double (*)[2][3])axb);
        eraPvxpv(*_a, *_b, *_axb);
    }
}

static void ufunc_loop_pxp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *a = *args++;
    npy_intp s_a = *steps++;
    char *b = *args++;
    npy_intp s_b = *steps++;
    char *axb = *args++;
    npy_intp s_axb = *steps++;
    double b_a[3];
    double (*_a)[3] = &b_a;
    double b_b[3];
    double (*_b)[3] = &b_b;
    double b_axb[3];
    double (*_axb)[3] = &b_axb;
    npy_intp is_a0 = *steps++;
    int copy_a = (is_a0 != sizeof(double));
    npy_intp is_b0 = *steps++;
    int copy_b = (is_b0 != sizeof(double));
    npy_intp is_axb0 = *steps++;
    int copy_axb = (is_axb0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, a += s_a, b += s_b, axb += s_axb) {
        if (copy_a) {
            copy_to_double3(a, is_a0, *_a);
        }
        else {
            _a = ((double (*)[3])a);
        }
        if (copy_b) {
            copy_to_double3(b, is_b0, *_b);
        }
        else {
            _b = ((double (*)[3])b);
        }
        if (!copy_axb) {
            _axb = ((double (*)[3])axb);
        }
        eraPxp(*_a, *_b, *_axb);
        if (copy_axb) {
            copy_from_double3(axb, is_axb0, *_axb);
        }
    }
}

static void ufunc_loop_s2xpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *s1 = *args++;
    npy_intp s_s1 = *steps++;
    char *s2 = *args++;
    npy_intp s_s2 = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *spv = *args++;
    npy_intp s_spv = *steps++;
    double (*_s1);
    double (*_s2);
    double (*_pv)[2][3];
    double (*_spv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, s1 += s_s1, s2 += s_s2, pv += s_pv, spv += s_spv) {
        _s1 = ((double (*))s1);
        _s2 = ((double (*))s2);
        _pv = ((double (*)[2][3])pv);
        _spv = ((double (*)[2][3])spv);
        eraS2xpv(*_s1, *_s2, *_pv, *_spv);
    }
}

static void ufunc_loop_sxp(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *p = *args++;
    npy_intp s_p = *steps++;
    char *sp = *args++;
    npy_intp s_sp = *steps++;
    double (*_s);
    double b_p[3];
    double (*_p)[3] = &b_p;
    double b_sp[3];
    double (*_sp)[3] = &b_sp;
    npy_intp is_p0 = *steps++;
    int copy_p = (is_p0 != sizeof(double));
    npy_intp is_sp0 = *steps++;
    int copy_sp = (is_sp0 != sizeof(double));
    for (i_o = 0; i_o < n_o;
         i_o++, s += s_s, p += s_p, sp += s_sp) {
        _s = ((double (*))s);
        if (copy_p) {
            copy_to_double3(p, is_p0, *_p);
        }
        else {
            _p = ((double (*)[3])p);
        }
        if (!copy_sp) {
            _sp = ((double (*)[3])sp);
        }
        eraSxp(*_s, *_p, *_sp);
        if (copy_sp) {
            copy_from_double3(sp, is_sp0, *_sp);
        }
    }
}

static void ufunc_loop_sxpv(
    char **args, npy_intp const *dimensions, npy_intp const* steps, void* data)
{
    npy_intp i_o;
    npy_intp n_o = *dimensions++;
    char *s = *args++;
    npy_intp s_s = *steps++;
    char *pv = *args++;
    npy_intp s_pv = *steps++;
    char *spv = *args++;
    npy_intp s_spv = *steps++;
    double (*_s);
    double (*_pv)[2][3];
    double (*_spv)[2][3];
    for (i_o = 0; i_o < n_o;
         i_o++, s += s_s, pv += s_pv, spv += s_spv) {
        _s = ((double (*))s);
        _pv = ((double (*)[2][3])pv);
        _spv = ((double (*)[2][3])spv);
        eraSxpv(*_s, *_pv, *_spv);
    }
}

/*
 * UFUNC LOOP MATCHING HELPERS
 * All but ufunc_loop_matches are copies of code needed but not exported.
 */

/*
 * Adjusted version of ufunc_loop_matches from
 * numpy/core/src/umath/ufunc_type_resolution.c.
 * Here, we special-case the structured dtype check, only allowing
 * casting of the same dtype or string.  We also do not distinguish
 * between input and output arguments for casting.
 */
static int
ufunc_loop_matches(PyUFuncObject *self,
                   PyArrayObject **op,
                   NPY_CASTING casting,
                   int *types, PyArray_Descr **dtypes)
{
    npy_intp i, nin = self->nin, nop = nin + self->nout;
    /*
     * Check if all the inputs can be cast to the types used by this function.
     */
    for (i = 0; i < nin; ++i) {
        PyArray_Descr *op_descr = PyArray_DESCR(op[i]);
        /*
         * Check for NPY_VOID with an associated struct dtype.
         */
        if (types[i] == NPY_VOID && dtypes != NULL) {
            int op_descr_type_num = op_descr->type_num;
            npy_intp dtype_elsize = PyDataType_ELSIZE(dtypes[i]);
            /*
             * MHvK: we do our own check on casting, since by default
             * all items can cast to structured dtypes (see gh-11114),
             * which is not OK. So, we only allow VOID->same VOID,
             * and STRING -> VOID-of-STRING (which works well; we
             * recognize VOID-of-STRING by the dtype element size;
             * it would be rather costly to go look at dtype->fields).
             */
            if (op_descr_type_num == NPY_VOID) {
                /* allow only the same structured to structured */
                if (!PyArray_EquivTypes(op_descr, dtypes[i])) {
                    return 0;
                }
            }
            else if (dtype_elsize == 1 || dtype_elsize == 12) {
                /* string structured array; string argument is OK */
                if (!((op_descr_type_num == NPY_STRING &&
                       PyDataType_ELSIZE(op_descr) <= dtype_elsize) ||
                      (op_descr_type_num == NPY_UNICODE &&
                       PyDataType_ELSIZE(op_descr) >> 2 <= dtype_elsize))) {
                    return 0;
                }
            }
            else {
                return 0;
            }
        }
        else { /* non-void function argument */
            PyArray_Descr *tmp = PyArray_DescrFromType(types[i]);
            if (tmp == NULL) {
                return -1;
            }
            if (!PyArray_CanCastTypeTo(op_descr, tmp, casting)) {
                Py_DECREF(tmp);
                return 0;
            }
            Py_DECREF(tmp);
        }
    }
    /*
     * All inputs were ok; now check casting back to the outputs.
     * For void, only allow casting to the same void.
     */
    for (i = nin; i < nop; ++i) {
        if (op[i] != NULL) {
            if (types[i] == NPY_VOID && dtypes != NULL) {
                PyArray_Descr *op_descr = PyArray_DESCR(op[i]);
                /*
                 * MHvK: for VOID, we only allow VOID->same VOID.
                 */
                if (op_descr->type_num != NPY_VOID
                    || !PyArray_EquivTypes(op_descr, dtypes[i])) {
                    return 0;
                }
            }
            else {
                PyArray_Descr *tmp = PyArray_DescrFromType(types[i]);
                if (tmp == NULL) {
                    return -1;
                }
                if (!PyArray_CanCastTypeTo(tmp, PyArray_DESCR(op[i]),
                                       casting)) {
                    Py_DECREF(tmp);
                    return 0;
                }
                Py_DECREF(tmp);
            }
        }
    }
    return 1;
}
/*
 * Copy from numpy/core/src/umath/ufunc_type_resolution.c,
 * since this translation function is not exported.
 */
static const char *
npy_casting_to_string(NPY_CASTING casting)
{
    switch (casting) {
        case NPY_NO_CASTING:
            return "'no'";
        case NPY_EQUIV_CASTING:
            return "'equiv'";
        case NPY_SAFE_CASTING:
            return "'safe'";
        case NPY_SAME_KIND_CASTING:
            return "'same_kind'";
        case NPY_UNSAFE_CASTING:
            return "'unsafe'";
        default:
            return "<unknown>";
    }
}

/*
 * Copy from numpy/core/src/umath/ufunc_type_resolution.c,
 * since not exported.
 */
static PyArray_Descr *
ensure_dtype_nbo(PyArray_Descr *type)
{
    if (PyArray_ISNBO(type->byteorder)) {
        Py_INCREF(type);
        return type;
    }
    else {
        return PyArray_DescrNewByteorder(type, NPY_NATIVE);
    }
}

/*
 * Copy from numpy/core/src/umath/ufunc_type_resolution.c,
 * since not exported.
 */
static int
set_ufunc_loop_data_types(PyUFuncObject *self, PyArrayObject **op,
                    PyArray_Descr **out_dtypes,
                    int *type_nums, PyArray_Descr **dtypes)
{
    int i, nin = self->nin, nop = nin + self->nout;

    /*
     * Fill the dtypes array.
     * For outputs,
     * also search the inputs for a matching type_num to copy
     * instead of creating a new one, similarly to preserve metadata.
     **/
    for (i = 0; i < nop; ++i) {
        if (dtypes != NULL) {
            out_dtypes[i] = dtypes[i];
            Py_XINCREF(out_dtypes[i]);
        /*
         * Copy the dtype from 'op' if the type_num matches,
         * to preserve metadata.
         */
        }
        else if (op[i] != NULL &&
                 PyArray_DESCR(op[i])->type_num == type_nums[i]) {
            out_dtypes[i] = ensure_dtype_nbo(PyArray_DESCR(op[i]));
        }
        /*
         * For outputs, copy the dtype from op[0] if the type_num
         * matches, similarly to preserve metdata.
         */
        else if (i >= nin && op[0] != NULL &&
                            PyArray_DESCR(op[0])->type_num == type_nums[i]) {
            out_dtypes[i] = ensure_dtype_nbo(PyArray_DESCR(op[0]));
        }
        /* Otherwise create a plain descr from the type number */
        else {
            out_dtypes[i] = PyArray_DescrFromType(type_nums[i]);
        }

        if (out_dtypes[i] == NULL) {
            goto fail;
        }
    }

    return 0;

fail:
    while (--i >= 0) {
        Py_DECREF(out_dtypes[i]);
        out_dtypes[i] = NULL;
    }
    return -1;
}

/*
 * UFUNC TYPE RESOLVER
 *
 * We provide our own type resolver, since the default one,
 * PyUFunc_DefaultTypeResolver from
 * numpy/core/src/umath/ufunc_type_resolution.c, has problems:
 * 1. It only looks for userloops if any of the operands have a user
 *    type, which does not work if the inputs are normal and no explicit
 *    output is given (see https://github.com/numpy/numpy/issues/11109).
 * 2. It only allows "safe" casting of inputs, which annoyingly prevents
 *    passing in a python int for int32 input.
 * The resolver below solves both, and speeds up the process by
 * explicitly assuming that a ufunc has only one function built in,
 * either a regular one or a userloop (for structured dtype).
 *
 * Combines code from linear_search_type_resolver and
 * linear_search_userloop_type_resolver from
 * numpy/core/src/umath/ufunc_type_resolution.c
 */
static int ErfaUFuncTypeResolver(PyUFuncObject *ufunc,
                                 NPY_CASTING casting,
                                 PyArrayObject **operands,
                                 PyObject *type_tup,
                                 PyArray_Descr **out_dtypes)
{
    int *types;
    PyArray_Descr **dtypes;

    /* This array needs to be at least as long as nint+nout. In practice, 32 suffices */
    int types_array[32];

    if (ufunc->userloops) {
        Py_ssize_t unused_pos = 0;
        PyObject *userloop;
        PyUFunc_Loop1d *funcdata;

        if (ufunc->ntypes > 0 || PyDict_Size(ufunc->userloops) != 1) {
            goto fail;
        }
        /* No iteration needed; only one entry in dict */
        PyDict_Next(ufunc->userloops, &unused_pos, NULL, &userloop);
        funcdata = (PyUFunc_Loop1d *)PyCapsule_GetPointer(userloop, NULL);
        /* There should be only one function */
        if (funcdata->next != NULL) {
            goto fail;
        }
        types = funcdata->arg_types;
        dtypes = funcdata->arg_dtypes;
    }
    else {
        npy_intp j;

        if (ufunc->ntypes != 1) {
            goto fail;
        }
        /* Copy the types into an int array for matching */
        for (j = 0; j < ufunc->nargs; ++j) {
            types_array[j] = ufunc->types[j];
        }
        types = types_array;
        dtypes = NULL;
    }
    switch (ufunc_loop_matches(ufunc, operands, casting, types, dtypes)) {
    case 1:  /* Matching types */
        return set_ufunc_loop_data_types(ufunc, operands, out_dtypes,
                                         types, dtypes);
    case -1:   /* Error */
        return -1;
    }
    /* No match */
    PyErr_Format(PyExc_TypeError,
                 "ufunc '%s' not supported for the input types, and the "
                 "inputs could not be safely coerced to any supported "
                 "types according to the casting rule '%s'",
                 ufunc->name, npy_casting_to_string(casting));
    return -1;

fail:
    /* More than one loop or function */
    PyErr_Format(PyExc_RuntimeError,
                 "Unexpected internal error: ufunc '%s' wraps an ERFA "
                 "function and should have only a single loop with a "
                 "single function, yet has more.",
                 ufunc->name);
    return -1;
}

/*
 * LEAP SECOND ACCESS
 *
 * Getting/Setting ERFAs built-in TAI-UTC table.
 *
 * TODO: the whole procedure is not sub-interpreter safe.
 * In this module, one might get dt_eraLEAPSECOND out of the module dict,
 * and store the leap_second array in a per-module struct (see PEP 3121).
 * But one then would also have to adapt erfa/dat.c to not use a
 * static leap second table.  Possibly best might be to copy dat.c here
 * and put the table into the per-module struct as well.
 */
static PyArray_Descr *dt_eraLEAPSECOND = NULL;  /* Set in PyInit_ufunc */

static PyObject *
get_leap_seconds(PyObject *NPY_UNUSED(module), PyObject *NPY_UNUSED(args)) {
    eraLEAPSECOND *leapseconds;
    npy_intp count;
    PyArrayObject *array;
    /* Get the leap seconds from ERFA */
    count = (npy_intp)eraGetLeapSeconds(&leapseconds);
    if (count < 0) {
        PyErr_SetString(PyExc_RuntimeError,
                        "Unpexected failure to get ERFA leap seconds.");
        return NULL;
    }
    /* Allocate an array to hold them */
    Py_INCREF(dt_eraLEAPSECOND);
    array = (PyArrayObject *)PyArray_NewFromDescr(
        &PyArray_Type, dt_eraLEAPSECOND, 1, &count, NULL, NULL, 0, NULL);
    if (array == NULL) {
        return NULL;
    }
    /* Copy the leap seconds over into the array */
    memcpy(PyArray_DATA(array), leapseconds, count*sizeof(eraLEAPSECOND));
    return (PyObject *)array;
}

static PyObject *
set_leap_seconds(PyObject *NPY_UNUSED(module), PyObject *args) {
    PyObject *leap_seconds = NULL;
    PyArrayObject *array;
    static PyArrayObject *leap_second_array = NULL;

    if (!PyArg_ParseTuple(args, "|O:set_leap_seconds", &leap_seconds)) {
        return NULL;
    }
    if (leap_seconds != NULL && leap_seconds != Py_None) {
        /*
         * Convert the input to an array with the proper dtype;
         * Ensure a copy is made so one cannot change the data by changing
         * the input array.
         */
        Py_INCREF(dt_eraLEAPSECOND);
        array = (PyArrayObject *)PyArray_FromAny(leap_seconds, dt_eraLEAPSECOND,
                    1, 1, (NPY_ARRAY_CARRAY | NPY_ARRAY_ENSURECOPY), NULL);
        if (array == NULL) {
            return NULL;
        }
        if (PyArray_SIZE(array) == 0) {
            PyErr_SetString(PyExc_ValueError,
                            "Leap second array must have at least one entry.");
        }
        /*
         * Use the array for the new leap seconds.
         */
        eraSetLeapSeconds(PyArray_DATA(array), PyArray_SIZE(array));
    }
    else {
        /*
         * If no input is given, reset leap second table.
         */
        array = NULL;
        eraSetLeapSeconds(NULL, 0);
    }
    /*
     * If we allocated a leap second array before, deallocate it,
     * and set it to remember any allocation from PyArray_FromAny.
     */
    if (leap_second_array != NULL) {
        Py_DECREF(leap_second_array);
    }
    leap_second_array = array;
    Py_RETURN_NONE;
}

/*
 * UFUNC MODULE DEFINITIONS AND INITIALIZATION
 */
static PyMethodDef ErfaUFuncMethods[] = {
    {"get_leap_seconds", (PyCFunction)get_leap_seconds,
         METH_NOARGS, GET_LEAP_SECONDS_DOCSTRING},
    {"set_leap_seconds", (PyCFunction)set_leap_seconds,
         METH_VARARGS, SET_LEAP_SECONDS_DOCSTRING},
    {NULL, NULL, 0, NULL}
};

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "ufunc",
    MODULE_DOCSTRING,
    -1,
    ErfaUFuncMethods,
    NULL,
    NULL,
    NULL,
    NULL
};

PyMODINIT_FUNC PyInit_ufunc(void)
{
    /* module and its dict */
    PyObject *m, *d;
    /* version information */
    PyObject *erfa_version, *sofa_version;
    /* structured dtypes and their definition */
    PyObject *dtype_def;
    PyArray_Descr *dt_double = NULL, *dt_int = NULL;
    PyArray_Descr *dt_pv = NULL, *dt_pvdpv = NULL;
    PyArray_Descr *dt_ymdf = NULL, *dt_hmsf = NULL, *dt_dmsf = NULL;
    PyArray_Descr *dt_sign = NULL, *dt_type = NULL;
    PyArray_Descr *dt_eraASTROM = NULL, *dt_eraLDBODY = NULL;

    /* This array needs to be at least as long as nint+nout. In practice, 32 suffices */
    PyArray_Descr *dtypes[32];

    /* ufuncs and their definitions */
    int status;
    PyUFuncObject *ufunc;
    static void *data[1] = {NULL};
    static char types_cal2jd[6] = {NPY_INT, NPY_INT, NPY_INT, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_cal2jd[1] = { &ufunc_loop_cal2jd };
    static char types_epb[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_epb[1] = { &ufunc_loop_epb };
    static char types_epb2jd[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_epb2jd[1] = { &ufunc_loop_epb2jd };
    static char types_epj[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_epj[1] = { &ufunc_loop_epj };
    static char types_epj2jd[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_epj2jd[1] = { &ufunc_loop_epj2jd };
    static char types_jd2cal[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_INT, NPY_INT, NPY_INT, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_jd2cal[1] = { &ufunc_loop_jd2cal };
    static char types_ab[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ab[1] = { &ufunc_loop_ab };
    static char types_atcc13[10] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_atcc13[1] = { &ufunc_loop_atcc13 };
    static char types_atci13[11] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_atci13[1] = { &ufunc_loop_atci13 };
    static char types_atco13[25] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_atco13[1] = { &ufunc_loop_atco13 };
    static char types_atic13[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_atic13[1] = { &ufunc_loop_atic13 };
    static char types_atio13[20] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_atio13[1] = { &ufunc_loop_atio13 };
    static char types_ld[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ld[1] = { &ufunc_loop_ld };
    static char types_ldsun[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ldsun[1] = { &ufunc_loop_ldsun };
    static char types_pmpx[9] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pmpx[1] = { &ufunc_loop_pmpx };
    static char types_pmsafe[17] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_pmsafe[1] = { &ufunc_loop_pmsafe };
    static char types_refco[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_refco[1] = { &ufunc_loop_refco };
    static char types_fad03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fad03[1] = { &ufunc_loop_fad03 };
    static char types_fae03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fae03[1] = { &ufunc_loop_fae03 };
    static char types_faf03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_faf03[1] = { &ufunc_loop_faf03 };
    static char types_faju03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_faju03[1] = { &ufunc_loop_faju03 };
    static char types_fal03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fal03[1] = { &ufunc_loop_fal03 };
    static char types_falp03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_falp03[1] = { &ufunc_loop_falp03 };
    static char types_fama03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fama03[1] = { &ufunc_loop_fama03 };
    static char types_fame03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fame03[1] = { &ufunc_loop_fame03 };
    static char types_fane03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fane03[1] = { &ufunc_loop_fane03 };
    static char types_faom03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_faom03[1] = { &ufunc_loop_faom03 };
    static char types_fapa03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fapa03[1] = { &ufunc_loop_fapa03 };
    static char types_fasa03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fasa03[1] = { &ufunc_loop_fasa03 };
    static char types_faur03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_faur03[1] = { &ufunc_loop_faur03 };
    static char types_fave03[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fave03[1] = { &ufunc_loop_fave03 };
    static char types_bi00[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_bi00[1] = { &ufunc_loop_bi00 };
    static char types_bp00[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_bp00[1] = { &ufunc_loop_bp00 };
    static char types_bp06[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_bp06[1] = { &ufunc_loop_bp06 };
    static char types_bpn2xy[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_bpn2xy[1] = { &ufunc_loop_bpn2xy };
    static char types_c2i00a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2i00a[1] = { &ufunc_loop_c2i00a };
    static char types_c2i00b[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2i00b[1] = { &ufunc_loop_c2i00b };
    static char types_c2i06a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2i06a[1] = { &ufunc_loop_c2i06a };
    static char types_c2ibpn[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2ibpn[1] = { &ufunc_loop_c2ibpn };
    static char types_c2ixy[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2ixy[1] = { &ufunc_loop_c2ixy };
    static char types_c2ixys[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2ixys[1] = { &ufunc_loop_c2ixys };
    static char types_c2t00a[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2t00a[1] = { &ufunc_loop_c2t00a };
    static char types_c2t00b[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2t00b[1] = { &ufunc_loop_c2t00b };
    static char types_c2t06a[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2t06a[1] = { &ufunc_loop_c2t06a };
    static char types_c2tcio[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2tcio[1] = { &ufunc_loop_c2tcio };
    static char types_c2teqx[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2teqx[1] = { &ufunc_loop_c2teqx };
    static char types_c2tpe[9] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2tpe[1] = { &ufunc_loop_c2tpe };
    static char types_c2txy[9] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2txy[1] = { &ufunc_loop_c2txy };
    static char types_eo06a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_eo06a[1] = { &ufunc_loop_eo06a };
    static char types_eors[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_eors[1] = { &ufunc_loop_eors };
    static char types_fw2m[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fw2m[1] = { &ufunc_loop_fw2m };
    static char types_fw2xy[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fw2xy[1] = { &ufunc_loop_fw2xy };
    static char types_ltp[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ltp[1] = { &ufunc_loop_ltp };
    static char types_ltpb[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ltpb[1] = { &ufunc_loop_ltpb };
    static char types_ltpecl[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ltpecl[1] = { &ufunc_loop_ltpecl };
    static char types_ltpequ[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ltpequ[1] = { &ufunc_loop_ltpequ };
    static char types_num00a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_num00a[1] = { &ufunc_loop_num00a };
    static char types_num00b[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_num00b[1] = { &ufunc_loop_num00b };
    static char types_num06a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_num06a[1] = { &ufunc_loop_num06a };
    static char types_numat[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_numat[1] = { &ufunc_loop_numat };
    static char types_nut00a[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_nut00a[1] = { &ufunc_loop_nut00a };
    static char types_nut00b[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_nut00b[1] = { &ufunc_loop_nut00b };
    static char types_nut06a[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_nut06a[1] = { &ufunc_loop_nut06a };
    static char types_nut80[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_nut80[1] = { &ufunc_loop_nut80 };
    static char types_nutm80[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_nutm80[1] = { &ufunc_loop_nutm80 };
    static char types_obl06[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_obl06[1] = { &ufunc_loop_obl06 };
    static char types_obl80[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_obl80[1] = { &ufunc_loop_obl80 };
    static char types_p06e[18] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_p06e[1] = { &ufunc_loop_p06e };
    static char types_pb06[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pb06[1] = { &ufunc_loop_pb06 };
    static char types_pfw06[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pfw06[1] = { &ufunc_loop_pfw06 };
    static char types_pmat00[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pmat00[1] = { &ufunc_loop_pmat00 };
    static char types_pmat06[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pmat06[1] = { &ufunc_loop_pmat06 };
    static char types_pmat76[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pmat76[1] = { &ufunc_loop_pmat76 };
    static char types_pn00[10] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pn00[1] = { &ufunc_loop_pn00 };
    static char types_pn00a[10] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pn00a[1] = { &ufunc_loop_pn00a };
    static char types_pn00b[10] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pn00b[1] = { &ufunc_loop_pn00b };
    static char types_pn06[10] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pn06[1] = { &ufunc_loop_pn06 };
    static char types_pn06a[10] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pn06a[1] = { &ufunc_loop_pn06a };
    static char types_pnm00a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pnm00a[1] = { &ufunc_loop_pnm00a };
    static char types_pnm00b[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pnm00b[1] = { &ufunc_loop_pnm00b };
    static char types_pnm06a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pnm06a[1] = { &ufunc_loop_pnm06a };
    static char types_pnm80[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pnm80[1] = { &ufunc_loop_pnm80 };
    static char types_pom00[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pom00[1] = { &ufunc_loop_pom00 };
    static char types_pr00[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pr00[1] = { &ufunc_loop_pr00 };
    static char types_prec76[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_prec76[1] = { &ufunc_loop_prec76 };
    static char types_s00[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s00[1] = { &ufunc_loop_s00 };
    static char types_s00a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s00a[1] = { &ufunc_loop_s00a };
    static char types_s00b[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s00b[1] = { &ufunc_loop_s00b };
    static char types_s06[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s06[1] = { &ufunc_loop_s06 };
    static char types_s06a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s06a[1] = { &ufunc_loop_s06a };
    static char types_sp00[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_sp00[1] = { &ufunc_loop_sp00 };
    static char types_xy06[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_xy06[1] = { &ufunc_loop_xy06 };
    static char types_xys00a[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_xys00a[1] = { &ufunc_loop_xys00a };
    static char types_xys00b[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_xys00b[1] = { &ufunc_loop_xys00b };
    static char types_xys06a[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_xys06a[1] = { &ufunc_loop_xys06a };
    static char types_ee00[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ee00[1] = { &ufunc_loop_ee00 };
    static char types_ee00a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ee00a[1] = { &ufunc_loop_ee00a };
    static char types_ee00b[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ee00b[1] = { &ufunc_loop_ee00b };
    static char types_ee06a[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ee06a[1] = { &ufunc_loop_ee06a };
    static char types_eect00[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_eect00[1] = { &ufunc_loop_eect00 };
    static char types_eqeq94[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_eqeq94[1] = { &ufunc_loop_eqeq94 };
    static char types_era00[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_era00[1] = { &ufunc_loop_era00 };
    static char types_gmst00[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gmst00[1] = { &ufunc_loop_gmst00 };
    static char types_gmst06[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gmst06[1] = { &ufunc_loop_gmst06 };
    static char types_gmst82[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gmst82[1] = { &ufunc_loop_gmst82 };
    static char types_gst00a[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gst00a[1] = { &ufunc_loop_gst00a };
    static char types_gst00b[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gst00b[1] = { &ufunc_loop_gst00b };
    static char types_gst06[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gst06[1] = { &ufunc_loop_gst06 };
    static char types_gst06a[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gst06a[1] = { &ufunc_loop_gst06a };
    static char types_gst94[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_gst94[1] = { &ufunc_loop_gst94 };
    static char types_fk425[12] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk425[1] = { &ufunc_loop_fk425 };
    static char types_fk45z[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk45z[1] = { &ufunc_loop_fk45z };
    static char types_fk524[12] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk524[1] = { &ufunc_loop_fk524 };
    static char types_fk52h[12] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk52h[1] = { &ufunc_loop_fk52h };
    static char types_fk54z[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk54z[1] = { &ufunc_loop_fk54z };
    static char types_fk5hip[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk5hip[1] = { &ufunc_loop_fk5hip };
    static char types_fk5hz[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_fk5hz[1] = { &ufunc_loop_fk5hz };
    static char types_h2fk5[12] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_h2fk5[1] = { &ufunc_loop_h2fk5 };
    static char types_hfk5z[8] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_hfk5z[1] = { &ufunc_loop_hfk5z };
    static char types_starpm[17] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_starpm[1] = { &ufunc_loop_starpm };
    static char types_eceq06[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_eceq06[1] = { &ufunc_loop_eceq06 };
    static char types_ecm06[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ecm06[1] = { &ufunc_loop_ecm06 };
    static char types_eqec06[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_eqec06[1] = { &ufunc_loop_eqec06 };
    static char types_lteceq[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_lteceq[1] = { &ufunc_loop_lteceq };
    static char types_ltecm[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ltecm[1] = { &ufunc_loop_ltecm };
    static char types_lteqec[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_lteqec[1] = { &ufunc_loop_lteqec };
    static char types_g2icrs[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_g2icrs[1] = { &ufunc_loop_g2icrs };
    static char types_icrs2g[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_icrs2g[1] = { &ufunc_loop_icrs2g };
    static char types_eform[4] = {NPY_INT, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_eform[1] = { &ufunc_loop_eform };
    static char types_gc2gd[6] = {NPY_INT, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_gc2gd[1] = { &ufunc_loop_gc2gd };
    static char types_gc2gde[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_gc2gde[1] = { &ufunc_loop_gc2gde };
    static char types_gd2gc[6] = {NPY_INT, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_gd2gc[1] = { &ufunc_loop_gd2gc };
    static char types_gd2gce[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_gd2gce[1] = { &ufunc_loop_gd2gce };
    static char types_dat[6] = {NPY_INT, NPY_INT, NPY_INT, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_dat[1] = { &ufunc_loop_dat };
    static char types_dtdb[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_dtdb[1] = { &ufunc_loop_dtdb };
    static char types_taitt[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_taitt[1] = { &ufunc_loop_taitt };
    static char types_taiut1[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_taiut1[1] = { &ufunc_loop_taiut1 };
    static char types_taiutc[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_taiutc[1] = { &ufunc_loop_taiutc };
    static char types_tcbtdb[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tcbtdb[1] = { &ufunc_loop_tcbtdb };
    static char types_tcgtt[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tcgtt[1] = { &ufunc_loop_tcgtt };
    static char types_tdbtcb[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tdbtcb[1] = { &ufunc_loop_tdbtcb };
    static char types_tdbtt[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tdbtt[1] = { &ufunc_loop_tdbtt };
    static char types_tttai[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tttai[1] = { &ufunc_loop_tttai };
    static char types_tttcg[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tttcg[1] = { &ufunc_loop_tttcg };
    static char types_tttdb[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tttdb[1] = { &ufunc_loop_tttdb };
    static char types_ttut1[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_ttut1[1] = { &ufunc_loop_ttut1 };
    static char types_ut1tai[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_ut1tai[1] = { &ufunc_loop_ut1tai };
    static char types_ut1tt[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_ut1tt[1] = { &ufunc_loop_ut1tt };
    static char types_ut1utc[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_ut1utc[1] = { &ufunc_loop_ut1utc };
    static char types_utctai[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_utctai[1] = { &ufunc_loop_utctai };
    static char types_utcut1[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_utcut1[1] = { &ufunc_loop_utcut1 };
    static char types_ae2hd[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ae2hd[1] = { &ufunc_loop_ae2hd };
    static char types_hd2ae[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_hd2ae[1] = { &ufunc_loop_hd2ae };
    static char types_hd2pa[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_hd2pa[1] = { &ufunc_loop_hd2pa };
    static char types_tpors[9] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tpors[1] = { &ufunc_loop_tpors };
    static char types_tporv[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tporv[1] = { &ufunc_loop_tporv };
    static char types_tpsts[6] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_tpsts[1] = { &ufunc_loop_tpsts };
    static char types_tpstv[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_tpstv[1] = { &ufunc_loop_tpstv };
    static char types_tpxes[7] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tpxes[1] = { &ufunc_loop_tpxes };
    static char types_tpxev[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_INT};
    static PyUFuncGenericFunction funcs_tpxev[1] = { &ufunc_loop_tpxev };
    static char types_anp[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_anp[1] = { &ufunc_loop_anp };
    static char types_anpm[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_anpm[1] = { &ufunc_loop_anpm };
    static char types_rx[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_rx[1] = { &ufunc_loop_rx };
    static char types_ry[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ry[1] = { &ufunc_loop_ry };
    static char types_rz[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_rz[1] = { &ufunc_loop_rz };
    static char types_cp[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_cp[1] = { &ufunc_loop_cp };
    static char types_cr[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_cr[1] = { &ufunc_loop_cr };
    static char types_ir[1] = {NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ir[1] = { &ufunc_loop_ir };
    static char types_zp[1] = {NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_zp[1] = { &ufunc_loop_zp };
    static char types_zr[1] = {NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_zr[1] = { &ufunc_loop_zr };
    static char types_rxr[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_rxr[1] = { &ufunc_loop_rxr };
    static char types_tr[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_tr[1] = { &ufunc_loop_tr };
    static char types_rxp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_rxp[1] = { &ufunc_loop_rxp };
    static char types_trxp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_trxp[1] = { &ufunc_loop_trxp };
    static char types_rm2v[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_rm2v[1] = { &ufunc_loop_rm2v };
    static char types_rv2m[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_rv2m[1] = { &ufunc_loop_rv2m };
    static char types_pap[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pap[1] = { &ufunc_loop_pap };
    static char types_pas[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pas[1] = { &ufunc_loop_pas };
    static char types_sepp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_sepp[1] = { &ufunc_loop_sepp };
    static char types_seps[5] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_seps[1] = { &ufunc_loop_seps };
    static char types_c2s[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_c2s[1] = { &ufunc_loop_c2s };
    static char types_p2s[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_p2s[1] = { &ufunc_loop_p2s };
    static char types_s2c[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s2c[1] = { &ufunc_loop_s2c };
    static char types_s2p[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_s2p[1] = { &ufunc_loop_s2p };
    static char types_pdp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pdp[1] = { &ufunc_loop_pdp };
    static char types_pm[2] = {NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pm[1] = { &ufunc_loop_pm };
    static char types_pmp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pmp[1] = { &ufunc_loop_pmp };
    static char types_pn[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pn[1] = { &ufunc_loop_pn };
    static char types_ppp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ppp[1] = { &ufunc_loop_ppp };
    static char types_ppsp[4] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_ppsp[1] = { &ufunc_loop_ppsp };
    static char types_pxp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_pxp[1] = { &ufunc_loop_pxp };
    static char types_sxp[3] = {NPY_DOUBLE, NPY_DOUBLE, NPY_DOUBLE};
    static PyUFuncGenericFunction funcs_sxp[1] = { &ufunc_loop_sxp };

    m = PyModule_Create(&moduledef);
    if (m == NULL) {
        return NULL;
    }
    d = PyModule_GetDict(m); /* borrowed ref. */
    if (d == NULL) {
        goto fail;
    }
    /*
     * Make the version information available in the module.
     * Note that this gets run every time _erfa is imported,
     * hence if the library is provided by the system rather
     * than bundled with pyerfa, one correctly gets the version
     * information from the system library.
     */
    erfa_version = PyUnicode_FromString(eraVersion());
    sofa_version = PyUnicode_FromString(eraSofaVersion());
    if (erfa_version == NULL || sofa_version == NULL) {
        goto fail;
    }
    PyDict_SetItemString(d, "erfa_version", erfa_version);
    PyDict_SetItemString(d, "sofa_version", sofa_version);
    /*
     * Get ready for arrays and ufuncs
     */
    import_array();
    import_umath();
    /*
     * Define the basic and structured types used in erfa so that
     * we can use them for definitions of userloops below.
     */
    dt_double = PyArray_DescrFromType(NPY_DOUBLE);
    dt_int = PyArray_DescrFromType(NPY_INT);
    /* double[2][3] = pv */
    dtype_def = Py_BuildValue("[(s, s), (s, s)]",
                              "p", "(3,)f8", "v", "(3,)f8");
    PyArray_DescrAlignConverter(dtype_def, &dt_pv);
    Py_DECREF(dtype_def);
    /* double[2] = pvdpv */
    dtype_def = Py_BuildValue("[(s, s), (s, s)]",
                              "pdp", "f8", "pdv", "f8");
    PyArray_DescrAlignConverter(dtype_def, &dt_pvdpv);
    Py_DECREF(dtype_def);
    /* int[4] = ymdf, hmsf, dmsf */
    dtype_def = Py_BuildValue("[(s, s), (s, s), (s, s), (s, s)]",
                              "y", "i4", "m", "i4", "d", "i4", "f", "i4");
    PyArray_DescrAlignConverter(dtype_def, &dt_ymdf);
    Py_DECREF(dtype_def);
    dtype_def = Py_BuildValue("[(s, s), (s, s), (s, s), (s, s)]",
                              "h", "i4", "m", "i4", "s", "i4", "f", "i4");
    PyArray_DescrAlignConverter(dtype_def, &dt_hmsf);
    Py_DECREF(dtype_def);
    dtype_def = Py_BuildValue("[(s, s), (s, s), (s, s), (s, s)]",
                              "h", "i4", "m", "i4", "s", "i4", "f", "i4");
    PyArray_DescrAlignConverter(dtype_def, &dt_dmsf);
    Py_DECREF(dtype_def);
    /* char1 (have to use structured, otherwise it cannot be a user type) */
    dtype_def = Py_BuildValue("[(s, s)]", "sign", "S1");
    PyArray_DescrAlignConverter(dtype_def, &dt_sign);
    Py_DECREF(dtype_def);
    /* char12 */
    dtype_def = Py_BuildValue("[(s, s)]", "type", "S12");
    PyArray_DescrAlignConverter(dtype_def, &dt_type);
    Py_DECREF(dtype_def);
    /* eraASTROM */
    dtype_def = Py_BuildValue(
        "[(s, s), (s, s), (s, s), (s, s),"
        " (s, s), (s, s), (s, s), (s, s),"
        " (s, s), (s, s), (s, s), (s, s),"
        " (s, s), (s, s), (s, s), (s, s), (s, s)]",
        "pmt", "f8",       /* PM time interval (SSB, Julian years) */
        "eb", "(3,)f8",    /* SSB to observer (vector, au) */
        "eh", "(3,)f8",    /* Sun to observer (unit vector) */
        "em", "f8",        /* distance from Sun to observer (au) */
        "v", "(3,)f8",     /* barycentric observer velocity (vector, c) */
        "bm1", "f8",       /* sqrt(1-|v|^2): reciprocal of Lorenz factor */
        "bpn", "(3,3)f8",  /* bias-precession-nutation matrix */
        "along", "f8",     /* longitude + s' + dERA(DUT) (radians) */
        "phi", "f8",       /* geodetic latitude (radians) */
        "xpl", "f8",       /* polar motion xp wrt local meridian (radians) */
        "ypl", "f8",       /* polar motion yp wrt local meridian (radians) */
        "sphi", "f8",      /* sine of geodetic latitude */
        "cphi", "f8",      /* cosine of geodetic latitude */
        "diurab", "f8",    /* magnitude of diurnal aberration vector */
        "eral", "f8",      /* "local" Earth rotation angle (radians) */
        "refa", "f8",      /* refraction constant A (radians) */
        "refb", "f8"       /* refraction constant B (radians) */
        );
    PyArray_DescrAlignConverter(dtype_def, &dt_eraASTROM);
    Py_DECREF(dtype_def);
    /* eraLEAPSECOND */
    dtype_def = Py_BuildValue("[(s, s), (s, s), (s, s)]",
                              "year", "i4", "month", "i4", "tai_utc", "f8");
    PyArray_DescrAlignConverter(dtype_def, &dt_eraLEAPSECOND);
    Py_DECREF(dtype_def);

    if (dt_double == NULL || dt_int == NULL ||
        dt_pv == NULL || dt_pvdpv == NULL ||
        dt_ymdf == NULL || dt_hmsf == NULL || dt_dmsf == NULL ||
        dt_sign == NULL || dt_type == NULL ||
        dt_eraASTROM == NULL || dt_eraLEAPSECOND == NULL) {
        goto fail;
    }
    /* eraLDBODY (needs dt_pv, so after check that that is OK) */
    dtype_def = Py_BuildValue(
        "[(s, s), (s, s), (s, O)]",
        "bm", "f8",     /* mass of the body (solar masses) */
        "dl", "f8",     /* deflection limiter (radians^2/2) */
        "pv", dt_pv     /* barycentric PV of the body (au, au/day) */
        );
    PyArray_DescrAlignConverter(dtype_def, &dt_eraLDBODY);
    Py_DECREF(dtype_def);
    if (dt_eraLDBODY == NULL) {
        goto fail;
    }
    /* Make the structured dtypes available in the module */
    PyDict_SetItemString(d, "dt_pv", (PyObject *)dt_pv);
    PyDict_SetItemString(d, "dt_pvdpv", (PyObject *)dt_pvdpv);
    PyDict_SetItemString(d, "dt_ymdf", (PyObject *)dt_ymdf);
    PyDict_SetItemString(d, "dt_hmsf", (PyObject *)dt_hmsf);
    PyDict_SetItemString(d, "dt_dmsf", (PyObject *)dt_dmsf);
    PyDict_SetItemString(d, "dt_sign", (PyObject *)dt_sign);
    PyDict_SetItemString(d, "dt_type", (PyObject *)dt_type);
    PyDict_SetItemString(d, "dt_eraLDBODY", (PyObject *)dt_eraLDBODY);
    PyDict_SetItemString(d, "dt_eraASTROM", (PyObject *)dt_eraASTROM);
    PyDict_SetItemString(d, "dt_eraLEAPSECOND", (PyObject *)dt_eraLEAPSECOND);
    /*
     * Define the ufuncs.  For those without structured dtypes,
     * the ufunc creation uses the static variables defined above;
     * for those with structured dtypes, an empty ufunc is created,
     * and then a userloop is added.  For both, we set the type
     * resolver to our own, and then add the ufunc to the module.
     *
     * Note that for the arguments, any inout arguments, i.e., those
     * that are changed in-place in the ERFA function, are repeated,
     * since we want the ufuncs not to do in-place changes (unless
     * explicitly requested with ufunc(..., in,..., out=in))
     */
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_cal2jd, data, types_cal2jd,
        1, 3, 3, PyUFunc_None,
        "cal2jd",
        "UFunc wrapper for eraCal2jd",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "cal2jd", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_epb, data, types_epb,
        1, 2, 1, PyUFunc_None,
        "epb",
        "UFunc wrapper for eraEpb",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "epb", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_epb2jd, data, types_epb2jd,
        1, 1, 2, PyUFunc_None,
        "epb2jd",
        "UFunc wrapper for eraEpb2jd",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "epb2jd", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_epj, data, types_epj,
        1, 2, 1, PyUFunc_None,
        "epj",
        "UFunc wrapper for eraEpj",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "epj", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_epj2jd, data, types_epj2jd,
        1, 1, 2, PyUFunc_None,
        "epj2jd",
        "UFunc wrapper for eraEpj2jd",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "epj2jd", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_jd2cal, data, types_jd2cal,
        1, 2, 5, PyUFunc_None,
        "jd2cal",
        "UFunc wrapper for eraJd2cal",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "jd2cal", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 2, PyUFunc_None,
        "jdcalf",
        "UFunc wrapper for eraJdcalf",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_int;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_ymdf;
    dtypes[4] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_ymdf,
        ufunc_loop_jdcalf, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "jdcalf", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ab, data, types_ab,
        1, 4, 1, PyUFunc_None,
        "ab",
        "UFunc wrapper for eraAb",
        0, "(3),(3),(),()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ab", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 1, PyUFunc_None,
        "apcg",
        "UFunc wrapper for eraApcg",
        0, "(),(),(),(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_double;
    dtypes[4] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_apcg, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apcg", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "apcg13",
        "UFunc wrapper for eraApcg13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_apcg13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apcg13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 7, 1, PyUFunc_None,
        "apci",
        "UFunc wrapper for eraApci",
        0, "(),(),(),(3),(),(),()->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_apci, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apci", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 2, PyUFunc_None,
        "apci13",
        "UFunc wrapper for eraApci13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    dtypes[3] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_apci13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apci13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 16, 1, PyUFunc_None,
        "apco",
        "UFunc wrapper for eraApco",
        0, "(),(),(),(3),(),(),(),(),(),(),(),(),(),(),(),()->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_double;
    dtypes[10] = dt_double;
    dtypes[11] = dt_double;
    dtypes[12] = dt_double;
    dtypes[13] = dt_double;
    dtypes[14] = dt_double;
    dtypes[15] = dt_double;
    dtypes[16] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_apco, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apco", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 12, 3, PyUFunc_None,
        "apco13",
        "UFunc wrapper for eraApco13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_double;
    dtypes[10] = dt_double;
    dtypes[11] = dt_double;
    dtypes[12] = dt_eraASTROM;
    dtypes[13] = dt_double;
    dtypes[14] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_apco13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apco13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 5, 1, PyUFunc_None,
        "apcs",
        "UFunc wrapper for eraApcs",
        0, "(),(),(),(),(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_pv;
    dtypes[4] = dt_double;
    dtypes[5] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_apcs, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apcs", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 1, PyUFunc_None,
        "apcs13",
        "UFunc wrapper for eraApcs13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_apcs13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apcs13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "aper",
        "UFunc wrapper for eraAper",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_eraASTROM;
    dtypes[2] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_aper, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "aper", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 1, PyUFunc_None,
        "aper13",
        "UFunc wrapper for eraAper13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    dtypes[3] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_aper13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "aper13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 9, 1, PyUFunc_None,
        "apio",
        "UFunc wrapper for eraApio",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_eraASTROM;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_apio, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apio", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 12, 2, PyUFunc_None,
        "apio13",
        "UFunc wrapper for eraApio13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_double;
    dtypes[10] = dt_double;
    dtypes[11] = dt_double;
    dtypes[12] = dt_eraASTROM;
    dtypes[13] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_apio13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "apio13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_atcc13, data, types_atcc13,
        1, 8, 2, PyUFunc_None,
        "atcc13",
        "UFunc wrapper for eraAtcc13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atcc13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 7, 2, PyUFunc_None,
        "atccq",
        "UFunc wrapper for eraAtccq",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_eraASTROM;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_atccq, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atccq", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_atci13, data, types_atci13,
        1, 8, 3, PyUFunc_None,
        "atci13",
        "UFunc wrapper for eraAtci13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atci13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 7, 2, PyUFunc_None,
        "atciq",
        "UFunc wrapper for eraAtciq",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_eraASTROM;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_atciq, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atciq", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 8, 2, PyUFunc_None,
        "atciqn",
        "UFunc wrapper for eraAtciqn",
        0, "(),(),(),(),(),(),(),(n)->(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_eraASTROM;
    dtypes[7] = dt_eraLDBODY;
    dtypes[8] = dt_double;
    dtypes[9] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraLDBODY,
        ufunc_loop_atciqn, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atciqn", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 2, PyUFunc_None,
        "atciqz",
        "UFunc wrapper for eraAtciqz",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_atciqz, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atciqz", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_atco13, data, types_atco13,
        1, 18, 7, PyUFunc_None,
        "atco13",
        "UFunc wrapper for eraAtco13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atco13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_atic13, data, types_atic13,
        1, 4, 3, PyUFunc_None,
        "atic13",
        "UFunc wrapper for eraAtic13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atic13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 2, PyUFunc_None,
        "aticq",
        "UFunc wrapper for eraAticq",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_aticq, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "aticq", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 2, PyUFunc_None,
        "aticqn",
        "UFunc wrapper for eraAticqn",
        0, "(),(),(),(n)->(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    dtypes[3] = dt_eraLDBODY;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraLDBODY,
        ufunc_loop_aticqn, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "aticqn", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_atio13, data, types_atio13,
        1, 14, 6, PyUFunc_None,
        "atio13",
        "UFunc wrapper for eraAtio13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atio13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 5, PyUFunc_None,
        "atioq",
        "UFunc wrapper for eraAtioq",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_eraASTROM;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraASTROM,
        ufunc_loop_atioq, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atioq", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 15, 3, PyUFunc_None,
        "atoc13",
        "UFunc wrapper for eraAtoc13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_type;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_double;
    dtypes[10] = dt_double;
    dtypes[11] = dt_double;
    dtypes[12] = dt_double;
    dtypes[13] = dt_double;
    dtypes[14] = dt_double;
    dtypes[15] = dt_double;
    dtypes[16] = dt_double;
    dtypes[17] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_type,
        ufunc_loop_atoc13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atoc13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 15, 3, PyUFunc_None,
        "atoi13",
        "UFunc wrapper for eraAtoi13",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_type;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_double;
    dtypes[10] = dt_double;
    dtypes[11] = dt_double;
    dtypes[12] = dt_double;
    dtypes[13] = dt_double;
    dtypes[14] = dt_double;
    dtypes[15] = dt_double;
    dtypes[16] = dt_double;
    dtypes[17] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_type,
        ufunc_loop_atoi13, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atoi13", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 2, PyUFunc_None,
        "atoiq",
        "UFunc wrapper for eraAtoiq",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_type;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_eraASTROM;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_type,
        ufunc_loop_atoiq, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "atoiq", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ld, data, types_ld,
        1, 6, 1, PyUFunc_None,
        "ld",
        "UFunc wrapper for eraLd",
        0, "(),(3),(3),(3),(),()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ld", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 1, PyUFunc_None,
        "ldn",
        "UFunc wrapper for eraLdn",
        0, "(n),(3),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_eraLDBODY;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_eraLDBODY,
        ufunc_loop_ldn, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ldn", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ldsun, data, types_ldsun,
        1, 3, 1, PyUFunc_None,
        "ldsun",
        "UFunc wrapper for eraLdsun",
        0, "(3),(3),()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ldsun", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pmpx, data, types_pmpx,
        1, 8, 1, PyUFunc_None,
        "pmpx",
        "UFunc wrapper for eraPmpx",
        0, "(),(),(),(),(),(),(),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pmpx", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pmsafe, data, types_pmsafe,
        1, 10, 7, PyUFunc_None,
        "pmsafe",
        "UFunc wrapper for eraPmsafe",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pmsafe", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 7, 1, PyUFunc_None,
        "pvtob",
        "UFunc wrapper for eraPvtob",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvtob, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvtob", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_refco, data, types_refco,
        1, 4, 2, PyUFunc_None,
        "refco",
        "UFunc wrapper for eraRefco",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "refco", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 3, PyUFunc_None,
        "epv00",
        "UFunc wrapper for eraEpv00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_pv;
    dtypes[4] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_epv00, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "epv00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "moon98",
        "UFunc wrapper for eraMoon98",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_moon98, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "moon98", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 2, PyUFunc_None,
        "plan94",
        "UFunc wrapper for eraPlan94",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_int;
    dtypes[3] = dt_pv;
    dtypes[4] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_plan94, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "plan94", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fad03, data, types_fad03,
        1, 1, 1, PyUFunc_None,
        "fad03",
        "UFunc wrapper for eraFad03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fad03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fae03, data, types_fae03,
        1, 1, 1, PyUFunc_None,
        "fae03",
        "UFunc wrapper for eraFae03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fae03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_faf03, data, types_faf03,
        1, 1, 1, PyUFunc_None,
        "faf03",
        "UFunc wrapper for eraFaf03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "faf03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_faju03, data, types_faju03,
        1, 1, 1, PyUFunc_None,
        "faju03",
        "UFunc wrapper for eraFaju03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "faju03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fal03, data, types_fal03,
        1, 1, 1, PyUFunc_None,
        "fal03",
        "UFunc wrapper for eraFal03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fal03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_falp03, data, types_falp03,
        1, 1, 1, PyUFunc_None,
        "falp03",
        "UFunc wrapper for eraFalp03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "falp03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fama03, data, types_fama03,
        1, 1, 1, PyUFunc_None,
        "fama03",
        "UFunc wrapper for eraFama03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fama03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fame03, data, types_fame03,
        1, 1, 1, PyUFunc_None,
        "fame03",
        "UFunc wrapper for eraFame03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fame03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fane03, data, types_fane03,
        1, 1, 1, PyUFunc_None,
        "fane03",
        "UFunc wrapper for eraFane03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fane03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_faom03, data, types_faom03,
        1, 1, 1, PyUFunc_None,
        "faom03",
        "UFunc wrapper for eraFaom03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "faom03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fapa03, data, types_fapa03,
        1, 1, 1, PyUFunc_None,
        "fapa03",
        "UFunc wrapper for eraFapa03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fapa03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fasa03, data, types_fasa03,
        1, 1, 1, PyUFunc_None,
        "fasa03",
        "UFunc wrapper for eraFasa03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fasa03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_faur03, data, types_faur03,
        1, 1, 1, PyUFunc_None,
        "faur03",
        "UFunc wrapper for eraFaur03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "faur03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fave03, data, types_fave03,
        1, 1, 1, PyUFunc_None,
        "fave03",
        "UFunc wrapper for eraFave03",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fave03", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_bi00, data, types_bi00,
        1, 0, 3, PyUFunc_None,
        "bi00",
        "UFunc wrapper for eraBi00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "bi00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_bp00, data, types_bp00,
        1, 2, 3, PyUFunc_None,
        "bp00",
        "UFunc wrapper for eraBp00",
        0, "(),()->(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "bp00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_bp06, data, types_bp06,
        1, 2, 3, PyUFunc_None,
        "bp06",
        "UFunc wrapper for eraBp06",
        0, "(),()->(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "bp06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_bpn2xy, data, types_bpn2xy,
        1, 1, 2, PyUFunc_None,
        "bpn2xy",
        "UFunc wrapper for eraBpn2xy",
        0, "(3, 3)->(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "bpn2xy", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2i00a, data, types_c2i00a,
        1, 2, 1, PyUFunc_None,
        "c2i00a",
        "UFunc wrapper for eraC2i00a",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2i00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2i00b, data, types_c2i00b,
        1, 2, 1, PyUFunc_None,
        "c2i00b",
        "UFunc wrapper for eraC2i00b",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2i00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2i06a, data, types_c2i06a,
        1, 2, 1, PyUFunc_None,
        "c2i06a",
        "UFunc wrapper for eraC2i06a",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2i06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2ibpn, data, types_c2ibpn,
        1, 3, 1, PyUFunc_None,
        "c2ibpn",
        "UFunc wrapper for eraC2ibpn",
        0, "(),(),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2ibpn", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2ixy, data, types_c2ixy,
        1, 4, 1, PyUFunc_None,
        "c2ixy",
        "UFunc wrapper for eraC2ixy",
        0, "(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2ixy", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2ixys, data, types_c2ixys,
        1, 3, 1, PyUFunc_None,
        "c2ixys",
        "UFunc wrapper for eraC2ixys",
        0, "(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2ixys", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2t00a, data, types_c2t00a,
        1, 6, 1, PyUFunc_None,
        "c2t00a",
        "UFunc wrapper for eraC2t00a",
        0, "(),(),(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2t00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2t00b, data, types_c2t00b,
        1, 6, 1, PyUFunc_None,
        "c2t00b",
        "UFunc wrapper for eraC2t00b",
        0, "(),(),(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2t00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2t06a, data, types_c2t06a,
        1, 6, 1, PyUFunc_None,
        "c2t06a",
        "UFunc wrapper for eraC2t06a",
        0, "(),(),(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2t06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2tcio, data, types_c2tcio,
        1, 3, 1, PyUFunc_None,
        "c2tcio",
        "UFunc wrapper for eraC2tcio",
        0, "(3, 3),(),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2tcio", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2teqx, data, types_c2teqx,
        1, 3, 1, PyUFunc_None,
        "c2teqx",
        "UFunc wrapper for eraC2teqx",
        0, "(3, 3),(),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2teqx", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2tpe, data, types_c2tpe,
        1, 8, 1, PyUFunc_None,
        "c2tpe",
        "UFunc wrapper for eraC2tpe",
        0, "(),(),(),(),(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2tpe", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2txy, data, types_c2txy,
        1, 8, 1, PyUFunc_None,
        "c2txy",
        "UFunc wrapper for eraC2txy",
        0, "(),(),(),(),(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2txy", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eo06a, data, types_eo06a,
        1, 2, 1, PyUFunc_None,
        "eo06a",
        "UFunc wrapper for eraEo06a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eo06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eors, data, types_eors,
        1, 2, 1, PyUFunc_None,
        "eors",
        "UFunc wrapper for eraEors",
        0, "(3, 3),()->()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eors", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fw2m, data, types_fw2m,
        1, 4, 1, PyUFunc_None,
        "fw2m",
        "UFunc wrapper for eraFw2m",
        0, "(),(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fw2m", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fw2xy, data, types_fw2xy,
        1, 4, 2, PyUFunc_None,
        "fw2xy",
        "UFunc wrapper for eraFw2xy",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fw2xy", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ltp, data, types_ltp,
        1, 1, 1, PyUFunc_None,
        "ltp",
        "UFunc wrapper for eraLtp",
        0, "()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ltp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ltpb, data, types_ltpb,
        1, 1, 1, PyUFunc_None,
        "ltpb",
        "UFunc wrapper for eraLtpb",
        0, "()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ltpb", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ltpecl, data, types_ltpecl,
        1, 1, 1, PyUFunc_None,
        "ltpecl",
        "UFunc wrapper for eraLtpecl",
        0, "()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ltpecl", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ltpequ, data, types_ltpequ,
        1, 1, 1, PyUFunc_None,
        "ltpequ",
        "UFunc wrapper for eraLtpequ",
        0, "()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ltpequ", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_num00a, data, types_num00a,
        1, 2, 1, PyUFunc_None,
        "num00a",
        "UFunc wrapper for eraNum00a",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "num00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_num00b, data, types_num00b,
        1, 2, 1, PyUFunc_None,
        "num00b",
        "UFunc wrapper for eraNum00b",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "num00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_num06a, data, types_num06a,
        1, 2, 1, PyUFunc_None,
        "num06a",
        "UFunc wrapper for eraNum06a",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "num06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_numat, data, types_numat,
        1, 3, 1, PyUFunc_None,
        "numat",
        "UFunc wrapper for eraNumat",
        0, "(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "numat", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_nut00a, data, types_nut00a,
        1, 2, 2, PyUFunc_None,
        "nut00a",
        "UFunc wrapper for eraNut00a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "nut00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_nut00b, data, types_nut00b,
        1, 2, 2, PyUFunc_None,
        "nut00b",
        "UFunc wrapper for eraNut00b",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "nut00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_nut06a, data, types_nut06a,
        1, 2, 2, PyUFunc_None,
        "nut06a",
        "UFunc wrapper for eraNut06a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "nut06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_nut80, data, types_nut80,
        1, 2, 2, PyUFunc_None,
        "nut80",
        "UFunc wrapper for eraNut80",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "nut80", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_nutm80, data, types_nutm80,
        1, 2, 1, PyUFunc_None,
        "nutm80",
        "UFunc wrapper for eraNutm80",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "nutm80", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_obl06, data, types_obl06,
        1, 2, 1, PyUFunc_None,
        "obl06",
        "UFunc wrapper for eraObl06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "obl06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_obl80, data, types_obl80,
        1, 2, 1, PyUFunc_None,
        "obl80",
        "UFunc wrapper for eraObl80",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "obl80", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_p06e, data, types_p06e,
        1, 2, 16, PyUFunc_None,
        "p06e",
        "UFunc wrapper for eraP06e",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "p06e", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pb06, data, types_pb06,
        1, 2, 3, PyUFunc_None,
        "pb06",
        "UFunc wrapper for eraPb06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pb06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pfw06, data, types_pfw06,
        1, 2, 4, PyUFunc_None,
        "pfw06",
        "UFunc wrapper for eraPfw06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pfw06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pmat00, data, types_pmat00,
        1, 2, 1, PyUFunc_None,
        "pmat00",
        "UFunc wrapper for eraPmat00",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pmat00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pmat06, data, types_pmat06,
        1, 2, 1, PyUFunc_None,
        "pmat06",
        "UFunc wrapper for eraPmat06",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pmat06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pmat76, data, types_pmat76,
        1, 2, 1, PyUFunc_None,
        "pmat76",
        "UFunc wrapper for eraPmat76",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pmat76", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pn00, data, types_pn00,
        1, 4, 6, PyUFunc_None,
        "pn00",
        "UFunc wrapper for eraPn00",
        0, "(),(),(),()->(),(3, 3),(3, 3),(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pn00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pn00a, data, types_pn00a,
        1, 2, 8, PyUFunc_None,
        "pn00a",
        "UFunc wrapper for eraPn00a",
        0, "(),()->(),(),(),(3, 3),(3, 3),(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pn00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pn00b, data, types_pn00b,
        1, 2, 8, PyUFunc_None,
        "pn00b",
        "UFunc wrapper for eraPn00b",
        0, "(),()->(),(),(),(3, 3),(3, 3),(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pn00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pn06, data, types_pn06,
        1, 4, 6, PyUFunc_None,
        "pn06",
        "UFunc wrapper for eraPn06",
        0, "(),(),(),()->(),(3, 3),(3, 3),(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pn06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pn06a, data, types_pn06a,
        1, 2, 8, PyUFunc_None,
        "pn06a",
        "UFunc wrapper for eraPn06a",
        0, "(),()->(),(),(),(3, 3),(3, 3),(3, 3),(3, 3),(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pn06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pnm00a, data, types_pnm00a,
        1, 2, 1, PyUFunc_None,
        "pnm00a",
        "UFunc wrapper for eraPnm00a",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pnm00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pnm00b, data, types_pnm00b,
        1, 2, 1, PyUFunc_None,
        "pnm00b",
        "UFunc wrapper for eraPnm00b",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pnm00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pnm06a, data, types_pnm06a,
        1, 2, 1, PyUFunc_None,
        "pnm06a",
        "UFunc wrapper for eraPnm06a",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pnm06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pnm80, data, types_pnm80,
        1, 2, 1, PyUFunc_None,
        "pnm80",
        "UFunc wrapper for eraPnm80",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pnm80", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pom00, data, types_pom00,
        1, 3, 1, PyUFunc_None,
        "pom00",
        "UFunc wrapper for eraPom00",
        0, "(),(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pom00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pr00, data, types_pr00,
        1, 2, 2, PyUFunc_None,
        "pr00",
        "UFunc wrapper for eraPr00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pr00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_prec76, data, types_prec76,
        1, 4, 3, PyUFunc_None,
        "prec76",
        "UFunc wrapper for eraPrec76",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "prec76", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s00, data, types_s00,
        1, 4, 1, PyUFunc_None,
        "s00",
        "UFunc wrapper for eraS00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s00a, data, types_s00a,
        1, 2, 1, PyUFunc_None,
        "s00a",
        "UFunc wrapper for eraS00a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s00b, data, types_s00b,
        1, 2, 1, PyUFunc_None,
        "s00b",
        "UFunc wrapper for eraS00b",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s06, data, types_s06,
        1, 4, 1, PyUFunc_None,
        "s06",
        "UFunc wrapper for eraS06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s06a, data, types_s06a,
        1, 2, 1, PyUFunc_None,
        "s06a",
        "UFunc wrapper for eraS06a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_sp00, data, types_sp00,
        1, 2, 1, PyUFunc_None,
        "sp00",
        "UFunc wrapper for eraSp00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "sp00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_xy06, data, types_xy06,
        1, 2, 2, PyUFunc_None,
        "xy06",
        "UFunc wrapper for eraXy06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "xy06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_xys00a, data, types_xys00a,
        1, 2, 3, PyUFunc_None,
        "xys00a",
        "UFunc wrapper for eraXys00a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "xys00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_xys00b, data, types_xys00b,
        1, 2, 3, PyUFunc_None,
        "xys00b",
        "UFunc wrapper for eraXys00b",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "xys00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_xys06a, data, types_xys06a,
        1, 2, 3, PyUFunc_None,
        "xys06a",
        "UFunc wrapper for eraXys06a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "xys06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ee00, data, types_ee00,
        1, 4, 1, PyUFunc_None,
        "ee00",
        "UFunc wrapper for eraEe00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ee00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ee00a, data, types_ee00a,
        1, 2, 1, PyUFunc_None,
        "ee00a",
        "UFunc wrapper for eraEe00a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ee00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ee00b, data, types_ee00b,
        1, 2, 1, PyUFunc_None,
        "ee00b",
        "UFunc wrapper for eraEe00b",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ee00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ee06a, data, types_ee06a,
        1, 2, 1, PyUFunc_None,
        "ee06a",
        "UFunc wrapper for eraEe06a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ee06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eect00, data, types_eect00,
        1, 2, 1, PyUFunc_None,
        "eect00",
        "UFunc wrapper for eraEect00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eect00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eqeq94, data, types_eqeq94,
        1, 2, 1, PyUFunc_None,
        "eqeq94",
        "UFunc wrapper for eraEqeq94",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eqeq94", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_era00, data, types_era00,
        1, 2, 1, PyUFunc_None,
        "era00",
        "UFunc wrapper for eraEra00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "era00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gmst00, data, types_gmst00,
        1, 4, 1, PyUFunc_None,
        "gmst00",
        "UFunc wrapper for eraGmst00",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gmst00", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gmst06, data, types_gmst06,
        1, 4, 1, PyUFunc_None,
        "gmst06",
        "UFunc wrapper for eraGmst06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gmst06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gmst82, data, types_gmst82,
        1, 2, 1, PyUFunc_None,
        "gmst82",
        "UFunc wrapper for eraGmst82",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gmst82", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gst00a, data, types_gst00a,
        1, 4, 1, PyUFunc_None,
        "gst00a",
        "UFunc wrapper for eraGst00a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gst00a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gst00b, data, types_gst00b,
        1, 2, 1, PyUFunc_None,
        "gst00b",
        "UFunc wrapper for eraGst00b",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gst00b", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gst06, data, types_gst06,
        1, 5, 1, PyUFunc_None,
        "gst06",
        "UFunc wrapper for eraGst06",
        0, "(),(),(),(),(3, 3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gst06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gst06a, data, types_gst06a,
        1, 4, 1, PyUFunc_None,
        "gst06a",
        "UFunc wrapper for eraGst06a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gst06a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gst94, data, types_gst94,
        1, 2, 1, PyUFunc_None,
        "gst94",
        "UFunc wrapper for eraGst94",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gst94", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 1, 7, PyUFunc_None,
        "pvstar",
        "UFunc wrapper for eraPvstar",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    dtypes[7] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvstar, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvstar", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 6, 2, PyUFunc_None,
        "starpv",
        "UFunc wrapper for eraStarpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_pv;
    dtypes[7] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_starpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "starpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk425, data, types_fk425,
        1, 6, 6, PyUFunc_None,
        "fk425",
        "UFunc wrapper for eraFk425",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk425", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk45z, data, types_fk45z,
        1, 3, 2, PyUFunc_None,
        "fk45z",
        "UFunc wrapper for eraFk45z",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk45z", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk524, data, types_fk524,
        1, 6, 6, PyUFunc_None,
        "fk524",
        "UFunc wrapper for eraFk524",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk524", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk52h, data, types_fk52h,
        1, 6, 6, PyUFunc_None,
        "fk52h",
        "UFunc wrapper for eraFk52h",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk52h", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk54z, data, types_fk54z,
        1, 3, 4, PyUFunc_None,
        "fk54z",
        "UFunc wrapper for eraFk54z",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk54z", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk5hip, data, types_fk5hip,
        1, 0, 2, PyUFunc_None,
        "fk5hip",
        "UFunc wrapper for eraFk5hip",
        0, "->(3, 3),(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk5hip", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_fk5hz, data, types_fk5hz,
        1, 4, 2, PyUFunc_None,
        "fk5hz",
        "UFunc wrapper for eraFk5hz",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "fk5hz", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_h2fk5, data, types_h2fk5,
        1, 6, 6, PyUFunc_None,
        "h2fk5",
        "UFunc wrapper for eraH2fk5",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "h2fk5", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_hfk5z, data, types_hfk5z,
        1, 4, 4, PyUFunc_None,
        "hfk5z",
        "UFunc wrapper for eraHfk5z",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "hfk5z", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_starpm, data, types_starpm,
        1, 10, 7, PyUFunc_None,
        "starpm",
        "UFunc wrapper for eraStarpm",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "starpm", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eceq06, data, types_eceq06,
        1, 4, 2, PyUFunc_None,
        "eceq06",
        "UFunc wrapper for eraEceq06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eceq06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ecm06, data, types_ecm06,
        1, 2, 1, PyUFunc_None,
        "ecm06",
        "UFunc wrapper for eraEcm06",
        0, "(),()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ecm06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eqec06, data, types_eqec06,
        1, 4, 2, PyUFunc_None,
        "eqec06",
        "UFunc wrapper for eraEqec06",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eqec06", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_lteceq, data, types_lteceq,
        1, 3, 2, PyUFunc_None,
        "lteceq",
        "UFunc wrapper for eraLteceq",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "lteceq", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ltecm, data, types_ltecm,
        1, 1, 1, PyUFunc_None,
        "ltecm",
        "UFunc wrapper for eraLtecm",
        0, "()->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ltecm", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_lteqec, data, types_lteqec,
        1, 3, 2, PyUFunc_None,
        "lteqec",
        "UFunc wrapper for eraLteqec",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "lteqec", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_g2icrs, data, types_g2icrs,
        1, 2, 2, PyUFunc_None,
        "g2icrs",
        "UFunc wrapper for eraG2icrs",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "g2icrs", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_icrs2g, data, types_icrs2g,
        1, 2, 2, PyUFunc_None,
        "icrs2g",
        "UFunc wrapper for eraIcrs2g",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "icrs2g", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_eform, data, types_eform,
        1, 1, 3, PyUFunc_None,
        "eform",
        "UFunc wrapper for eraEform",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "eform", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gc2gd, data, types_gc2gd,
        1, 2, 4, PyUFunc_None,
        "gc2gd",
        "UFunc wrapper for eraGc2gd",
        0, "(),(3)->(),(),(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gc2gd", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gc2gde, data, types_gc2gde,
        1, 3, 4, PyUFunc_None,
        "gc2gde",
        "UFunc wrapper for eraGc2gde",
        0, "(),(),(3)->(),(),(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gc2gde", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gd2gc, data, types_gd2gc,
        1, 4, 2, PyUFunc_None,
        "gd2gc",
        "UFunc wrapper for eraGd2gc",
        0, "(),(),(),()->(3),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gd2gc", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_gd2gce, data, types_gd2gce,
        1, 5, 2, PyUFunc_None,
        "gd2gce",
        "UFunc wrapper for eraGd2gce",
        0, "(),(),(),(),()->(3),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "gd2gce", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 5, PyUFunc_None,
        "d2dtf",
        "UFunc wrapper for eraD2dtf",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_type;
    dtypes[1] = dt_int;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_int;
    dtypes[5] = dt_int;
    dtypes[6] = dt_int;
    dtypes[7] = dt_hmsf;
    dtypes[8] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_type,
        ufunc_loop_d2dtf, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "d2dtf", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_dat, data, types_dat,
        1, 4, 2, PyUFunc_None,
        "dat",
        "UFunc wrapper for eraDat",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "dat", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_dtdb, data, types_dtdb,
        1, 6, 1, PyUFunc_None,
        "dtdb",
        "UFunc wrapper for eraDtdb",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "dtdb", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 7, 3, PyUFunc_None,
        "dtf2d",
        "UFunc wrapper for eraDtf2d",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_type;
    dtypes[1] = dt_int;
    dtypes[2] = dt_int;
    dtypes[3] = dt_int;
    dtypes[4] = dt_int;
    dtypes[5] = dt_int;
    dtypes[6] = dt_double;
    dtypes[7] = dt_double;
    dtypes[8] = dt_double;
    dtypes[9] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_type,
        ufunc_loop_dtf2d, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "dtf2d", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_taitt, data, types_taitt,
        1, 2, 3, PyUFunc_None,
        "taitt",
        "UFunc wrapper for eraTaitt",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "taitt", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_taiut1, data, types_taiut1,
        1, 3, 3, PyUFunc_None,
        "taiut1",
        "UFunc wrapper for eraTaiut1",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "taiut1", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_taiutc, data, types_taiutc,
        1, 2, 3, PyUFunc_None,
        "taiutc",
        "UFunc wrapper for eraTaiutc",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "taiutc", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tcbtdb, data, types_tcbtdb,
        1, 2, 3, PyUFunc_None,
        "tcbtdb",
        "UFunc wrapper for eraTcbtdb",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tcbtdb", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tcgtt, data, types_tcgtt,
        1, 2, 3, PyUFunc_None,
        "tcgtt",
        "UFunc wrapper for eraTcgtt",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tcgtt", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tdbtcb, data, types_tdbtcb,
        1, 2, 3, PyUFunc_None,
        "tdbtcb",
        "UFunc wrapper for eraTdbtcb",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tdbtcb", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tdbtt, data, types_tdbtt,
        1, 3, 3, PyUFunc_None,
        "tdbtt",
        "UFunc wrapper for eraTdbtt",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tdbtt", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tttai, data, types_tttai,
        1, 2, 3, PyUFunc_None,
        "tttai",
        "UFunc wrapper for eraTttai",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tttai", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tttcg, data, types_tttcg,
        1, 2, 3, PyUFunc_None,
        "tttcg",
        "UFunc wrapper for eraTttcg",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tttcg", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tttdb, data, types_tttdb,
        1, 3, 3, PyUFunc_None,
        "tttdb",
        "UFunc wrapper for eraTttdb",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tttdb", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ttut1, data, types_ttut1,
        1, 3, 3, PyUFunc_None,
        "ttut1",
        "UFunc wrapper for eraTtut1",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ttut1", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ut1tai, data, types_ut1tai,
        1, 3, 3, PyUFunc_None,
        "ut1tai",
        "UFunc wrapper for eraUt1tai",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ut1tai", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ut1tt, data, types_ut1tt,
        1, 3, 3, PyUFunc_None,
        "ut1tt",
        "UFunc wrapper for eraUt1tt",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ut1tt", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ut1utc, data, types_ut1utc,
        1, 3, 3, PyUFunc_None,
        "ut1utc",
        "UFunc wrapper for eraUt1utc",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ut1utc", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_utctai, data, types_utctai,
        1, 2, 3, PyUFunc_None,
        "utctai",
        "UFunc wrapper for eraUtctai",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "utctai", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_utcut1, data, types_utcut1,
        1, 3, 3, PyUFunc_None,
        "utcut1",
        "UFunc wrapper for eraUtcut1",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "utcut1", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ae2hd, data, types_ae2hd,
        1, 3, 2, PyUFunc_None,
        "ae2hd",
        "UFunc wrapper for eraAe2hd",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ae2hd", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_hd2ae, data, types_hd2ae,
        1, 3, 2, PyUFunc_None,
        "hd2ae",
        "UFunc wrapper for eraHd2ae",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "hd2ae", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_hd2pa, data, types_hd2pa,
        1, 3, 1, PyUFunc_None,
        "hd2pa",
        "UFunc wrapper for eraHd2pa",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "hd2pa", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tpors, data, types_tpors,
        1, 4, 5, PyUFunc_None,
        "tpors",
        "UFunc wrapper for eraTpors",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tpors", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tporv, data, types_tporv,
        1, 3, 3, PyUFunc_None,
        "tporv",
        "UFunc wrapper for eraTporv",
        0, "(),(),(3)->(3),(3),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tporv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tpsts, data, types_tpsts,
        1, 4, 2, PyUFunc_None,
        "tpsts",
        "UFunc wrapper for eraTpsts",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tpsts", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tpstv, data, types_tpstv,
        1, 3, 1, PyUFunc_None,
        "tpstv",
        "UFunc wrapper for eraTpstv",
        0, "(),(),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tpstv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tpxes, data, types_tpxes,
        1, 4, 3, PyUFunc_None,
        "tpxes",
        "UFunc wrapper for eraTpxes",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tpxes", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tpxev, data, types_tpxev,
        1, 2, 3, PyUFunc_None,
        "tpxev",
        "UFunc wrapper for eraTpxev",
        0, "(3),(3)->(),(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tpxev", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 2, PyUFunc_None,
        "a2af",
        "UFunc wrapper for eraA2af",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_int;
    dtypes[1] = dt_double;
    dtypes[2] = dt_sign;
    dtypes[3] = dt_dmsf;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_sign,
        ufunc_loop_a2af, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "a2af", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 2, PyUFunc_None,
        "a2tf",
        "UFunc wrapper for eraA2tf",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_int;
    dtypes[1] = dt_double;
    dtypes[2] = dt_sign;
    dtypes[3] = dt_hmsf;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_sign,
        ufunc_loop_a2tf, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "a2tf", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 2, PyUFunc_None,
        "af2a",
        "UFunc wrapper for eraAf2a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_sign;
    dtypes[1] = dt_int;
    dtypes[2] = dt_int;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_sign,
        ufunc_loop_af2a, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "af2a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_anp, data, types_anp,
        1, 1, 1, PyUFunc_None,
        "anp",
        "UFunc wrapper for eraAnp",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "anp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_anpm, data, types_anpm,
        1, 1, 1, PyUFunc_None,
        "anpm",
        "UFunc wrapper for eraAnpm",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "anpm", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 2, PyUFunc_None,
        "d2tf",
        "UFunc wrapper for eraD2tf",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_int;
    dtypes[1] = dt_double;
    dtypes[2] = dt_sign;
    dtypes[3] = dt_hmsf;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_sign,
        ufunc_loop_d2tf, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "d2tf", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 2, PyUFunc_None,
        "tf2a",
        "UFunc wrapper for eraTf2a",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_sign;
    dtypes[1] = dt_int;
    dtypes[2] = dt_int;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_sign,
        ufunc_loop_tf2a, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tf2a", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 4, 2, PyUFunc_None,
        "tf2d",
        "UFunc wrapper for eraTf2d",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_sign;
    dtypes[1] = dt_int;
    dtypes[2] = dt_int;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_int;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_sign,
        ufunc_loop_tf2d, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tf2d", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_rx, data, types_rx,
        1, 2, 1, PyUFunc_None,
        "rx",
        "UFunc wrapper for eraRx",
        0, "(),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rx", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ry, data, types_ry,
        1, 2, 1, PyUFunc_None,
        "ry",
        "UFunc wrapper for eraRy",
        0, "(),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ry", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_rz, data, types_rz,
        1, 2, 1, PyUFunc_None,
        "rz",
        "UFunc wrapper for eraRz",
        0, "(),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rz", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_cp, data, types_cp,
        1, 1, 1, PyUFunc_None,
        "cp",
        "UFunc wrapper for eraCp",
        0, "(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "cp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 1, 1, PyUFunc_None,
        "cpv",
        "UFunc wrapper for eraCpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_cpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "cpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_cr, data, types_cr,
        1, 1, 1, PyUFunc_None,
        "cr",
        "UFunc wrapper for eraCr",
        0, "(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "cr", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 1, 1, PyUFunc_None,
        "p2pv",
        "UFunc wrapper for eraP2pv",
        0, "(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_p2pv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "p2pv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 1, 1, PyUFunc_None,
        "pv2p",
        "UFunc wrapper for eraPv2p",
        0, "()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pv2p, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pv2p", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ir, data, types_ir,
        1, 0, 1, PyUFunc_None,
        "ir",
        "UFunc wrapper for eraIr",
        0, "->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ir", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_zp, data, types_zp,
        1, 0, 1, PyUFunc_None,
        "zp",
        "UFunc wrapper for eraZp",
        0, "->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "zp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 0, 1, PyUFunc_None,
        "zpv",
        "UFunc wrapper for eraZpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_zpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "zpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_zr, data, types_zr,
        1, 0, 1, PyUFunc_None,
        "zr",
        "UFunc wrapper for eraZr",
        0, "->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "zr", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_rxr, data, types_rxr,
        1, 2, 1, PyUFunc_None,
        "rxr",
        "UFunc wrapper for eraRxr",
        0, "(3, 3),(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rxr", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_tr, data, types_tr,
        1, 1, 1, PyUFunc_None,
        "tr",
        "UFunc wrapper for eraTr",
        0, "(3, 3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "tr", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_rxp, data, types_rxp,
        1, 2, 1, PyUFunc_None,
        "rxp",
        "UFunc wrapper for eraRxp",
        0, "(3, 3),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rxp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "rxpv",
        "UFunc wrapper for eraRxpv",
        0, "(3, 3),()->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_rxpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rxpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_trxp, data, types_trxp,
        1, 2, 1, PyUFunc_None,
        "trxp",
        "UFunc wrapper for eraTrxp",
        0, "(3, 3),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "trxp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "trxpv",
        "UFunc wrapper for eraTrxpv",
        0, "(3, 3),()->()");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_trxpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "trxpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_rm2v, data, types_rm2v,
        1, 1, 1, PyUFunc_None,
        "rm2v",
        "UFunc wrapper for eraRm2v",
        0, "(3, 3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rm2v", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_rv2m, data, types_rv2m,
        1, 1, 1, PyUFunc_None,
        "rv2m",
        "UFunc wrapper for eraRv2m",
        0, "(3)->(3, 3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "rv2m", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pap, data, types_pap,
        1, 2, 1, PyUFunc_None,
        "pap",
        "UFunc wrapper for eraPap",
        0, "(3),(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pap", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pas, data, types_pas,
        1, 4, 1, PyUFunc_None,
        "pas",
        "UFunc wrapper for eraPas",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pas", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_sepp, data, types_sepp,
        1, 2, 1, PyUFunc_None,
        "sepp",
        "UFunc wrapper for eraSepp",
        0, "(3),(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "sepp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_seps, data, types_seps,
        1, 4, 1, PyUFunc_None,
        "seps",
        "UFunc wrapper for eraSeps",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "seps", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_c2s, data, types_c2s,
        1, 1, 2, PyUFunc_None,
        "c2s",
        "UFunc wrapper for eraC2s",
        0, "(3)->(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "c2s", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_p2s, data, types_p2s,
        1, 1, 3, PyUFunc_None,
        "p2s",
        "UFunc wrapper for eraP2s",
        0, "(3)->(),(),()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "p2s", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 1, 6, PyUFunc_None,
        "pv2s",
        "UFunc wrapper for eraPv2s",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pv2s, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pv2s", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s2c, data, types_s2c,
        1, 2, 1, PyUFunc_None,
        "s2c",
        "UFunc wrapper for eraS2c",
        0, "(),()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s2c", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_s2p, data, types_s2p,
        1, 3, 1, PyUFunc_None,
        "s2p",
        "UFunc wrapper for eraS2p",
        0, "(),(),()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s2p", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 6, 1, PyUFunc_None,
        "s2pv",
        "UFunc wrapper for eraS2pv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    dtypes[3] = dt_double;
    dtypes[4] = dt_double;
    dtypes[5] = dt_double;
    dtypes[6] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_s2pv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s2pv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pdp, data, types_pdp,
        1, 2, 1, PyUFunc_None,
        "pdp",
        "UFunc wrapper for eraPdp",
        0, "(3),(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pdp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pm, data, types_pm,
        1, 1, 1, PyUFunc_None,
        "pm",
        "UFunc wrapper for eraPm",
        0, "(3)->()");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pm", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pmp, data, types_pmp,
        1, 2, 1, PyUFunc_None,
        "pmp",
        "UFunc wrapper for eraPmp",
        0, "(3),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pmp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pn, data, types_pn,
        1, 1, 2, PyUFunc_None,
        "pn",
        "UFunc wrapper for eraPn",
        0, "(3)->(),(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pn", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ppp, data, types_ppp,
        1, 2, 1, PyUFunc_None,
        "ppp",
        "UFunc wrapper for eraPpp",
        0, "(3),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ppp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_ppsp, data, types_ppsp,
        1, 3, 1, PyUFunc_None,
        "ppsp",
        "UFunc wrapper for eraPpsp",
        0, "(3),(),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "ppsp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "pvdpv",
        "UFunc wrapper for eraPvdpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pvdpv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvdpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvdpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 1, 2, PyUFunc_None,
        "pvm",
        "UFunc wrapper for eraPvm",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_double;
    dtypes[2] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvm, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvm", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "pvmpv",
        "UFunc wrapper for eraPvmpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvmpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvmpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "pvppv",
        "UFunc wrapper for eraPvppv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvppv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvppv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "pvu",
        "UFunc wrapper for eraPvu",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvu, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvu", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "pvup",
        "UFunc wrapper for eraPvup",
        0, "(),()->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_double;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvup, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvup", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "pvxpv",
        "UFunc wrapper for eraPvxpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_pv;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_pvxpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pvxpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_pxp, data, types_pxp,
        1, 2, 1, PyUFunc_None,
        "pxp",
        "UFunc wrapper for eraPxp",
        0, "(3),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "pxp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 3, 1, PyUFunc_None,
        "s2xpv",
        "UFunc wrapper for eraS2xpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_double;
    dtypes[2] = dt_pv;
    dtypes[3] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_s2xpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "s2xpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        funcs_sxp, data, types_sxp,
        1, 2, 1, PyUFunc_None,
        "sxp",
        "UFunc wrapper for eraSxp",
        0, "(),(3)->(3)");
    if (ufunc == NULL) {
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "sxp", (PyObject *)ufunc);
    Py_DECREF(ufunc);
    ufunc = (PyUFuncObject *)PyUFunc_FromFuncAndDataAndSignature(
        NULL, NULL, NULL,
        0, 2, 1, PyUFunc_None,
        "sxpv",
        "UFunc wrapper for eraSxpv",
        0, NULL);
    if (ufunc == NULL) {
        goto fail;
    }
    dtypes[0] = dt_double;
    dtypes[1] = dt_pv;
    dtypes[2] = dt_pv;
    status = PyUFunc_RegisterLoopForDescr(
        ufunc, dt_pv,
        ufunc_loop_sxpv, dtypes, NULL);
    if(status != 0){
        Py_DECREF(ufunc);
        goto fail;
    }
    ufunc->type_resolver = &ErfaUFuncTypeResolver;
    PyDict_SetItemString(d, "sxpv", (PyObject *)ufunc);
    Py_DECREF(ufunc);

    goto decref;

fail:
    Py_XDECREF(m);
    m = NULL;

decref:
    Py_XDECREF(dt_double);
    Py_XDECREF(dt_int);
    Py_XDECREF(dt_pv);
    Py_XDECREF(dt_pvdpv);
    Py_XDECREF(dt_ymdf);
    Py_XDECREF(dt_hmsf);
    Py_XDECREF(dt_dmsf);
    Py_XDECREF(dt_sign);
    Py_XDECREF(dt_type);
    Py_XDECREF(dt_eraASTROM);
    Py_XDECREF(dt_eraLDBODY);
    Py_XDECREF(dt_eraLEAPSECOND);
    return m;
}