# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TestJob(Model):
    """Definition of the test job.

    :param creation_time: Gets or sets the creation time of the test job.
    :type creation_time: datetime
    :param status: Gets or sets the status of the test job.
    :type status: str
    :param status_details: Gets or sets the status details of the test job.
    :type status_details: str
    :param run_on: Gets or sets the runOn which specifies the group name where
     the job is to be executed.
    :type run_on: str
    :param start_time: Gets or sets the start time of the test job.
    :type start_time: datetime
    :param end_time: Gets or sets the end time of the test job.
    :type end_time: datetime
    :param exception: Gets or sets the exception of the test job.
    :type exception: str
    :param last_modified_time: Gets or sets the last modified time of the test
     job.
    :type last_modified_time: datetime
    :param last_status_modified_time: Gets or sets the last status modified
     time of the test job.
    :type last_status_modified_time: datetime
    :param parameters: Gets or sets the parameters of the test job.
    :type parameters: dict[str, str]
    :param log_activity_trace: The activity-level tracing options of the
     runbook.
    :type log_activity_trace: int
    """

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'run_on': {'key': 'runOn', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exception': {'key': 'exception', 'type': 'str'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'last_status_modified_time': {'key': 'lastStatusModifiedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'log_activity_trace': {'key': 'logActivityTrace', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TestJob, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.status = kwargs.get('status', None)
        self.status_details = kwargs.get('status_details', None)
        self.run_on = kwargs.get('run_on', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.exception = kwargs.get('exception', None)
        self.last_modified_time = kwargs.get('last_modified_time', None)
        self.last_status_modified_time = kwargs.get('last_status_modified_time', None)
        self.parameters = kwargs.get('parameters', None)
        self.log_activity_trace = kwargs.get('log_activity_trace', None)
