# These are the configuration parameters for Quisk using the
# SDR-IQ by RfSpace or the AMRAD Charleston Rx1 as the capture device.

# Please do not change this sample file.
# Instead copy it to your own .quisk_conf.py and make changes there.
# See quisk_conf_defaults.py for more information.

# Some decimation rates and resulting sampling frequencies:
#  Charleston decimation must be evenly divisible by four
#  Charleston 160 = 480k samples
#  Charleston 200 = 384k samples
#  Charleston 300 = 256k samples
#  Charleston 320 = 240k samples
#  Charleston 400 = 192k samples (DEFAULT)
#  Charleston 640 = 120k samples
#  Charleston 800 = 96k samples
#  SDR-IQ decimation must be 360, 500, 600, or 1250
#  SDR-IQ 360 = 185k samples (185,185)
#  SDR-IQ 500 = 133k samples (133,333)
#  SDR-IQ 600 = 111k samples (111,111)
#  SDR-IQ 1250 = 53k samples (53,333)
 
Charleston = 1		# sets up the SDR-IQ or Charleston test

if Charleston == 1:
  from charleston import  quisk_widgets  # add Charleston widgets 3.4.6 and above
  from charleston import  quisk_hardware # Use different hardware file 3.4.6 and above
  use_sdriq = 0  						# turn OFF SDR-IQ stuff 
  sdriq_name = "Digilent"				# set name, probably not necessary any more!
  playback_rate = 48000					# set playback rate
  graph_y_scale = 80			# adjust the "graphic" vertical scale
  graph_y_zero  = 75			# adjust the "graphic" vertical position
  waterfall_y_scale = 90		# adjust the "waterfall" vert scale
  waterfall_y_zero  = 70		# adjust the "waterfall" vert position
  waterfall_graph_y_scale = 100		# adjust the spectrum within "waterfall" vert scale
  waterfall_graph_y_zero = 70  		# adjust the spectrum within "waterfall" vert pos
  display_fraction = 0.90    
else:
  use_sdriq = 1   
  from sdriqpkg import quisk_hardware
  sdriq_name = "/dev/ft2450"		# Name of the SDR-IQ device to open
#  sdriq_name = "/dev/ttyUSB0"		# name of the SDR-IQ driver to open
  sdriq_clock = 66666667.0		# actual sample rate (66666667 nominal)
  sdriq_decimation = 500		# Must be 360, 500, 600, or 1250
  sample_rate = int(float(sdriq_clock) / sdriq_decimation + 0.5)  # Don't change 
  display_fraction = 0.85    
  playback_rate = 48000

# In ALSA, soundcards have these names:
#name_of_sound_play = "hw:0"
#name_of_sound_play = "hw:1"
#name_of_sound_play = "plughw"
#name_of_sound_play = "plughw:1"
#name_of_sound_play = "default"

name_of_sound_capt = ""			# We do not capture from the soundcard
name_of_sound_play = "hw:0"		# Play back on this soundcard
# Note: For the SDR-IQ, playback is stereo at 48000 Hertz.
channel_i = 0				# Soundcard index of left channel
channel_q = 1				# Soundcard index of right channel

mouse_tune_method = 1			# tune freq unchanged
graph_refresh = 7
latency_millisecs = 150
filter_display = 1			# turn on/off WB4JFI audio filter display

# note: these are here in case you want to adjust the screen colors,
#  a work in progress (WB4JFI)
# Define colors used by all widgets in wxPython colour format:
#color_bg	= 'light steel blue'	# Lower screen background
#color_graph	= 'lemonchiffon1'	# Graph background
#color_gl	= 'grey'		# Lines on the graph
#color_btn	= 'steelblue2'		# button color
#color_check_btn = 'yellow2'		# color of a check button when it is checked
#color_cycle_btn = 'goldenrod3'		# color of a cycle button when it is checked
#color_test	= 'hot pink'		# color of a button used for test (turn off for tx)
#color_freq	= 'lightcyan1'		# background color of frequency and s-meter
#color_entry	= 'lemonchiffon2'	# frequency entry box
