% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockDirectory.R
\name{lockDirectory}
\alias{lockDirectory}
\alias{unlockDirectory}
\title{Lock and unlock directories}
\usage{
lockDirectory(path, ...)

unlockDirectory(lock.info, clear = TRUE, ...)
}
\arguments{
\item{path}{String containing the path to a versioned directory.
The \code{dirname} should be the package cache while the \code{basename} should be a version number.}

\item{...}{For \code{lockDirectory}, further arguments to pass to \code{\link{lock}}.

For \code{unlockDirectory}, further arguments to pass to \code{\link{clearDirectories}}.}

\item{lock.info}{The list returned by \code{\link{lockDirectory}}.}

\item{clear}{Logical scalar indicating whether to remove expired versions via \code{\link{clearDirectories}}.}
}
\value{
\code{lockDirectory} returns a list of locking information, including lock handles generated by the \pkg{filelock} package.

\code{unlockDirectory} unlocks the handles generated by \code{lockDirectory}.
If \code{clear=TRUE}, versioned directories that have expired are removed by \code{\link{clearDirectories}}.
It returns a \code{NULL} invisibly.
}
\description{
Mark directories as locked or unlocked for thread-safe processing,
using a standard naming scheme for the lock files.
}
\details{
\code{lockDirectory} actually creates two locks:
\itemize{
\item The first lock is applied to the versioned directory (i.e., \code{basename(path)}) within the package cache (i.e., \code{dirname(path)}).
This provides thread-safe read/write on its contents, protecting against other processes that want to write to the same versioned directory.
Concurrent read operations are also permitted by setting \code{exclusive=FALSE} in \code{...} to define a shared lock..
\item The second lock is applied to the package cache and is always a shared lock, regardless of the contents of \code{...}.
This provides thread-safe access to the lock file used in the first lock,
protecting it from deletion when the relevant directory expires in \code{\link{clearDirectories}}.
}
If \code{dirname(path)} does not exist, it will be created by \code{lockDirectory}.

\code{\link{clearDirectories}} is called in \code{unlockDirectory} as the former needs to hold an exclusive lock on the package cache.
Thus, the clearing can only be performed after the shared lock created by \code{lockDirectory} is released.
}
\examples{
# Creating the relevant directories.
cache.dir <- tempfile(pattern="expired_demo")
version <- package_version("1.11.0")

handle <- lockDirectory(file.path(cache.dir, version))
handle
unlockDirectory(handle)

list.files(cache.dir)

}
\author{
Aaron Lun
}
