% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/104-getDrugKEGG.R
\name{getSmiFromKEGG}
\alias{getSmiFromKEGG}
\title{Retrieve Drug Molecules in SMILES Format from the KEGG Database}
\usage{
getSmiFromKEGG(id, parallel = 5)
}
\arguments{
\item{id}{A character vector, as the KEGG drug ID.}

\item{parallel}{An integer, the parallel parameter, indicates how many
process the user would like to use for retrieving
the data (using RCurl), default is \code{5}.
For regular cases, we recommend a number less than \code{20}.}
}
\value{
A length of \code{id} character vector,
each element containing the corresponding drug molecule.
}
\description{
Retrieve Drug Molecules in SMILES Format from the KEGG Database
}
\details{
This function retrieves drug molecules in SMILES format from the
KEGG database.
}
\examples{
id = 'D00496'  # Penicillamine
\donttest{
getSmiFromKEGG(id)}
}
\seealso{
See \code{\link{getMolFromKEGG}} for retrieving drug molecules
in MOL format from the KEGG database.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{KEGG}
\keyword{getDrug}
\keyword{getSmiFromKEGG}
