% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year-day-widen}
\alias{year-day-widen}
\alias{calendar_widen.clock_year_day}
\title{Widen: year-day}
\usage{
\method{calendar_widen}{clock_year_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_day]}

A year-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} widened to the supplied \code{precision}.
}
\description{
This is a year-day method for the \code{\link[=calendar_widen]{calendar_widen()}} generic. It
widens a year-day vector to the specified \code{precision}.
}
\examples{
# Year precision
x <- year_day(2019)
x

# Widen to day precision
calendar_widen(x, "day")

# Or second precision
sec <- calendar_widen(x, "second")
sec

# Second precision can be widened to subsecond precision
milli <- calendar_widen(sec, "millisecond")
micro <- calendar_widen(sec, "microsecond")
milli
micro

# But once you have "locked in" a subsecond precision, it can't
# be widened again
try(calendar_widen(milli, "microsecond"))
}
