# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Pack circles together
#'
#' This function is a direct interface to the circle packing algorithm used by
#' \code{\link{layout_tbl_graph_circlepack}}. It takes a vector of sizes and
#' returns the x and y position of each circle as a two-column matrix.
#'
#' @param areas A vector of circle areas
#'
#' @return A matrix with two columns and the same number of rows as the length
#' of the "areas" vector. The matrix has the following attributes added:
#' "enclosing_radius" giving the radius of the smallest enclosing circle, and
#' "front_chain" giving the terminating members of the front chain (see
#' Wang \emph{et al}. 2006).
#'
#' @references
#' Wang, W., Wang, H. H., Dai, G., & Wang, H. (2006). \emph{Visualization of
#' large hierarchical data by circle packing}. Chi, 517-520.
#'
#' @export
#'
#' @examples
#' library(ggforce)
#' sizes <- sample(10, 100, TRUE)
#'
#' position <- pack_circles(sizes)
#' data <- data.frame(x = position[,1], y = position[,2], r = sqrt(sizes/pi))
#'
#' ggplot() +
#'   geom_circle(aes(x0 = x, y0 = y, r = r), data = data, fill = 'steelblue') +
#'   geom_circle(aes(x0 = 0, y0 = 0, r = attr(position, 'enclosing_radius'))) +
#'   geom_polygon(aes(x = x, y = y),
#'                data = data[attr(position, 'front_chain'), ],
#'                fill = NA,
#'                colour = 'black')
#'
pack_circles <- function(areas) {
    .Call('_ggraph_pack', PACKAGE = 'ggraph', areas)
}

circlePackLayout <- function(parent, weight) {
    .Call('_ggraph_circlePackLayout', PACKAGE = 'ggraph', parent, weight)
}

dendrogram_spread <- function(graph, starts, y, leaf, repel, pad, ratio) {
    .Call('_ggraph_dendrogram_spread', PACKAGE = 'ggraph', graph, starts, y, leaf, repel, pad, ratio)
}

partitionTree <- function(parent, order, weight, height) {
    .Call('_ggraph_partitionTree', PACKAGE = 'ggraph', parent, order, weight, height)
}

cut_lines <- function(x, y, id, start_width, start_height, end_width, end_height, start_type, end_type) {
    .Call('_ggraph_cut_lines', PACKAGE = 'ggraph', x, y, id, start_width, start_height, end_width, end_height, start_type, end_type)
}

pathAttr <- function(paths, ngroups) {
    .Call('_ggraph_pathAttr', PACKAGE = 'ggraph', paths, ngroups)
}

splitTreemap <- function(parent, order, weight, width, height) {
    .Call('_ggraph_splitTreemap', PACKAGE = 'ggraph', parent, order, weight, width, height)
}

unrooted <- function(parent, order, length, daylight, tol, rotation_mod, maxiter) {
    .Call('_ggraph_unrooted', PACKAGE = 'ggraph', parent, order, length, daylight, tol, rotation_mod, maxiter)
}

