% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{head.git_repository}
\alias{head.git_repository}
\title{Get HEAD for a repository}
\usage{
\method{head}{git_repository}(x, ...)
}
\arguments{
\item{x}{The repository \code{x} to check head}

\item{...}{Additional arguments. Unused.}
}
\value{
NULL if unborn branch or not found. A git_branch if not a
    detached head. A git_commit if detached head
}
\description{
Get HEAD for a repository
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Commit message")

## Get HEAD of repository
head(repo)
}
}
