% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_copy.R
\name{sheet_copy}
\alias{sheet_copy}
\title{Copy a (work)sheet}
\usage{
sheet_copy(
  from_ss,
  from_sheet = NULL,
  to_ss = from_ss,
  to_sheet = NULL,
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{from_ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:as_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{from_sheet}{Sheet to copy, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number. Defaults to the first visible sheet.}

\item{to_ss}{The Sheet to copy \emph{to}. Accepts all the same types of input as
\code{from_ss}, which is also what this defaults to, if unspecified.}

\item{to_sheet}{Optional. Name of the new sheet, as a string. If you don't
specify this, Google generates a name, along the lines of "Copy of blah".
Note that sheet names must be unique within a Sheet, so if the automatic
name would violate this, Google also de-duplicates it for you, meaning you
could conceivably end up with "Copy of blah 2". If you have better ideas
about sheet names, specify \code{to_sheet}.}

\item{.before, .after}{Optional specification of where to put the new sheet. Specify, at most, one of \code{.before} and \code{.after}. Refer to an existing sheet by name (via a string) or by position (via a number). If unspecified, Sheets puts the new sheet at the end.}
}
\value{
The receiving Sheet, \verb{to_ ss}, as an instance of \code{\link{sheets_id}}.
}
\description{
Copies a (work)sheet, within its current (spread)Sheet or to another Sheet.
}
\examples{
if (gs4_has_token()) {
  ss_aaa <- gs4_create(
    "sheet-copy-demo-aaa",
    sheets = list(mtcars = head(mtcars), chickwts = head(chickwts))
  )

  # copy 'mtcars' sheet within existing Sheet, accept autogenerated name
  ss_aaa \%>\%
    sheet_copy()

  # copy 'mtcars' sheet within existing Sheet
  # specify new sheet's name and location
  ss_aaa \%>\%
    sheet_copy(to_sheet = "mtcars-the-sequel", .after = 1)

  # make a second Sheet
  ss_bbb <- gs4_create("sheet-copy-demo-bbb")

  # copy 'chickwts' sheet from first Sheet to second
  # accept auto-generated name and default location
  ss_aaa \%>\%
    sheet_copy("chickwts", to_ss = ss_bbb)

  # copy 'chickwts' sheet from first Sheet to second,
  # WITH a specific name and into a specific location
  ss_aaa \%>\%
    sheet_copy(
      "chickwts",
      to_ss = ss_bbb, to_sheet = "chicks-two", .before = 1
    )

  # clean up
  gs4_find("sheet-copy-demo") \%>\%
    googledrive::drive_trash()
}
}
\seealso{
If the copy happens within one Sheet, makes a \code{DuplicateSheetRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#duplicatesheetrequest}
}

If the copy is from one Sheet to another, wraps the
\code{spreadsheets.sheets/copyTo} endpoint:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets.sheets/copyTo}
}

and possibly makes a subsequent \code{UpdateSheetPropertiesRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#UpdateSheetPropertiesRequest}
}

Other worksheet functions: 
\code{\link{sheet_add}()},
\code{\link{sheet_append}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_properties}()},
\code{\link{sheet_relocate}()},
\code{\link{sheet_rename}()},
\code{\link{sheet_resize}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
