% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_islands}
\alias{sample_islands}
\alias{interconnected.islands.game}
\title{A graph with subgraphs that are each a random graph.}
\usage{
sample_islands(islands.n, islands.size, islands.pin, n.inter)
}
\arguments{
\item{islands.n}{The number of islands in the graph.}

\item{islands.size}{The size of islands in the graph.}

\item{islands.pin}{The probability to create each possible edge into each
island.}

\item{n.inter}{The number of edges to create between two islands.}
}
\value{
An igraph graph.
}
\description{
Create a number of Erdos-Renyi random graphs with identical parameters, and
connect them with the specified number of edges.
}
\examples{

g <- sample_islands(3, 10, 5/10, 1)
oc <- cluster_optimal(g)
oc
}
\seealso{
\code{\link{sample_gnp}}
}
\author{
Samuel Thiriot
}
\keyword{graphs}
