% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite.R
\name{bipartite_projection}
\alias{bipartite_projection}
\alias{bipartite.projection}
\alias{bipartite.projection.size}
\alias{bipartite_projection_size}
\title{Project a bipartite graph}
\usage{
bipartite_projection(
  graph,
  types = NULL,
  multiplicity = TRUE,
  probe1 = NULL,
  which = c("both", "true", "false"),
  remove.type = TRUE
)

bipartite_projection_size(graph, types = NULL)
}
\arguments{
\item{graph}{The input graph. It can be directed, but edge directions are
ignored during the computation.}

\item{types}{An optional vertex type vector to use instead of the
\sQuote{\code{type}} vertex attribute. You must supply this argument if the
graph has no \sQuote{\code{type}} vertex attribute.}

\item{multiplicity}{If \code{TRUE}, then igraph keeps the multiplicity of
the edges as an edge attribute called \sQuote{weight}.
E.g. if there is an A-C-B and also an A-D-B
triple in the bipartite graph (but no more X, such that A-X-B is also in the
graph), then the multiplicity of the A-B edge in the projection will be 2.}

\item{probe1}{This argument can be used to specify the order of the
projections in the resulting list. If given, then it is considered as a
vertex id (or a symbolic vertex name); the projection containing this vertex
will be the first one in the result list.  This argument is ignored if only
one projection is requested in argument \code{which}.}

\item{which}{A character scalar to specify which projection(s) to calculate.
The default is to calculate both.}

\item{remove.type}{Logical scalar, whether to remove the \code{type} vertex
attribute from the projections. This makes sense because these graphs are
not bipartite any more. However if you want to combine them with each other
(or other bipartite graphs), then it is worth keeping this attribute. By
default it will be removed.}
}
\value{
A list of two undirected graphs. See details above.
}
\description{
A bipartite graph is projected into two one-mode networks
}
\details{
Bipartite graphs have a \code{type} vertex attribute in igraph, this is
boolean and \code{FALSE} for the vertices of the first kind and \code{TRUE}
for vertices of the second kind.

\code{bipartite_projection_size()} calculates the number of vertices and edges
in the two projections of the bipartite graphs, without calculating the
projections themselves. This is useful to check how much memory the
projections would need if you have a large bipartite graph.

\code{bipartite_projection()} calculates the actual projections.  You can use
the \code{probe1} argument to specify the order of the projections in the
result. By default vertex type \code{FALSE} is the first and \code{TRUE} is
the second.

\code{bipartite_projection()} keeps vertex attributes.
}
\examples{

## Projection of a full bipartite graph is a full graph
g <- make_full_bipartite_graph(10, 5)
proj <- bipartite_projection(g)
graph.isomorphic(proj[[1]], make_full_graph(10))
graph.isomorphic(proj[[2]], make_full_graph(5))

## The projection keeps the vertex attributes
M <- matrix(0, nrow = 5, ncol = 3)
rownames(M) <- c("Alice", "Bob", "Cecil", "Dan", "Ethel")
colnames(M) <- c("Party", "Skiing", "Badminton")
M[] <- sample(0:1, length(M), replace = TRUE)
M
g2 <- graph_from_biadjacency_matrix(M)
g2$name <- "Event network"
proj2 <- bipartite_projection(g2)
print(proj2[[1]], g = TRUE, e = TRUE)
print(proj2[[2]], g = TRUE, e = TRUE)

}
\seealso{
Bipartite graphs
\code{\link{bipartite_mapping}()},
\code{\link{is_bipartite}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{bipartite}
\keyword{graphs}
