% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{c.igraph.vs}
\alias{c.igraph.vs}
\title{Concatenate vertex sequences}
\usage{
\method{c}{igraph.vs}(..., recursive = FALSE)
}
\arguments{
\item{...}{The vertex sequences to concatenate. They must
refer to the same graph.}

\item{recursive}{Ignored, included for S3 compatibility with
the base \code{c} function.}
}
\value{
A vertex sequence, the input sequences concatenated.
}
\description{
Concatenate vertex sequences
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
c(V(g)[1], V(g)["A"], V(g)[1:4])
}
\seealso{
Other vertex and edge sequence operations: 
\code{\link{c.igraph.es}()},
\code{\link{difference.igraph.es}()},
\code{\link{difference.igraph.vs}()},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-es-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{igraph-vs-indexing2}},
\code{\link{intersection.igraph.es}()},
\code{\link{intersection.igraph.vs}()},
\code{\link{rev.igraph.es}()},
\code{\link{rev.igraph.vs}()},
\code{\link{union.igraph.es}()},
\code{\link{union.igraph.vs}()},
\code{\link{unique.igraph.es}()},
\code{\link{unique.igraph.vs}()}
}
\concept{vertex and edge sequence operations}
