% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{graph}
\alias{graph}
\title{Create an igraph graph from a list of edges, or a notable graph}
\usage{
graph(
  edges,
  ...,
  n = max(edges),
  isolates = NULL,
  directed = TRUE,
  dir = directed,
  simplify = TRUE
)
}
\arguments{
\item{edges}{A vector defining the edges, the first edge points
from the first element to the second, the second edge from the third
to the fourth, etc. For a numeric vector, these are interpreted
as internal vertex ids. For character vectors, they are interpreted
as vertex names.

Alternatively, this can be a character scalar, the name of a
notable graph. See Notable graphs below. The name is case
insensitive.

Starting from igraph 0.8.0, you can also include literals here,
via igraph's formula notation (see \code{\link[=graph_from_literal]{graph_from_literal()}}).
In this case, the first term of the formula has to start with
a \sQuote{\code{~}} character, just like regular formulae in R.
See examples below.}

\item{...}{For \code{make_graph()}: extra arguments for the case when the
graph is given via a literal, see \code{\link[=graph_from_literal]{graph_from_literal()}}.
For \code{directed_graph()} and \code{undirected_graph()}:
Passed to \code{make_directed_graph()} or \code{make_undirected_graph()}.}

\item{n}{The number of vertices in the graph. This argument is
ignored (with a warning) if \code{edges} are symbolic vertex names. It
is also ignored if there is a bigger vertex id in \code{edges}. This
means that for this function it is safe to supply zero here if the
vertex with the largest id is not an isolate.}

\item{isolates}{Character vector, names of isolate vertices,
for symbolic edge lists. It is ignored for numeric edge lists.}

\item{directed}{Whether to create a directed graph.}

\item{dir}{It is the same as \code{directed}, for compatibility.
Do not give both of them.}

\item{simplify}{For graph literals, whether to simplify the graph.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{graph()} was renamed to \code{make_graph()} to create a more
consistent API.
}
\keyword{internal}
