% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{similarity}
\alias{similarity}
\title{Similarity measures of two vertices}
\usage{
similarity(
  graph,
  vids = V(graph),
  mode = c("all", "out", "in", "total"),
  loops = FALSE,
  method = c("jaccard", "dice", "invlogweighted")
)
}
\arguments{
\item{graph}{The input graph.}

\item{vids}{The vertex ids for which the similarity is calculated.}

\item{mode}{The type of neighboring vertices to use for the calculation,
possible values: \sQuote{\code{out}}, \sQuote{\verb{in}},
\sQuote{\code{all}}.}

\item{loops}{Whether to include vertices themselves in the neighbor
sets.}

\item{method}{The method to use.}
}
\value{
A \code{length(vids)} by \code{length(vids)} numeric matrix
containing the similarity scores. This argument is ignored by the
\code{invlogweighted} method.
}
\description{
These functions calculates similarity scores for vertices based on their
connection patterns.
}
\details{
The Jaccard similarity coefficient of two vertices is the number of common
neighbors divided by the number of vertices that are neighbors of at least
one of the two vertices being considered. The \code{jaccard} method
calculates the pairwise Jaccard similarities for some (or all) of the
vertices.

The Dice similarity coefficient of two vertices is twice the number of
common neighbors divided by the sum of the degrees of the vertices.
Methof \code{dice} calculates the pairwise Dice similarities for some
(or all) of the vertices.

The inverse log-weighted similarity of two vertices is the number of their
common neighbors, weighted by the inverse logarithm of their degrees.  It is
based on the assumption that two vertices should be considered more similar
if they share a low-degree common neighbor, since high-degree common
neighbors are more likely to appear even by pure chance.  Isolated vertices
will have zero similarity to any other vertex.  Self-similarities are not
calculated.  See the following paper for more details: Lada A. Adamic and
Eytan Adar: Friends and neighbors on the Web. Social Networks,
25(3):211-230, 2003.
}
\examples{

g <- make_ring(5)
similarity(g, method = "dice")
similarity(g, method = "jaccard")
}
\references{
Lada A. Adamic and Eytan Adar: Friends and neighbors on the Web.
\emph{Social Networks}, 25(3):211-230, 2003.
}
\seealso{
Other cocitation: 
\code{\link{cocitation}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com} for the manual page.
}
\concept{cocitation}
\concept{similarity}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/latest/igraph-Structural.html#igraph_similarity_jaccard}{\code{igraph_similarity_jaccard()}}, \href{https://igraph.org/c/html/latest/igraph-Structural.html#igraph_similarity_dice}{\code{igraph_similarity_dice()}}, \href{https://igraph.org/c/html/latest/igraph-Structural.html#igraph_similarity_inverse_log_weighted}{\code{igraph_similarity_inverse_log_weighted()}}.}

