% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowSums2.R
\name{rowSums2}
\alias{rowSums2}
\alias{colSums2}
\title{Calculates the sum for each row (column) in a matrix}
\usage{
rowSums2(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...)

colSums2(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...)
}
\arguments{
\item{x}{A \code{\link[base]{numeric}} NxK \code{\link[base]{matrix}}.}

\item{rows, cols}{A \code{\link[base]{vector}} indicating subset of rows
(and/or columns) to operate over. If \code{\link[base]{NULL}}, no subsetting
is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link[base]{NA}}s
are excluded first, otherwise not.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.}

\item{...}{Not used.}
}
\value{
Returns a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
length N (K).
}
\description{
Calculates the sum for each row (column) in a matrix.
}
\details{
The implementation of \code{rowSums2()} and \code{colSums2()} is
optimized for both speed and memory.
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
