% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_rename_xts.R
\name{rdb_rename_xts}
\alias{rdb_rename_xts}
\title{Rename the xts object columns}
\usage{
rdb_rename_xts(x, fun = NULL, ...)
}
\arguments{
\item{x}{\code{xts} object. The \code{xts} object returned by the function
\code{rdb_to_xts}.}

\item{fun}{function (default NULL). The function to apply to the column names.}

\item{...}{Arguments for the function \code{fun}.}
}
\value{
A \code{xts} object.
}
\description{
In the \code{xts} object returned by the function \code{rdb_to_xts}, the
series codes are used as column names. If you prefer the series names
(or apply a function to them), the function \code{rdb_rename_xts} is here for
that.
}
\examples{
\dontrun{
library(xts)
library(data.table)
library(rdbnomics)

df <- rdb("IMF", "BOP", mask = "A.FR+ES.BCA_BP6_EUR")
df <- rdb_to_xts(df)
rdb_rename_xts(df)
}
}
\seealso{
\code{\link{rdb}}, \code{\link{rdb_to_xts}}
}
\author{
Sebastien Galais
}
