% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_FISCH.R
\name{aux.fisch}
\alias{aux.fisch}
\title{Generate a 2-dimensional discrete Poisson matrix}
\usage{
aux.fisch(N, sparse = FALSE)
}
\arguments{
\item{N}{the number of grid points for each direction.}

\item{sparse}{a logical; \code{TRUE} for returning sparse matrix, \code{FALSE} otherwise.}
}
\value{
an \eqn{(N^2 \times N^2)} matrix having block banded structure.
}
\description{
Poisson equation is one of most well-known elliptic partial differential equations. In order to
give a concrete example, a discrete Poisson matrix is generated, assuming we have \code{N} number of
grid points for each dimension under square domain. \emph{fisch} is a German word for Poisson.
}
\examples{
## generate dense and sparse Poisson matrix of size 25 by 25.
A = aux.fisch(5, sparse=FALSE)
B = aux.fisch(5, sparse=TRUE)
(all(A==B)) # TRUE if two matrices are equal.


}
\references{
Golub, G. H. and Van Loan, C. F. (1996) \emph{Matrix Computations, 3rd Ed.}, pages 177–180.
}
