% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{RunLSI}
\alias{RunLSI}
\alias{RunLSI.default}
\alias{RunLSI.Assay}
\alias{RunLSI.Seurat}
\title{Run Latent Semantic Indexing on binary count matrix}
\usage{
RunLSI(object, ...)

\method{RunLSI}{default}(
  object,
  assay = NULL,
  n = 50,
  reduction.key = "LSI_",
  scale.max = NULL,
  seed.use = 42,
  verbose = TRUE,
  ...
)

\method{RunLSI}{Assay}(
  object,
  assay = NULL,
  features = NULL,
  n = 50,
  reduction.key = "LSI_",
  scale.max = NULL,
  verbose = TRUE,
  ...
)

\method{RunLSI}{Seurat}(
  object,
  assay = NULL,
  features = NULL,
  n = 50,
  reduction.key = "LSI_",
  reduction.name = "lsi",
  scale.max = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{...}{Arguments passed to other methods}

\item{assay}{Which assay to use. If NULL, use the default assay}

\item{n}{Number of singular values to compute}

\item{reduction.key}{Key for dimension reduction object}

\item{scale.max}{Clipping value for cell embeddings. Default (NULL) is no clipping.}

\item{seed.use}{Set a random seed. By default, sets the seed to 42. Setting
NULL will not set a seed.}

\item{verbose}{Print messages}

\item{features}{Which features to use. If NULL, use variable features}

\item{reduction.name}{Name for stored dimension reduction object. Default 'lsi'}
}
\description{
For details about stored LSI calculation parameters, see
\code{PrintLSIParams}.
}
\note{
RunLSI is being moved to Signac. Equivalent functionality can be
achieved via the Signac::RunTFIDF and Signac::RunSVD functions;
for more information on Signac, please see
\url{https://github.com/timoast/Signac}
}
\examples{
lsi <- RunLSI(object = pbmc_small, n = 5)

}
