% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CellScatter}
\alias{CellScatter}
\alias{CellPlot}
\title{Cell-cell scatter plot}
\usage{
CellScatter(
  object,
  cell1,
  cell2,
  features = NULL,
  highlight = NULL,
  cols = NULL,
  pt.size = 1,
  smooth = FALSE,
  raster = NULL,
  raster.dpi = c(512, 512)
)
}
\arguments{
\item{object}{Seurat object}

\item{cell1}{Cell 1 name}

\item{cell2}{Cell 2 name}

\item{features}{Features to plot (default, all features)}

\item{highlight}{Features to highlight}

\item{cols}{Colors to use for identity class plotting.}

\item{pt.size}{Size of the points on the plot}

\item{smooth}{Smooth the graph (similar to smoothScatter)}

\item{raster}{Convert points to raster format, default is \code{NULL}
which will automatically use raster if the number of points plotted is greater than
100,000}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}
}
\value{
A ggplot object
}
\description{
Creates a plot of scatter plot of features across two single cells. Pearson
correlation between the two cells is displayed above the plot.
}
\examples{
data("pbmc_small")
CellScatter(object = pbmc_small, cell1 = 'ATAGGAGAAACAGA', cell2 = 'CATCAGGATGCACA')

}
\concept{visualization}
