% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{LabelClusters}
\alias{LabelClusters}
\title{Label clusters on a ggplot2-based scatter plot}
\usage{
LabelClusters(
  plot,
  id,
  clusters = NULL,
  labels = NULL,
  split.by = NULL,
  repel = TRUE,
  box = FALSE,
  geom = "GeomPoint",
  position = "median",
  ...
)
}
\arguments{
\item{plot}{A ggplot2-based scatter plot}

\item{id}{Name of variable used for coloring scatter plot}

\item{clusters}{Vector of cluster ids to label}

\item{labels}{Custom labels for the clusters}

\item{split.by}{Split labels by some grouping label, useful when using
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}}

\item{repel}{Use \code{geom_text_repel} to create nicely-repelled labels}

\item{box}{Use geom_label/geom_label_repel (includes a box around the text
labels)}

\item{geom}{Name of geom to get X/Y aesthetic names for}

\item{position}{How to place the label if repel = FALSE. If "median", place
the label at the median position. If "nearest" place the label at the
position of the nearest data point to the median.}

\item{...}{Extra parameters to \code{\link[ggrepel]{geom_text_repel}}, such as \code{size}}
}
\value{
A ggplot2-based scatter plot with cluster labels
}
\description{
Label clusters on a ggplot2-based scatter plot
}
\examples{
data("pbmc_small")
plot <- DimPlot(object = pbmc_small)
LabelClusters(plot = plot, id = 'ident')

}
\seealso{
\code{\link[ggrepel]{geom_text_repel}} \code{\link[ggplot2]{geom_text}}
}
\concept{visualization}
