# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "PortFuse.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.portsmodel


# interface
class PortFuse(Interface):
    idlType = "portsmodel.PortFuse:1.0.1"

    # enumeration
    class Status(Enumeration):
        idlType = "portsmodel.PortFuse_1_0_1.Status:1.0.0"
        values = ["UNKNOWN", "TRIPPED", "GOOD"]

    Status.UNKNOWN = Status(0)
    Status.TRIPPED = Status(1)
    Status.GOOD = Status(2)

    # value object
    class StatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "portsmodel.PortFuse_1_0_1.StatusChangedEvent:1.0.0"

        def __init__(self, oldStatus=None, newStatus=None, source=None):
            super(raritan.rpc.portsmodel.PortFuse.StatusChangedEvent, self).__init__(source)
            if oldStatus is None:
                oldStatus = raritan.rpc.portsmodel.PortFuse.Status.UNKNOWN
            if newStatus is None:
                newStatus = raritan.rpc.portsmodel.PortFuse.Status.UNKNOWN
            typecheck.is_enum(oldStatus, raritan.rpc.portsmodel.PortFuse.Status, AssertionError)
            typecheck.is_enum(newStatus, raritan.rpc.portsmodel.PortFuse.Status, AssertionError)

            self.oldStatus = oldStatus
            self.newStatus = newStatus

        def encode(self):
            json = super(raritan.rpc.portsmodel.PortFuse.StatusChangedEvent, self).encode()
            json['oldStatus'] = raritan.rpc.portsmodel.PortFuse.Status.encode(self.oldStatus)
            json['newStatus'] = raritan.rpc.portsmodel.PortFuse.Status.encode(self.newStatus)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldStatus = raritan.rpc.portsmodel.PortFuse.Status.decode(json['oldStatus']) if 'oldStatus' in json or not useDefaults else raritan.rpc.portsmodel.PortFuse.Status.UNKNOWN,
                newStatus = raritan.rpc.portsmodel.PortFuse.Status.decode(json['newStatus']) if 'newStatus' in json or not useDefaults else raritan.rpc.portsmodel.PortFuse.Status.UNKNOWN,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldStatus", "newStatus"]
            elements = elements + super(raritan.rpc.portsmodel.PortFuse.StatusChangedEvent, self).listElements()
            return elements

    class _getStatus(Interface.Method):
        name = 'getStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.portsmodel.PortFuse.Status.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.portsmodel.PortFuse.Status, DecodeException)
            return _ret_

    class _reset(Interface.Method):
        name = 'reset'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getTripCount(Interface.Method):
        name = 'getTripCount'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(PortFuse, self).__init__(target, agent)
        self.getStatus = PortFuse._getStatus(self)
        self.reset = PortFuse._reset(self)
        self.getTripCount = PortFuse._getTripCount(self)

#
# Section generated by IdlC from "Port.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.portsmodel


# interface
class Port(Interface):
    idlType = "portsmodel.Port:2.0.4"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    ERR_DEVICE_BUSY = 2

    # enumeration
    class DetectionType(Enumeration):
        idlType = "portsmodel.Port_2_0_4.DetectionType:1.0.0"
        values = ["AUTO", "PINNED", "DISABLED"]

    DetectionType.AUTO = DetectionType(0)
    DetectionType.PINNED = DetectionType(1)
    DetectionType.DISABLED = DetectionType(2)

    # enumeration
    class DeviceTypeId(Enumeration):
        idlType = "portsmodel.Port_2_0_4.DeviceTypeId:1.0.0"
        values = ["UNSPECIFIED", "OTHER", "SENSOR_HUB", "BEEPER", "ASSET_STRIP", "POWER_CIM", "GATEWAY_SENSOR"]

    DeviceTypeId.UNSPECIFIED = DeviceTypeId(0)
    DeviceTypeId.OTHER = DeviceTypeId(1)
    DeviceTypeId.SENSOR_HUB = DeviceTypeId(2)
    DeviceTypeId.BEEPER = DeviceTypeId(3)
    DeviceTypeId.ASSET_STRIP = DeviceTypeId(4)
    DeviceTypeId.POWER_CIM = DeviceTypeId(5)
    DeviceTypeId.GATEWAY_SENSOR = DeviceTypeId(6)
    DeviceTypeId._fallback = DeviceTypeId.OTHER

    # structure
    class DeviceTypeWithId(Structure):
        idlType = "portsmodel.Port_2_0_4.DeviceTypeWithId:1.0.0"
        elements = ["id", "type"]

        def __init__(self, id=None, type=""):
            if id is None:
                id = raritan.rpc.portsmodel.Port.DeviceTypeId.UNSPECIFIED
            typecheck.is_enum(id, raritan.rpc.portsmodel.Port.DeviceTypeId, AssertionError)
            typecheck.is_string(type, AssertionError)

            self.id = id
            self.type = type

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = raritan.rpc.portsmodel.Port.DeviceTypeId.decode(json['id']) if 'id' in json or not useDefaults else raritan.rpc.portsmodel.Port.DeviceTypeId.UNSPECIFIED,
                type = json['type'] if 'type' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = raritan.rpc.portsmodel.Port.DeviceTypeId.encode(self.id)
            json['type'] = self.type
            return json

    # structure
    class DetectionMode(Structure):
        idlType = "portsmodel.Port_2_0_4.DetectionMode:1.0.0"
        elements = ["type", "pinnedDeviceType"]

        def __init__(self, type=None, pinnedDeviceType=""):
            if type is None:
                type = raritan.rpc.portsmodel.Port.DetectionType.AUTO
            typecheck.is_enum(type, raritan.rpc.portsmodel.Port.DetectionType, AssertionError)
            typecheck.is_string(pinnedDeviceType, AssertionError)

            self.type = type
            self.pinnedDeviceType = pinnedDeviceType

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                type = raritan.rpc.portsmodel.Port.DetectionType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.portsmodel.Port.DetectionType.AUTO,
                pinnedDeviceType = json['pinnedDeviceType'] if 'pinnedDeviceType' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.portsmodel.Port.DetectionType.encode(self.type)
            json['pinnedDeviceType'] = self.pinnedDeviceType
            return json

    # structure
    class Properties(Structure):
        idlType = "portsmodel.Port_2_0_4.Properties:1.0.0"
        elements = ["name", "label", "mode", "detectedDeviceType", "detectedDeviceName", "pinnedDeviceTypeId", "detectedDeviceTypeId", "detectableDeviceTypes", "topoId", "serialId", "portType", "position"]

        def __init__(self, name="", label="", mode=None, detectedDeviceType="", detectedDeviceName="", pinnedDeviceTypeId=None, detectedDeviceTypeId=None, detectableDeviceTypes=[], topoId="", serialId="", portType=None, position=[]):
            if mode is None:
                mode = raritan.rpc.portsmodel.Port.DetectionMode()
            if pinnedDeviceTypeId is None:
                pinnedDeviceTypeId = raritan.rpc.portsmodel.Port.DeviceTypeId.UNSPECIFIED
            if detectedDeviceTypeId is None:
                detectedDeviceTypeId = raritan.rpc.portsmodel.Port.DeviceTypeId.UNSPECIFIED
            if portType is None:
                portType = raritan.rpc.peripheral.PortType.ONBOARD
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(label, AssertionError)
            typecheck.is_struct(mode, raritan.rpc.portsmodel.Port.DetectionMode, AssertionError)
            typecheck.is_string(detectedDeviceType, AssertionError)
            typecheck.is_string(detectedDeviceName, AssertionError)
            typecheck.is_enum(pinnedDeviceTypeId, raritan.rpc.portsmodel.Port.DeviceTypeId, AssertionError)
            typecheck.is_enum(detectedDeviceTypeId, raritan.rpc.portsmodel.Port.DeviceTypeId, AssertionError)
            for x0 in detectableDeviceTypes:
                typecheck.is_struct(x0, raritan.rpc.portsmodel.Port.DeviceTypeWithId, AssertionError)
            typecheck.is_string(topoId, AssertionError)
            typecheck.is_string(serialId, AssertionError)
            typecheck.is_enum(portType, raritan.rpc.peripheral.PortType, AssertionError)
            for x0 in position:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)

            self.name = name
            self.label = label
            self.mode = mode
            self.detectedDeviceType = detectedDeviceType
            self.detectedDeviceName = detectedDeviceName
            self.pinnedDeviceTypeId = pinnedDeviceTypeId
            self.detectedDeviceTypeId = detectedDeviceTypeId
            self.detectableDeviceTypes = detectableDeviceTypes
            self.topoId = topoId
            self.serialId = serialId
            self.portType = portType
            self.position = position

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                label = json['label'] if 'label' in json or not useDefaults else "",
                mode = raritan.rpc.portsmodel.Port.DetectionMode.decode(json['mode'], agent, useDefaults=useDefaults) if 'mode' in json or not useDefaults else raritan.rpc.portsmodel.Port.DetectionMode(),
                detectedDeviceType = json['detectedDeviceType'] if 'detectedDeviceType' in json or not useDefaults else "",
                detectedDeviceName = json['detectedDeviceName'] if 'detectedDeviceName' in json or not useDefaults else "",
                pinnedDeviceTypeId = raritan.rpc.portsmodel.Port.DeviceTypeId.decode(json['pinnedDeviceTypeId']) if 'pinnedDeviceTypeId' in json or not useDefaults else raritan.rpc.portsmodel.Port.DeviceTypeId.UNSPECIFIED,
                detectedDeviceTypeId = raritan.rpc.portsmodel.Port.DeviceTypeId.decode(json['detectedDeviceTypeId']) if 'detectedDeviceTypeId' in json or not useDefaults else raritan.rpc.portsmodel.Port.DeviceTypeId.UNSPECIFIED,
                detectableDeviceTypes = [raritan.rpc.portsmodel.Port.DeviceTypeWithId.decode(x0, agent, useDefaults=useDefaults) for x0 in json['detectableDeviceTypes']] if 'detectableDeviceTypes' in json or not useDefaults else [],
                topoId = json['topoId'] if 'topoId' in json or not useDefaults else "",
                serialId = json['serialId'] if 'serialId' in json or not useDefaults else "",
                portType = raritan.rpc.peripheral.PortType.decode(json['portType']) if 'portType' in json or not useDefaults else raritan.rpc.peripheral.PortType.ONBOARD,
                position = [raritan.rpc.peripheral.PosElement.decode(x0, agent, useDefaults=useDefaults) for x0 in json['position']] if 'position' in json or not useDefaults else [],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['label'] = self.label
            json['mode'] = raritan.rpc.portsmodel.Port.DetectionMode.encode(self.mode)
            json['detectedDeviceType'] = self.detectedDeviceType
            json['detectedDeviceName'] = self.detectedDeviceName
            json['pinnedDeviceTypeId'] = raritan.rpc.portsmodel.Port.DeviceTypeId.encode(self.pinnedDeviceTypeId)
            json['detectedDeviceTypeId'] = raritan.rpc.portsmodel.Port.DeviceTypeId.encode(self.detectedDeviceTypeId)
            json['detectableDeviceTypes'] = [raritan.rpc.portsmodel.Port.DeviceTypeWithId.encode(x0) for x0 in self.detectableDeviceTypes]
            json['topoId'] = self.topoId
            json['serialId'] = self.serialId
            json['portType'] = raritan.rpc.peripheral.PortType.encode(self.portType)
            json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
            return json

    # value object
    class PropertiesChangedEvent(raritan.rpc.idl.Event):
        idlType = "portsmodel.Port_2_0_4.PropertiesChangedEvent:1.0.0"

        def __init__(self, oldProperties=None, newProperties=None, source=None):
            super(raritan.rpc.portsmodel.Port.PropertiesChangedEvent, self).__init__(source)
            if oldProperties is None:
                oldProperties = raritan.rpc.portsmodel.Port.Properties()
            if newProperties is None:
                newProperties = raritan.rpc.portsmodel.Port.Properties()
            typecheck.is_struct(oldProperties, raritan.rpc.portsmodel.Port.Properties, AssertionError)
            typecheck.is_struct(newProperties, raritan.rpc.portsmodel.Port.Properties, AssertionError)

            self.oldProperties = oldProperties
            self.newProperties = newProperties

        def encode(self):
            json = super(raritan.rpc.portsmodel.Port.PropertiesChangedEvent, self).encode()
            json['oldProperties'] = raritan.rpc.portsmodel.Port.Properties.encode(self.oldProperties)
            json['newProperties'] = raritan.rpc.portsmodel.Port.Properties.encode(self.newProperties)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldProperties = raritan.rpc.portsmodel.Port.Properties.decode(json['oldProperties'], agent, useDefaults=useDefaults) if 'oldProperties' in json or not useDefaults else raritan.rpc.portsmodel.Port.Properties(),
                newProperties = raritan.rpc.portsmodel.Port.Properties.decode(json['newProperties'], agent, useDefaults=useDefaults) if 'newProperties' in json or not useDefaults else raritan.rpc.portsmodel.Port.Properties(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldProperties", "newProperties"]
            elements = elements + super(raritan.rpc.portsmodel.Port.PropertiesChangedEvent, self).listElements()
            return elements

    # value object
    class DeviceChangedEvent(raritan.rpc.idl.Event):
        idlType = "portsmodel.Port_2_0_4.DeviceChangedEvent:1.0.0"

        def __init__(self, oldDevice=None, newDevice=None, source=None):
            super(raritan.rpc.portsmodel.Port.DeviceChangedEvent, self).__init__(source)
            typecheck.is_remote_obj(oldDevice, AssertionError)
            typecheck.is_remote_obj(newDevice, AssertionError)

            self.oldDevice = oldDevice
            self.newDevice = newDevice

        def encode(self):
            json = super(raritan.rpc.portsmodel.Port.DeviceChangedEvent, self).encode()
            json['oldDevice'] = Interface.encode(self.oldDevice)
            json['newDevice'] = Interface.encode(self.newDevice)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldDevice = Interface.decode(json['oldDevice'], agent) if 'oldDevice' in json or not useDefaults else None,
                newDevice = Interface.decode(json['newDevice'], agent) if 'newDevice' in json or not useDefaults else None,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldDevice", "newDevice"]
            elements = elements + super(raritan.rpc.portsmodel.Port.DeviceChangedEvent, self).listElements()
            return elements

    class _getProperties(Interface.Method):
        name = 'getProperties'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.portsmodel.Port.Properties.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.portsmodel.Port.Properties, DecodeException)
            return _ret_

    class _setName(Interface.Method):
        name = 'setName'

        @staticmethod
        def encode(name):
            typecheck.is_string(name, AssertionError)
            args = {}
            args['name'] = name
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _setDetectionMode(Interface.Method):
        name = 'setDetectionMode'

        @staticmethod
        def encode(mode):
            typecheck.is_struct(mode, raritan.rpc.portsmodel.Port.DetectionMode, AssertionError)
            args = {}
            args['mode'] = raritan.rpc.portsmodel.Port.DetectionMode.encode(mode)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getDetectableDevices(Interface.Method):
        name = 'getDetectableDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getDevice(Interface.Method):
        name = 'getDevice'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_remote_obj(_ret_, DecodeException)
            return _ret_

    class _getDeviceConfig(Interface.Method):
        name = 'getDeviceConfig'

        @staticmethod
        def encode(deviceType):
            typecheck.is_string(deviceType, AssertionError)
            args = {}
            args['deviceType'] = deviceType
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_remote_obj(_ret_, DecodeException)
            return _ret_

    class _getFuse(Interface.Method):
        name = 'getFuse'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.portsmodel.PortFuse, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Port, self).__init__(target, agent)
        self.getProperties = Port._getProperties(self)
        self.setName = Port._setName(self)
        self.setDetectionMode = Port._setDetectionMode(self)
        self.getDetectableDevices = Port._getDetectableDevices(self)
        self.getDevice = Port._getDevice(self)
        self.getDeviceConfig = Port._getDeviceConfig(self)
        self.getFuse = Port._getFuse(self)
