/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file UserData.h
    \author Romain BONDUE
    \date 03/08/2005 */
#ifndef __USERDATA_H__
#define __USERDATA_H__

#include <string>
#include <ostream>
#include <vector>
#include <stdexcept>

#include "XMLParser.h"
#include "Parameters.h"
#include "Exceptions.h"



namespace nsUserData
{
    extern const std::string AppDirectory;

    void MakeAppDirectory () throw (nsErrors::CSystemExc);


        // Could have been more beautiful...
    enum IPSetting_e {None, Dhcp, Static};

    class CIPSettings
    {
      public :
        CIPSettings (IPSetting_e = None) throw();
        IPSetting_e GetSetting () const throw();
        void SetSetting (IPSetting_e) throw();


      private :
        IPSetting_e m_Setting;

    }; // CIPSettings


    class CProfile
    {
      public :
        CProfile (const std::string& = std::string()) throw();
        CProfile (const std::string&, const nsWireless::CCell&)
                                                        throw (std::bad_alloc);
        ~CProfile () throw();

        const std::string& GetName () const throw();
        const std::string& GetSSID () const throw();
        nsWireless::Mode_e GetMode () const throw();
        unsigned GetChannel () const throw();
        const nsWireless::CEncryptionD& GetEncryptionD () const throw();
        nsWireless::CEncryptionD& GetEncryptionD () throw();
        CIPSettings& GetIPSettings () throw();
        const CIPSettings& GetIPSettings () const throw();

        void SetName (const std::string&) throw();
        void SetSSID (const std::string&) throw();
        void SetMode (nsWireless::Mode_e) throw();
        void SetChannel (unsigned) throw();
        void SetEncryptionD (const nsWireless::CEncryptionD&);

        bool Match (const nsWireless::CCell&) const throw();


      private :
        std::string m_Name;
        std::string m_SSID;
        nsWireless::Mode_e m_Mode;
        unsigned m_Channel;
        nsWireless::CEncryptionD m_EncryptionD;
        CIPSettings m_IPSettings;

    }; // CProfile


    class CProfilesFile : private CXMLParser
    {
      public :
        CProfilesFile () throw (nsErrors::CSystemExc);
        ~CProfilesFile () throw();

        void Extract () throw (nsErrors::CException);
        void Record () throw (nsErrors::CException);
        void NewProfile (const char*) throw();
        void NewProfile (const char*, const nsWireless::CCell&) throw();
        void DeleteLastProfile () throw();
        /** \warning No bound check! */
        void DeleteProfile (unsigned Pos) throw();
        /** \warning No bound check! */
        CProfile& GetProfile (unsigned) throw();
        const CProfile& GetProfile (unsigned) const throw();
        unsigned Size () const throw();


      private :
            // For extracting :
        void StartElement (const char*, const char**, const char**)
                                throw (std::bad_alloc, nsErrors::CException);
        void EndElement (const char*) throw (nsErrors::CException);
        void Text (const char*, const std::string&)
                                                throw (nsErrors::CException);
        void Error () throw();
            // For recording :
        const char* GetRootMarkupLabel () const throw();
        void RecordFields (std::ostream&, unsigned)
                                                throw (std::ios_base::failure);

        static const char* const Indentation;

        std::vector<CProfile> m_Profiles;

    }; // CProfilesFile

} // namespace nsUserData

#include "private/UserData.hxx"

#endif // __USERDATA_H__
