/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file UserData.hxx
    \author Romain BONDUE
    \date 05/07/2005
    \warning This file should only be included from UserData.h */
#ifndef NDEBUG
#include <iostream>
#endif // NDEBUG
#include <cerrno> // EEXIST

extern "C"{
#include <sys/stat.h> // ::mkdir()
}



inline nsUserData::CProfile::CProfile (const std::string& Name) throw()
    : m_Name (Name), m_Mode (nsWireless::Managed), m_Channel (1),
      m_IPSettings (Dhcp) {}


inline nsUserData::CProfile::~CProfile () throw() {}


inline const std::string& nsUserData::CProfile::GetName () const throw()
{
    return m_Name;

} // GetName()


inline const std::string& nsUserData::CProfile::GetSSID () const throw()
{
    return m_SSID;

} // GetSSID()


inline nsWireless::Mode_e nsUserData::CProfile::GetMode () const throw()
{
    return m_Mode;

} // GetMode()


inline unsigned nsUserData::CProfile::GetChannel () const throw()
{
    return m_Channel;

} // GetChannel()


inline const nsWireless::CEncryptionD& nsUserData::CProfile::GetEncryptionD ()
                                                                const throw()
{
    return m_EncryptionD;

} // GetEncryptionD()


inline nsWireless::CEncryptionD& nsUserData::CProfile::GetEncryptionD ()
                                                                        throw()
{
    return m_EncryptionD;

} // GetEncryptionD()


inline void nsUserData::CProfile::SetName (const std::string& Name) throw()
{
    m_Name = Name;

} // SetName()


inline void nsUserData::CProfile::SetSSID (const std::string& SSID) throw()
{
    m_SSID = SSID;

} // SetSSID()


inline void nsUserData::CProfile::SetMode (nsWireless::Mode_e Mode) throw()
{
    m_Mode = Mode;

} // SetMode()


inline void nsUserData::CProfile::SetChannel (unsigned Channel) throw()
{
    m_Channel = Channel;

} // SetChannel()


inline void nsUserData::CProfile::SetEncryptionD
                                            (const nsWireless::CEncryptionD& D)
{
    m_EncryptionD = D;

} // SetEncryptionD()


inline nsUserData::CIPSettings& nsUserData::CProfile::GetIPSettings () throw()
{
    return m_IPSettings;

} // GetIPSettings()


inline const nsUserData::CIPSettings& nsUserData::CProfile::GetIPSettings ()
                                                                const throw()
{
    return m_IPSettings;

} // GetIPSettings()


inline nsUserData::CProfilesFile::~CProfilesFile () throw() {}


inline void nsUserData::CProfilesFile::Error () throw()
{     // We remove the last CProfile as it may be invalid.
    DeleteLastProfile();

} // Error()


inline nsUserData::CProfile& nsUserData::CProfilesFile::GetProfile
                                                        (unsigned Pos) throw()
{
#ifndef NDEBUG
    try
    {
        return m_Profiles.at (Pos);
    }
    catch (const std::out_of_range& Exc)
    {
        std::cerr << Exc.what() << "\tAccessing profile index : " << Pos
                  << ", but there are only " << m_Profiles.size()
                  << " profiles." << std::endl;
    }
#endif // NDEBUG
    return m_Profiles [Pos];

} // GetProfile()


inline const nsUserData::CProfile& nsUserData::CProfilesFile::GetProfile
                                                    (unsigned Pos) const throw()
{
#ifndef NDEBUG
    try
    {
        return m_Profiles.at (Pos);
    }
    catch (const std::out_of_range& Exc)
    {
        std::cerr << Exc.what() << "\tAccessing profile index : " << Pos
                  << ", but there are only " << m_Profiles.size()
                  << " profiles." << std::endl;
    }
#endif // NDEBUG
    return m_Profiles [Pos];

} // GetProfile()


inline unsigned nsUserData::CProfilesFile::Size () const throw()
{
    return m_Profiles.size();

} // Size()


inline void nsUserData::CProfilesFile::NewProfile (const char* Name) throw()
{
    m_Profiles.push_back (CProfile (Name));

} // NewProfile()


inline void nsUserData::CProfilesFile::NewProfile (const char* Name,
                                        const nsWireless::CCell& Cell) throw()
{
    try{m_Profiles.push_back (CProfile (Name, Cell));}
    catch (std::bad_alloc) {m_Profiles.push_back (CProfile (Name));}

} // NewProfile()


inline void nsUserData::CProfilesFile::DeleteLastProfile () throw()
{
    if (!m_Profiles.empty()) m_Profiles.erase (--m_Profiles.end());

} // DeleteLastProfile()


inline void nsUserData::CProfilesFile::DeleteProfile (unsigned Pos) throw()
{
    m_Profiles.erase (m_Profiles.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CIPSettings::CIPSettings (IPSetting_e Setting) throw()
    : m_Setting (Setting) {}


inline nsUserData::IPSetting_e nsUserData::CIPSettings::GetSetting () const
                                                                        throw()
{
    return m_Setting;

} // GetSetting()


inline void nsUserData::CIPSettings::SetSetting (IPSetting_e Setting) throw()
{
    m_Setting = Setting;

} // SetSetting()
