#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

proc DS9Def {} {
    global ds9
    global pds9

    set ds9(title) "$ds9(app)"
    set ds9(version) {7.2}

    set ds9(top) .
    set ds9(mb) .mb

    set ds9(visual) {}
    set ds9(depth) 8
    set ds9(FTY_MAXAXES) 10

    set ds9(helvetica) [font configure TkDefaultFont -family]
    set ds9(courier) [font configure TkFixedFont -family]
    set ds9(times) times

    # These look better if normal weight
    font configure TkCaptionFont -weight normal
    font configure TkHeadingFont -weight normal

    eval font create DefaultFont [font actual TkDefaultFont]
    eval font create DefaultMenuFont [font actual TkMenuFont]
    eval font create DefaultTextFont [font actual TkTextFont]

    set ds9(main) {}
    set ds9(image) {}
    set ds9(canvas) {}
    set ds9(panel) {}
    set ds9(info) {}
    set ds9(panner) {}
    set ds9(magnifier) {}
    set ds9(buttons) {}
    set ds9(graph,sp) {}
    set ds9(graph,horz) {}
    set ds9(graph,vert) {}

    set ds9(frames) {}
    set ds9(active) {}
    set ds9(active,num) 0
    set ds9(lock) 0
    set ds9(next) {}
    set ds9(next,num) 1
    set ds9(last) {}

    set ds9(event,opendoc) {}
    set ds9(event,printdoc) {}

    set ds9(dialog,dir) {}
    set ds9(tmpdir) {}

    switch $ds9(wm) {
	x11 -
	win32 {
	    set ds9(menu,start) 1
	}
	aqua {
	    set ds9(menu,start) 0
	}
    }
    set ds9(menu,size,frame,goto) [expr $ds9(menu,start)+0]
    set ds9(menu,size,frame,active) [expr $ds9(menu,start)+3]
    set ds9(menu,size,analysis) [expr $ds9(menu,start)+31]
    set ds9(menu,size,wrap) 20

    set ds9(display) single
    set ds9(bg) white

    set ds9(array,x) 512
    set ds9(array,y) 512
    set ds9(array,bitpix) -32
    set ds9(array,skip) 0
    set ds9(array,arch) bigendian

    set ds9(idletasks) 1

    set ds9(row) -1
    set ds9(freeze) 0

    set ds9(b1) 0
    set ds9(b2) 0
    set ds9(b3) 0

    set ds9(sb1) 0
    set ds9(sb2) 0
    set ds9(sb3) 0

    set ds9(cb1) 0
    set ds9(cb2) 0
    set ds9(cb3) 0

    set ds9(csb1) 0
    set ds9(csb2) 0
    set ds9(csb3) 0

    set ds9(modifier) 0

    set ds9(ext,file) ".$ds9(app).fil"
    set ds9(ext,alt) ".$ds9(app).file"

    set ds9(msg) {}
    set ds9(msg,level) info
    set ds9(msg,src) {}
    set ds9(msg,timeout) 1000

    set ds9(prefs) 0

    switch $ds9(wm) {
	x11 {
	    set ds9(ctrl) "Control-"
	    set ds9(shiftctrl) "Shift-Control-"
	}
	win32 {
	    set ds9(ctrl) "Control-"
	    set ds9(shiftctrl) "Shift-Control-"
	} 
	aqua {
	    set ds9(ctrl) "Command-"
	    set ds9(shiftctrl) "Shift-Command-"
	}
    }

    # prefs only
    set pds9(font) helvetica
    set pds9(font,size) [PixelsToPoints [font configure TkDefaultFont -size]]
    set pds9(font,weight) [font configure TkDefaultFont -weight]
    set pds9(font,slant) [font configure TkDefaultFont -slant]

    set pds9(text,font) courier
    set pds9(text,font,size) [PixelsToPoints [font actual TkFixedFont -size]]
    set pds9(text,font,weight) [font actual TkFixedFont -weight]
    set pds9(text,font,slant) [font actual TkFixedFont -slant]

    set pds9(backup) 1
    set pds9(automarker) 1
    set pds9(tcl) 0
    set pds9(xpa) 1
    set pds9(samp) 1
    set pds9(confirm) 1
    set pds9(bg) white
    set pds9(nan) white
    switch $ds9(wm) {
	x11 {set pds9(dialog) motif}
	win32 {set pds9(dialog) native}
	aqua {set pds9(dialog) native}
    }
    set pds9(dialog,center) 0
    set pds9(dialog,all) 0
    set pds9(language) locale
    set pds9(language,name) [LanguageToName $pds9(language)]
    set pds9(language,dir) {}

    set pds9(theme) native
    set pds9(threads) 8
}

# who are we?
set ds9(app) [file rootname [file tail $argv0]]
# if we have a problem at this point, dump simple message and exit
if {[catch {tk windowingsystem} ds9(wm)]} {
    puts stderr "Unable to initialize window system."
    exit
}

# Styles
set ds9(app,bg) [ttk::style lookup "." -background]

switch $ds9(wm) {
    x11 {
	# change just default style
	ttk::style theme settings default \
	    [list ;
	     ttk::style configure TLabel -borderwidth 2 -padding 1;
	     ttk::style configure TEntry -fieldbackground $ds9(app,bg) -padding 1;
	    ]
    }
    win32 {}
    aqua {}
}

# set to absolute path so that if -cd command is used,
# so we can still find our files
set ds9(root) "[pwd]/zvfsmntpt"

# tcl modules
if {![namespace exists msgcat]} {
    source $ds9(root)/tcl8/8.5/msgcat-1.4.3.tm
}
if {![namespace exists http]} {
    source $ds9(root)/tcl8/8.4/http-2.7.5.tm
}

source $ds9(root)/tk8.5/tearoff.tcl
source $ds9(root)/tk8.5/comdlg.tcl
source $ds9(root)/tk8.5/focus.tcl
source $ds9(root)/tk8.5/msgbox.tcl

source $ds9(root)/tcllib1.14/base64/base64.tcl
source $ds9(root)/tcllib1.14/log/log.tcl
source $ds9(root)/tcllib1.14/ftp/ftp.tcl
source $ds9(root)/tcllib1.14/textutil/repeat.tcl
source $ds9(root)/tcllib1.14/textutil/tabify.tcl
source $ds9(root)/tcllib1.14/math/fuzzy.tcl

source $ds9(root)/tkcon2.5/tkcon.tcl
source $ds9(root)/xmlrpc0.3/xmlrpc.tcl
source $ds9(root)/blt3.0/graph.tcl

source $ds9(root)/src/source.tcl

# fix ::tk and msgcat
rename ::tk::msgcat::mc {}
rename ::tk::msgcat::mcmax {}

namespace import ::msgcat::mc
namespace import ::msgcat::mcmax
::msgcat::mcload [file join $::tk_library msgs]

# fix ::tk::dialog::file
set ::tk::dialog::file::showHiddenVar 0
set ::tk::dialog::file::showHiddenBtn 1

# Define Variables
DS9Def
2MASSDef
3DDef
AnalysisDef
BinDef
BlinkDef
ButtonsDef
CanvasDef
CATDef
CATSymDef
CATCDSSrchDef
CentroidDef
ColorbarDef
ContourDef
CoordDef
CrosshairDef
CubeDef
CurrentDef
CursorDef
DebugDef 
ESODef
ExamineDef
ExportDef
FIRSTDef
GraphDef
GridDef
GroupDef
HelpDef
HTTPDef
HVDef
IISDef
ImexamDef
MagnifierDef
MarkerDef
MaskDef
MinMaxDef
MovieDef
NRESDef
NVSSDef
PannerDef
PanZoomDef
CropDef
PixelDef
PlotDef
PrefsDef
PSDef
RGBDef
SAMPDef
SAODef
SaveDef
SaveImageDef
ScaleDef
SkyViewDef
SmoothDef
STSCIDef
TemplateDef
TileDef
ViewDef
VODef
WCSDef
ZScaleDef

# let's start
set ds9(init) 1

# set up signal trap
# not supported under windows
switch $tcl_platform(platform) {
    unix {signal add SIGINT QuitDS9}
    windows {}
}

# set the appname
tk appname $ds9(app)

# environment vars
# we don't want to see any error messages if xpa is not available
if { [info exists env(XPA_VERBOSITY)] == 0 } {
  set env(XPA_VERBOSITY) 0
}
# set filter ptype to contained (default is process)
set env(FILTER_PTYPE) c
# set filter error proc so it will not kill ds9
set env(GERROR) 0

# Events
switch $ds9(wm) {
    x11 {}
    win32 {}
    aqua {
	event add <<Redo>> <Command-Key-Z>
	bind $ds9(top) <$ds9(ctrl)-`> "lower $ds9(top)"
    }
}
event add <<Open>> <${ds9(ctrl)}o>
event add <<PageSetup>> <${ds9(ctrl)}P>
event add <<Print>> <${ds9(ctrl)}p>
event add <<SelectAll>> <${ds9(ctrl)}a>
event add <<Find>> <${ds9(ctrl)}f>
event add <<FindNext>> <${ds9(ctrl)}g>

# Init Temporary Dir before prefs
InitTempDir

# Init the filter compiler
InitFilterCompiler

# Load any preferences here, before we do any real work
LoadPrefs

# adjust default canvas size based on layout
switch $view(layout) {
    horizontal {
	set canvas(width) 680
	set canvas(height) 450
    }
    vertical {
	set canvas(width) 540
	set canvas(height) 646
    }
}

switch $ds9(wm) {
    x11 -
    win32 {}
    aqua {
	::tk::unsupported::MacWindowStyle style $ds9(top) document "closeBox fullZoom collapseBox resizable"
	# we need to map the top window so we can get the proper truecolor masks
	update idletasks
    }
}

# We want to withdraw the window til everything is ready to go
wm withdraw $ds9(top)

wm title $ds9(top) "SAOImage $ds9(title)"
wm iconname $ds9(top) "SAOImage $ds9(title)"
wm protocol $ds9(top) WM_DELETE_WINDOW QuitDS9
$ds9(top) configure -menu $ds9(mb)

# Theme
PrefsTheme

# we need to set certain variables before anything else
# such as color, title, language
ProcessCommandLineFirst

# initialize language
switch $pds9(language) {
    locale {
	switch $ds9(wm) {
	    aqua {
		foreach ll [MacOSXGetLocale] {
		    if {[SetLanguage $ll]} {
			break
		    }
		}
	    }
	    x11 {
		foreach ee {LC_MESSAGES LC_ALL LANG} {
		    if {[info exists env($ee)]} {
			set ll [string tolower [string range $env($ee) 0 1]]
			if {[SetLanguage $ll]} {
			    break
			}
		    }
		}
	    }
	    win32 {}
	}
    }
    default {SetLanguage $pds9(language)}
}

# set the visual
set ds9(visual) [winfo visual .]
set ds9(depth) [winfo depth .]

switch $ds9(wm) {
    x11 {
	if {$ds9(depth)==15} {
	    set ds9(depth) 16
	}
	if {$ds9(depth)==32} {
	    set ds9(depth) 24
	}
    } 
    win32 {
	if {$ds9(depth)==32} {
	    set ds9(depth) 24
	}
    }
    aqua {
	if {$ds9(depth)==15} {
	    set ds9(depth) 16
	}
    }
}

switch -- $ds9(visual)$ds9(depth) {
    pseudocolor8 {}
    truecolor8 {}
    truecolor16 {}
    truecolor24 {}
    default {BadVisualError}
}

# create our main frame
set ds9(main) [ttk::frame ${ds9(top)}ds9]
pack $ds9(main) -fill both -expand true

# Create image canvas
CreateCanvas

# Create Colorbar-- Create this first, so in case of a private colormap,
# gui colors will be allocated in the new colormap, not the default colormap
CreateColorbar

# Create other parts of the display
CreateMenuBar
CreateInfoPanel
CreatePanner
CreateMagnifier
CreateButtons
CreateGraphs

# Make sure that the wm knows when to swap in the colormap (if needed)
wm colormapwindows . "$ds9(main) $ds9(canvas)"

# Initialize the display
InitColorbar
InitPanner
InitDialogBox

# Set our current state of things
ChangeMode

# force a update, then layout
update
ConfigureView

# our first frame
CreateFrame

# do this last so we don't get an ConfigureView event
InitCanvas

# ok, ready to show the window
wm deiconify $ds9(top)
update

# Init external File Formats
# we want this before processing the command line
InitExternalFile

# Init analysis file formats
InitAnalysisFile

# Configure HTTP
ConfigHTTP

# SAMP
InitSAMP

# XPA
InitXPA

# and process any command line items
# we want to see something before any fits files are loaded
ProcessCommandLine

# Initialize IIS
# after command line options to set port/fifo/unix...
catch {IISInit}

# any os events received?
switch $ds9(wm) {
    x11 {}
    win32 {}
    aqua {
	MacOSXOpenDocEvent 0
	MacOSXPrintDocEvent 1
    }
}

# Load any initalization tcl code
SourceInitFile {.ini}

# do we have the correct prefs file?
CheckPrefs

# any post-prefs work?
PostPrefs

# kludge for aqua. We need to trigger the trap to update buttons vars
switch $ds9(wm) {
    x11 -
    win32 {}
    aqua {
	set current(display) $current(display)
	set colorbar(map) $colorbar(map)
    }
}

# start error monitor
after $ds9(msg,timeout) [list ErrorTimer]

# ok, we're done
set ds9(init) 0

