// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2013 - Scilab Enterprises - Antoine ELIAS
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
// <-- CLI SHELL MODE -->
//
// <-- Non-regression test for bug 14313 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/14313
//
// <-- Short Description -->
// Parser did not interpret a space before ... as a column separator in matrices

r1 = [1, ...
2, ...
-1, ...
-2, ...
3];

r2 = [1 ...
2 ...
-1 ...
-2 ...
3];
assert_checkequal(r1, r2);

r_i1 = ...
     [0.000000000000E+00, ...
      0.586655087100E-01, ...
      0.450322755820E-04, ...
      0.289084072120E-07, ...
     -0.330568966520E-09, ...
      0.650244032700E-12, ...
     -0.191974955040E-15, ...
     -0.125366004970E-17, ...
      0.214892175690E-20, ...
     -0.143880417820E-23, ...
      0.359608994810E-27];

r_i2 = ...
     [0.000000000000E+00 ...
      0.586655087100E-01 ...
      0.450322755820E-04 ...
      0.289084072120E-07 ...
     -0.330568966520E-09 ...
      0.650244032700E-12 ...
     -0.191974955040E-15 ...
     -0.125366004970E-17 ...
      0.214892175690E-20 ...
     -0.143880417820E-23 ...
      0.359608994810E-27];

assert_checkequal(r_i1, r_i2);

a = 3;
r1 = [a...
 -1];
r2 = [a, ...
 -1];
r3 = [a...
-1];

assert_checkequal(r1, r2);
assert_checkequal(r3, 2);
