/* This file contains the CIE XYZ 1931 Standard Observer curves */
/* sampled at 1 nm intervals, from 360 nm to 830 nm. This data  */
/* obtained from:  http://www.cis.rit.edu/mcsl/online/cie.php   */

#ifndef CIE_XYZ_STANDARD_OBSERVER_1NM_H
#define CIE_XYZ_STANDARD_OBSERVER_1NM_H

static float const xyz1931_1nm[471][3] = {
    { 0.000130f, 0.000004f, 0.000606f },    // 360 nm
    { 0.000146f, 0.000004f, 0.000681f },    // 361 nm
    { 0.000164f, 0.000005f, 0.000765f },    // 362 nm
    { 0.000184f, 0.000006f, 0.000860f },    // 363 nm
    { 0.000207f, 0.000006f, 0.000967f },    // 364 nm
    { 0.000232f, 0.000007f, 0.001086f },    // 365 nm
    { 0.000261f, 0.000008f, 0.001221f },    // 366 nm
    { 0.000293f, 0.000009f, 0.001373f },    // 367 nm
    { 0.000329f, 0.000010f, 0.001544f },    // 368 nm
    { 0.000370f, 0.000011f, 0.001734f },    // 369 nm
    { 0.000415f, 0.000012f, 0.001946f },    // 370 nm
    { 0.000464f, 0.000014f, 0.002178f },    // 371 nm
    { 0.000519f, 0.000016f, 0.002436f },    // 372 nm
    { 0.000582f, 0.000017f, 0.002732f },    // 373 nm
    { 0.000655f, 0.000020f, 0.003078f },    // 374 nm
    { 0.000742f, 0.000022f, 0.003486f },    // 375 nm
    { 0.000845f, 0.000025f, 0.003975f },    // 376 nm
    { 0.000965f, 0.000028f, 0.004541f },    // 377 nm
    { 0.001095f, 0.000032f, 0.005158f },    // 378 nm
    { 0.001231f, 0.000035f, 0.005803f },    // 379 nm
    { 0.001368f, 0.000039f, 0.006450f },    // 380 nm
    { 0.001502f, 0.000043f, 0.007083f },    // 381 nm
    { 0.001642f, 0.000047f, 0.007746f },    // 382 nm
    { 0.001802f, 0.000052f, 0.008501f },    // 383 nm
    { 0.001996f, 0.000057f, 0.009414f },    // 384 nm
    { 0.002236f, 0.000064f, 0.010550f },    // 385 nm
    { 0.002535f, 0.000072f, 0.011966f },    // 386 nm
    { 0.002893f, 0.000082f, 0.013656f },    // 387 nm
    { 0.003301f, 0.000094f, 0.015588f },    // 388 nm
    { 0.003753f, 0.000106f, 0.017730f },    // 389 nm
    { 0.004243f, 0.000120f, 0.020050f },    // 390 nm
    { 0.004762f, 0.000135f, 0.022511f },    // 391 nm
    { 0.005330f, 0.000152f, 0.025203f },    // 392 nm
    { 0.005979f, 0.000170f, 0.028280f },    // 393 nm
    { 0.006741f, 0.000192f, 0.031897f },    // 394 nm
    { 0.007650f, 0.000217f, 0.036210f },    // 395 nm
    { 0.008751f, 0.000247f, 0.041438f },    // 396 nm
    { 0.010029f, 0.000281f, 0.047504f },    // 397 nm
    { 0.011422f, 0.000319f, 0.054120f },    // 398 nm
    { 0.012869f, 0.000357f, 0.060998f },    // 399 nm
    { 0.014310f, 0.000396f, 0.067850f },    // 400 nm
    { 0.015704f, 0.000434f, 0.074486f },    // 401 nm
    { 0.017147f, 0.000473f, 0.081362f },    // 402 nm
    { 0.018781f, 0.000518f, 0.089154f },    // 403 nm
    { 0.020748f, 0.000572f, 0.098540f },    // 404 nm
    { 0.023190f, 0.000640f, 0.110200f },    // 405 nm
    { 0.026207f, 0.000725f, 0.124613f },    // 406 nm
    { 0.029783f, 0.000825f, 0.141702f },    // 407 nm
    { 0.033881f, 0.000941f, 0.161304f },    // 408 nm
    { 0.038468f, 0.001070f, 0.183257f },    // 409 nm
    { 0.043510f, 0.001210f, 0.207400f },    // 410 nm
    { 0.048996f, 0.001362f, 0.233692f },    // 411 nm
    { 0.055023f, 0.001531f, 0.262611f },    // 412 nm
    { 0.061719f, 0.001720f, 0.294775f },    // 413 nm
    { 0.069212f, 0.001935f, 0.330799f },    // 414 nm
    { 0.077630f, 0.002180f, 0.371300f },    // 415 nm
    { 0.086958f, 0.002455f, 0.416209f },    // 416 nm
    { 0.097177f, 0.002764f, 0.465464f },    // 417 nm
    { 0.108406f, 0.003118f, 0.519695f },    // 418 nm
    { 0.120767f, 0.003526f, 0.579530f },    // 419 nm
    { 0.134380f, 0.004000f, 0.645600f },    // 420 nm
    { 0.149358f, 0.004546f, 0.718484f },    // 421 nm
    { 0.165396f, 0.005159f, 0.796713f },    // 422 nm
    { 0.181983f, 0.005829f, 0.877846f },    // 423 nm
    { 0.198611f, 0.006546f, 0.959439f },    // 424 nm
    { 0.214770f, 0.007300f, 1.039050f },    // 425 nm
    { 0.230187f, 0.008086f, 1.115367f },    // 426 nm
    { 0.244880f, 0.008909f, 1.188497f },    // 427 nm
    { 0.258777f, 0.009768f, 1.258123f },    // 428 nm
    { 0.271808f, 0.010664f, 1.323930f },    // 429 nm
    { 0.283900f, 0.011600f, 1.385600f },    // 430 nm
    { 0.294944f, 0.012573f, 1.442635f },    // 431 nm
    { 0.304897f, 0.013583f, 1.494804f },    // 432 nm
    { 0.313787f, 0.014630f, 1.542190f },    // 433 nm
    { 0.321645f, 0.015715f, 1.584881f },    // 434 nm
    { 0.328500f, 0.016840f, 1.622960f },    // 435 nm
    { 0.334351f, 0.018007f, 1.656405f },    // 436 nm
    { 0.339210f, 0.019214f, 1.685296f },    // 437 nm
    { 0.343121f, 0.020454f, 1.709875f },    // 438 nm
    { 0.346130f, 0.021718f, 1.730382f },    // 439 nm
    { 0.348280f, 0.023000f, 1.747060f },    // 440 nm
    { 0.349600f, 0.024295f, 1.760045f },    // 441 nm
    { 0.350147f, 0.025610f, 1.769623f },    // 442 nm
    { 0.350013f, 0.026959f, 1.776264f },    // 443 nm
    { 0.349287f, 0.028351f, 1.780433f },    // 444 nm
    { 0.348060f, 0.029800f, 1.782600f },    // 445 nm
    { 0.346373f, 0.031311f, 1.782968f },    // 446 nm
    { 0.344262f, 0.032884f, 1.781700f },    // 447 nm
    { 0.341809f, 0.034521f, 1.779198f },    // 448 nm
    { 0.339094f, 0.036226f, 1.775867f },    // 449 nm
    { 0.336200f, 0.038000f, 1.772110f },    // 450 nm
    { 0.333198f, 0.039847f, 1.768259f },    // 451 nm
    { 0.330041f, 0.041768f, 1.764039f },    // 452 nm
    { 0.326636f, 0.043766f, 1.758944f },    // 453 nm
    { 0.322887f, 0.045843f, 1.752466f },    // 454 nm
    { 0.318700f, 0.048000f, 1.744100f },    // 455 nm
    { 0.314025f, 0.050244f, 1.733559f },    // 456 nm
    { 0.308884f, 0.052573f, 1.720858f },    // 457 nm
    { 0.303290f, 0.054981f, 1.705937f },    // 458 nm
    { 0.297258f, 0.057459f, 1.688737f },    // 459 nm
    { 0.290800f, 0.060000f, 1.669200f },    // 460 nm
    { 0.283970f, 0.062602f, 1.647529f },    // 461 nm
    { 0.276721f, 0.065278f, 1.623413f },    // 462 nm
    { 0.268918f, 0.068042f, 1.596022f },    // 463 nm
    { 0.260423f, 0.070911f, 1.564528f },    // 464 nm
    { 0.251100f, 0.073900f, 1.528100f },    // 465 nm
    { 0.240847f, 0.077016f, 1.486111f },    // 466 nm
    { 0.229851f, 0.080266f, 1.439522f },    // 467 nm
    { 0.218407f, 0.083667f, 1.389880f },    // 468 nm
    { 0.206812f, 0.087233f, 1.338736f },    // 469 nm
    { 0.195360f, 0.090980f, 1.287640f },    // 470 nm
    { 0.184214f, 0.094918f, 1.237422f },    // 471 nm
    { 0.173327f, 0.099046f, 1.187824f },    // 472 nm
    { 0.162688f, 0.103367f, 1.138761f },    // 473 nm
    { 0.152283f, 0.107885f, 1.090148f },    // 474 nm
    { 0.142100f, 0.112600f, 1.041900f },    // 475 nm
    { 0.132179f, 0.117532f, 0.994198f },    // 476 nm
    { 0.122570f, 0.122674f, 0.947347f },    // 477 nm
    { 0.113275f, 0.127993f, 0.901453f },    // 478 nm
    { 0.104298f, 0.133453f, 0.856619f },    // 479 nm
    { 0.095640f, 0.139020f, 0.812950f },    // 480 nm
    { 0.087300f, 0.144676f, 0.770517f },    // 481 nm
    { 0.079308f, 0.150469f, 0.729445f },    // 482 nm
    { 0.071718f, 0.156462f, 0.689914f },    // 483 nm
    { 0.064581f, 0.162718f, 0.652105f },    // 484 nm
    { 0.057950f, 0.169300f, 0.616200f },    // 485 nm
    { 0.051862f, 0.176243f, 0.582329f },    // 486 nm
    { 0.046282f, 0.183558f, 0.550416f },    // 487 nm
    { 0.041151f, 0.191273f, 0.520338f },    // 488 nm
    { 0.036413f, 0.199418f, 0.491967f },    // 489 nm
    { 0.032010f, 0.208020f, 0.465180f },    // 490 nm
    { 0.027917f, 0.217120f, 0.439925f },    // 491 nm
    { 0.024144f, 0.226735f, 0.416184f },    // 492 nm
    { 0.020687f, 0.236857f, 0.393882f },    // 493 nm
    { 0.017540f, 0.247481f, 0.372946f },    // 494 nm
    { 0.014700f, 0.258600f, 0.353300f },    // 495 nm
    { 0.012162f, 0.270185f, 0.334858f },    // 496 nm
    { 0.009920f, 0.282294f, 0.317552f },    // 497 nm
    { 0.007967f, 0.295051f, 0.301338f },    // 498 nm
    { 0.006296f, 0.308578f, 0.286169f },    // 499 nm
    { 0.004900f, 0.323000f, 0.272000f },    // 500 nm
    { 0.003777f, 0.338402f, 0.258817f },    // 501 nm
    { 0.002945f, 0.354686f, 0.246484f },    // 502 nm
    { 0.002425f, 0.371699f, 0.234772f },    // 503 nm
    { 0.002236f, 0.389288f, 0.223453f },    // 504 nm
    { 0.002400f, 0.407300f, 0.212300f },    // 505 nm
    { 0.002926f, 0.425630f, 0.201169f },    // 506 nm
    { 0.003837f, 0.444310f, 0.190120f },    // 507 nm
    { 0.005175f, 0.463394f, 0.179225f },    // 508 nm
    { 0.006982f, 0.482940f, 0.168561f },    // 509 nm
    { 0.009300f, 0.503000f, 0.158200f },    // 510 nm
    { 0.012149f, 0.523569f, 0.148138f },    // 511 nm
    { 0.015536f, 0.544512f, 0.138376f },    // 512 nm
    { 0.019477f, 0.565690f, 0.128994f },    // 513 nm
    { 0.023993f, 0.586965f, 0.120075f },    // 514 nm
    { 0.029100f, 0.608200f, 0.111700f },    // 515 nm
    { 0.034815f, 0.629346f, 0.103905f },    // 516 nm
    { 0.041120f, 0.650307f, 0.096667f },    // 517 nm
    { 0.047985f, 0.670875f, 0.089983f },    // 518 nm
    { 0.055379f, 0.690842f, 0.083845f },    // 519 nm
    { 0.063270f, 0.710000f, 0.078250f },    // 520 nm
    { 0.071635f, 0.728185f, 0.073209f },    // 521 nm
    { 0.080462f, 0.745464f, 0.068678f },    // 522 nm
    { 0.089740f, 0.761969f, 0.064568f },    // 523 nm
    { 0.099456f, 0.777837f, 0.060788f },    // 524 nm
    { 0.109600f, 0.793200f, 0.057250f },    // 525 nm
    { 0.120167f, 0.808110f, 0.053904f },    // 526 nm
    { 0.131114f, 0.822496f, 0.050747f },    // 527 nm
    { 0.142368f, 0.836307f, 0.047753f },    // 528 nm
    { 0.153854f, 0.849492f, 0.044899f },    // 529 nm
    { 0.165500f, 0.862000f, 0.042160f },    // 530 nm
    { 0.177257f, 0.873811f, 0.039507f },    // 531 nm
    { 0.189140f, 0.884962f, 0.036936f },    // 532 nm
    { 0.201169f, 0.895494f, 0.034458f },    // 533 nm
    { 0.213366f, 0.905443f, 0.032089f },    // 534 nm
    { 0.225750f, 0.914850f, 0.029840f },    // 535 nm
    { 0.238321f, 0.923735f, 0.027712f },    // 536 nm
    { 0.251067f, 0.932092f, 0.025694f },    // 537 nm
    { 0.263992f, 0.939923f, 0.023787f },    // 538 nm
    { 0.277102f, 0.947225f, 0.021989f },    // 539 nm
    { 0.290400f, 0.954000f, 0.020300f },    // 540 nm
    { 0.303891f, 0.960256f, 0.018718f },    // 541 nm
    { 0.317573f, 0.966007f, 0.017240f },    // 542 nm
    { 0.331438f, 0.971261f, 0.015864f },    // 543 nm
    { 0.345483f, 0.976022f, 0.014585f },    // 544 nm
    { 0.359700f, 0.980300f, 0.013400f },    // 545 nm
    { 0.374084f, 0.984092f, 0.012307f },    // 546 nm
    { 0.388640f, 0.987418f, 0.011302f },    // 547 nm
    { 0.403378f, 0.990313f, 0.010378f },    // 548 nm
    { 0.418312f, 0.992812f, 0.009529f },    // 549 nm
    { 0.433450f, 0.994950f, 0.008750f },    // 550 nm
    { 0.448795f, 0.996711f, 0.008035f },    // 551 nm
    { 0.464336f, 0.998098f, 0.007382f },    // 552 nm
    { 0.480064f, 0.999112f, 0.006785f },    // 553 nm
    { 0.495971f, 0.999748f, 0.006243f },    // 554 nm
    { 0.512050f, 1.000000f, 0.005750f },    // 555 nm
    { 0.528296f, 0.999857f, 0.005304f },    // 556 nm
    { 0.544692f, 0.999305f, 0.004900f },    // 557 nm
    { 0.561209f, 0.998326f, 0.004534f },    // 558 nm
    { 0.577821f, 0.996899f, 0.004202f },    // 559 nm
    { 0.594500f, 0.995000f, 0.003900f },    // 560 nm
    { 0.611221f, 0.992601f, 0.003623f },    // 561 nm
    { 0.627976f, 0.989743f, 0.003371f },    // 562 nm
    { 0.644760f, 0.986444f, 0.003141f },    // 563 nm
    { 0.661570f, 0.982724f, 0.002935f },    // 564 nm
    { 0.678400f, 0.978600f, 0.002750f },    // 565 nm
    { 0.695239f, 0.974084f, 0.002585f },    // 566 nm
    { 0.712059f, 0.969171f, 0.002439f },    // 567 nm
    { 0.728828f, 0.963857f, 0.002309f },    // 568 nm
    { 0.745519f, 0.958135f, 0.002197f },    // 569 nm
    { 0.762100f, 0.952000f, 0.002100f },    // 570 nm
    { 0.778543f, 0.945450f, 0.002018f },    // 571 nm
    { 0.794826f, 0.938499f, 0.001948f },    // 572 nm
    { 0.810926f, 0.931163f, 0.001890f },    // 573 nm
    { 0.826825f, 0.923458f, 0.001841f },    // 574 nm
    { 0.842500f, 0.915400f, 0.001800f },    // 575 nm
    { 0.857933f, 0.907006f, 0.001766f },    // 576 nm
    { 0.873082f, 0.898277f, 0.001738f },    // 577 nm
    { 0.887894f, 0.889205f, 0.001711f },    // 578 nm
    { 0.902318f, 0.879782f, 0.001683f },    // 579 nm
    { 0.916300f, 0.870000f, 0.001650f },    // 580 nm
    { 0.929799f, 0.859861f, 0.001610f },    // 581 nm
    { 0.942798f, 0.849392f, 0.001564f },    // 582 nm
    { 0.955278f, 0.838622f, 0.001514f },    // 583 nm
    { 0.967218f, 0.827581f, 0.001459f },    // 584 nm
    { 0.978600f, 0.816300f, 0.001400f },    // 585 nm
    { 0.989386f, 0.804795f, 0.001337f },    // 586 nm
    { 0.999549f, 0.793082f, 0.001270f },    // 587 nm
    { 1.009089f, 0.781192f, 0.001205f },    // 588 nm
    { 1.018006f, 0.769155f, 0.001147f },    // 589 nm
    { 1.026300f, 0.757000f, 0.001100f },    // 590 nm
    { 1.033983f, 0.744754f, 0.001069f },    // 591 nm
    { 1.040986f, 0.732422f, 0.001049f },    // 592 nm
    { 1.047188f, 0.720004f, 0.001036f },    // 593 nm
    { 1.052467f, 0.707497f, 0.001021f },    // 594 nm
    { 1.056700f, 0.694900f, 0.001000f },    // 595 nm
    { 1.059794f, 0.682219f, 0.000969f },    // 596 nm
    { 1.061799f, 0.669472f, 0.000930f },    // 597 nm
    { 1.062807f, 0.656674f, 0.000887f },    // 598 nm
    { 1.062910f, 0.643845f, 0.000843f },    // 599 nm
    { 1.062200f, 0.631000f, 0.000800f },    // 600 nm
    { 1.060735f, 0.618155f, 0.000761f },    // 601 nm
    { 1.058444f, 0.605314f, 0.000724f },    // 602 nm
    { 1.055224f, 0.592476f, 0.000686f },    // 603 nm
    { 1.050977f, 0.579638f, 0.000645f },    // 604 nm
    { 1.045600f, 0.566800f, 0.000600f },    // 605 nm
    { 1.039037f, 0.553961f, 0.000548f },    // 606 nm
    { 1.031361f, 0.541137f, 0.000492f },    // 607 nm
    { 1.022666f, 0.528353f, 0.000435f },    // 608 nm
    { 1.013048f, 0.515632f, 0.000384f },    // 609 nm
    { 1.002600f, 0.503000f, 0.000340f },    // 610 nm
    { 0.991368f, 0.490469f, 0.000307f },    // 611 nm
    { 0.979331f, 0.478030f, 0.000283f },    // 612 nm
    { 0.966492f, 0.465678f, 0.000265f },    // 613 nm
    { 0.952848f, 0.453403f, 0.000252f },    // 614 nm
    { 0.938400f, 0.441200f, 0.000240f },    // 615 nm
    { 0.923194f, 0.429080f, 0.000230f },    // 616 nm
    { 0.907244f, 0.417036f, 0.000221f },    // 617 nm
    { 0.890502f, 0.405032f, 0.000212f },    // 618 nm
    { 0.872920f, 0.393032f, 0.000202f },    // 619 nm
    { 0.854450f, 0.381000f, 0.000190f },    // 620 nm
    { 0.835084f, 0.368918f, 0.000174f },    // 621 nm
    { 0.814946f, 0.356827f, 0.000156f },    // 622 nm
    { 0.794186f, 0.344777f, 0.000136f },    // 623 nm
    { 0.772954f, 0.332818f, 0.000117f },    // 624 nm
    { 0.751400f, 0.321000f, 0.000100f },    // 625 nm
    { 0.729584f, 0.309338f, 0.000086f },    // 626 nm
    { 0.707589f, 0.297850f, 0.000075f },    // 627 nm
    { 0.685602f, 0.286594f, 0.000065f },    // 628 nm
    { 0.663810f, 0.275625f, 0.000057f },    // 629 nm
    { 0.642400f, 0.265000f, 0.000050f },    // 630 nm
    { 0.621515f, 0.254763f, 0.000044f },    // 631 nm
    { 0.601114f, 0.244890f, 0.000039f },    // 632 nm
    { 0.581105f, 0.235334f, 0.000036f },    // 633 nm
    { 0.561398f, 0.226053f, 0.000033f },    // 634 nm
    { 0.541900f, 0.217000f, 0.000030f },    // 635 nm
    { 0.522600f, 0.208162f, 0.000028f },    // 636 nm
    { 0.503546f, 0.199549f, 0.000026f },    // 637 nm
    { 0.484744f, 0.191155f, 0.000024f },    // 638 nm
    { 0.466194f, 0.182974f, 0.000022f },    // 639 nm
    { 0.447900f, 0.175000f, 0.000020f },    // 640 nm
    { 0.429861f, 0.167223f, 0.000018f },    // 641 nm
    { 0.412098f, 0.159646f, 0.000016f },    // 642 nm
    { 0.394644f, 0.152278f, 0.000014f },    // 643 nm
    { 0.377533f, 0.145126f, 0.000012f },    // 644 nm
    { 0.360800f, 0.138200f, 0.000010f },    // 645 nm
    { 0.344456f, 0.131500f, 0.000008f },    // 646 nm
    { 0.328517f, 0.125025f, 0.000005f },    // 647 nm
    { 0.313019f, 0.118779f, 0.000003f },    // 648 nm
    { 0.298001f, 0.112769f, 0.000001f },    // 649 nm
    { 0.283500f, 0.107000f, 0.000000f },    // 650 nm
    { 0.269545f, 0.101476f, 0.000000f },    // 651 nm
    { 0.256118f, 0.096189f, 0.000000f },    // 652 nm
    { 0.243190f, 0.091123f, 0.000000f },    // 653 nm
    { 0.230727f, 0.086265f, 0.000000f },    // 654 nm
    { 0.218700f, 0.081600f, 0.000000f },    // 655 nm
    { 0.207097f, 0.077121f, 0.000000f },    // 656 nm
    { 0.195923f, 0.072825f, 0.000000f },    // 657 nm
    { 0.185171f, 0.068710f, 0.000000f },    // 658 nm
    { 0.174832f, 0.064770f, 0.000000f },    // 659 nm
    { 0.164900f, 0.061000f, 0.000000f },    // 660 nm
    { 0.155367f, 0.057396f, 0.000000f },    // 661 nm
    { 0.146230f, 0.053955f, 0.000000f },    // 662 nm
    { 0.137490f, 0.050674f, 0.000000f },    // 663 nm
    { 0.129147f, 0.047550f, 0.000000f },    // 664 nm
    { 0.121200f, 0.044580f, 0.000000f },    // 665 nm
    { 0.113640f, 0.041759f, 0.000000f },    // 666 nm
    { 0.106465f, 0.039085f, 0.000000f },    // 667 nm
    { 0.099690f, 0.036564f, 0.000000f },    // 668 nm
    { 0.093331f, 0.034201f, 0.000000f },    // 669 nm
    { 0.087400f, 0.032000f, 0.000000f },    // 670 nm
    { 0.081901f, 0.029963f, 0.000000f },    // 671 nm
    { 0.076804f, 0.028077f, 0.000000f },    // 672 nm
    { 0.072077f, 0.026329f, 0.000000f },    // 673 nm
    { 0.067687f, 0.024708f, 0.000000f },    // 674 nm
    { 0.063600f, 0.023200f, 0.000000f },    // 675 nm
    { 0.059807f, 0.021801f, 0.000000f },    // 676 nm
    { 0.056282f, 0.020501f, 0.000000f },    // 677 nm
    { 0.052971f, 0.019281f, 0.000000f },    // 678 nm
    { 0.049819f, 0.018121f, 0.000000f },    // 679 nm
    { 0.046770f, 0.017000f, 0.000000f },    // 680 nm
    { 0.043784f, 0.015904f, 0.000000f },    // 681 nm
    { 0.040875f, 0.014837f, 0.000000f },    // 682 nm
    { 0.038073f, 0.013811f, 0.000000f },    // 683 nm
    { 0.035405f, 0.012835f, 0.000000f },    // 684 nm
    { 0.032900f, 0.011920f, 0.000000f },    // 685 nm
    { 0.030564f, 0.011068f, 0.000000f },    // 686 nm
    { 0.028381f, 0.010273f, 0.000000f },    // 687 nm
    { 0.026345f, 0.009533f, 0.000000f },    // 688 nm
    { 0.024453f, 0.008846f, 0.000000f },    // 689 nm
    { 0.022700f, 0.008210f, 0.000000f },    // 690 nm
    { 0.021084f, 0.007624f, 0.000000f },    // 691 nm
    { 0.019600f, 0.007085f, 0.000000f },    // 692 nm
    { 0.018237f, 0.006591f, 0.000000f },    // 693 nm
    { 0.016987f, 0.006138f, 0.000000f },    // 694 nm
    { 0.015840f, 0.005723f, 0.000000f },    // 695 nm
    { 0.014791f, 0.005343f, 0.000000f },    // 696 nm
    { 0.013831f, 0.004996f, 0.000000f },    // 697 nm
    { 0.012949f, 0.004676f, 0.000000f },    // 698 nm
    { 0.012129f, 0.004380f, 0.000000f },    // 699 nm
    { 0.011359f, 0.004102f, 0.000000f },    // 700 nm
    { 0.010629f, 0.003839f, 0.000000f },    // 701 nm
    { 0.009939f, 0.003589f, 0.000000f },    // 702 nm
    { 0.009288f, 0.003354f, 0.000000f },    // 703 nm
    { 0.008679f, 0.003134f, 0.000000f },    // 704 nm
    { 0.008111f, 0.002929f, 0.000000f },    // 705 nm
    { 0.007582f, 0.002738f, 0.000000f },    // 706 nm
    { 0.007089f, 0.002560f, 0.000000f },    // 707 nm
    { 0.006627f, 0.002393f, 0.000000f },    // 708 nm
    { 0.006195f, 0.002237f, 0.000000f },    // 709 nm
    { 0.005790f, 0.002091f, 0.000000f },    // 710 nm
    { 0.005410f, 0.001954f, 0.000000f },    // 711 nm
    { 0.005053f, 0.001825f, 0.000000f },    // 712 nm
    { 0.004717f, 0.001704f, 0.000000f },    // 713 nm
    { 0.004403f, 0.001590f, 0.000000f },    // 714 nm
    { 0.004109f, 0.001484f, 0.000000f },    // 715 nm
    { 0.003834f, 0.001384f, 0.000000f },    // 716 nm
    { 0.003576f, 0.001291f, 0.000000f },    // 717 nm
    { 0.003334f, 0.001204f, 0.000000f },    // 718 nm
    { 0.003109f, 0.001123f, 0.000000f },    // 719 nm
    { 0.002899f, 0.001047f, 0.000000f },    // 720 nm
    { 0.002704f, 0.000977f, 0.000000f },    // 721 nm
    { 0.002523f, 0.000911f, 0.000000f },    // 722 nm
    { 0.002354f, 0.000850f, 0.000000f },    // 723 nm
    { 0.002197f, 0.000793f, 0.000000f },    // 724 nm
    { 0.002049f, 0.000740f, 0.000000f },    // 725 nm
    { 0.001911f, 0.000690f, 0.000000f },    // 726 nm
    { 0.001781f, 0.000643f, 0.000000f },    // 727 nm
    { 0.001660f, 0.000600f, 0.000000f },    // 728 nm
    { 0.001547f, 0.000559f, 0.000000f },    // 729 nm
    { 0.001440f, 0.000520f, 0.000000f },    // 730 nm
    { 0.001340f, 0.000484f, 0.000000f },    // 731 nm
    { 0.001246f, 0.000450f, 0.000000f },    // 732 nm
    { 0.001158f, 0.000418f, 0.000000f },    // 733 nm
    { 0.001076f, 0.000389f, 0.000000f },    // 734 nm
    { 0.001000f, 0.000361f, 0.000000f },    // 735 nm
    { 0.000929f, 0.000335f, 0.000000f },    // 736 nm
    { 0.000862f, 0.000311f, 0.000000f },    // 737 nm
    { 0.000801f, 0.000289f, 0.000000f },    // 738 nm
    { 0.000743f, 0.000269f, 0.000000f },    // 739 nm
    { 0.000690f, 0.000249f, 0.000000f },    // 740 nm
    { 0.000640f, 0.000231f, 0.000000f },    // 741 nm
    { 0.000594f, 0.000215f, 0.000000f },    // 742 nm
    { 0.000552f, 0.000199f, 0.000000f },    // 743 nm
    { 0.000512f, 0.000185f, 0.000000f },    // 744 nm
    { 0.000476f, 0.000172f, 0.000000f },    // 745 nm
    { 0.000442f, 0.000160f, 0.000000f },    // 746 nm
    { 0.000411f, 0.000149f, 0.000000f },    // 747 nm
    { 0.000383f, 0.000138f, 0.000000f },    // 748 nm
    { 0.000357f, 0.000129f, 0.000000f },    // 749 nm
    { 0.000332f, 0.000120f, 0.000000f },    // 750 nm
    { 0.000310f, 0.000112f, 0.000000f },    // 751 nm
    { 0.000289f, 0.000104f, 0.000000f },    // 752 nm
    { 0.000269f, 0.000097f, 0.000000f },    // 753 nm
    { 0.000252f, 0.000091f, 0.000000f },    // 754 nm
    { 0.000235f, 0.000085f, 0.000000f },    // 755 nm
    { 0.000219f, 0.000079f, 0.000000f },    // 756 nm
    { 0.000205f, 0.000074f, 0.000000f },    // 757 nm
    { 0.000191f, 0.000069f, 0.000000f },    // 758 nm
    { 0.000178f, 0.000064f, 0.000000f },    // 759 nm
    { 0.000166f, 0.000060f, 0.000000f },    // 760 nm
    { 0.000155f, 0.000056f, 0.000000f },    // 761 nm
    { 0.000145f, 0.000052f, 0.000000f },    // 762 nm
    { 0.000135f, 0.000049f, 0.000000f },    // 763 nm
    { 0.000126f, 0.000045f, 0.000000f },    // 764 nm
    { 0.000117f, 0.000042f, 0.000000f },    // 765 nm
    { 0.000110f, 0.000040f, 0.000000f },    // 766 nm
    { 0.000102f, 0.000037f, 0.000000f },    // 767 nm
    { 0.000095f, 0.000034f, 0.000000f },    // 768 nm
    { 0.000089f, 0.000032f, 0.000000f },    // 769 nm
    { 0.000083f, 0.000030f, 0.000000f },    // 770 nm
    { 0.000078f, 0.000028f, 0.000000f },    // 771 nm
    { 0.000072f, 0.000026f, 0.000000f },    // 772 nm
    { 0.000067f, 0.000024f, 0.000000f },    // 773 nm
    { 0.000063f, 0.000023f, 0.000000f },    // 774 nm
    { 0.000059f, 0.000021f, 0.000000f },    // 775 nm
    { 0.000055f, 0.000020f, 0.000000f },    // 776 nm
    { 0.000051f, 0.000018f, 0.000000f },    // 777 nm
    { 0.000048f, 0.000017f, 0.000000f },    // 778 nm
    { 0.000044f, 0.000016f, 0.000000f },    // 779 nm
    { 0.000042f, 0.000015f, 0.000000f },    // 780 nm
    { 0.000039f, 0.000014f, 0.000000f },    // 781 nm
    { 0.000036f, 0.000013f, 0.000000f },    // 782 nm
    { 0.000034f, 0.000012f, 0.000000f },    // 783 nm
    { 0.000031f, 0.000011f, 0.000000f },    // 784 nm
    { 0.000029f, 0.000011f, 0.000000f },    // 785 nm
    { 0.000027f, 0.000010f, 0.000000f },    // 786 nm
    { 0.000026f, 0.000009f, 0.000000f },    // 787 nm
    { 0.000024f, 0.000009f, 0.000000f },    // 788 nm
    { 0.000022f, 0.000008f, 0.000000f },    // 789 nm
    { 0.000021f, 0.000007f, 0.000000f },    // 790 nm
    { 0.000019f, 0.000007f, 0.000000f },    // 791 nm
    { 0.000018f, 0.000006f, 0.000000f },    // 792 nm
    { 0.000017f, 0.000006f, 0.000000f },    // 793 nm
    { 0.000016f, 0.000006f, 0.000000f },    // 794 nm
    { 0.000015f, 0.000005f, 0.000000f },    // 795 nm
    { 0.000014f, 0.000005f, 0.000000f },    // 796 nm
    { 0.000013f, 0.000005f, 0.000000f },    // 797 nm
    { 0.000012f, 0.000004f, 0.000000f },    // 798 nm
    { 0.000011f, 0.000004f, 0.000000f },    // 799 nm
    { 0.000010f, 0.000004f, 0.000000f },    // 800 nm
    { 0.000010f, 0.000003f, 0.000000f },    // 801 nm
    { 0.000009f, 0.000003f, 0.000000f },    // 802 nm
    { 0.000008f, 0.000003f, 0.000000f },    // 803 nm
    { 0.000008f, 0.000003f, 0.000000f },    // 804 nm
    { 0.000007f, 0.000003f, 0.000000f },    // 805 nm
    { 0.000007f, 0.000002f, 0.000000f },    // 806 nm
    { 0.000006f, 0.000002f, 0.000000f },    // 807 nm
    { 0.000006f, 0.000002f, 0.000000f },    // 808 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 809 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 810 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 811 nm
    { 0.000004f, 0.000002f, 0.000000f },    // 812 nm
    { 0.000004f, 0.000001f, 0.000000f },    // 813 nm
    { 0.000004f, 0.000001f, 0.000000f },    // 814 nm
    { 0.000004f, 0.000001f, 0.000000f },    // 815 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 816 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 817 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 818 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 819 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 820 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 821 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 822 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 823 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 824 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 825 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 826 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 827 nm
    { 0.000001f, 0.000001f, 0.000000f },    // 828 nm
    { 0.000001f, 0.000000f, 0.000000f },    // 829 nm
    { 0.000001f, 0.000000f, 0.000000f }     // 830 nm
};

static float const xyz1964_1nm[471][3] = {
    { 0.000000f, 0.000000f, 0.000001f },    // 360 nm
    { 0.000000f, 0.000000f, 0.000001f },    // 361 nm
    { 0.000000f, 0.000000f, 0.000001f },    // 362 nm
    { 0.000000f, 0.000000f, 0.000002f },    // 363 nm
    { 0.000001f, 0.000000f, 0.000003f },    // 364 nm
    { 0.000001f, 0.000000f, 0.000004f },    // 365 nm
    { 0.000001f, 0.000000f, 0.000006f },    // 366 nm
    { 0.000002f, 0.000000f, 0.000009f },    // 367 nm
    { 0.000003f, 0.000000f, 0.000013f },    // 368 nm
    { 0.000004f, 0.000000f, 0.000018f },    // 369 nm
    { 0.000006f, 0.000001f, 0.000026f },    // 370 nm
    { 0.000009f, 0.000001f, 0.000037f },    // 371 nm
    { 0.000012f, 0.000001f, 0.000053f },    // 372 nm
    { 0.000017f, 0.000002f, 0.000075f },    // 373 nm
    { 0.000024f, 0.000003f, 0.000105f },    // 374 nm
    { 0.000033f, 0.000004f, 0.000146f },    // 375 nm
    { 0.000046f, 0.000005f, 0.000203f },    // 376 nm
    { 0.000063f, 0.000007f, 0.000279f },    // 377 nm
    { 0.000087f, 0.000009f, 0.000383f },    // 378 nm
    { 0.000118f, 0.000013f, 0.000521f },    // 379 nm
    { 0.000160f, 0.000017f, 0.000705f },    // 380 nm
    { 0.000215f, 0.000023f, 0.000948f },    // 381 nm
    { 0.000288f, 0.000031f, 0.001268f },    // 382 nm
    { 0.000382f, 0.000041f, 0.001686f },    // 383 nm
    { 0.000505f, 0.000055f, 0.002229f },    // 384 nm
    { 0.000662f, 0.000072f, 0.002928f },    // 385 nm
    { 0.000865f, 0.000093f, 0.003824f },    // 386 nm
    { 0.001122f, 0.000121f, 0.004964f },    // 387 nm
    { 0.001446f, 0.000156f, 0.006407f },    // 388 nm
    { 0.001854f, 0.000199f, 0.008219f },    // 389 nm
    { 0.002362f, 0.000253f, 0.010482f },    // 390 nm
    { 0.002991f, 0.000320f, 0.013289f },    // 391 nm
    { 0.003764f, 0.000402f, 0.016747f },    // 392 nm
    { 0.004710f, 0.000502f, 0.020980f },    // 393 nm
    { 0.005858f, 0.000623f, 0.026127f },    // 394 nm
    { 0.007242f, 0.000768f, 0.032344f },    // 395 nm
    { 0.008900f, 0.000942f, 0.039802f },    // 396 nm
    { 0.010871f, 0.001148f, 0.048691f },    // 397 nm
    { 0.013199f, 0.001390f, 0.059210f },    // 398 nm
    { 0.015929f, 0.001674f, 0.071576f },    // 399 nm
    { 0.019110f, 0.002004f, 0.086011f },    // 400 nm
    { 0.022788f, 0.002386f, 0.102740f },    // 401 nm
    { 0.027011f, 0.002822f, 0.122000f },    // 402 nm
    { 0.031829f, 0.003319f, 0.144020f },    // 403 nm
    { 0.037278f, 0.003880f, 0.168990f },    // 404 nm
    { 0.043400f, 0.004509f, 0.197120f },    // 405 nm
    { 0.050223f, 0.005209f, 0.228570f },    // 406 nm
    { 0.057764f, 0.005985f, 0.263470f },    // 407 nm
    { 0.066038f, 0.006833f, 0.301900f },    // 408 nm
    { 0.075033f, 0.007757f, 0.343870f },    // 409 nm
    { 0.084736f, 0.008756f, 0.389366f },    // 410 nm
    { 0.095041f, 0.009816f, 0.437970f },    // 411 nm
    { 0.105836f, 0.010918f, 0.489220f },    // 412 nm
    { 0.117066f, 0.012058f, 0.542900f },    // 413 nm
    { 0.128682f, 0.013237f, 0.598810f },    // 414 nm
    { 0.140638f, 0.014456f, 0.656760f },    // 415 nm
    { 0.152893f, 0.015717f, 0.716580f },    // 416 nm
    { 0.165416f, 0.017025f, 0.778120f },    // 417 nm
    { 0.178191f, 0.018399f, 0.841310f },    // 418 nm
    { 0.191214f, 0.019848f, 0.906110f },    // 419 nm
    { 0.204492f, 0.021391f, 0.972542f },    // 420 nm
    { 0.217650f, 0.022992f, 1.038900f },    // 421 nm
    { 0.230267f, 0.024598f, 1.103100f },    // 422 nm
    { 0.242311f, 0.026213f, 1.165100f },    // 423 nm
    { 0.253793f, 0.027841f, 1.224900f },    // 424 nm
    { 0.264737f, 0.029497f, 1.282500f },    // 425 nm
    { 0.275195f, 0.031195f, 1.338200f },    // 426 nm
    { 0.285301f, 0.032927f, 1.392600f },    // 427 nm
    { 0.295143f, 0.034738f, 1.446100f },    // 428 nm
    { 0.304869f, 0.036654f, 1.499400f },    // 429 nm
    { 0.314679f, 0.038676f, 1.553480f },    // 430 nm
    { 0.324355f, 0.040792f, 1.607200f },    // 431 nm
    { 0.333570f, 0.042946f, 1.658900f },    // 432 nm
    { 0.342243f, 0.045114f, 1.708200f },    // 433 nm
    { 0.350312f, 0.047333f, 1.754800f },    // 434 nm
    { 0.357719f, 0.049602f, 1.798500f },    // 435 nm
    { 0.364482f, 0.051934f, 1.839200f },    // 436 nm
    { 0.370493f, 0.054337f, 1.876600f },    // 437 nm
    { 0.375727f, 0.056822f, 1.910500f },    // 438 nm
    { 0.380158f, 0.059399f, 1.940800f },    // 439 nm
    { 0.383734f, 0.062077f, 1.967280f },    // 440 nm
    { 0.386327f, 0.064737f, 1.989100f },    // 441 nm
    { 0.387858f, 0.067285f, 2.005700f },    // 442 nm
    { 0.388396f, 0.069764f, 2.017400f },    // 443 nm
    { 0.387978f, 0.072218f, 2.024400f },    // 444 nm
    { 0.386726f, 0.074704f, 2.027300f },    // 445 nm
    { 0.384696f, 0.077272f, 2.026400f },    // 446 nm
    { 0.382006f, 0.079979f, 2.022300f },    // 447 nm
    { 0.378709f, 0.082874f, 2.015300f },    // 448 nm
    { 0.374915f, 0.086000f, 2.006000f },    // 449 nm
    { 0.370702f, 0.089456f, 1.994800f },    // 450 nm
    { 0.366089f, 0.092947f, 1.981400f },    // 451 nm
    { 0.361045f, 0.096275f, 1.965300f },    // 452 nm
    { 0.355518f, 0.099535f, 1.946400f },    // 453 nm
    { 0.349486f, 0.102829f, 1.924800f },    // 454 nm
    { 0.342957f, 0.106256f, 1.900700f },    // 455 nm
    { 0.335893f, 0.109901f, 1.874100f },    // 456 nm
    { 0.328284f, 0.113835f, 1.845100f },    // 457 nm
    { 0.320150f, 0.118167f, 1.813900f },    // 458 nm
    { 0.311475f, 0.122932f, 1.780600f },    // 459 nm
    { 0.302273f, 0.128201f, 1.745370f },    // 460 nm
    { 0.292858f, 0.133457f, 1.709100f },    // 461 nm
    { 0.283502f, 0.138323f, 1.672300f },    // 462 nm
    { 0.274044f, 0.143042f, 1.634700f },    // 463 nm
    { 0.264263f, 0.147787f, 1.595600f },    // 464 nm
    { 0.254085f, 0.152761f, 1.554900f },    // 465 nm
    { 0.243392f, 0.158102f, 1.512200f },    // 466 nm
    { 0.232187f, 0.163941f, 1.467300f },    // 467 nm
    { 0.220488f, 0.170362f, 1.419900f },    // 468 nm
    { 0.208198f, 0.177425f, 1.370000f },    // 469 nm
    { 0.195618f, 0.185190f, 1.317560f },    // 470 nm
    { 0.183034f, 0.193025f, 1.262400f },    // 471 nm
    { 0.170222f, 0.200313f, 1.205000f },    // 472 nm
    { 0.157348f, 0.207156f, 1.146600f },    // 473 nm
    { 0.144650f, 0.213644f, 1.088000f },    // 474 nm
    { 0.132349f, 0.219940f, 1.030200f },    // 475 nm
    { 0.120584f, 0.226170f, 0.973830f },    // 476 nm
    { 0.109456f, 0.232467f, 0.919430f },    // 477 nm
    { 0.099042f, 0.239025f, 0.867460f },    // 478 nm
    { 0.089388f, 0.245997f, 0.818280f },    // 479 nm
    { 0.080507f, 0.253589f, 0.772125f },    // 480 nm
    { 0.072034f, 0.261876f, 0.728290f },    // 481 nm
    { 0.063710f, 0.270643f, 0.686040f },    // 482 nm
    { 0.055694f, 0.279645f, 0.645530f },    // 483 nm
    { 0.048117f, 0.288694f, 0.606850f },    // 484 nm
    { 0.041072f, 0.297665f, 0.570060f },    // 485 nm
    { 0.034642f, 0.306469f, 0.535220f },    // 486 nm
    { 0.028896f, 0.315035f, 0.502340f },    // 487 nm
    { 0.023876f, 0.323335f, 0.471400f },    // 488 nm
    { 0.019628f, 0.331366f, 0.442390f },    // 489 nm
    { 0.016172f, 0.339133f, 0.415254f },    // 490 nm
    { 0.013300f, 0.347860f, 0.390024f },    // 491 nm
    { 0.010759f, 0.358326f, 0.366399f },    // 492 nm
    { 0.008542f, 0.370001f, 0.344015f },    // 493 nm
    { 0.006661f, 0.382464f, 0.322689f },    // 494 nm
    { 0.005132f, 0.395379f, 0.302356f },    // 495 nm
    { 0.003982f, 0.408482f, 0.283036f },    // 496 nm
    { 0.003239f, 0.421588f, 0.264816f },    // 497 nm
    { 0.002934f, 0.434619f, 0.247848f },    // 498 nm
    { 0.003114f, 0.447601f, 0.232318f },    // 499 nm
    { 0.003816f, 0.460777f, 0.218502f },    // 500 nm
    { 0.005095f, 0.474340f, 0.205851f },    // 501 nm
    { 0.006936f, 0.488200f, 0.193596f },    // 502 nm
    { 0.009299f, 0.502340f, 0.181736f },    // 503 nm
    { 0.012147f, 0.516740f, 0.170281f },    // 504 nm
    { 0.015444f, 0.531360f, 0.159249f },    // 505 nm
    { 0.019156f, 0.546190f, 0.148673f },    // 506 nm
    { 0.023250f, 0.561180f, 0.138609f },    // 507 nm
    { 0.027690f, 0.576290f, 0.129096f },    // 508 nm
    { 0.032444f, 0.591500f, 0.120215f },    // 509 nm
    { 0.037465f, 0.606741f, 0.112044f },    // 510 nm
    { 0.042956f, 0.622150f, 0.104710f },    // 511 nm
    { 0.049114f, 0.637830f, 0.098196f },    // 512 nm
    { 0.055920f, 0.653710f, 0.092361f },    // 513 nm
    { 0.063349f, 0.669680f, 0.087088f },    // 514 nm
    { 0.071358f, 0.685660f, 0.082248f },    // 515 nm
    { 0.079901f, 0.701550f, 0.077744f },    // 516 nm
    { 0.088909f, 0.717230f, 0.073456f },    // 517 nm
    { 0.098293f, 0.732570f, 0.069268f },    // 518 nm
    { 0.107949f, 0.747460f, 0.065060f },    // 519 nm
    { 0.117749f, 0.761757f, 0.060709f },    // 520 nm
    { 0.127839f, 0.775340f, 0.056457f },    // 521 nm
    { 0.138450f, 0.788220f, 0.052609f },    // 522 nm
    { 0.149516f, 0.800460f, 0.049122f },    // 523 nm
    { 0.161041f, 0.812140f, 0.045954f },    // 524 nm
    { 0.172953f, 0.823330f, 0.043050f },    // 525 nm
    { 0.185209f, 0.834120f, 0.040368f },    // 526 nm
    { 0.197755f, 0.844600f, 0.037839f },    // 527 nm
    { 0.210538f, 0.854870f, 0.035384f },    // 528 nm
    { 0.223460f, 0.865040f, 0.032949f },    // 529 nm
    { 0.236491f, 0.875211f, 0.030451f },    // 530 nm
    { 0.249633f, 0.885370f, 0.028029f },    // 531 nm
    { 0.262972f, 0.895370f, 0.025862f },    // 532 nm
    { 0.276515f, 0.905150f, 0.023920f },    // 533 nm
    { 0.290269f, 0.914650f, 0.022174f },    // 534 nm
    { 0.304213f, 0.923810f, 0.020584f },    // 535 nm
    { 0.318361f, 0.932550f, 0.019127f },    // 536 nm
    { 0.332705f, 0.940810f, 0.017740f },    // 537 nm
    { 0.347232f, 0.948520f, 0.016403f },    // 538 nm
    { 0.361926f, 0.955600f, 0.015064f },    // 539 nm
    { 0.376772f, 0.961988f, 0.013676f },    // 540 nm
    { 0.391683f, 0.967540f, 0.012308f },    // 541 nm
    { 0.406594f, 0.972230f, 0.011056f },    // 542 nm
    { 0.421539f, 0.976170f, 0.009915f },    // 543 nm
    { 0.436517f, 0.979460f, 0.008872f },    // 544 nm
    { 0.451584f, 0.982200f, 0.007918f },    // 545 nm
    { 0.466782f, 0.984520f, 0.007030f },    // 546 nm
    { 0.482147f, 0.986520f, 0.006223f },    // 547 nm
    { 0.497738f, 0.988320f, 0.005453f },    // 548 nm
    { 0.513606f, 0.990020f, 0.004714f },    // 549 nm
    { 0.529826f, 0.991761f, 0.003988f },    // 550 nm
    { 0.546440f, 0.993530f, 0.003289f },    // 551 nm
    { 0.563426f, 0.995230f, 0.002646f },    // 552 nm
    { 0.580726f, 0.996770f, 0.002063f },    // 553 nm
    { 0.598290f, 0.998090f, 0.001533f },    // 554 nm
    { 0.616053f, 0.999110f, 0.001091f },    // 555 nm
    { 0.633948f, 0.999770f, 0.000711f },    // 556 nm
    { 0.651901f, 1.000000f, 0.000407f },    // 557 nm
    { 0.669824f, 0.999710f, 0.000184f },    // 558 nm
    { 0.687632f, 0.998850f, 0.000047f },    // 559 nm
    { 0.705224f, 0.997340f, 0.000000f },    // 560 nm
    { 0.722773f, 0.995260f, 0.000000f },    // 561 nm
    { 0.740483f, 0.992740f, 0.000000f },    // 562 nm
    { 0.758273f, 0.989750f, 0.000000f },    // 563 nm
    { 0.776083f, 0.986300f, 0.000000f },    // 564 nm
    { 0.793832f, 0.982380f, 0.000000f },    // 565 nm
    { 0.811436f, 0.977980f, 0.000000f },    // 566 nm
    { 0.828822f, 0.973110f, 0.000000f },    // 567 nm
    { 0.845879f, 0.967740f, 0.000000f },    // 568 nm
    { 0.862525f, 0.961890f, 0.000000f },    // 569 nm
    { 0.878655f, 0.955552f, 0.000000f },    // 570 nm
    { 0.894208f, 0.948601f, 0.000000f },    // 571 nm
    { 0.909206f, 0.940981f, 0.000000f },    // 572 nm
    { 0.923672f, 0.932798f, 0.000000f },    // 573 nm
    { 0.937638f, 0.924158f, 0.000000f },    // 574 nm
    { 0.951162f, 0.915175f, 0.000000f },    // 575 nm
    { 0.964283f, 0.905954f, 0.000000f },    // 576 nm
    { 0.977068f, 0.896608f, 0.000000f },    // 577 nm
    { 0.989590f, 0.887249f, 0.000000f },    // 578 nm
    { 1.001910f, 0.877986f, 0.000000f },    // 579 nm
    { 1.014160f, 0.868934f, 0.000000f },    // 580 nm
    { 1.026500f, 0.860164f, 0.000000f },    // 581 nm
    { 1.038800f, 0.851519f, 0.000000f },    // 582 nm
    { 1.051000f, 0.842963f, 0.000000f },    // 583 nm
    { 1.062900f, 0.834393f, 0.000000f },    // 584 nm
    { 1.074300f, 0.825623f, 0.000000f },    // 585 nm
    { 1.085200f, 0.816764f, 0.000000f },    // 586 nm
    { 1.095200f, 0.807544f, 0.000000f },    // 587 nm
    { 1.104200f, 0.797947f, 0.000000f },    // 588 nm
    { 1.112000f, 0.787893f, 0.000000f },    // 589 nm
    { 1.118520f, 0.777405f, 0.000000f },    // 590 nm
    { 1.123800f, 0.766490f, 0.000000f },    // 591 nm
    { 1.128000f, 0.755309f, 0.000000f },    // 592 nm
    { 1.131100f, 0.743845f, 0.000000f },    // 593 nm
    { 1.133200f, 0.732190f, 0.000000f },    // 594 nm
    { 1.134300f, 0.720353f, 0.000000f },    // 595 nm
    { 1.134300f, 0.708281f, 0.000000f },    // 596 nm
    { 1.133300f, 0.696055f, 0.000000f },    // 597 nm
    { 1.131200f, 0.683621f, 0.000000f },    // 598 nm
    { 1.128100f, 0.671048f, 0.000000f },    // 599 nm
    { 1.123990f, 0.658341f, 0.000000f },    // 600 nm
    { 1.118900f, 0.645545f, 0.000000f },    // 601 nm
    { 1.112900f, 0.632718f, 0.000000f },    // 602 nm
    { 1.105900f, 0.619815f, 0.000000f },    // 603 nm
    { 1.098000f, 0.606887f, 0.000000f },    // 604 nm
    { 1.089100f, 0.593878f, 0.000000f },    // 605 nm
    { 1.079200f, 0.580781f, 0.000000f },    // 606 nm
    { 1.068400f, 0.567653f, 0.000000f },    // 607 nm
    { 1.056700f, 0.554490f, 0.000000f },    // 608 nm
    { 1.044000f, 0.541228f, 0.000000f },    // 609 nm
    { 1.030480f, 0.527963f, 0.000000f },    // 610 nm
    { 1.016000f, 0.514634f, 0.000000f },    // 611 nm
    { 1.000800f, 0.501363f, 0.000000f },    // 612 nm
    { 0.984790f, 0.488124f, 0.000000f },    // 613 nm
    { 0.968080f, 0.474935f, 0.000000f },    // 614 nm
    { 0.950740f, 0.461834f, 0.000000f },    // 615 nm
    { 0.932800f, 0.448823f, 0.000000f },    // 616 nm
    { 0.914340f, 0.435917f, 0.000000f },    // 617 nm
    { 0.895390f, 0.423153f, 0.000000f },    // 618 nm
    { 0.876030f, 0.410526f, 0.000000f },    // 619 nm
    { 0.856297f, 0.398057f, 0.000000f },    // 620 nm
    { 0.836350f, 0.385835f, 0.000000f },    // 621 nm
    { 0.816290f, 0.373951f, 0.000000f },    // 622 nm
    { 0.796050f, 0.362311f, 0.000000f },    // 623 nm
    { 0.775610f, 0.350863f, 0.000000f },    // 624 nm
    { 0.754930f, 0.339554f, 0.000000f },    // 625 nm
    { 0.733990f, 0.328309f, 0.000000f },    // 626 nm
    { 0.712780f, 0.317118f, 0.000000f },    // 627 nm
    { 0.691290f, 0.305936f, 0.000000f },    // 628 nm
    { 0.669520f, 0.294737f, 0.000000f },    // 629 nm
    { 0.647467f, 0.283493f, 0.000000f },    // 630 nm
    { 0.625110f, 0.272222f, 0.000000f },    // 631 nm
    { 0.602520f, 0.260990f, 0.000000f },    // 632 nm
    { 0.579890f, 0.249877f, 0.000000f },    // 633 nm
    { 0.557370f, 0.238946f, 0.000000f },    // 634 nm
    { 0.535110f, 0.228254f, 0.000000f },    // 635 nm
    { 0.513240f, 0.217853f, 0.000000f },    // 636 nm
    { 0.491860f, 0.207780f, 0.000000f },    // 637 nm
    { 0.471080f, 0.198072f, 0.000000f },    // 638 nm
    { 0.450960f, 0.188748f, 0.000000f },    // 639 nm
    { 0.431567f, 0.179828f, 0.000000f },    // 640 nm
    { 0.412870f, 0.171285f, 0.000000f },    // 641 nm
    { 0.394750f, 0.163059f, 0.000000f },    // 642 nm
    { 0.377210f, 0.155151f, 0.000000f },    // 643 nm
    { 0.360190f, 0.147535f, 0.000000f },    // 644 nm
    { 0.343690f, 0.140211f, 0.000000f },    // 645 nm
    { 0.327690f, 0.133170f, 0.000000f },    // 646 nm
    { 0.312170f, 0.126400f, 0.000000f },    // 647 nm
    { 0.297110f, 0.119892f, 0.000000f },    // 648 nm
    { 0.282500f, 0.113640f, 0.000000f },    // 649 nm
    { 0.268329f, 0.107633f, 0.000000f },    // 650 nm
    { 0.254590f, 0.101870f, 0.000000f },    // 651 nm
    { 0.241300f, 0.096347f, 0.000000f },    // 652 nm
    { 0.228480f, 0.091063f, 0.000000f },    // 653 nm
    { 0.216140f, 0.086010f, 0.000000f },    // 654 nm
    { 0.204300f, 0.081187f, 0.000000f },    // 655 nm
    { 0.192950f, 0.076583f, 0.000000f },    // 656 nm
    { 0.182110f, 0.072198f, 0.000000f },    // 657 nm
    { 0.171770f, 0.068024f, 0.000000f },    // 658 nm
    { 0.161920f, 0.064052f, 0.000000f },    // 659 nm
    { 0.152568f, 0.060281f, 0.000000f },    // 660 nm
    { 0.143670f, 0.056697f, 0.000000f },    // 661 nm
    { 0.135200f, 0.053292f, 0.000000f },    // 662 nm
    { 0.127130f, 0.050059f, 0.000000f },    // 663 nm
    { 0.119480f, 0.046998f, 0.000000f },    // 664 nm
    { 0.112210f, 0.044096f, 0.000000f },    // 665 nm
    { 0.105310f, 0.041345f, 0.000000f },    // 666 nm
    { 0.098786f, 0.038751f, 0.000000f },    // 667 nm
    { 0.092610f, 0.036298f, 0.000000f },    // 668 nm
    { 0.086773f, 0.033983f, 0.000000f },    // 669 nm
    { 0.081261f, 0.031800f, 0.000000f },    // 670 nm
    { 0.076048f, 0.029739f, 0.000000f },    // 671 nm
    { 0.071114f, 0.027792f, 0.000000f },    // 672 nm
    { 0.066454f, 0.025955f, 0.000000f },    // 673 nm
    { 0.062062f, 0.024226f, 0.000000f },    // 674 nm
    { 0.057930f, 0.022602f, 0.000000f },    // 675 nm
    { 0.054050f, 0.021078f, 0.000000f },    // 676 nm
    { 0.050412f, 0.019651f, 0.000000f },    // 677 nm
    { 0.047006f, 0.018315f, 0.000000f },    // 678 nm
    { 0.043823f, 0.017069f, 0.000000f },    // 679 nm
    { 0.040851f, 0.015905f, 0.000000f },    // 680 nm
    { 0.038072f, 0.014818f, 0.000000f },    // 681 nm
    { 0.035468f, 0.013801f, 0.000000f },    // 682 nm
    { 0.033031f, 0.012850f, 0.000000f },    // 683 nm
    { 0.030753f, 0.011961f, 0.000000f },    // 684 nm
    { 0.028623f, 0.011130f, 0.000000f },    // 685 nm
    { 0.026635f, 0.010355f, 0.000000f },    // 686 nm
    { 0.024781f, 0.009633f, 0.000000f },    // 687 nm
    { 0.023052f, 0.008960f, 0.000000f },    // 688 nm
    { 0.021441f, 0.008332f, 0.000000f },    // 689 nm
    { 0.019941f, 0.007749f, 0.000000f },    // 690 nm
    { 0.018544f, 0.007205f, 0.000000f },    // 691 nm
    { 0.017241f, 0.006698f, 0.000000f },    // 692 nm
    { 0.016027f, 0.006225f, 0.000000f },    // 693 nm
    { 0.014896f, 0.005785f, 0.000000f },    // 694 nm
    { 0.013842f, 0.005375f, 0.000000f },    // 695 nm
    { 0.012862f, 0.004994f, 0.000000f },    // 696 nm
    { 0.011949f, 0.004639f, 0.000000f },    // 697 nm
    { 0.011100f, 0.004309f, 0.000000f },    // 698 nm
    { 0.010311f, 0.004003f, 0.000000f },    // 699 nm
    { 0.009577f, 0.003718f, 0.000000f },    // 700 nm
    { 0.008894f, 0.003453f, 0.000000f },    // 701 nm
    { 0.008258f, 0.003206f, 0.000000f },    // 702 nm
    { 0.007666f, 0.002976f, 0.000000f },    // 703 nm
    { 0.007116f, 0.002763f, 0.000000f },    // 704 nm
    { 0.006605f, 0.002565f, 0.000000f },    // 705 nm
    { 0.006131f, 0.002381f, 0.000000f },    // 706 nm
    { 0.005690f, 0.002210f, 0.000000f },    // 707 nm
    { 0.005282f, 0.002051f, 0.000000f },    // 708 nm
    { 0.004903f, 0.001904f, 0.000000f },    // 709 nm
    { 0.004553f, 0.001768f, 0.000000f },    // 710 nm
    { 0.004227f, 0.001642f, 0.000000f },    // 711 nm
    { 0.003926f, 0.001525f, 0.000000f },    // 712 nm
    { 0.003646f, 0.001417f, 0.000000f },    // 713 nm
    { 0.003386f, 0.001316f, 0.000000f },    // 714 nm
    { 0.003145f, 0.001222f, 0.000000f },    // 715 nm
    { 0.002921f, 0.001136f, 0.000000f },    // 716 nm
    { 0.002713f, 0.001055f, 0.000000f },    // 717 nm
    { 0.002520f, 0.000980f, 0.000000f },    // 718 nm
    { 0.002341f, 0.000911f, 0.000000f },    // 719 nm
    { 0.002175f, 0.000846f, 0.000000f },    // 720 nm
    { 0.002021f, 0.000786f, 0.000000f },    // 721 nm
    { 0.001877f, 0.000731f, 0.000000f },    // 722 nm
    { 0.001744f, 0.000679f, 0.000000f },    // 723 nm
    { 0.001620f, 0.000631f, 0.000000f },    // 724 nm
    { 0.001506f, 0.000586f, 0.000000f },    // 725 nm
    { 0.001399f, 0.000545f, 0.000000f },    // 726 nm
    { 0.001300f, 0.000507f, 0.000000f },    // 727 nm
    { 0.001209f, 0.000471f, 0.000000f },    // 728 nm
    { 0.001124f, 0.000438f, 0.000000f },    // 729 nm
    { 0.001045f, 0.000407f, 0.000000f },    // 730 nm
    { 0.000972f, 0.000379f, 0.000000f },    // 731 nm
    { 0.000904f, 0.000353f, 0.000000f },    // 732 nm
    { 0.000840f, 0.000328f, 0.000000f },    // 733 nm
    { 0.000782f, 0.000305f, 0.000000f },    // 734 nm
    { 0.000728f, 0.000284f, 0.000000f },    // 735 nm
    { 0.000677f, 0.000264f, 0.000000f },    // 736 nm
    { 0.000630f, 0.000246f, 0.000000f },    // 737 nm
    { 0.000586f, 0.000229f, 0.000000f },    // 738 nm
    { 0.000546f, 0.000213f, 0.000000f },    // 739 nm
    { 0.000508f, 0.000199f, 0.000000f },    // 740 nm
    { 0.000473f, 0.000185f, 0.000000f },    // 741 nm
    { 0.000441f, 0.000173f, 0.000000f },    // 742 nm
    { 0.000411f, 0.000161f, 0.000000f },    // 743 nm
    { 0.000383f, 0.000150f, 0.000000f },    // 744 nm
    { 0.000356f, 0.000140f, 0.000000f },    // 745 nm
    { 0.000332f, 0.000130f, 0.000000f },    // 746 nm
    { 0.000310f, 0.000121f, 0.000000f },    // 747 nm
    { 0.000289f, 0.000113f, 0.000000f },    // 748 nm
    { 0.000269f, 0.000106f, 0.000000f },    // 749 nm
    { 0.000251f, 0.000098f, 0.000000f },    // 750 nm
    { 0.000234f, 0.000092f, 0.000000f },    // 751 nm
    { 0.000219f, 0.000086f, 0.000000f },    // 752 nm
    { 0.000204f, 0.000080f, 0.000000f },    // 753 nm
    { 0.000190f, 0.000075f, 0.000000f },    // 754 nm
    { 0.000178f, 0.000070f, 0.000000f },    // 755 nm
    { 0.000166f, 0.000065f, 0.000000f },    // 756 nm
    { 0.000155f, 0.000061f, 0.000000f },    // 757 nm
    { 0.000145f, 0.000057f, 0.000000f },    // 758 nm
    { 0.000135f, 0.000053f, 0.000000f },    // 759 nm
    { 0.000126f, 0.000050f, 0.000000f },    // 760 nm
    { 0.000118f, 0.000046f, 0.000000f },    // 761 nm
    { 0.000110f, 0.000043f, 0.000000f },    // 762 nm
    { 0.000103f, 0.000041f, 0.000000f },    // 763 nm
    { 0.000096f, 0.000038f, 0.000000f },    // 764 nm
    { 0.000090f, 0.000036f, 0.000000f },    // 765 nm
    { 0.000084f, 0.000033f, 0.000000f },    // 766 nm
    { 0.000079f, 0.000031f, 0.000000f },    // 767 nm
    { 0.000074f, 0.000029f, 0.000000f },    // 768 nm
    { 0.000069f, 0.000027f, 0.000000f },    // 769 nm
    { 0.000065f, 0.000025f, 0.000000f },    // 770 nm
    { 0.000060f, 0.000024f, 0.000000f },    // 771 nm
    { 0.000057f, 0.000022f, 0.000000f },    // 772 nm
    { 0.000053f, 0.000021f, 0.000000f },    // 773 nm
    { 0.000049f, 0.000020f, 0.000000f },    // 774 nm
    { 0.000046f, 0.000018f, 0.000000f },    // 775 nm
    { 0.000043f, 0.000017f, 0.000000f },    // 776 nm
    { 0.000041f, 0.000016f, 0.000000f },    // 777 nm
    { 0.000038f, 0.000015f, 0.000000f },    // 778 nm
    { 0.000036f, 0.000014f, 0.000000f },    // 779 nm
    { 0.000033f, 0.000013f, 0.000000f },    // 780 nm
    { 0.000031f, 0.000012f, 0.000000f },    // 781 nm
    { 0.000029f, 0.000012f, 0.000000f },    // 782 nm
    { 0.000028f, 0.000011f, 0.000000f },    // 783 nm
    { 0.000026f, 0.000010f, 0.000000f },    // 784 nm
    { 0.000024f, 0.000010f, 0.000000f },    // 785 nm
    { 0.000023f, 0.000009f, 0.000000f },    // 786 nm
    { 0.000021f, 0.000008f, 0.000000f },    // 787 nm
    { 0.000020f, 0.000008f, 0.000000f },    // 788 nm
    { 0.000019f, 0.000007f, 0.000000f },    // 789 nm
    { 0.000018f, 0.000007f, 0.000000f },    // 790 nm
    { 0.000017f, 0.000007f, 0.000000f },    // 791 nm
    { 0.000016f, 0.000006f, 0.000000f },    // 792 nm
    { 0.000015f, 0.000006f, 0.000000f },    // 793 nm
    { 0.000014f, 0.000005f, 0.000000f },    // 794 nm
    { 0.000013f, 0.000005f, 0.000000f },    // 795 nm
    { 0.000012f, 0.000005f, 0.000000f },    // 796 nm
    { 0.000011f, 0.000005f, 0.000000f },    // 797 nm
    { 0.000011f, 0.000004f, 0.000000f },    // 798 nm
    { 0.000010f, 0.000004f, 0.000000f },    // 799 nm
    { 0.000009f, 0.000004f, 0.000000f },    // 800 nm
    { 0.000009f, 0.000004f, 0.000000f },    // 801 nm
    { 0.000008f, 0.000003f, 0.000000f },    // 802 nm
    { 0.000008f, 0.000003f, 0.000000f },    // 803 nm
    { 0.000007f, 0.000003f, 0.000000f },    // 804 nm
    { 0.000007f, 0.000003f, 0.000000f },    // 805 nm
    { 0.000007f, 0.000003f, 0.000000f },    // 806 nm
    { 0.000006f, 0.000002f, 0.000000f },    // 807 nm
    { 0.000006f, 0.000002f, 0.000000f },    // 808 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 809 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 810 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 811 nm
    { 0.000005f, 0.000002f, 0.000000f },    // 812 nm
    { 0.000004f, 0.000002f, 0.000000f },    // 813 nm
    { 0.000004f, 0.000002f, 0.000000f },    // 814 nm
    { 0.000004f, 0.000002f, 0.000000f },    // 815 nm
    { 0.000004f, 0.000001f, 0.000000f },    // 816 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 817 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 818 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 819 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 820 nm
    { 0.000003f, 0.000001f, 0.000000f },    // 821 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 822 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 823 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 824 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 825 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 826 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 827 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 828 nm
    { 0.000002f, 0.000001f, 0.000000f },    // 829 nm
    { 0.000002f, 0.000001f, 0.000000f }     // 830 nm
};
#endif
