from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


AifiraMap = _Mock()

ArraySave = _Mock()

COLORMAPLIST = _Mock()

CloseEventNotifyingWidget = _Mock()

ColormapDialog = _Mock()

DataObject = _Mock()

EDFStack = _Mock()

ExternalImagesWindow = _Mock()

IconDict = _Mock()

LuciaMap = _Mock()

MaskImageWidget = _Mock()

McaWindow = _Mock()

NNMAWindow = _Mock()

OmnicMap = _Mock()

OpusDPTMap = _Mock()

PCAWindow = _Mock()

PyMcaDirs = _Mock()

QHDF5Stack1D = _Mock()

QPyMcaMatplotlibSave = _Mock()

Qwt5 = _Mock()

RGBCorrelator = _Mock()

RGBCorrelatorGraph = _Mock()

SGWindow = _Mock()

SNIPWindow = _Mock()

SpecFileStack = _Mock()

SpecfitFuns = _Mock()

StackROIWindow = _Mock()

StackSimpleFitWindow = _Mock()

SupaVisioMap = _Mock()

copy = _Mock()

numpy = _Mock()

os = _Mock()

qt = _Mock()

runAsMain = _Mock()

spslut = _Mock()

sys = _Mock()

time = _Mock()

DEBUG = 0

HDF5 = _Mock()

MATPLOTLIB = _Mock()

NNMA = _Mock()

PCA = _Mock()

QTVERSION = '4.8.6'

SNIP = _Mock()

class ImageShapeDialog(_Mock):
  pass
  Accepted = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rejected = 0

class QEDFStackWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QSpecFileStack(_Mock):
  pass
  GETDATA_DEPRECATION_WARNING = True
  GETINFO_DEPRECATION_WARNING = True
  SELECT_DEPRECATION_WARNING = True

class QStack(_Mock):
  pass
  GETDATA_DEPRECATION_WARNING = True
  GETINFO_DEPRECATION_WARNING = True
  SELECT_DEPRECATION_WARNING = True

class SimpleThread(_Mock):
  pass
  HighPriority = 4
  HighestPriority = 5
  IdlePriority = 0
  InheritPriority = 7
  LowPriority = 2
  LowestPriority = 1
  NormalPriority = 3
  TimeCriticalPriority = 6

