/* i386-bsd.elf.execve-entry.h
   created from i386-bsd.elf.execve-entry.bin, 30398 (0x76be) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2024 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2024 Laszlo Molnar
   Copyright (C) 2000-2024 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_BSD_ELF_EXECVE_ENTRY_SIZE    30398
#define STUB_I386_BSD_ELF_EXECVE_ENTRY_ADLER32 0xb76faea6
#define STUB_I386_BSD_ELF_EXECVE_ENTRY_CRC32   0x600ad90d

unsigned char stub_i386_bsd_elf_execve_entry[30398] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  40, 34,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,232,252,255,255,255,184,  0,  0,  0,  0, 96,106,
/* 0x0040 */   0,139,116, 36, 40,139,124, 36, 48,131,205,255,235,  3,164,235,
/* 0x0050 */   3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,
/* 0x0060 */  17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,
/* 0x0070 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,
/* 0x0080 */   7,139, 30,131,238,252, 17,219,115,255,  1,219,115,255,117,  9,
/* 0x0090 */ 139, 30,131,238,252, 17,219,115,255, 49,201,131,232,  3,114, 13,
/* 0x00a0 */ 193,224,  8,138,  6, 70,131,240,255,116,255,137,197,  1,219,117,
/* 0x00b0 */   7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,
/* 0x00c0 */ 131,238,252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,
/* 0x00d0 */ 131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x00e0 */  17,219,115, 48,  1,219,115, 48,117,  9,139, 30,131,238,252, 17,
/* 0x00f0 */ 219,115, 48, 65, 65,131,193,  2,129,253,  0,243,255,255,131,209,
/* 0x0100 */   1, 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,
/* 0x0110 */ 131,253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,
/* 0x0120 */ 247,233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,
/* 0x0130 */ 131,233,  4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,
/* 0x0140 */   3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,
/* 0x0150 */  17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,
/* 0x0160 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,
/* 0x0170 */   7,139, 30,131,238,252, 17,219,114, 15,  1,219,115, 11,117, 15,
/* 0x0180 */ 139, 30,131,238,252, 17,219,114, 15, 72,  1,219,117,  7,139, 30,
/* 0x0190 */ 131,238,252, 17,219, 17,192,235,255, 49,201,131,232,  3,114, 17,
/* 0x01a0 */ 193,224,  8,138,  6, 70,131,240,255,116,255,209,248,137,197,235,
/* 0x01b0 */  11,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,
/* 0x01c0 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,  1,219,
/* 0x01d0 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139,
/* 0x01e0 */  30,131,238,252, 17,219,115, 68,  1,219,115, 68,117,  9,139, 30,
/* 0x01f0 */ 131,238,252, 17,219,115, 68, 65, 65,131,193,  2,129,253,  0,251,
/* 0x0200 */ 255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,255,255,
/* 0x0210 */ 255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,136,
/* 0x0220 */   7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,137,
/* 0x0230 */   7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,255,
/* 0x0240 */ 235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139,
/* 0x0250 */  30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,
/* 0x0260 */   1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0270 */ 192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 30,  1,219,
/* 0x0280 */ 115, 11,117, 30,139, 30,131,238,252, 17,219,114, 30, 72,  1,219,
/* 0x0290 */ 117,  7,139, 30,131,238,252, 17,219, 17,192,235,255,  1,219,117,
/* 0x02a0 */   7,139, 30,131,238,252, 17,219, 17,201,235,255, 49,201,131,232,
/* 0x02b0 */   3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,248,
/* 0x02c0 */ 137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x02d0 */ 204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,114,190,  1,
/* 0x02e0 */ 219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,
/* 0x02f0 */ 139, 30,131,238,252, 17,219,115, 81,  1,219,115, 81,117,  9,139,
/* 0x0300 */  30,131,238,252, 17,219,115, 81, 65, 65,131,193,  2,129,253,  0,
/* 0x0310 */ 251,255,255,131,209,  2, 86,141, 52, 47,243,164, 94,233,252,255,
/* 0x0320 */ 255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,
/* 0x0330 */ 136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,
/* 0x0340 */ 137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,
/* 0x0350 */ 255,128,126,252, 14,116,  1,244,137,229,141,156, 36,  0,  0,  0,
/* 0x0360 */   0, 49,192, 80, 57,220,117,251, 83,255,118,244, 87,131,195,  4,
/* 0x0370 */  83,139, 70,248, 72, 72, 80, 70, 70, 86,131,195,  4, 83, 41,192,
/* 0x0380 */  80,199,  3,  0,  0,  0,  0,137,229,139, 85, 44,172, 74,136,193,
/* 0x0390 */  36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164, 92,144,
/* 0x03a0 */ 241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,195,  4,
/* 0x03b0 */ 139, 77, 52,255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,
/* 0x03c0 */ 193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85,
/* 0x03d0 */  87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,
/* 0x03e0 */ 116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,
/* 0x03f0 */   0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,
/* 0x0400 */   2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,
/* 0x0410 */ 211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182,
/* 0x0420 */  50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,
/* 0x0430 */ 199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199,
/* 0x0440 */  68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199,
/* 0x0450 */  68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,
/* 0x0460 */ 182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,
/* 0x0470 */ 116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,
/* 0x0480 */ 246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,
/* 0x0490 */ 255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,
/* 0x04a0 */ 210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,
/* 0x04b0 */   8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,
/* 0x04c0 */   0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,
/* 0x04d0 */ 116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116,
/* 0x04e0 */  36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119,
/* 0x04f0 */  24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8,
/* 0x0500 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,
/* 0x0510 */   0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,
/* 0x0520 */   0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,
/* 0x0530 */ 100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,
/* 0x0540 */ 115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,
/* 0x0550 */ 120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,
/* 0x0560 */ 105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,
/* 0x0570 */   0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116,
/* 0x0580 */  43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137,
/* 0x0590 */  68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108,
/* 0x05a0 */  36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,
/* 0x05b0 */ 141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36,
/* 0x05c0 */  76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,
/* 0x05d0 */ 231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,
/* 0x05e0 */ 193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36,
/* 0x05f0 */  72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36,
/* 0x0600 */  60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46,
/* 0x0610 */  41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102,
/* 0x0620 */  41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,
/* 0x0630 */ 129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,
/* 0x0640 */ 255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,
/* 0x0650 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,
/* 0x0660 */   7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x0670 */ 199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,
/* 0x0680 */ 175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x0690 */ 240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41,
/* 0x06a0 */  68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,
/* 0x06b0 */ 193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,
/* 0x06c0 */ 160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,
/* 0x06d0 */   3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233,
/* 0x06e0 */  27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,
/* 0x06f0 */ 233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139,
/* 0x0700 */  76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,232,
/* 0x0710 */   5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,139,108,
/* 0x0720 */  36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76,
/* 0x0730 */  15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,
/* 0x0740 */   9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,
/* 0x0750 */   0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,
/* 0x0760 */   8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,
/* 0x0770 */ 141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,
/* 0x0780 */ 137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68,
/* 0x0790 */  36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,
/* 0x07a0 */   0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206,
/* 0x07b0 */  41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,
/* 0x07c0 */ 194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22,
/* 0x07d0 */  59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,
/* 0x07e0 */ 193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,
/* 0x07f0 */ 139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,
/* 0x0800 */ 227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36,
/* 0x0810 */  52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36,
/* 0x0820 */  56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,
/* 0x0830 */ 193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,
/* 0x0840 */ 119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,
/* 0x0850 */ 231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,
/* 0x0860 */ 240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76,
/* 0x0870 */  36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,
/* 0x0880 */ 124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,
/* 0x0890 */ 147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,
/* 0x08a0 */   0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36,
/* 0x08b0 */  96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,
/* 0x08c0 */ 115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198,
/* 0x08d0 */  41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,224,  1,
/* 0x08e0 */   0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,
/* 0x08f0 */ 108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,102,137,
/* 0x0900 */ 141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,
/* 0x0910 */   0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36,
/* 0x0920 */  56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202,
/* 0x0930 */  15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,
/* 0x0940 */ 139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,
/* 0x0950 */   0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,
/* 0x0960 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,
/* 0x0970 */ 255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76,
/* 0x0980 */  15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,
/* 0x0990 */   9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,
/* 0x09a0 */   0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,
/* 0x09b0 */   8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,
/* 0x09c0 */ 137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199,
/* 0x09d0 */  41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,
/* 0x09e0 */ 137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84,
/* 0x09f0 */  36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68,
/* 0x0a00 */  36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,
/* 0x0a10 */ 120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68,
/* 0x0a20 */  36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,
/* 0x0a30 */ 243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x0a40 */ 102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,
/* 0x0a50 */ 115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36,
/* 0x0a60 */  68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,
/* 0x0a70 */ 102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,
/* 0x0a80 */ 114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,129,254,
/* 0x0a90 */ 255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,
/* 0x0aa0 */   3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,
/* 0x0ab0 */ 139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,
/* 0x0ac0 */ 115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36,
/* 0x0ad0 */  68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,
/* 0x0ae0 */ 139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137,
/* 0x0af0 */  76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,
/* 0x0b00 */ 199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,
/* 0x0b10 */   0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137,
/* 0x0b20 */  81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,
/* 0x0b30 */ 186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,
/* 0x0b40 */   1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,
/* 0x0b50 */  15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x0b60 */   8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,
/* 0x0b70 */ 202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0b80 */   0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21,
/* 0x0b90 */  41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,102,
/* 0x0ba0 */ 137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,
/* 0x0bb0 */ 138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36,
/* 0x0bc0 */  44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,
/* 0x0bd0 */ 131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,
/* 0x0be0 */   0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,
/* 0x0bf0 */ 141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,
/* 0x0c00 */ 141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,
/* 0x0c10 */   0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36,
/* 0x0c20 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x0c30 */ 139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137,
/* 0x0c40 */  68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x0c50 */ 102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,
/* 0x0c60 */ 193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36,
/* 0x0c70 */  77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36,
/* 0x0c80 */  15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,141,
/* 0x0c90 */  72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108,
/* 0x0ca0 */  36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5,
/* 0x0cb0 */  94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36,
/* 0x0cc0 */  72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,
/* 0x0cd0 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,
/* 0x0ce0 */ 108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,
/* 0x0cf0 */ 206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5,
/* 0x0d00 */  68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,
/* 0x0d10 */ 199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,
/* 0x0d20 */   4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,
/* 0x0d30 */   0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36,
/* 0x0d40 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x0d50 */ 139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,
/* 0x0d60 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,
/* 0x0d70 */   2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,
/* 0x0d80 */ 199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137,
/* 0x0d90 */  85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100,
/* 0x0da0 */  36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36,
/* 0x0db0 */  70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,
/* 0x0dc0 */ 193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,
/* 0x0dd0 */ 234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,
/* 0x0de0 */   6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,
/* 0x0df0 */ 139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,
/* 0x0e00 */ 132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,
/* 0x0e10 */ 129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,
/* 0x0e20 */   0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,
/* 0x0e30 */ 156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139,
/* 0x0e40 */  76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,
/* 0x0e50 */ 124, 91, 94, 95, 93, 85, 87, 86, 83,131,236,124,139,148, 36,144,
/* 0x0e60 */   0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,
/* 0x0e70 */ 139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,
/* 0x0e80 */   0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76,
/* 0x0e90 */  36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,
/* 0x0ea0 */ 168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68,
/* 0x0eb0 */  36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,
/* 0x0ec0 */   0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36,
/* 0x0ed0 */  88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36,
/* 0x0ee0 */  80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,
/* 0x0ef0 */   7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,
/* 0x0f00 */   0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,
/* 0x0f10 */ 199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,152,  0,  0,
/* 0x0f20 */   0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,
/* 0x0f30 */   0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,126,231,
/* 0x0f40 */ 139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,
/* 0x0f50 */   0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,
/* 0x0f60 */ 120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,255,255,
/* 0x0f70 */ 255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,
/* 0x0f80 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,
/* 0x0f90 */  68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,175,193,
/* 0x0fa0 */  57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0fb0 */   0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,
/* 0x0fc0 */   4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35,
/* 0x0fd0 */  68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76,
/* 0x0fe0 */  36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,
/* 0x0ff0 */   6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,
/* 0x1000 */   0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,
/* 0x1010 */   0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36,
/* 0x1020 */  64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,129,124,
/* 0x1030 */  36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44,
/* 0x1040 */  16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36,
/* 0x1050 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x1060 */ 139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,
/* 0x1070 */ 199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,
/* 0x1080 */ 193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,
/* 0x1090 */   0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,
/* 0x10a0 */   1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,102,137,141,
/* 0x10b0 */   0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,
/* 0x10c0 */ 255,255,235,121,129,254,255,  0,  0,  0,127,113,141, 20, 54,139,
/* 0x10d0 */ 108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x10e0 */  92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x10f0 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,
/* 0x1100 */ 232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,
/* 0x1110 */ 184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,  1,102,
/* 0x1120 */ 137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,
/* 0x1130 */ 102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,139, 84, 36,
/* 0x1140 */ 116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4,
/* 0x1150 */  10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36,
/* 0x1160 */  96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127,
/* 0x1170 */  10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,
/* 0x1180 */ 233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,
/* 0x1190 */ 193,137,208,102,193,232,  5,102, 41,194,129,249,255,255,255,  0,
/* 0x11a0 */ 102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,116, 36, 56,
/* 0x11b0 */ 119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,
/* 0x11c0 */ 231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,200,193,232,
/* 0x11d0 */  11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,
/* 0x11e0 */ 115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,
/* 0x11f0 */ 248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36,
/* 0x1200 */  80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,
/* 0x1210 */ 137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,
/* 0x1220 */ 159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,
/* 0x1230 */ 116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,193,232,  5,
/* 0x1240 */ 139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,102,137,145,
/* 0x1250 */ 128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0,
/* 0x1260 */  15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,
/* 0x1270 */ 137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,
/* 0x1280 */ 175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,
/* 0x1290 */ 214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,
/* 0x12a0 */ 141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68,
/* 0x12b0 */  36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,
/* 0x12c0 */ 255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,
/* 0x12d0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,
/* 0x12e0 */ 149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,175,193,
/* 0x12f0 */  57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36,
/* 0x1300 */  52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,137,133,
/* 0x1310 */ 224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,
/* 0x1320 */   6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,192,141,
/* 0x1330 */  68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138,
/* 0x1340 */  68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233,
/* 0x1350 */  49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,  5,102, 41,
/* 0x1360 */ 194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,
/* 0x1370 */ 214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,215,129,254,
/* 0x1380 */ 255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36,
/* 0x1390 */  76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x13a0 */  67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,139,145,176,
/* 0x13b0 */   1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,137,198,184,
/* 0x13c0 */   0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,
/* 0x13d0 */ 102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,
/* 0x13e0 */ 137,241, 41,199, 41,193,137,208,102,193,232,  5,102, 41,194,139,
/* 0x13f0 */  68, 36, 56,129,249,255,255,255,  0,102,137,144,176,  1,  0,  0,
/* 0x1400 */ 119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,
/* 0x1410 */ 231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,200,193,232,
/* 0x1420 */  11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,
/* 0x1430 */ 115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,
/* 0x1440 */ 248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,
/* 0x1450 */ 235, 38,137,206, 41,199, 41,198,137,208,102,193,232,  5,102, 41,
/* 0x1460 */ 194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,
/* 0x1470 */ 139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,
/* 0x1480 */ 139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,131,124,
/* 0x1490 */  36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,
/* 0x14a0 */ 141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,119, 22,
/* 0x14b0 */  59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,
/* 0x14c0 */ 193,230,  8, 67,  9,199,102,139, 17,137,240,193,232, 11, 15,183,
/* 0x14d0 */ 234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,
/* 0x14e0 */   0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,
/* 0x14f0 */   0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,
/* 0x1500 */   4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,102,193,232,
/* 0x1510 */   5,102, 41,194,129,254,255,255,255,  0,102,137, 17,119, 22, 59,
/* 0x1520 */  92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x1530 */ 230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232, 11, 15,183,
/* 0x1540 */ 234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,
/* 0x1550 */   0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,
/* 0x1560 */   0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140,
/* 0x1570 */  17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,
/* 0x1580 */   0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,102,193,232,
/* 0x1590 */   5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,
/* 0x15a0 */   8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76,
/* 0x15b0 */  36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141,
/* 0x15c0 */  44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,
/* 0x15d0 */ 119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,
/* 0x15e0 */   8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,
/* 0x15f0 */  22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68,
/* 0x1600 */  36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,
/* 0x1610 */ 234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,
/* 0x1620 */ 232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,
/* 0x1630 */ 137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,
/* 0x1640 */ 224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12,
/* 0x1650 */  15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,
/* 0x1660 */ 126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,199, 68,
/* 0x1670 */  36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,
/* 0x1680 */   8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,
/* 0x1690 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,
/* 0x16a0 */   2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x16b0 */ 199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,
/* 0x16c0 */ 193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,
/* 0x16d0 */ 193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36,
/* 0x16e0 */  72, 41,199,137,208,102,193,232,  5,102, 41,194,141, 69,  1,102,
/* 0x16f0 */ 137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,
/* 0x1700 */ 131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,
/* 0x1710 */ 209,248,131,230,  1,141, 72,255,131,206,  2,131,250, 13,137, 76,
/* 0x1720 */  36, 32,127, 28,139,108, 36,120,211,230,  1,210,137, 52, 36,141,
/* 0x1730 */  68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,
/* 0x1740 */ 141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36,
/* 0x1750 */  76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,
/* 0x1760 */ 231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,
/* 0x1770 */   7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,120,193,
/* 0x1780 */ 230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,
/* 0x1790 */   0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,
/* 0x17a0 */   0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,
/* 0x17b0 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,
/* 0x17c0 */   0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x17d0 */ 199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,
/* 0x17e0 */ 175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x17f0 */ 240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235,
/* 0x1800 */  31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,
/* 0x1810 */ 139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,
/* 0x1820 */ 139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,
/* 0x1830 */ 255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36,
/* 0x1840 */  12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,139,132,
/* 0x1850 */  36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,
/* 0x1860 */   0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255,
/* 0x1870 */  68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,
/* 0x1880 */ 116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116,
/* 0x1890 */  15,130,187,246,255,255,129,124, 36, 72,255,255,255,  0,119, 21,
/* 0x18a0 */  59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,
/* 0x18b0 */   0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148,
/* 0x18c0 */  36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,
/* 0x18d0 */   0,  0,137, 11,131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,
/* 0x18e0 */ 248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,204,117,
/* 0x18f0 */ 251,137,236, 49,201,139, 84, 36, 40,  3, 84, 36, 44, 57,242,116,
/* 0x1900 */   1, 72,135, 68, 36, 32,139, 84, 36, 52,137,249,139,124, 36, 48,
/* 0x1910 */  41,249,137, 10, 90, 87,106, 15, 91,136,215,147,233,252,255,255,
/* 0x1920 */ 255,235,  4, 90, 88, 89,151, 96, 49,219,187,  0,  0,  0,  0,106,
/* 0x1930 */  15, 88,138,100, 36, 32,106, 15, 91,138,124, 36, 32,138, 84, 36,
/* 0x1940 */  32,233,252,255,255,255, 15,183, 47, 43,110, 12, 41,221,117,255,
/* 0x1950 */ 131,237,  1,115,255,136, 95,255, 73,136,  7, 71,139,  7,156,102,
/* 0x1960 */ 193,232,  8,193,192, 16,134,196,157,115,255,176,  0, 15,200,115,
/* 0x1970 */ 255,193,232,  1,115,  4,254,203, 75, 35, 30,125,  2,  3, 30,137,
/* 0x1980 */   4,156,235,255,141, 20, 24, 15,182,210, 35, 22, 59, 22,114,  2,
/* 0x1990 */  43, 22,139,  4,148,254,203, 75, 35, 30,125,  2,  3, 30,139, 44,
/* 0x19a0 */ 156,133,237,117,  9, 80,139, 70,  4,254,200, 72, 35,  6,125,  2,
/* 0x19b0 */   3,  6, 49,237,137, 70,  4,135,108,132,  4, 88,137, 44,148,137,
/* 0x19c0 */   4,156, 41,248,131,233,  4,  3, 70, 16,  1,240,137,  7,131,199,
/* 0x19d0 */   4,235,255, 80,176,233,176,232, 80,106,  0, 83,137,230, 94,137,
/* 0x19e0 */ 218,178,233,178,232, 67,106,  0,254,203, 75,117,255, 15,183,  7,
/* 0x19f0 */ 131,199,  1, 60,128,114,  4, 60,143,118,255, 41,208, 43, 70,  8,
/* 0x1a00 */ 131,232,  2,116,255,131,232,  1,114,255,115,255,122,  0,123,  0,
/* 0x1a10 */ 248,235,255,131,233,  1,127,255,137,231,185,  4,  1,  0,  0,139,
/* 0x1a20 */  14,131,193,  5,139, 14,131,193,  4, 49,192,243,171,137,252, 86,
/* 0x1a30 */  97,151, 81, 80, 82,195,137,254,235, 31,138,  7, 71, 60,128,114,
/* 0x1a40 */  10, 60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,
/* 0x1a50 */ 255,131,249,  4,114,  4,139,  7, 40,208,117,255,134,196,193,192,
/* 0x1a60 */  16,134,196, 41,248,  1,240,131,233,  4,171,131,233,  1,114,  4,
/* 0x1a70 */ 138,  7, 71,235, 13,131,233,  1,115,  3,185,  0,  0,  0,  0,137,
/* 0x1a80 */ 254,138,  7, 71, 44,232, 60,  1,119,247,128, 63,  0,117,  6,139,
/* 0x1a90 */   7,138, 95,  4,102,193,232,  8,134,196,193,192, 16,134,196, 41,
/* 0x1aa0 */ 248,128,235,232,  1,240,137,  7,131,199,  5,136,216,226, 11,185,
/* 0x1ab0 */   0,  0,  0,  0,176,232,176,233,242,174,117,  6,128, 63,  0,117,
/* 0x1ac0 */ 255,139,  7,102,193,232,  8,134,196,193,192, 16,134,196, 41,248,
/* 0x1ad0 */   1,240,171,235,  4, 97,195, 93,187,  0, 16, 64,  0,102,105,108,
/* 0x1ae0 */ 101, 32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45,105,
/* 0x1af0 */  51, 56, 54, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x1b00 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b10 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x1b20 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x1b30 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x1b40 */ 108, 97,103,115, 10, 32, 32, 48, 32, 76, 69, 88, 69, 67, 48, 48,
/* 0x1b50 */  48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x1b60 */  32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1b70 */  69, 78, 84, 83, 10, 32, 32, 49, 32, 76, 69, 88, 69, 67, 48, 48,
/* 0x1b80 */  57, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x1b90 */  32, 48, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1ba0 */  69, 78, 84, 83, 10, 32, 32, 50, 32, 76, 69, 88, 69, 67, 48, 49,
/* 0x1bb0 */  48, 32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32,
/* 0x1bc0 */  32, 48, 51,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1bd0 */  69, 78, 84, 83, 10, 32, 32, 51, 32, 78, 50, 66, 83, 77, 65, 49,
/* 0x1be0 */  48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x1bf0 */  32, 48, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1c00 */  69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x1c10 */  48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x1c20 */  32, 48, 52,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1c30 */  69, 78, 84, 83, 10, 32, 32, 53, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x1c40 */  49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x1c50 */  32, 48, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1c60 */  69, 78, 84, 83, 10, 32, 32, 54, 32, 78, 50, 66, 68, 69, 67, 49,
/* 0x1c70 */  48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32,
/* 0x1c80 */  32, 48, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1c90 */  69, 78, 84, 83, 10, 32, 32, 55, 32, 78, 50, 66, 83, 77, 65, 50,
/* 0x1ca0 */  48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x1cb0 */  32, 48, 54, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1cc0 */  69, 78, 84, 83, 10, 32, 32, 56, 32, 78, 50, 66, 70, 65, 83, 50,
/* 0x1cd0 */  48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32,
/* 0x1ce0 */  32, 48, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1cf0 */  69, 78, 84, 83, 10, 32, 32, 57, 32, 78, 50, 66, 68, 69, 67, 50,
/* 0x1d00 */  48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32,
/* 0x1d10 */  32, 48, 55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1d20 */  69, 78, 84, 83, 10, 32, 49, 48, 32, 78, 50, 66, 83, 77, 65, 51,
/* 0x1d30 */  48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32,
/* 0x1d40 */  32, 48, 55,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1d50 */  69, 78, 84, 83, 10, 32, 49, 49, 32, 78, 50, 66, 70, 65, 83, 51,
/* 0x1d60 */  48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32,
/* 0x1d70 */  32, 48, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1d80 */  69, 78, 84, 83, 10, 32, 49, 50, 32, 78, 50, 66, 68, 69, 67, 51,
/* 0x1d90 */  48, 32, 32, 32, 32, 32, 32, 48, 51,101, 32, 32, 48, 32, 32, 48,
/* 0x1da0 */  32, 32, 48, 57, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1db0 */  84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 78, 50, 66, 83, 77, 65,
/* 0x1dc0 */  52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48,
/* 0x1dd0 */  32, 32, 48,100, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1de0 */  84, 69, 78, 84, 83, 10, 32, 49, 52, 32, 78, 50, 66, 70, 65, 83,
/* 0x1df0 */  52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48,
/* 0x1e00 */  32, 32, 48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1e10 */  84, 69, 78, 84, 83, 10, 32, 49, 53, 32, 78, 50, 66, 83, 77, 65,
/* 0x1e20 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x1e30 */  32, 32, 48,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1e40 */  84, 69, 78, 84, 83, 10, 32, 49, 54, 32, 78, 50, 66, 70, 65, 83,
/* 0x1e50 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48,
/* 0x1e60 */  32, 32, 48,102, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1e70 */  84, 69, 78, 84, 83, 10, 32, 49, 55, 32, 78, 50, 66, 68, 69, 67,
/* 0x1e80 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48,
/* 0x1e90 */  32, 32, 48,102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ea0 */  84, 69, 78, 84, 83, 10, 32, 49, 56, 32, 78, 50, 66, 83, 77, 65,
/* 0x1eb0 */  54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48,
/* 0x1ec0 */  32, 32, 48, 49, 48, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1ed0 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 57, 32, 78, 50, 66, 70, 65,
/* 0x1ee0 */  83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32,
/* 0x1ef0 */  32, 48, 32, 32, 48, 49, 48,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1f00 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 48, 32, 78, 50, 66,
/* 0x1f10 */  70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32,
/* 0x1f20 */  48, 32, 32, 48, 32, 32, 48, 49, 50, 54, 32, 32, 50, 42, 42, 48,
/* 0x1f30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 49, 32, 78,
/* 0x1f40 */  50, 66, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32,
/* 0x1f50 */  48, 32, 32, 48, 32, 32, 48, 49, 51, 99, 32, 32, 50, 42, 42, 48,
/* 0x1f60 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 50, 32, 78,
/* 0x1f70 */  50, 68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32,
/* 0x1f80 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 99, 32, 32, 50, 42, 42,
/* 0x1f90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 51, 32,
/* 0x1fa0 */  78, 50, 68, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x1fb0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,102, 32, 32, 50, 42,
/* 0x1fc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 52,
/* 0x1fd0 */  32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x1fe0 */  54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 52, 49, 32, 32, 50,
/* 0x1ff0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x2000 */  53, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x2010 */  48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 52, 55, 32, 32,
/* 0x2020 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2030 */  50, 54, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32,
/* 0x2040 */  32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53, 50, 32,
/* 0x2050 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2060 */  32, 50, 55, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32,
/* 0x2070 */  32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53, 55,
/* 0x2080 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2090 */  10, 32, 50, 56, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x20a0 */  32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 54,
/* 0x20b0 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x20c0 */  83, 10, 32, 50, 57, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32,
/* 0x20d0 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x20e0 */  54,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x20f0 */  84, 83, 10, 32, 51, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32,
/* 0x2100 */  32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2110 */  49, 55, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2120 */  78, 84, 83, 10, 32, 51, 49, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x2130 */  32, 32, 32, 32, 32, 32, 48, 53, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2140 */  32, 48, 49, 56, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2150 */  84, 69, 78, 84, 83, 10, 32, 51, 50, 32, 78, 50, 68, 83, 77, 65,
/* 0x2160 */  52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48,
/* 0x2170 */  32, 32, 48, 49,100, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2180 */  78, 84, 69, 78, 84, 83, 10, 32, 51, 51, 32, 78, 50, 68, 70, 65,
/* 0x2190 */  83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32,
/* 0x21a0 */  48, 32, 32, 48, 49,101, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x21b0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 52, 32, 78, 50, 68, 83,
/* 0x21c0 */  77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x21d0 */  32, 48, 32, 32, 48, 49,102, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x21e0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 53, 32, 78, 50, 68,
/* 0x21f0 */  70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48,
/* 0x2200 */  32, 32, 48, 32, 32, 48, 49,102, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x2210 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 54, 32, 78, 50,
/* 0x2220 */  68, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32,
/* 0x2230 */  48, 32, 32, 48, 32, 32, 48, 49,102, 99, 32, 32, 50, 42, 42, 48,
/* 0x2240 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 55, 32, 78,
/* 0x2250 */  50, 68, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32,
/* 0x2260 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 48, 53, 32, 32, 50, 42, 42,
/* 0x2270 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 56, 32,
/* 0x2280 */  78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x2290 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 49, 49, 32, 32, 50,
/* 0x22a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51,
/* 0x22b0 */  57, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32,
/* 0x22c0 */  48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 50, 97, 32,
/* 0x22d0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x22e0 */  32, 52, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32,
/* 0x22f0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 52, 48, 32,
/* 0x2300 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2310 */  32, 52, 49, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32,
/* 0x2320 */  32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 52, 48,
/* 0x2330 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2340 */  10, 32, 52, 50, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32,
/* 0x2350 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 52,
/* 0x2360 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2370 */  83, 10, 32, 52, 51, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32,
/* 0x2380 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2390 */  52, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x23a0 */  84, 83, 10, 32, 52, 52, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32,
/* 0x23b0 */  32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x23c0 */  50, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x23d0 */  78, 84, 83, 10, 32, 52, 53, 32, 78, 50, 69, 83, 77, 65, 50, 48,
/* 0x23e0 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x23f0 */  48, 50, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2400 */  69, 78, 84, 83, 10, 32, 52, 54, 32, 78, 50, 69, 70, 65, 83, 50,
/* 0x2410 */  48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32,
/* 0x2420 */  32, 48, 50, 53, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2430 */  84, 69, 78, 84, 83, 10, 32, 52, 55, 32, 78, 50, 69, 68, 69, 67,
/* 0x2440 */  50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48,
/* 0x2450 */  32, 32, 48, 50, 54, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2460 */  78, 84, 69, 78, 84, 83, 10, 32, 52, 56, 32, 78, 50, 69, 83, 77,
/* 0x2470 */  65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32,
/* 0x2480 */  48, 32, 32, 48, 50, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2490 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 57, 32, 78, 50, 69, 70,
/* 0x24a0 */  65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32,
/* 0x24b0 */  32, 48, 32, 32, 48, 50, 55,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x24c0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 48, 32, 78, 50, 69,
/* 0x24d0 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 53,102, 32, 32,
/* 0x24e0 */  48, 32, 32, 48, 32, 32, 48, 50, 56,100, 32, 32, 50, 42, 42, 48,
/* 0x24f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 49, 32, 78,
/* 0x2500 */  50, 69, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32,
/* 0x2510 */  32, 48, 32, 32, 48, 32, 32, 48, 50,101, 99, 32, 32, 50, 42, 42,
/* 0x2520 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 50, 32,
/* 0x2530 */  78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x2540 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50,102, 57, 32, 32, 50, 42,
/* 0x2550 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 51,
/* 0x2560 */  32, 78, 50, 69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2570 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 48, 56, 32, 32, 50,
/* 0x2580 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x2590 */  52, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x25a0 */  48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 48, 97, 32, 32,
/* 0x25b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x25c0 */  53, 53, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32,
/* 0x25d0 */  32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 48,100, 32,
/* 0x25e0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x25f0 */  32, 53, 54, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32,
/* 0x2600 */  32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 49, 54,
/* 0x2610 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2620 */  10, 32, 53, 55, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32,
/* 0x2630 */  32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x2640 */  50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2650 */  84, 83, 10, 32, 53, 56, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32,
/* 0x2660 */  32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2670 */  48, 51, 51, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2680 */  69, 78, 84, 83, 10, 32, 53, 57, 32, 78, 50, 69, 68, 69, 67, 54,
/* 0x2690 */  48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x26a0 */  48, 51, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x26b0 */  69, 78, 84, 83, 10, 32, 54, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x26c0 */  67, 48, 48, 32, 32, 32, 32, 48, 51, 54, 32, 32, 48, 32, 32, 48,
/* 0x26d0 */  32, 32, 48, 51, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x26e0 */  78, 84, 69, 78, 84, 83, 10, 32, 54, 49, 32, 76, 90, 77, 65, 95,
/* 0x26f0 */  69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48, 32,
/* 0x2700 */  32, 48, 32, 32, 48, 51, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2710 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 50, 32, 76, 90, 77,
/* 0x2720 */  65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 97, 56, 54, 32,
/* 0x2730 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 99,102, 32, 32, 50, 42, 42,
/* 0x2740 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 51, 32,
/* 0x2750 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 97,
/* 0x2760 */  56, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 53, 53, 32, 32,
/* 0x2770 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2780 */  54, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32,
/* 0x2790 */  32, 48, 49, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,100,
/* 0x27a0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x27b0 */  83, 10, 32, 54, 53, 32, 76, 69, 88, 69, 67, 48, 49, 53, 32, 32,
/* 0x27c0 */  32, 32, 32, 32, 48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x27d0 */  49, 56,102, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x27e0 */  69, 78, 84, 83, 10, 32, 54, 54, 32, 76, 69, 88, 69, 67, 49, 49,
/* 0x27f0 */  48, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x2800 */  32, 48, 49, 57, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2810 */  78, 84, 69, 78, 84, 83, 10, 32, 54, 55, 32, 76, 69, 88, 69, 67,
/* 0x2820 */  49, 48, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32,
/* 0x2830 */  48, 32, 32, 48, 49, 57, 49, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2840 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 56, 32, 76, 69, 88,
/* 0x2850 */  69, 67, 48, 49, 54, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x2860 */  32, 32, 48, 32, 32, 48, 49, 57, 49, 99, 32, 32, 50, 42, 42, 48,
/* 0x2870 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 57, 32, 76,
/* 0x2880 */  88, 85, 78, 70, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x2890 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 50, 49, 32, 32, 50, 42,
/* 0x28a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 48,
/* 0x28b0 */  32, 76, 88, 85, 78, 70, 48, 48, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x28c0 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 50, 51, 32, 32,
/* 0x28d0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x28e0 */  55, 49, 32, 77, 82, 85, 66, 89, 84, 69, 48, 32, 32, 32, 32, 32,
/* 0x28f0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 50, 56,
/* 0x2900 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2910 */  10, 32, 55, 50, 32, 76, 88, 77, 82, 85, 48, 48, 53, 32, 32, 32,
/* 0x2920 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x2930 */  50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2940 */  84, 83, 10, 32, 55, 51, 32, 76, 88, 77, 82, 85, 48, 48, 54, 32,
/* 0x2950 */  32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2960 */  49, 57, 50,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2970 */  69, 78, 84, 83, 10, 32, 55, 52, 32, 76, 88, 77, 82, 85, 48, 48,
/* 0x2980 */  55, 32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32,
/* 0x2990 */  32, 48, 49, 57, 51, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x29a0 */  78, 84, 69, 78, 84, 83, 10, 32, 55, 53, 32, 76, 88, 85, 78, 70,
/* 0x29b0 */  48, 48, 56, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x29c0 */  48, 32, 32, 48, 49, 57, 51,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x29d0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 54, 32, 76, 88, 85,
/* 0x29e0 */  78, 70, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x29f0 */  32, 32, 48, 32, 32, 48, 49, 57, 52, 49, 32, 32, 50, 42, 42, 48,
/* 0x2a00 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 55, 32, 76,
/* 0x2a10 */  88, 74, 67, 67, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32,
/* 0x2a20 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 52, 54, 32, 32, 50, 42,
/* 0x2a30 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 56,
/* 0x2a40 */  32, 76, 88, 77, 82, 85, 48, 52, 53, 32, 32, 32, 32, 32, 32, 48,
/* 0x2a50 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 52, 57, 32, 32,
/* 0x2a60 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2a70 */  55, 57, 32, 76, 88, 77, 82, 85, 48, 52, 54, 32, 32, 32, 32, 32,
/* 0x2a80 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 52, 99,
/* 0x2a90 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2aa0 */  10, 32, 56, 48, 32, 76, 88, 74, 67, 67, 48, 50, 48, 32, 32, 32,
/* 0x2ab0 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x2ac0 */  52,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2ad0 */  84, 83, 10, 32, 56, 49, 32, 76, 88, 74, 67, 67, 48, 50, 49, 32,
/* 0x2ae0 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2af0 */  49, 57, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2b00 */  69, 78, 84, 83, 10, 32, 56, 50, 32, 76, 88, 74, 67, 67, 48, 50,
/* 0x2b10 */  51, 32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32,
/* 0x2b20 */  32, 48, 49, 57, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2b30 */  78, 84, 69, 78, 84, 83, 10, 32, 56, 51, 32, 76, 88, 85, 78, 70,
/* 0x2b40 */  48, 51, 55, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x2b50 */  48, 32, 32, 48, 49, 57, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2b60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 52, 32, 76, 88, 85,
/* 0x2b70 */  78, 70, 51, 56, 54, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48,
/* 0x2b80 */  32, 32, 48, 32, 32, 48, 49, 57, 53,101, 32, 32, 50, 42, 42, 48,
/* 0x2b90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 53, 32, 76,
/* 0x2ba0 */  88, 85, 78, 70, 51, 56, 55, 32, 32, 32, 32, 32, 32, 48, 57, 32,
/* 0x2bb0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 53,102, 32, 32, 50, 42,
/* 0x2bc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 54,
/* 0x2bd0 */  32, 76, 88, 85, 78, 70, 51, 56, 56, 32, 32, 32, 32, 32, 32, 48,
/* 0x2be0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 54, 56, 32, 32,
/* 0x2bf0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2c00 */  56, 55, 32, 76, 88, 85, 78, 70, 52, 56, 54, 32, 32, 32, 32, 32,
/* 0x2c10 */  32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 54, 98,
/* 0x2c20 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2c30 */  10, 32, 56, 56, 32, 76, 88, 85, 78, 70, 52, 56, 55, 32, 32, 32,
/* 0x2c40 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x2c50 */  54,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2c60 */  84, 83, 10, 32, 56, 57, 32, 76, 88, 77, 82, 85, 48, 54, 53, 32,
/* 0x2c70 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2c80 */  49, 57, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2c90 */  69, 78, 84, 83, 10, 32, 57, 48, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x2ca0 */  51, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2cb0 */  32, 48, 49, 57, 55, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2cc0 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 49, 32, 77, 82, 85, 65, 82,
/* 0x2cd0 */  66, 51, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32,
/* 0x2ce0 */  48, 32, 32, 48, 49, 57, 55, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2cf0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 50, 32, 77, 82, 85,
/* 0x2d00 */  66, 73, 84, 83, 51, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2d10 */  32, 32, 48, 32, 32, 48, 49, 57, 55, 57, 32, 32, 50, 42, 42, 48,
/* 0x2d20 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 51, 32, 77,
/* 0x2d30 */  82, 85, 65, 82, 66, 52, 48, 32, 32, 32, 32, 32, 32, 48, 52, 32,
/* 0x2d40 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 55, 98, 32, 32, 50, 42,
/* 0x2d50 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 52,
/* 0x2d60 */  32, 76, 88, 77, 82, 85, 48, 55, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2d70 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 55,102, 32, 32,
/* 0x2d80 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2d90 */  57, 53, 32, 77, 82, 85, 66, 89, 84, 69, 52, 32, 32, 32, 32, 32,
/* 0x2da0 */  32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 56, 55,
/* 0x2db0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2dc0 */  10, 32, 57, 54, 32, 77, 82, 85, 66, 73, 84, 83, 52, 32, 32, 32,
/* 0x2dd0 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x2de0 */  56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2df0 */  84, 83, 10, 32, 57, 55, 32, 77, 82, 85, 65, 82, 66, 53, 48, 32,
/* 0x2e00 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2e10 */  49, 57, 56, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2e20 */  69, 78, 84, 83, 10, 32, 57, 56, 32, 76, 88, 77, 82, 85, 48, 56,
/* 0x2e30 */  48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x2e40 */  32, 48, 49, 57, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2e50 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 57, 32, 77, 82, 85, 66, 89,
/* 0x2e60 */  84, 69, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x2e70 */  48, 32, 32, 48, 49, 57, 57, 53, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2e80 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 48, 32, 77, 82, 85,
/* 0x2e90 */  65, 82, 66, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48,
/* 0x2ea0 */  32, 32, 48, 32, 32, 48, 49, 57, 57, 55, 32, 32, 50, 42, 42, 48,
/* 0x2eb0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 49, 32, 77,
/* 0x2ec0 */  82, 85, 66, 73, 84, 83, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x2ed0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 57, 56, 32, 32, 50, 42,
/* 0x2ee0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 50,
/* 0x2ef0 */  32, 77, 82, 85, 65, 82, 66, 55, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2f00 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 57, 97, 32, 32,
/* 0x2f10 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x2f20 */  48, 51, 32, 76, 88, 77, 82, 85, 48, 57, 48, 32, 32, 32, 32, 32,
/* 0x2f30 */  32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 57,101,
/* 0x2f40 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2f50 */  10, 49, 48, 52, 32, 77, 82, 85, 66, 89, 84, 69, 54, 32, 32, 32,
/* 0x2f60 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x2f70 */  97, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2f80 */  84, 83, 10, 49, 48, 53, 32, 77, 82, 85, 65, 82, 66, 56, 48, 32,
/* 0x2f90 */  32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2fa0 */  49, 57, 97, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2fb0 */  69, 78, 84, 83, 10, 49, 48, 54, 32, 77, 82, 85, 66, 73, 84, 83,
/* 0x2fc0 */  54, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2fd0 */  32, 48, 49, 57, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2fe0 */  78, 84, 69, 78, 84, 83, 10, 49, 48, 55, 32, 77, 82, 85, 65, 82,
/* 0x2ff0 */  66, 57, 48, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x3000 */  48, 32, 32, 48, 49, 57, 97,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3010 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 56, 32, 76, 88, 77,
/* 0x3020 */  82, 85, 49, 48, 48, 32, 32, 32, 32, 32, 32, 48, 49, 48, 32, 32,
/* 0x3030 */  48, 32, 32, 48, 32, 32, 48, 49, 57, 98, 50, 32, 32, 50, 42, 42,
/* 0x3040 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 57, 32,
/* 0x3050 */  76, 88, 85, 78, 70, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x3060 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 99, 50, 32, 32, 50,
/* 0x3070 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49,
/* 0x3080 */  48, 32, 76, 88, 77, 82, 85, 49, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x3090 */  48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 99, 55, 32,
/* 0x30a0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x30b0 */  49, 49, 49, 32, 76, 88, 77, 82, 85, 49, 49, 49, 32, 32, 32, 32,
/* 0x30c0 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 99,
/* 0x30d0 */  97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x30e0 */  83, 10, 49, 49, 50, 32, 76, 88, 85, 78, 70, 48, 52, 49, 32, 32,
/* 0x30f0 */  32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3100 */  57, 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3110 */  78, 84, 83, 10, 49, 49, 51, 32, 76, 88, 85, 78, 70, 48, 52, 50,
/* 0x3120 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3130 */  49, 57,100, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3140 */  69, 78, 84, 83, 10, 49, 49, 52, 32, 76, 88, 77, 82, 85, 48, 49,
/* 0x3150 */  48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32,
/* 0x3160 */  32, 48, 49, 57,100, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3170 */  78, 84, 69, 78, 84, 83, 10, 49, 49, 53, 32, 76, 88, 74, 77, 80,
/* 0x3180 */  65, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x3190 */  48, 32, 32, 48, 49, 57,100, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x31a0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 54, 32, 76, 88, 67,
/* 0x31b0 */  65, 76, 76, 66, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x31c0 */  32, 32, 48, 32, 32, 48, 49, 57,100, 54, 32, 32, 50, 42, 42, 48,
/* 0x31d0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 55, 32, 76,
/* 0x31e0 */  88, 85, 78, 70, 48, 50, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32,
/* 0x31f0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57,100, 56, 32, 32, 50, 42,
/* 0x3200 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 56,
/* 0x3210 */  32, 76, 88, 77, 82, 85, 48, 50, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x3220 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,100,101, 32, 32,
/* 0x3230 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x3240 */  49, 57, 32, 76, 88, 74, 77, 80, 65, 48, 49, 32, 32, 32, 32, 32,
/* 0x3250 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,101, 49,
/* 0x3260 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3270 */  10, 49, 50, 48, 32, 76, 88, 67, 65, 76, 76, 66, 49, 32, 32, 32,
/* 0x3280 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x3290 */ 101, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x32a0 */  84, 83, 10, 49, 50, 49, 32, 77, 82, 85, 66, 73, 84, 83, 49, 32,
/* 0x32b0 */  32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x32c0 */  49, 57,101, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x32d0 */  69, 78, 84, 83, 10, 49, 50, 50, 32, 76, 88, 77, 82, 85, 48, 51,
/* 0x32e0 */  48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x32f0 */  32, 48, 49, 57,101, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3300 */  78, 84, 69, 78, 84, 83, 10, 49, 50, 51, 32, 77, 82, 85, 66, 89,
/* 0x3310 */  84, 69, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x3320 */  48, 32, 32, 48, 49, 57,101, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3330 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 52, 32, 77, 82, 85,
/* 0x3340 */  65, 82, 66, 49, 48, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48,
/* 0x3350 */  32, 32, 48, 32, 32, 48, 49, 57,101, 97, 32, 32, 50, 42, 42, 48,
/* 0x3360 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 53, 32, 76,
/* 0x3370 */  88, 77, 82, 85, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x3380 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57,101, 98, 32, 32, 50, 42,
/* 0x3390 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 54,
/* 0x33a0 */  32, 76, 88, 85, 78, 70, 48, 51, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x33b0 */  54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,101,100, 32, 32,
/* 0x33c0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x33d0 */  50, 55, 32, 76, 88, 74, 67, 67, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x33e0 */  32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,102, 51,
/* 0x33f0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3400 */  10, 49, 50, 56, 32, 76, 88, 67, 74, 48, 77, 82, 85, 32, 32, 32,
/* 0x3410 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x3420 */ 102, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3430 */  84, 83, 10, 49, 50, 57, 32, 76, 88, 67, 74, 49, 77, 82, 85, 32,
/* 0x3440 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3450 */  49, 57,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3460 */  69, 78, 84, 83, 10, 49, 51, 48, 32, 76, 88, 67, 65, 76, 74, 77,
/* 0x3470 */  80, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x3480 */  32, 48, 49, 97, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3490 */  78, 84, 69, 78, 84, 83, 10, 49, 51, 49, 32, 76, 88, 67, 65, 76,
/* 0x34a0 */  76, 48, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x34b0 */  48, 32, 32, 48, 49, 97, 48, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x34c0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 50, 32, 76, 88, 67,
/* 0x34d0 */  65, 76, 76, 48, 49, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48,
/* 0x34e0 */  32, 32, 48, 32, 32, 48, 49, 97, 48, 53, 32, 32, 50, 42, 42, 48,
/* 0x34f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 51, 32, 76,
/* 0x3500 */  88, 67, 74, 50, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x3510 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 48, 56, 32, 32, 50, 42,
/* 0x3520 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 51, 52,
/* 0x3530 */  32, 76, 88, 67, 74, 52, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48,
/* 0x3540 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 48, 97, 32, 32,
/* 0x3550 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x3560 */  51, 53, 32, 76, 88, 67, 74, 54, 77, 82, 85, 32, 32, 32, 32, 32,
/* 0x3570 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 48, 99,
/* 0x3580 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3590 */  10, 49, 51, 54, 32, 76, 88, 67, 74, 55, 77, 82, 85, 32, 32, 32,
/* 0x35a0 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x35b0 */  48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x35c0 */  84, 83, 10, 49, 51, 55, 32, 76, 88, 67, 74, 56, 77, 82, 85, 32,
/* 0x35d0 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x35e0 */  49, 97, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x35f0 */  69, 78, 84, 83, 10, 49, 51, 56, 32, 76, 88, 85, 78, 70, 48, 51,
/* 0x3600 */  52, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x3610 */  32, 48, 49, 97, 49, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3620 */  78, 84, 69, 78, 84, 83, 10, 49, 51, 57, 32, 76, 88, 77, 82, 85,
/* 0x3630 */  48, 53, 53, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x3640 */  48, 32, 32, 48, 49, 97, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3650 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 48, 32, 77, 82, 85,
/* 0x3660 */  66, 89, 84, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x3670 */  32, 32, 48, 32, 32, 48, 49, 97, 49, 97, 32, 32, 50, 42, 42, 48,
/* 0x3680 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 49, 32, 77,
/* 0x3690 */  82, 85, 66, 73, 84, 83, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x36a0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 49,102, 32, 32, 50, 42,
/* 0x36b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 50,
/* 0x36c0 */  32, 77, 82, 85, 65, 82, 66, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x36d0 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 50, 52, 32, 32,
/* 0x36e0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x36f0 */  52, 51, 32, 76, 88, 77, 82, 85, 48, 53, 55, 32, 32, 32, 32, 32,
/* 0x3700 */  32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 50, 57,
/* 0x3710 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3720 */  10, 49, 52, 52, 32, 76, 88, 77, 82, 85, 48, 53, 56, 32, 32, 32,
/* 0x3730 */  32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x3740 */  50,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3750 */  84, 83, 10, 49, 52, 53, 32, 76, 88, 85, 78, 70, 48, 51, 53, 32,
/* 0x3760 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3770 */  49, 97, 51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3780 */  69, 78, 84, 83, 10, 49, 52, 54, 32, 99,116,111,107, 51, 50, 46,
/* 0x3790 */  48, 48, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32,
/* 0x37a0 */  32, 48, 49, 97, 51, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x37b0 */  78, 84, 69, 78, 84, 83, 10, 49, 52, 55, 32, 99,116,111,107, 51,
/* 0x37c0 */  50, 46, 49, 48, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32,
/* 0x37d0 */  48, 32, 32, 48, 49, 97, 51,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x37e0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 56, 32, 99,116,111,
/* 0x37f0 */ 107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48, 50, 48, 32, 32,
/* 0x3800 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 52, 98, 32, 32, 50, 42, 42,
/* 0x3810 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 52, 57, 32,
/* 0x3820 */  99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 97,
/* 0x3830 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 54, 98, 32, 32, 50,
/* 0x3840 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53,
/* 0x3850 */  48, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 32, 32, 32, 32,
/* 0x3860 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 55, 53, 32,
/* 0x3870 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3880 */  49, 53, 49, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32, 32, 32,
/* 0x3890 */  32, 32, 48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x38a0 */  55, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x38b0 */  84, 83, 10, 49, 53, 50, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32,
/* 0x38c0 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x38d0 */  49, 97, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x38e0 */  69, 78, 84, 83, 10, 49, 53, 51, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x38f0 */  49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x3900 */  32, 48, 49, 97, 56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3910 */  78, 84, 69, 78, 84, 83, 10, 49, 53, 52, 32, 67, 84, 66, 83, 72,
/* 0x3920 */  82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x3930 */  48, 32, 32, 48, 49, 97, 57, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3940 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53, 53, 32, 67, 84, 66,
/* 0x3950 */  82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x3960 */  32, 32, 48, 32, 32, 48, 49, 97, 57, 56, 32, 32, 50, 42, 42, 48,
/* 0x3970 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53, 54, 32, 67,
/* 0x3980 */  84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x3990 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 57, 97, 32, 32, 50, 42,
/* 0x39a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 53, 55,
/* 0x39b0 */  32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x39c0 */  49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 57,102, 32,
/* 0x39d0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x39e0 */  49, 53, 56, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32,
/* 0x39f0 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97,
/* 0x3a00 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3a10 */  83, 10, 49, 53, 57, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 32,
/* 0x3a20 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3a30 */  97, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3a40 */  78, 84, 83, 10, 49, 54, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57,
/* 0x3a50 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3a60 */  48, 49, 97, 98, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3a70 */  84, 69, 78, 84, 83, 10, 49, 54, 49, 32, 67, 65, 76, 76, 84, 82,
/* 0x3a80 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48,
/* 0x3a90 */  32, 32, 48, 49, 97, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3aa0 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 50, 32, 67, 84, 67, 76,
/* 0x3ab0 */  69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x3ac0 */  32, 48, 32, 32, 48, 49, 97, 98, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x3ad0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 51, 32, 67, 65,
/* 0x3ae0 */  76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x3af0 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 49, 32, 32, 50, 42, 42,
/* 0x3b00 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54, 52, 32,
/* 0x3b10 */  67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x3b20 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 51, 32, 32, 50,
/* 0x3b30 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 54,
/* 0x3b40 */  53, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x3b50 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 55, 32,
/* 0x3b60 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3b70 */  49, 54, 54, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32, 32,
/* 0x3b80 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99,
/* 0x3b90 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3ba0 */  83, 10, 49, 54, 55, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 32,
/* 0x3bb0 */  32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3bc0 */  97, 99,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3bd0 */  78, 84, 83, 10, 49, 54, 56, 32, 76, 69, 88, 69, 67, 48, 49, 55,
/* 0x3be0 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3bf0 */  48, 49, 97,100, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3c00 */  84, 69, 78, 84, 83, 10, 49, 54, 57, 32, 76, 69, 88, 69, 67, 48,
/* 0x3c10 */  50, 48, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48,
/* 0x3c20 */  32, 32, 48, 49, 97,100, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3c30 */  79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84,
/* 0x3c40 */  65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3c50 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32,
/* 0x3c60 */  48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3c70 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x3c80 */  65, 83, 49, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10,
/* 0x3c90 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3ca0 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 66, 68,
/* 0x3cb0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3cc0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 48,
/* 0x3cd0 */  32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ce0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,
/* 0x3cf0 */  67, 51, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48,
/* 0x3d00 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3d10 */  78, 50, 66, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 66, 68, 69,
/* 0x3d20 */  67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3d30 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 48, 32,
/* 0x3d40 */  78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d50 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x3d60 */  54, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48,
/* 0x3d70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3d80 */  50, 68, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65,
/* 0x3d90 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3da0 */  32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 48, 32, 78,
/* 0x3db0 */  50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x3dd0 */  48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3de0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3df0 */  68, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 50,
/* 0x3e00 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3e10 */ 100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50,
/* 0x3e20 */  68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3e30 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,
/* 0x3e40 */  32, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48,
/* 0x3e50 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3e60 */  70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 54, 49,
/* 0x3e70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3e80 */  32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 68,
/* 0x3e90 */  68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3ea0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32,
/* 0x3eb0 */  48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3ec0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3ed0 */  65, 83, 49, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10,
/* 0x3ee0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3ef0 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 69, 68,
/* 0x3f00 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3f10 */  32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 48,
/* 0x3f20 */  32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3f30 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,
/* 0x3f40 */  67, 51, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48,
/* 0x3f50 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3f60 */  78, 50, 69, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 69, 68, 69,
/* 0x3f70 */  67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3f80 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 48, 32,
/* 0x3f90 */  78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fa0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x3fb0 */  54, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 48, 48,
/* 0x3fc0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3fd0 */  88, 85, 78, 70, 48, 49, 48, 32, 48, 32, 76, 88, 85, 78, 70, 48,
/* 0x3fe0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3ff0 */  32,100, 32, 32, 76, 88, 74, 67, 67, 48, 49, 48, 32, 48, 32, 76,
/* 0x4000 */  88, 74, 67, 67, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 51,
/* 0x4020 */  55, 32, 48, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 48, 48, 48,
/* 0x4030 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x4040 */  77, 82, 85, 48, 55, 48, 32, 48, 32, 76, 88, 77, 82, 85, 48, 55,
/* 0x4050 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4060 */ 100, 32, 32, 76, 88, 77, 82, 85, 49, 48, 48, 32, 48, 32, 76, 88,
/* 0x4070 */  77, 82, 85, 49, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4080 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 52, 48,
/* 0x4090 */  32, 48, 32, 76, 88, 85, 78, 70, 48, 52, 48, 10, 48, 48, 48, 48,
/* 0x40a0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x40b0 */  78, 70, 48, 52, 50, 32, 48, 32, 76, 88, 85, 78, 70, 48, 52, 50,
/* 0x40c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x40d0 */  32, 32, 76, 88, 77, 82, 85, 48, 51, 48, 32, 48, 32, 76, 88, 77,
/* 0x40e0 */  82, 85, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x40f0 */  32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 51, 48, 32,
/* 0x4100 */  48, 32, 76, 88, 85, 78, 70, 48, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x4110 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74,
/* 0x4120 */  56, 77, 82, 85, 32, 48, 32, 76, 88, 67, 74, 56, 77, 82, 85, 10,
/* 0x4130 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4140 */  32, 76, 88, 85, 78, 70, 48, 51, 52, 32, 48, 32, 76, 88, 85, 78,
/* 0x4150 */  70, 48, 51, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4160 */  32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32,
/* 0x4170 */  48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48,
/* 0x4180 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,
/* 0x4190 */ 107, 51, 50, 46, 49, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x41a0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x41b0 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 48, 32,
/* 0x41c0 */  99,116,111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x41d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,
/* 0x41e0 */  50, 46, 52, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x41f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4200 */  32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 48, 32, 67, 65, 76,
/* 0x4210 */  76, 84, 82, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4220 */  32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32,
/* 0x4230 */  48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x4240 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,
/* 0x4250 */  84, 82, 49, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10,
/* 0x4260 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4270 */  32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 48, 32, 67, 65, 76, 76,
/* 0x4280 */  84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4290 */  32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 50, 48, 32, 48,
/* 0x42a0 */  32, 76, 69, 88, 69, 67, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x42b0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67,
/* 0x42c0 */  48, 48, 48, 32, 48, 32, 76, 69, 88, 69, 67, 48, 48, 48, 10, 48,
/* 0x42d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x42e0 */  76, 69, 88, 69, 67, 48, 48, 57, 32, 48, 32, 76, 69, 88, 69, 67,
/* 0x42f0 */  48, 48, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4300 */  32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 48, 32, 48, 32,
/* 0x4310 */  76, 69, 88, 69, 67, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4320 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x4330 */  49, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48, 10, 48, 48,
/* 0x4340 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4350 */  50, 66, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65,
/* 0x4360 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4370 */  32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 48, 32, 78,
/* 0x4380 */  50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4390 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 51,
/* 0x43a0 */  48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x43c0 */  66, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 51,
/* 0x43d0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x43e0 */ 100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50,
/* 0x43f0 */  66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4400 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48,
/* 0x4410 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48,
/* 0x4420 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x4430 */  83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 53, 48,
/* 0x4440 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4450 */  32, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 66,
/* 0x4460 */  70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4470 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32,
/* 0x4480 */  48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x4490 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x44a0 */  65, 83, 54, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x44c0 */  32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 68, 70,
/* 0x44d0 */  65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x44e0 */  32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 48,
/* 0x44f0 */  32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4500 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,
/* 0x4510 */  83, 50, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 50, 48, 10, 48,
/* 0x4520 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4530 */  78, 50, 68, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 68, 83, 77,
/* 0x4540 */  65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4550 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 48, 32,
/* 0x4560 */  78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4570 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x4580 */  52, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48, 10, 48, 48,
/* 0x4590 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x45a0 */  50, 68, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x45b0 */  52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x45c0 */  32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 48, 32, 78,
/* 0x45d0 */  50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x45f0 */  48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48,
/* 0x4600 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4610 */  68, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 54,
/* 0x4620 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4630 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50,
/* 0x4640 */  68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4650 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48,
/* 0x4660 */  32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48,
/* 0x4670 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x4680 */  83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 50, 48,
/* 0x4690 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x46a0 */  32, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 69,
/* 0x46b0 */  70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x46c0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32,
/* 0x46d0 */  48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x46e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x46f0 */  65, 83, 51, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4710 */  32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 69, 83,
/* 0x4720 */  77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4730 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 48,
/* 0x4740 */  32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4750 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,
/* 0x4760 */  65, 53, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 10, 48,
/* 0x4770 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4780 */  78, 50, 69, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 69, 70, 65,
/* 0x4790 */  83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x47a0 */  32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 48, 32,
/* 0x47b0 */  78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x47c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x47d0 */  54, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48, 10, 48, 48,
/* 0x47e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x47f0 */  90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x4800 */  95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4810 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x4820 */  48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x4830 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4840 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90,
/* 0x4850 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4860 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x4870 */  69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x4880 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4890 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32,
/* 0x48a0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x48b0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69,
/* 0x48c0 */  67, 48, 49, 53, 32, 48, 32, 76, 69, 88, 69, 67, 48, 49, 53, 10,
/* 0x48d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x48e0 */  32, 76, 69, 88, 69, 67, 49, 49, 48, 32, 48, 32, 76, 69, 88, 69,
/* 0x48f0 */  67, 49, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4900 */  32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 49, 48, 48, 32, 48,
/* 0x4910 */  32, 76, 69, 88, 69, 67, 49, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4920 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67,
/* 0x4930 */  48, 49, 54, 32, 48, 32, 76, 69, 88, 69, 67, 48, 49, 54, 10, 48,
/* 0x4940 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4950 */  76, 88, 85, 78, 70, 48, 48, 48, 32, 48, 32, 76, 88, 85, 78, 70,
/* 0x4960 */  48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4970 */  32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 48, 50, 32, 48, 32,
/* 0x4980 */  76, 88, 85, 78, 70, 48, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4990 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84,
/* 0x49a0 */  69, 48, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 48, 10, 48, 48,
/* 0x49b0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x49c0 */  88, 77, 82, 85, 48, 48, 53, 32, 48, 32, 76, 88, 77, 82, 85, 48,
/* 0x49d0 */  48, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x49e0 */  32,100, 32, 32, 76, 88, 77, 82, 85, 48, 48, 54, 32, 48, 32, 76,
/* 0x49f0 */  88, 77, 82, 85, 48, 48, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a00 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 48,
/* 0x4a10 */  55, 32, 48, 32, 76, 88, 77, 82, 85, 48, 48, 55, 10, 48, 48, 48,
/* 0x4a20 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x4a30 */  85, 78, 70, 48, 48, 56, 32, 48, 32, 76, 88, 85, 78, 70, 48, 48,
/* 0x4a40 */  56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4a50 */ 100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 53, 32, 48, 32, 76, 88,
/* 0x4a60 */  77, 82, 85, 48, 52, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4a70 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 54,
/* 0x4a80 */  32, 48, 32, 76, 88, 77, 82, 85, 48, 52, 54, 10, 48, 48, 48, 48,
/* 0x4a90 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74,
/* 0x4aa0 */  67, 67, 48, 50, 48, 32, 48, 32, 76, 88, 74, 67, 67, 48, 50, 48,
/* 0x4ab0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4ac0 */  32, 32, 76, 88, 74, 67, 67, 48, 50, 49, 32, 48, 32, 76, 88, 74,
/* 0x4ad0 */  67, 67, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4ae0 */  32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 50, 51, 32,
/* 0x4af0 */  48, 32, 76, 88, 74, 67, 67, 48, 50, 51, 10, 48, 48, 48, 48, 48,
/* 0x4b00 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78,
/* 0x4b10 */  70, 51, 56, 54, 32, 48, 32, 76, 88, 85, 78, 70, 51, 56, 54, 10,
/* 0x4b20 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4b30 */  32, 76, 88, 85, 78, 70, 51, 56, 55, 32, 48, 32, 76, 88, 85, 78,
/* 0x4b40 */  70, 51, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4b50 */  32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 51, 56, 56, 32, 48,
/* 0x4b60 */  32, 76, 88, 85, 78, 70, 51, 56, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x4b70 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70,
/* 0x4b80 */  52, 56, 54, 32, 48, 32, 76, 88, 85, 78, 70, 52, 56, 54, 10, 48,
/* 0x4b90 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4ba0 */  76, 88, 85, 78, 70, 52, 56, 55, 32, 48, 32, 76, 88, 85, 78, 70,
/* 0x4bb0 */  52, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4bc0 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 54, 53, 32, 48, 32,
/* 0x4bd0 */  76, 88, 77, 82, 85, 48, 54, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4be0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84,
/* 0x4bf0 */  69, 51, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 51, 10, 48, 48,
/* 0x4c00 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,
/* 0x4c10 */  82, 85, 65, 82, 66, 51, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66,
/* 0x4c20 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4c30 */  32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 51, 32, 48, 32, 77,
/* 0x4c40 */  82, 85, 66, 73, 84, 83, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c50 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 52,
/* 0x4c60 */  48, 32, 48, 32, 77, 82, 85, 65, 82, 66, 52, 48, 10, 48, 48, 48,
/* 0x4c70 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82,
/* 0x4c80 */  85, 66, 89, 84, 69, 52, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x4c90 */  52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4ca0 */ 100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 52, 32, 48, 32, 77, 82,
/* 0x4cb0 */  85, 66, 73, 84, 83, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4cc0 */ 108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 53, 48,
/* 0x4cd0 */  32, 48, 32, 77, 82, 85, 65, 82, 66, 53, 48, 10, 48, 48, 48, 48,
/* 0x4ce0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77,
/* 0x4cf0 */  82, 85, 48, 56, 48, 32, 48, 32, 76, 88, 77, 82, 85, 48, 56, 48,
/* 0x4d00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4d10 */  32, 32, 77, 82, 85, 66, 89, 84, 69, 53, 32, 48, 32, 77, 82, 85,
/* 0x4d20 */  66, 89, 84, 69, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4d30 */  32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 54, 48, 32,
/* 0x4d40 */  48, 32, 77, 82, 85, 65, 82, 66, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x4d50 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66,
/* 0x4d60 */  73, 84, 83, 53, 32, 48, 32, 77, 82, 85, 66, 73, 84, 83, 53, 10,
/* 0x4d70 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4d80 */  32, 77, 82, 85, 65, 82, 66, 55, 48, 32, 48, 32, 77, 82, 85, 65,
/* 0x4d90 */  82, 66, 55, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4da0 */  32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 57, 48, 32, 48,
/* 0x4db0 */  32, 76, 88, 77, 82, 85, 48, 57, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4dc0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89,
/* 0x4dd0 */  84, 69, 54, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 54, 10, 48,
/* 0x4de0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4df0 */  77, 82, 85, 65, 82, 66, 56, 48, 32, 48, 32, 77, 82, 85, 65, 82,
/* 0x4e00 */  66, 56, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4e10 */  32, 32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 54, 32, 48, 32,
/* 0x4e20 */  77, 82, 85, 66, 73, 84, 83, 54, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e30 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66,
/* 0x4e40 */  57, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66, 57, 48, 10, 48, 48,
/* 0x4e50 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4e60 */  88, 77, 82, 85, 49, 49, 48, 32, 48, 32, 76, 88, 77, 82, 85, 49,
/* 0x4e70 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4e80 */  32,100, 32, 32, 76, 88, 77, 82, 85, 49, 49, 49, 32, 48, 32, 76,
/* 0x4e90 */  88, 77, 82, 85, 49, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ea0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 52,
/* 0x4eb0 */  49, 32, 48, 32, 76, 88, 85, 78, 70, 48, 52, 49, 10, 48, 48, 48,
/* 0x4ec0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x4ed0 */  77, 82, 85, 48, 49, 48, 32, 48, 32, 76, 88, 77, 82, 85, 48, 49,
/* 0x4ee0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4ef0 */ 100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 48, 32, 48, 32, 76, 88,
/* 0x4f00 */  74, 77, 80, 65, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4f10 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76, 76, 66, 48,
/* 0x4f20 */  32, 48, 32, 76, 88, 67, 65, 76, 76, 66, 48, 10, 48, 48, 48, 48,
/* 0x4f30 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x4f40 */  78, 70, 48, 50, 49, 32, 48, 32, 76, 88, 85, 78, 70, 48, 50, 49,
/* 0x4f50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4f60 */  32, 32, 76, 88, 77, 82, 85, 48, 50, 50, 32, 48, 32, 76, 88, 77,
/* 0x4f70 */  82, 85, 48, 50, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4f80 */  32, 32, 32, 32,100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 49, 32,
/* 0x4f90 */  48, 32, 76, 88, 74, 77, 80, 65, 48, 49, 10, 48, 48, 48, 48, 48,
/* 0x4fa0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65,
/* 0x4fb0 */  76, 76, 66, 49, 32, 48, 32, 76, 88, 67, 65, 76, 76, 66, 49, 10,
/* 0x4fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4fd0 */  32, 77, 82, 85, 66, 73, 84, 83, 49, 32, 48, 32, 77, 82, 85, 66,
/* 0x4fe0 */  73, 84, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4ff0 */  32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69, 49, 32, 48,
/* 0x5000 */  32, 77, 82, 85, 66, 89, 84, 69, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x5010 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82,
/* 0x5020 */  66, 49, 48, 32, 48, 32, 77, 82, 85, 65, 82, 66, 49, 48, 10, 48,
/* 0x5030 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5040 */  76, 88, 77, 82, 85, 48, 52, 48, 32, 48, 32, 76, 88, 77, 82, 85,
/* 0x5050 */  48, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5060 */  32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 48, 48, 32, 48, 32,
/* 0x5070 */  76, 88, 74, 67, 67, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5080 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 48, 77,
/* 0x5090 */  82, 85, 32, 48, 32, 76, 88, 67, 74, 48, 77, 82, 85, 10, 48, 48,
/* 0x50a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x50b0 */  88, 67, 74, 49, 77, 82, 85, 32, 48, 32, 76, 88, 67, 74, 49, 77,
/* 0x50c0 */  82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x50d0 */  32,100, 32, 32, 76, 88, 67, 65, 76, 74, 77, 80, 32, 48, 32, 76,
/* 0x50e0 */  88, 67, 65, 76, 74, 77, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x50f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76, 76, 48,
/* 0x5100 */  48, 32, 48, 32, 76, 88, 67, 65, 76, 76, 48, 48, 10, 48, 48, 48,
/* 0x5110 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88,
/* 0x5120 */  67, 65, 76, 76, 48, 49, 32, 48, 32, 76, 88, 67, 65, 76, 76, 48,
/* 0x5130 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x5140 */ 100, 32, 32, 76, 88, 67, 74, 50, 77, 82, 85, 32, 48, 32, 76, 88,
/* 0x5150 */  67, 74, 50, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5160 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 52, 77, 82, 85,
/* 0x5170 */  32, 48, 32, 76, 88, 67, 74, 52, 77, 82, 85, 10, 48, 48, 48, 48,
/* 0x5180 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67,
/* 0x5190 */  74, 54, 77, 82, 85, 32, 48, 32, 76, 88, 67, 74, 54, 77, 82, 85,
/* 0x51a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x51b0 */  32, 32, 76, 88, 67, 74, 55, 77, 82, 85, 32, 48, 32, 76, 88, 67,
/* 0x51c0 */  74, 55, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x51d0 */  32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 53, 53, 32,
/* 0x51e0 */  48, 32, 76, 88, 77, 82, 85, 48, 53, 53, 10, 48, 48, 48, 48, 48,
/* 0x51f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66,
/* 0x5200 */  89, 84, 69, 50, 32, 48, 32, 77, 82, 85, 66, 89, 84, 69, 50, 10,
/* 0x5210 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5220 */  32, 77, 82, 85, 66, 73, 84, 83, 50, 32, 48, 32, 77, 82, 85, 66,
/* 0x5230 */  73, 84, 83, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5240 */  32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 50, 48, 32, 48,
/* 0x5250 */  32, 77, 82, 85, 65, 82, 66, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x5260 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85,
/* 0x5270 */  48, 53, 55, 32, 48, 32, 76, 88, 77, 82, 85, 48, 53, 55, 10, 48,
/* 0x5280 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5290 */  76, 88, 77, 82, 85, 48, 53, 56, 32, 48, 32, 76, 88, 77, 82, 85,
/* 0x52a0 */  48, 53, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x52b0 */  32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 51, 53, 32, 48, 32,
/* 0x52c0 */  76, 88, 85, 78, 70, 48, 51, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x52d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50,
/* 0x52e0 */  46, 51, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10,
/* 0x52f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5300 */  32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 48, 32, 67, 84, 67, 76,
/* 0x5310 */  69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5320 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32, 48,
/* 0x5330 */  32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x5340 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72,
/* 0x5350 */  82, 48, 49, 32, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48,
/* 0x5360 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5370 */  67, 84, 66, 82, 79, 82, 48, 49, 32, 48, 32, 67, 84, 66, 82, 79,
/* 0x5380 */  82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5390 */  32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 48, 32,
/* 0x53a0 */  67, 84, 66, 83, 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x53b0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x53c0 */  48, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48,
/* 0x53d0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x53e0 */  65, 76, 76, 84, 82, 69, 56, 32, 48, 32, 67, 65, 76, 76, 84, 82,
/* 0x53f0 */  69, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5400 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 48, 32, 67,
/* 0x5410 */  65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5420 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69,
/* 0x5430 */  50, 32, 48, 32, 67, 84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48,
/* 0x5440 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x5450 */  76, 76, 84, 82, 49, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x5460 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x5470 */ 100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 48, 32, 67, 84,
/* 0x5480 */  66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5490 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 49, 49,
/* 0x54a0 */  32, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48,
/* 0x54b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x54c0 */  83, 87, 65, 49, 49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49,
/* 0x54d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x54e0 */  32, 32, 76, 69, 88, 69, 67, 48, 49, 55, 32, 48, 32, 76, 69, 88,
/* 0x54f0 */  69, 67, 48, 49, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x5500 */  32, 32, 32, 32, 32, 32, 32, 76, 69, 88, 69, 67, 48, 48, 48, 32,
/* 0x5510 */  48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5520 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x5530 */  48, 32, 78, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5540 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x5550 */ 102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48,
/* 0x5560 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5570 */  42, 32, 48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,
/* 0x5580 */ 100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5590 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,
/* 0x55a0 */ 122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48,
/* 0x55b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x55c0 */  42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,101,114, 95,108,
/* 0x55d0 */ 101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x55e0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x55f0 */  69, 88, 69, 67, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5600 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5610 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5620 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x5630 */  32, 32, 32, 32, 32, 32, 76, 69, 88, 69, 67, 48, 50, 48, 10, 10,
/* 0x5640 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5650 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48, 48, 57,
/* 0x5660 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5670 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5680 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5690 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x56a0 */  77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x56b0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 69, 88,
/* 0x56c0 */  69, 67, 48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x56d0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56e0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x56f0 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5700 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 10,
/* 0x5710 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5720 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 49, 48,
/* 0x5730 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5740 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5750 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5760 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5770 */  50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5780 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5790 */  91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x57a0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x57b0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x57c0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x57d0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x57e0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x57f0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,
/* 0x5800 */  50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5810 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5820 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x5830 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5840 */  32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x5850 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5860 */  82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70,
/* 0x5870 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5880 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5890 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x58a0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x58b0 */  49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x58c0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83,
/* 0x58d0 */  77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x58e0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x58f0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x5900 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5910 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76,
/* 0x5920 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5930 */  70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48, 93, 58, 10,
/* 0x5940 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5950 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5960 */  10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x5970 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x5980 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95,
/* 0x5990 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x59a0 */  78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x59b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x59c0 */  32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70,
/* 0x59d0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x59e0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x59f0 */  48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5a00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 54,
/* 0x5a10 */  48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95, 51, 56, 54,
/* 0x5a20 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x5a30 */  68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5a40 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5a50 */  50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5a60 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a70 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5a80 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5a90 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10,
/* 0x5aa0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5ab0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 52, 48,
/* 0x5ac0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5ad0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5ae0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x5af0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5b00 */  50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x5b10 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5b20 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x5b30 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5b40 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48, 93, 58, 10,
/* 0x5b50 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5b60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5b70 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x5b80 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x5b90 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5ba0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5bb0 */  66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5bc0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5bd0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5be0 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5bf0 */  32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x5c00 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x5c10 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49,
/* 0x5c20 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5c30 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,
/* 0x5c40 */  83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5c50 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c60 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x5c70 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5c80 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5c90 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5ca0 */  79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93, 58, 10, 79,
/* 0x5cb0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5cc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5cd0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5ce0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x5cf0 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5d00 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x5d10 */  70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5d20 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d30 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5d40 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5d50 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5d60 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5d70 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50, 48, 93, 58,
/* 0x5d80 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5d90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5da0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5db0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x5dc0 */  83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5dd0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5de0 */  50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5df0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e00 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5e10 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5e20 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 10,
/* 0x5e30 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5e40 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 51, 48,
/* 0x5e50 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5e60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5e70 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x5e80 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5e90 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5ea0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5eb0 */  91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5ec0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ed0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5ee0 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x5f00 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5f10 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x5f20 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5f30 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5f40 */  68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5f50 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f60 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5f70 */  48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5f80 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5f90 */  48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 54,
/* 0x5fb0 */  48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95, 51, 56, 54,
/* 0x5fc0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x5fd0 */  68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5fe0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5ff0 */  50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6000 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6010 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6020 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6030 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10,
/* 0x6040 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6050 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 52, 48,
/* 0x6060 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6080 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x6090 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x60a0 */  50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x60b0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x60c0 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x60d0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x60e0 */  70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48, 93, 58, 10,
/* 0x60f0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6100 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6110 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x6120 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x6130 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6140 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x6150 */  68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6160 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6170 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6180 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6190 */  32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x61a0 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x61b0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x61c0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x61d0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65,
/* 0x61e0 */  83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x61f0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6200 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x6210 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x6220 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x6230 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6240 */  79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93, 58, 10, 79,
/* 0x6250 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6260 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6270 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6280 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x6290 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x62a0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x62b0 */  70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x62c0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x62d0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x62e0 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x62f0 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x6300 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6310 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50, 48, 93, 58,
/* 0x6320 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6330 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6340 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6350 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x6360 */  83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6370 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x6380 */  50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6390 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x63a0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x63b0 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x63c0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 10,
/* 0x63d0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x63e0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 51, 48,
/* 0x63f0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6400 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6410 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x6420 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6430 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6440 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6450 */  91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6460 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6470 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6480 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6490 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x64a0 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x64b0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x64c0 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x64d0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x64e0 */  69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x64f0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6500 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6510 */  48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6520 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x6530 */  48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6540 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 53,
/* 0x6550 */  48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 51, 56, 54,
/* 0x6560 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x6570 */  68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6580 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x6590 */  50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x65a0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x65b0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x65c0 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x65d0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10,
/* 0x65e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x65f0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 52, 48,
/* 0x6600 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6610 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6620 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x6630 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6640 */  50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x6650 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6660 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x6670 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6680 */  70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48, 93, 58, 10,
/* 0x6690 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x66a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x66b0 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x66c0 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x66d0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x66e0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x66f0 */  69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6700 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6710 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6720 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6730 */  32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x6740 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x6750 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x6760 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6770 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65,
/* 0x6780 */  83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6790 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x67a0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x67b0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x67c0 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x67d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x67e0 */  79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93, 58,
/* 0x67f0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6800 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6810 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,
/* 0x6820 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x6830 */  97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48,
/* 0x6840 */  48, 48, 48, 48, 48, 51, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x6850 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,
/* 0x6860 */ 114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67,
/* 0x6870 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6880 */  82, 32, 91, 76, 69, 88, 69, 67, 48, 49, 54, 93, 58, 10, 79, 70,
/* 0x6890 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x68a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x68b0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x68c0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,
/* 0x68d0 */  52, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x68e0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78,
/* 0x68f0 */  70, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6900 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6910 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x6920 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6930 */  32, 32, 32, 76, 88, 85, 78, 70, 48, 49, 48, 10, 10, 82, 69, 76,
/* 0x6940 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6950 */  70, 79, 82, 32, 91, 76, 88, 77, 82, 85, 48, 48, 53, 93, 58, 10,
/* 0x6960 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6970 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6980 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x6990 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 77, 82, 85,
/* 0x69a0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x69b0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 48,
/* 0x69c0 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x69d0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x69e0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x69f0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a00 */  32, 76, 88, 85, 78, 70, 48, 52, 50, 10, 10, 82, 69, 76, 79, 67,
/* 0x6a10 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6a20 */  82, 32, 91, 76, 88, 74, 67, 67, 48, 50, 48, 93, 58, 10, 79, 70,
/* 0x6a30 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6a40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6a50 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6a60 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,
/* 0x6a70 */  51, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6a80 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 74, 67,
/* 0x6a90 */  67, 48, 50, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6aa0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ab0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x6ac0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6ad0 */  32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 10, 82, 69, 76,
/* 0x6ae0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6af0 */  70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 51, 56, 56, 93, 58, 10,
/* 0x6b00 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6b10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6b20 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6b30 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78,
/* 0x6b40 */  70, 48, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6b50 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88,
/* 0x6b60 */  85, 78, 70, 52, 56, 55, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6b70 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b80 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6b90 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6ba0 */  32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52, 48, 10, 10, 82,
/* 0x6bb0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6bc0 */  83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85, 48, 54, 53, 93,
/* 0x6bd0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6be0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6bf0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56,
/* 0x6c00 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88,
/* 0x6c10 */  77, 82, 85, 48, 55, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6c20 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6c30 */  76, 88, 77, 82, 85, 48, 55, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6c40 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c50 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6c60 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6c70 */  32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52, 48, 10,
/* 0x6c80 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6c90 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85, 48, 57,
/* 0x6ca0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6cb0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6cc0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95,
/* 0x6cd0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ce0 */  76, 88, 77, 82, 85, 49, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6cf0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6d00 */  32, 91, 76, 88, 85, 78, 70, 48, 52, 49, 93, 58, 10, 79, 70, 70,
/* 0x6d10 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6d20 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6d30 */  48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6d40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51,
/* 0x6d50 */  52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6d60 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85,
/* 0x6d70 */  48, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6d80 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d90 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6da0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6db0 */  32, 32, 76, 88, 77, 82, 85, 48, 51, 48, 10, 10, 82, 69, 76, 79,
/* 0x6dc0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6dd0 */  79, 82, 32, 91, 76, 88, 74, 67, 67, 48, 48, 48, 93, 58, 10, 79,
/* 0x6de0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6df0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6e00 */  48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6e10 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 74, 67, 67,
/* 0x6e20 */  48, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6e30 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67,
/* 0x6e40 */  65, 76, 76, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6e50 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e60 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6e70 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6e80 */  32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69,
/* 0x6e90 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6ea0 */  32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 50, 77, 82, 85, 93, 58,
/* 0x6eb0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6ed0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6ee0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85,
/* 0x6ef0 */  78, 70, 48, 51, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6f00 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x6f10 */  88, 67, 74, 52, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6f20 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f30 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6f40 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6f50 */  32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 10,
/* 0x6f60 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6f70 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 54, 77, 82, 85,
/* 0x6f80 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6f90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6fa0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x6fb0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x6fc0 */  88, 67, 74, 56, 77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6fd0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6fe0 */  91, 76, 88, 67, 74, 55, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83,
/* 0x6ff0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7000 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7010 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x7020 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 67, 74, 56, 77, 82, 85,
/* 0x7030 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7040 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 56, 77,
/* 0x7050 */  82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x7060 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7070 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x7080 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7090 */  32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69, 76, 79, 67,
/* 0x70a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x70b0 */  82, 32, 91, 76, 88, 85, 78, 70, 48, 51, 52, 93, 58, 10, 79, 70,
/* 0x70c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x70d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x70e0 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x70f0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,
/* 0x7100 */  51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x7110 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107,
/* 0x7120 */  51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7130 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7140 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7150 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x7160 */  32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82,
/* 0x7170 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7180 */  83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49, 48,
/* 0x7190 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x71a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x71b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51,
/* 0x71c0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x71d0 */ 116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x71e0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x71f0 */  32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79, 70,
/* 0x7200 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x7210 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x7220 */  48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x7230 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50,
/* 0x7240 */  46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51,
/* 0x7250 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x7260 */ 116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x7270 */  48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x7280 */  32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 10, 82,
/* 0x7290 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x72a0 */  83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 51, 48,
/* 0x72b0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x72c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x72d0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51,
/* 0x72e0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x72f0 */ 116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7300 */  57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x7310 */  32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82,
/* 0x7320 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7330 */  83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x7340 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x7350 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x7360 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51,
/* 0x7370 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x7380 */ 116,111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7390 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x73a0 */  32, 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x73b0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x73c0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x73d0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x73e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x73f0 */ 108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7400 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7410 */  67, 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7420 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7430 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7440 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32,
/* 0x7450 */  32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,
/* 0x7460 */ 111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x7470 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76,
/* 0x7480 */  76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x7490 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,
/* 0x74a0 */  65, 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x74b0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x74c0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x74d0 */  48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x74e0 */  32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10,
/* 0x74f0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x7500 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48,
/* 0x7510 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x7520 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x7530 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x7540 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x7550 */ 105,108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69,
/* 0x7560 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x7570 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58,
/* 0x7580 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7590 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x75a0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,
/* 0x75b0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76,
/* 0x75c0 */  76, 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x75d0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,
/* 0x75e0 */  84, 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x75f0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7600 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x7610 */  48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32,
/* 0x7620 */  32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111,
/* 0x7630 */  10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95,
/* 0x7640 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,
/* 0x7650 */  84, 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x7660 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,
/* 0x7670 */  76, 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7680 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7690 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x76a0 */  48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x76b0 */  32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10
};
