/***************************************************************************
                          dcfilebrowser.h  -  description
                             -------------------
    begin                : Fre Nov 29 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILEBROWSER_H
#define DCFILEBROWSER_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qstringlist.h>

#include <dclib/dcos.h>
#include <dclib/core/cbytearray.h>

#include "DCDialogFileBrowser.h"

class CXml;
class DCFileItem;
class DCFilelistDecompressor;
class Q3ListViewItem;
class DCFileBrowserListItem;

/**
  *@author Mathias Küster
  */

class DCFileBrowser : public QWidget, private Ui::DCDialogFileBrowser  {
Q_OBJECT

public: 
	/** construtor */
	DCFileBrowser( QWidget * parent = 0, bool AllowOpen = true );
	/** destructor */
	virtual ~DCFileBrowser();

	/** */
	void InitTree( QString nick, QString hubname, QString hubhost, QString filename, QString jumpto = QString::null, QStringList dirs = QStringList() );

protected:
	/** to get events for folder opening */
	virtual void customEvent( QEvent * event );

private:
	/** */
	void ContinueInitTree( CString * data );
	/** */
	void InitTXTTree( Q3ListViewItem * item, CString * data );
	/** */
	void InitXMLTree( Q3ListViewItem * item, CString * data );
	/** */
	void ParseXMLTree( CXml * xml, Q3ListViewItem * item );
	/** */
	bool DownloadDirectory( QString dir );
	/** */
	void JumpTo( QString target );
	/** */
	void CreateMenu( Q3ListViewItem * item, bool direntry, int column );
	/** */
	QString CreateRemotePath( Q3ListViewItem * item );

	/** */
	void DownloadFile( QString rootPath, QString localPath, QString localName,
			   QString remotePath, QString remoteName, ulonglong size,
			   QString hash );
	/** */
	void DownloadPath( QString rootPath, QString localPath, QString localName, Q3ListViewItem * item );

	/** */
	void AddFile( Q3ListViewItem * item, DCFileItem * fileitem );
	/** */
	void AddDirectory( Q3ListViewItem * item, QString name );
	/** */
	void ClearView();
	/** Recursively calculates the size of a folder's contents.
	 *  This is only needed for non-xml filelists.
	 */
	ulonglong CalcDirSize( Q3ListViewItem * item );
	/** Gets the left pane item for the right pane folder item */
	Q3ListViewItem * GetDirItem( Q3ListViewItem * item );
	/** disable all the gui elements, while thread running */
	void DisableGuiElements();
	/** enable all the gui elements, after thread finished */
	void EnableGuiElements();
	
	/** */
	void GetOwnList();
	
	/** */
	QString m_sNick;
	/** */
	QString m_sHubName;
	/** */
	QString m_sHubHost;
	/** */
	CByteArray m_ListData;
	/** */
	QString m_sFileName;
	/** */
	QString m_sJumpTo;
	/** */
	QStringList m_lDownloadDirs;
	/** */
	ulonglong m_nShareSize;
	/** */
	ulonglong m_nFileCount;
	/** */
	QPixmap m_FolderPixmap;
	/** */
	DCFilelistDecompressor * m_pDecomp;
	/** To disable download for own filelist */
	bool m_bAllowDownload;
	/** Disable the open file button for own file list from options dialog */
	bool m_bAllowOpen;
	
	/** search string */
	QString m_sFindString;
	/** index of the file name of current found file */
	int m_nFoundFile;
	/**
	 * a list of all the found files in the current directory
	 * which gets sorted into the correct order of the files view
	 */
	QStringList m_FoundFiles;
	/**
	 * last directory found - either matches itself,
	 * or more likely contains the matching file
	 */
	DCFileBrowserListItem * m_pFoundDir;

private slots:
	/** */
	void slotRightButtonClickedDirectory( Q3ListViewItem *, const QPoint &, int );
	/** */
	void slotRightButtonClickedFiles( Q3ListViewItem *, const QPoint &, int );
	/** */
	void slotCurrentChangedDirectory();
	/** */
	void slotExpandedDirectory( Q3ListViewItem * );
	/** */
	void slotCollapsedDirectory( Q3ListViewItem * );
	/** */
	void slotFileOpen();
	/** */
	void slotFileSave();
	/** */
	void slotItemDoubleClicked( Q3ListViewItem *, const QPoint &, int );
	/** */
	void slotThreadFinishedLoading( bool ok );
	/** find the hub and jump to the user for this filelist */
	void slotGotoUser();
	/** */
	void slotFind();
	/** */
	void slotFindNext();
};

#endif
