/***************************************************************************
                   searchspymodel.h  -  Search Spy Model header
                             -------------------
    begin                : Sat Nov 3 2007
    copyright            : (C) 2007 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHSPYMODEL_H
#define SEARCHSPYMODEL_H

#include <QAbstractItemModel>
#include <QString>
#include <QList>
#include <QHash>
#include <QDateTime>

/**
 * @author Edward Sheldrake - inspired by dc-qt 0.2.0 alpha
 * 
 * Replacing all the custom sorting code with QSortFilterProxyModel
 * resulted in excessive CPU usage and the result was unusable
 * on large hubs. At least for the userlist, but the design
 * is essentially the same, the spy is simpler (no sort top bool).
 */

class SearchSpyItem {

public:
	/** Constructor */
	SearchSpyItem( QString search );
	/** Destructor */
	~SearchSpyItem() {};
	
	/** Search text / TTH */
	QString text;
	/** Time of search */
	QDateTime lastseen;
	/** Number of times this search has been seen */
	int count;
	/**
	 * Position in list.
	 * The hash is needed for lookup by search string
	 * and the list is needed for lookup by model index.
	 * 
	 * So the index here is needed when getting the item
	 * out of the hash.
	 */
	int index;
};

class SearchSpyModel : public QAbstractItemModel {
Q_OBJECT

public:
	/** Constructor */
	SearchSpyModel( QObject * parent = 0 );
	/** Destructor */
	virtual ~SearchSpyModel();
	
	/** number of rows */
	virtual int rowCount( const QModelIndex & index = QModelIndex() ) const;
	/** number of columns */
	virtual int columnCount( const QModelIndex & index = QModelIndex() ) const;
	/** gets data */
	virtual QVariant data( const QModelIndex & index, int role = Qt::DisplayRole ) const;
	/** gets headings */
	virtual QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
	/** sort list */
	virtual void sort( int column, Qt::SortOrder order = Qt::AscendingOrder );
	/** */
	virtual QModelIndex index( int row, int column, const QModelIndex & parent = QModelIndex() ) const;
	/** */
	virtual QModelIndex parent( const QModelIndex & parent ) const;
	
	/** got search string */
	void search( QString query );
	
	/** get sort column */
	int getSortColumn() const { return sortColumn; };
	/** get sort order */
	Qt::SortOrder getSortOrder() const { return sortOrder; };

public slots:
	/** delete all data */
	void clear();

private:
	/** Hash of items keyed on search string */
	QHash<QString, SearchSpyItem*> itemHash;
	/** Sorted list of items */
	QList<SearchSpyItem*> itemList;
	/** Column sorted by */
	int sortColumn;
	/** Sort order */
	Qt::SortOrder sortOrder;
};

#endif // SEARCHSPYMODEL_H
