/*  shared.c
 *
 *  Shared global variables
 */

/*
 *  xdemorse: An application to decode Morse code signals to text
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"

/*------------------------------------------------------------------------*/

/* Global widgets */
GtkWidget
  *gbl_rx_scrolledwindow,
  *gbl_scope,
  *gbl_waterfall,
  *gbl_scope_label;

/* Speed and squelch spin button */
GtkSpinButton
  *gbl_speed,
  *gbl_squelch,
  *gbl_ratio;

/* Runtime config data */
rc_data_t rc_data;

/* DSP samples buffer */
samples_buffer_t samples_buffer;

/* Waterfall window pixbuf */
GdkPixbuf *gbl_wfall_pixbuf = NULL;
guchar *gbl_wfall_pixels;
gint
  gbl_wfall_rowstride,
  gbl_wfall_n_channels,
  gbl_wfall_width,
  gbl_wfall_height;

/* Text buffer for text viewer */
GtkTextBuffer *gbl_rx_text_buffer;

/* Text buffer for text viewer */
GtkTextBuffer *gbl_rx_text_buffer;

/* Scope signal display */
gint
  gbl_scope_width,
  gbl_scope_height;

/* Average bin values */
int *gbl_bin_ave = NULL;

/* fft in/out buffers */
int
  *fft_in_r  = NULL,
  *fft_out_r = NULL,
  *fft_out_i = NULL;

/*------------------------------------------------------------------------*/

