/*
 * key.h  keycode definition
 *
 * Copyright (C) 2000-    Masaki Chikama (Wren) <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/* $Id: key.h,v 1.2 2000/08/11 18:55:51 chikama Exp $ */

#ifndef __KEYCODE__
#define __KEYCODE__

#define KEY_UNDEFINED    (0x00)
#define KEY_MOUSE_LEFT   (0x01)
#define KEY_MOUSE_RIGHT  (0x02)
#define KEY_CONTROL      (0x03)
#define KEY_MOUSE_MIDDLE (0x04)
#define KEY_BS           (0x08)
#define KEY_BACKSPACE    (0x08)
#define KEY_TAB          (0x09)
#define KEY_CLEAR        (0x0c)
#define KEY_ENTER        (0x0d)
#define KEY_PAD_ENTER    (0x0d)
#define KEY_RETURN       (0x0d)
#define KEY_SHIFT        (0x10)
#define KEY_LSHIFT       (0x10)
#define KEY_RSHIFT       (0x10)
#define KEY_CTRL         (0x11)
#define KEY_LCTRL        (0x11)
#define KEY_RCTRL        (0x11)
#define KEY_ALT          (0x12)
#define KEY_LALT         (0x12)
#define KEY_RALT         (0x12)
#define KEY_PAUSE        (0x13)
#define KEY_CAPSLOCK     (0x14)
#define KEY_KANAKAN      (0x15)
#define KEY_ESC          (0x1b)
#define KEY_ESCAPE       (0x1b)
#define KEY_SPACE        (0x20)
#define KEY_PAGEUP       (0x21)
#define KEY_PAGEDOWN     (0x22)
#define KEY_END          (0x23)
#define KEY_HOME         (0x24)
#define KEY_LEFT         (0x25)
#define KEY_UP           (0x26)
#define KEY_RIGHT        (0x27)
#define KEY_DOWN         (0x28)
#define KEY_SELECT       (0x29)
#define KEY_EXECUTE      (0x2b)
#define KEY_PRINTSCREEN  (0x2c)
#define KEY_INS          (0x2d)
#define KEY_INSERT       (0x2d)
#define KEY_DEL          (0x2e)
#define KEY_DELETE       (0x2e)
#define KEY_HELP         (0x2f)
#define KEY_0            (0x30)
#define KEY_1            (0x31)
#define KEY_2            (0x32)
#define KEY_3            (0x33)
#define KEY_4            (0x34)
#define KEY_5            (0x35)
#define KEY_6            (0x36)
#define KEY_7            (0x37)
#define KEY_8            (0x38)
#define KEY_9            (0x39)
#define KEY_PAD_EQUALS   (0x3d)
#define KEY_A            (0x41)
#define KEY_B            (0x42)
#define KEY_C            (0x43)
#define KEY_D            (0x44)
#define KEY_E            (0x45)
#define KEY_F            (0x46)
#define KEY_G            (0x47)
#define KEY_H            (0x48)
#define KEY_I            (0x49)
#define KEY_J            (0x4a)
#define KEY_K            (0x4b)
#define KEY_L            (0x4c)
#define KEY_M            (0x4d)
#define KEY_N            (0x4e)
#define KEY_O            (0x4f)
#define KEY_P            (0x50)
#define KEY_Q            (0x51)
#define KEY_R            (0x52)
#define KEY_S            (0x53)
#define KEY_T            (0x54)
#define KEY_U            (0x55)
#define KEY_V            (0x56)
#define KEY_W            (0x57)
#define KEY_X            (0x58)
#define KEY_Y            (0x59)
#define KEY_Z            (0x5a)
#define KEY_PAD_0        (0x60)
#define KEY_PAD_1        (0x61)
#define KEY_PAD_2        (0x62)
#define KEY_PAD_3        (0x63)
#define KEY_PAD_4        (0x64)
#define KEY_PAD_5        (0x65)
#define KEY_PAD_6        (0x66)
#define KEY_PAD_7        (0x67)
#define KEY_PAD_8        (0x68)
#define KEY_PAD_9        (0x69)
#define KEY_PAD_STAR     (0x6a)
#define KEY_PAD_MULTIPLY (0x6a)
#define KEY_PAD_PLUS     (0x6b)
#define KEY_PAD_SEP      (0x6c)
#define KEY_PAD_MINUS    (0x6d)
#define KEY_PAD_DOT      (0x6e)
#define KEY_PAD_PERIOD   (0x6e)
#define KEY_PAD_SLASH    (0x6f)
#define KEY_PAD_DIVIDE   (0x6f)
#define KEY_F1           (0x70)
#define KEY_F2           (0x71)
#define KEY_F3           (0x72)
#define KEY_F4           (0x73)
#define KEY_F5           (0x74)
#define KEY_F6           (0x75)
#define KEY_F7           (0x76)
#define KEY_F8           (0x77)
#define KEY_F9           (0x78)
#define KEY_F10          (0x79)
#define KEY_F11          (0x7a)
#define KEY_F12          (0x7b)
#define KEY_F13          (0x7c)
#define KEY_F14          (0x7d)
#define KEY_F15          (0x7e)
#define KEY_F16          (0x7f)
#define KEY_F17          (0x80)
#define KEY_F18          (0x81)
#define KEY_F19          (0x82)
#define KEY_F20          (0x83)
#define KEY_F21          (0x84)
#define KEY_F22          (0x85)
#define KEY_F23          (0x86)
#define KEY_F24          (0x87)
#define KEY_NUMLOCK      (0x90)
#define KEY_SCROLL_LOCK  (0x91)
#define KEY_SCROLLOCK    (0x91)

#endif /* __KEYCODE__ */
