#!/usr/bin/perl -w 

%consonants = (
	"k" => "0x0915",
	"kh" => "0x0916",
	"g" => "0x0917",
	"gh" => "0x0918",
	"N^" => "0x0919",
	"~N" => "0x0919",
	"c" => "0x091a",
	"ch" => "0x091a",
	"chh" => "0x091b",
	"Ch" => "0x091b",
	"j" => "0x091c",
	"jh" => "0x091d",
	"~n" => "0x091e",
	"JN" => "0x091e",
	"T" => "0x091f",
	"Th" => "0x0920",
	"D" => "0x0921",
	"Dh" => "0x0922",
	"N" => "0x0923",
	"t" => "0x0924",
	"th" => "0x0925",
	"d" => "0x0926",
	"dh" => "0x0927",
	"n" => "0x0928",
	"p" => "0x092a",
	"ph" => "0x092b",
	"b" => "0x092c",
	"bh" => "0x092d",
	"m" => "0x092e",
	"y" => "0x092f",
	"r" => "0x0930",
	"l" => "0x0932",
	"L" => "0x0933",
	"ld" => "0x0933",
	"v" => "0x0935",
	"w" => "0x0935",
	"sh" => "0x0936",
	"shh" => "0x0937",
	"Sh" => "0x0937",
	"s" => "0x0938",
	"h" => "0x0939",
	"q" => "0x0958",
	"K" => "0x0959",
	"G" => "0x095a",
	"z" => "0x095b",
	"J" => "0x095b",
	".D" => "0x095c",
	".Dh" => "0x095d",
	"f" => "0x095e",
	"Y" => "0x095f",
	"x" => "0x0915 0x094d 0x0937",
	"GY" => "0x091c 0x094d 0x091e",
	"dny" => "0x091c 0x094d 0x091e",
);

%vowels = (
	"" => " 0x094d",
	"a" => "",
	"A" => " 0x093e",
	"aa" => " 0x093e",
	"i" => " 0x093f",
	"I" => " 0x0940",
	"ii" => " 0x0940",
	"u" => " 0x0941",
	"U" => " 0x0942",
	"uu" => " 0x0942",
	"R^i" => " 0x0943",
	"RRi" => " 0x0943",
	"R^I" => " 0x0944",
	"RRI" => " 0x0944",
	"e" => " 0x0947",
	"ai" => " 0x0948",
	"A.c" => " 0x0949",
	"aa.c" => " 0x0949",
	"o" => " 0x094b",
	"au" => " 0x094c",
	".h" => " 0x094d 0x200c",
	"L^i" => " 0x0962",
	"LLi" => " 0x0962",
	"L^I" => " 0x0963",
	"LLI" => " 0x0963",
);

print "// Devanagari kmap according to Itrans transliteration\n";
print "// by Miikka-Markus Alhonen 2002-01-20\n\n";
print "// Consonant + vowel/virama\n";

foreach $cons (sort keys %consonants) {
  foreach $vowel (sort keys %vowels) {
    printf ("\"%s%s=%s%s\",\n",$cons,$vowel,$consonants{$cons},$vowels{$vowel});
  }
}

print <<EOF;

// Independent vowels

"a=0x0905",
"A=0x0906",
"aa=0x0906",
"i=0x0907",
"I=0x0908",
"ii=0x0908",
"u=0x0909",
"U=0x090a",
"uu=0x090a",
"R^i=0x090b",
"RRi=0x090b",
"L^i=0x090c",
"LLi=0x090c",
"e.c=0x090d",
"e=0x090f",
"ai=0x0910",
"A.c=0x0911",
"aa.c=0x0911",
"o=0x0913",
"au=0x0914",
"R^I=0x0960",
"RRI=0x0960",
"L^I=0x0961",
"LLI=0x0961",

// Numbers

"0x30=0x0966",
"0x31=0x0967",
"0x32=0x0968",
"0x33=0x0969",
"0x34=0x096a",
"0x35=0x096b",
"0x36=0x096c",
"0x37=0x096d",
"0x38=0x096e",
"0x39=0x096f",

// Other marks

".N=0x0901",
".n=0x0902",
"M=0x0902",
"H=0x0903",
"R=0x0931 0x094d",
".a=0x093d",
".c=0x0945",
".h=0x094d 0x200c",
"AUM=0x0950",
"OM=0x0950",
".=0x0964",
"..=0x0965",
"|=0x0964",
"||=0x0965",
";=0x0965",
"{\\\\rm 0x20 .}=0x002e",
"{}=0x200d",
EOF
