package ONVIF::Media::Types::AnalyticsState;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Error_of :ATTR(:get<Error>);
my %State_of :ATTR(:get<State>);

__PACKAGE__->_factory(
    [ qw(        Error
        State

    ) ],
    {
        'Error' => \%Error_of,
        'State' => \%State_of,
    },
    {
        'Error' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'State' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'Error' => 'Error',
        'State' => 'State',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::AnalyticsState

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AnalyticsState from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Error


=item * State




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::AnalyticsState
   Error =>  $some_value, # string
   State =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

