package ONVIF::Device::Types::WhiteBalance;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %CrGain_of :ATTR(:get<CrGain>);
my %CbGain_of :ATTR(:get<CbGain>);

__PACKAGE__->_factory(
    [ qw(        Mode
        CrGain
        CbGain

    ) ],
    {
        'Mode' => \%Mode_of,
        'CrGain' => \%CrGain_of,
        'CbGain' => \%CbGain_of,
    },
    {
        'Mode' => 'ONVIF::Device::Types::WhiteBalanceMode',
        'CrGain' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'CbGain' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
    },
    {

        'Mode' => 'Mode',
        'CrGain' => 'CrGain',
        'CbGain' => 'CbGain',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::WhiteBalance

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
WhiteBalance from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * CrGain


=item * CbGain




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::WhiteBalance
   Mode => $some_value, # WhiteBalanceMode
   CrGain =>  $some_value, # float
   CbGain =>  $some_value, # float
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

